/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoIntRetorno;
import com.fincatto.documentofiscal.nfe.webservices.distribuicao.WSDistribuicaoNFe;
import com.fincatto.documentofiscal.nfe400.classes.cadastro.NFRetornoConsultaCadastro;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFEnviaEventoRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.cartacorrecao.NFProtocoloEventoCartaCorrecao;
import com.fincatto.documentofiscal.nfe400.classes.evento.epec.NFEnviaEventoEpecRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.inutilizacao.NFRetornoEventoInutilizacao;
import com.fincatto.documentofiscal.nfe400.classes.evento.manifestacaodestinatario.NFProtocoloEventoManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.evento.manifestacaodestinatario.NFTipoEventoManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.lote.consulta.NFLoteConsultaRetorno;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvio;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvioRetorno;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvioRetornoDados;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteIndicadorProcessamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.consulta.NFNotaConsultaRetorno;
import com.fincatto.documentofiscal.nfe400.classes.statusservico.consulta.NFStatusServicoConsultaRetorno;
import com.fincatto.documentofiscal.nfe400.webservices.WSCancelamento;
import com.fincatto.documentofiscal.nfe400.webservices.WSCartaCorrecao;
import com.fincatto.documentofiscal.nfe400.webservices.WSConsultaCadastro;
import com.fincatto.documentofiscal.nfe400.webservices.WSEpec;
import com.fincatto.documentofiscal.nfe400.webservices.WSInutilizacao;
import com.fincatto.documentofiscal.nfe400.webservices.WSLoteConsulta;
import com.fincatto.documentofiscal.nfe400.webservices.WSLoteEnvio;
import com.fincatto.documentofiscal.nfe400.webservices.WSManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe400.webservices.WSNotaConsulta;
import com.fincatto.documentofiscal.nfe400.webservices.WSStatusConsulta;
import com.fincatto.documentofiscal.nfe400.webservices.gerado.NFeAutorizacao4Stub;
import com.fincatto.documentofiscal.utils.DFSocketFactory;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class WSFacade {
    private final WSLoteEnvio wsLoteEnvio;
    private final WSLoteConsulta wsLoteConsulta;
    private final WSStatusConsulta wsStatusConsulta;
    private final WSNotaConsulta wsNotaConsulta;
    private final WSCartaCorrecao wsCartaCorrecao;
    private final WSCancelamento wsCancelamento;
    private final WSConsultaCadastro wsConsultaCadastro;
    private final WSInutilizacao wsInutilizacao;
    private final WSManifestacaoDestinatario wSManifestacaoDestinatario;
    private final WSDistribuicaoNFe wSDistribuicaoNFe;
    private final WSEpec wsEpec;

    public WSFacade(NFeConfig config) throws KeyManagementException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new DFSocketFactory(config), 443));
        this.wsLoteEnvio = new WSLoteEnvio(config);
        this.wsLoteConsulta = new WSLoteConsulta(config);
        this.wsStatusConsulta = new WSStatusConsulta(config);
        this.wsNotaConsulta = new WSNotaConsulta(config);
        this.wsCartaCorrecao = new WSCartaCorrecao(config);
        this.wsCancelamento = new WSCancelamento(config);
        this.wsConsultaCadastro = new WSConsultaCadastro(config);
        this.wsInutilizacao = new WSInutilizacao(config);
        this.wSManifestacaoDestinatario = new WSManifestacaoDestinatario(config);
        this.wSDistribuicaoNFe = new WSDistribuicaoNFe(config);
        this.wsEpec = new WSEpec(config);
    }

    public NFLoteEnvioRetornoDados enviaLote(NFLoteEnvio lote, boolean validarXML) throws Exception {
        if (lote.getIndicadorProcessamento().equals((Object)NFLoteIndicadorProcessamento.PROCESSAMENTO_SINCRONO) && lote.getNotas().size() > 1) {
            throw new IllegalArgumentException("Apenas uma nota permitida no modo sincrono!");
        }
        if (lote.getNotas().size() == 0) {
            throw new IllegalArgumentException("Nenhuma nota informada no envio do Lote!");
        }
        return this.wsLoteEnvio.enviaLote(lote, validarXML);
    }

    public NFLoteEnvioRetornoDados enviaLote(NFLoteEnvio lote) throws Exception {
        return this.enviaLote(lote, true);
    }

    public NFLoteEnvio getLoteAssinado(NFLoteEnvio lote) throws Exception {
        return this.wsLoteEnvio.getLoteAssinado(lote);
    }

    public NFLoteEnvioRetorno enviaLoteAssinado(String loteAssinadoXml, DFModelo modelo) throws Exception {
        return this.wsLoteEnvio.enviaLoteAssinado(loteAssinadoXml, modelo);
    }

    public NFeAutorizacao4Stub.NfeResultMsg getNfeResultMsg(String loteAssinadoXml, DFModelo modelo) throws Exception {
        return this.wsLoteEnvio.comunicaLoteRaw(loteAssinadoXml, modelo, true);
    }

    public NFLoteConsultaRetorno consultaLote(String numeroRecibo, DFModelo modelo) throws Exception {
        return this.wsLoteConsulta.consultaLote(numeroRecibo, modelo);
    }

    public NFStatusServicoConsultaRetorno consultaStatus(DFUnidadeFederativa uf, DFModelo modelo) throws Exception {
        return this.wsStatusConsulta.consultaStatus(uf, modelo);
    }

    public NFNotaConsultaRetorno consultaNota(String chaveDeAcesso) throws Exception {
        return this.wsNotaConsulta.consultaNota(chaveDeAcesso);
    }

    public String consultaNotaAsString(String chaveDeAcesso) throws Exception {
        return this.wsNotaConsulta.consultaNotaAsString(chaveDeAcesso);
    }

    public NFEnviaEventoRetorno corrigeNota(String chaveDeAcesso, String textoCorrecao, int numeroSequencialEvento) throws Exception {
        return this.wsCartaCorrecao.corrigeNota(chaveDeAcesso, textoCorrecao, numeroSequencialEvento);
    }

    public NFEnviaEventoRetorno corrigeNotaAssinada(String chave, String eventoAssinadoXml) throws Exception {
        return this.wsCartaCorrecao.corrigeNotaAssinada(chave, eventoAssinadoXml);
    }

    public NFEnviaEventoRetorno corrigeNotaAssinada(String eventoAssinadoXml) throws Exception {
        return this.wsCartaCorrecao.corrigeNotaAssinada(eventoAssinadoXml);
    }

    public NFProtocoloEventoCartaCorrecao corrigeNotaAssinadaProtocolo(String eventoAssinadoXml) throws Exception {
        return this.wsCartaCorrecao.corrigeNotaAssinadaProtocolo(eventoAssinadoXml);
    }

    public NFProtocoloEventoCartaCorrecao corrigeNotaAssinadaProtocolo(String chaveDeAcesso, String textoCorrecao, int numeroSequencialEvento) throws Exception {
        return this.wsCartaCorrecao.corrigeNotaAssinadaProtocolo(this.getXmlAssinado(chaveDeAcesso, textoCorrecao, numeroSequencialEvento));
    }

    public String getXmlAssinado(String chaveDeAcesso, String textoCorrecao, int numeroSequencialEvento) throws Exception {
        return this.wsCartaCorrecao.getXmlAssinado(chaveDeAcesso, textoCorrecao, numeroSequencialEvento);
    }

    public NFEnviaEventoRetorno cancelaNota(String chave, String numeroProtocolo, String motivo) throws Exception {
        return this.wsCancelamento.cancelaNota(chave, numeroProtocolo, motivo);
    }

    public NFEnviaEventoRetorno cancelaNotaAssinada(String chave, String eventoAssinadoXml) throws Exception {
        return this.wsCancelamento.cancelaNotaAssinada(chave, eventoAssinadoXml);
    }

    public NFEnviaEventoRetorno cancelaNotaPorSubstituicao(String chave, String numeroProtocolo, String motivo, String versaoAplicativoAutorizador, String chaveSubstituta) throws Exception {
        return this.wsCancelamento.cancelaNotaPorSubstituicao(chave, numeroProtocolo, motivo, versaoAplicativoAutorizador, chaveSubstituta);
    }

    public NFRetornoEventoInutilizacao inutilizaNotaAssinada(String eventoAssinadoXml, DFModelo modelo) throws Exception {
        return this.wsInutilizacao.inutilizaNotaAssinada(eventoAssinadoXml, modelo);
    }

    public NFRetornoEventoInutilizacao inutilizaNota(int anoInutilizacaoNumeracao, String cnpjEmitente, String serie, String numeroInicial, String numeroFinal, String justificativa, DFModelo modelo) throws Exception {
        return this.wsInutilizacao.inutilizaNota(anoInutilizacaoNumeracao, cnpjEmitente, serie, numeroInicial, numeroFinal, justificativa, modelo);
    }

    public NFRetornoConsultaCadastro consultaCadastro(String cnpj, DFUnidadeFederativa uf) throws Exception {
        return this.wsConsultaCadastro.consultaCadastro(cnpj, uf);
    }

    public NFRetornoConsultaCadastro consultaCadastroInscEst(String inscEst, DFUnidadeFederativa uf) throws Exception {
        return this.wsConsultaCadastro.consultaCadastroInscEst(inscEst, uf);
    }

    public NFEnviaEventoRetorno manifestaDestinatarioNota(String chave, NFTipoEventoManifestacaoDestinatario tipoEvento, String motivo, String cnpj) throws Exception {
        return this.wSManifestacaoDestinatario.manifestaDestinatarioNota(chave, tipoEvento, motivo, cnpj);
    }

    public NFProtocoloEventoManifestacaoDestinatario manifestaDestinatarioNotaProtocolo(String chave, NFTipoEventoManifestacaoDestinatario tipoEvento, String motivo, String cnpj) throws Exception {
        return this.wSManifestacaoDestinatario.manifestaDestinatarioNotaProtocolo(chave, tipoEvento, motivo, cnpj);
    }

    public NFEnviaEventoRetorno manifestaDestinatarioNotaAssinada(String chave, String eventoAssinadoXml) throws Exception {
        return this.wSManifestacaoDestinatario.manifestaDestinatarioNotaAssinada(chave, eventoAssinadoXml);
    }

    public NFDistribuicaoIntRetorno consultarDistribuicaoDFe(String cpfOuCnpj, DFUnidadeFederativa uf, String chaveAcesso, String nsu, String ultNsu) throws Exception {
        return this.wSDistribuicaoNFe.consultar(cpfOuCnpj, uf, chaveAcesso, nsu, ultNsu);
    }

    public NFEnviaEventoEpecRetorno enviaLoteEpec(NFLoteEnvio lote) throws Exception {
        return this.wsEpec.enviaEpec(lote);
    }

    public NFEnviaEventoEpecRetorno enviaEpec(NFLoteEnvio lote) throws Exception {
        return this.wsEpec.enviaEpec(lote);
    }

    public NFEnviaEventoEpecRetorno enviaEpecAssinado(String epecAssinadoXml) throws Exception {
        return this.wsEpec.enviaEpecAssinado(epecAssinadoXml);
    }
}

