/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.NFAutorizador400;
import com.fincatto.documentofiscal.nfe400.classes.evento.inutilizacao.NFEnviaEventoInutilizacao;
import com.fincatto.documentofiscal.nfe400.classes.evento.inutilizacao.NFEventoInutilizacaoDados;
import com.fincatto.documentofiscal.nfe400.classes.evento.inutilizacao.NFRetornoEventoInutilizacao;
import com.fincatto.documentofiscal.nfe400.webservices.gerado.NFeInutilizacao4Stub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import java.math.BigDecimal;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.lang3.StringUtils;

class WSInutilizacao
implements DFLog {
    private static final String VERSAO_SERVICO = "4.00";
    private static final String NOME_SERVICO = "INUTILIZAR";
    private final NFeConfig config;

    WSInutilizacao(NFeConfig config) {
        this.config = config;
    }

    NFRetornoEventoInutilizacao inutilizaNotaAssinada(String eventoAssinadoXml, DFModelo modelo) throws Exception {
        OMElement omElementResult = this.efetuaInutilizacao(eventoAssinadoXml, modelo);
        return (NFRetornoEventoInutilizacao)this.config.getPersister().read(NFRetornoEventoInutilizacao.class, omElementResult.toString());
    }

    NFRetornoEventoInutilizacao inutilizaNota(int anoInutilizacaoNumeracao, String cnpjEmitente, String serie, String numeroInicial, String numeroFinal, String justificativa, DFModelo modelo) throws Exception {
        String inutilizacaoXML = this.geraDadosInutilizacao(anoInutilizacaoNumeracao, cnpjEmitente, serie, numeroInicial, numeroFinal, justificativa, modelo).toString();
        String inutilizacaoXMLAssinado = new DFAssinaturaDigital(this.config).assinarDocumento(inutilizacaoXML);
        OMElement omElementResult = this.efetuaInutilizacao(inutilizacaoXMLAssinado, modelo);
        return (NFRetornoEventoInutilizacao)this.config.getPersister().read(NFRetornoEventoInutilizacao.class, omElementResult.toString());
    }

    private OMElement efetuaInutilizacao(String inutilizacaoXMLAssinado, DFModelo modelo) throws Exception {
        NFeInutilizacao4Stub.NfeDadosMsg dados = new NFeInutilizacao4Stub.NfeDadosMsg();
        OMElement omElement = AXIOMUtil.stringToOM((String)inutilizacaoXMLAssinado);
        this.getLogger().debug(omElement.toString());
        dados.setExtraElement(omElement);
        NFAutorizador400 autorizador = NFAutorizador400.valueOfCodigoUF(this.config.getCUF());
        String urlWebService = DFModelo.NFE.equals((Object)modelo) ? autorizador.getNfeInutilizacao(this.config.getAmbiente()) : autorizador.getNfceInutilizacao(this.config.getAmbiente());
        NFeInutilizacao4Stub.NfeResultMsg nf4Result = new NFeInutilizacao4Stub(urlWebService, this.config).nfeInutilizacaoNF(dados);
        OMElement dadosRetorno = nf4Result.getExtraElement();
        this.getLogger().debug(dadosRetorno.toString());
        return dadosRetorno;
    }

    private NFEnviaEventoInutilizacao geraDadosInutilizacao(int anoInutilizacaoNumeracao, String cnpjEmitente, String serie, String numeroInicial, String numeroFinal, String justificativa, DFModelo modelo) {
        NFEnviaEventoInutilizacao inutilizacao = new NFEnviaEventoInutilizacao();
        NFEventoInutilizacaoDados dados = new NFEventoInutilizacaoDados();
        dados.setAmbiente(this.config.getAmbiente());
        dados.setAno(anoInutilizacaoNumeracao);
        dados.setCnpj(cnpjEmitente);
        dados.setJustificativa(justificativa);
        dados.setModeloDocumentoFiscal(modelo.getCodigo());
        dados.setNomeServico(NOME_SERVICO);
        dados.setNumeroNFInicial(numeroInicial);
        dados.setNumeroNFFinal(numeroFinal);
        dados.setSerie(serie);
        dados.setUf(this.config.getCUF());
        String numeroInicialTamanhoMaximo = StringUtils.leftPad((String)numeroInicial, (int)9, (String)"0");
        String numeroFinalTamanhoMaximo = StringUtils.leftPad((String)numeroFinal, (int)9, (String)"0");
        String serieTamanhoMaximo = StringUtils.leftPad((String)serie, (int)3, (String)"0");
        dados.setIdentificador("ID" + this.config.getCUF().getCodigoIbge() + anoInutilizacaoNumeracao + cnpjEmitente + modelo.getCodigo() + serieTamanhoMaximo + numeroInicialTamanhoMaximo + numeroFinalTamanhoMaximo);
        inutilizacao.setVersao(new BigDecimal(VERSAO_SERVICO));
        inutilizacao.setDados(dados);
        return inutilizacao;
    }
}

