/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.NFAutorizador400;
import com.fincatto.documentofiscal.nfe400.classes.lote.consulta.NFLoteConsulta;
import com.fincatto.documentofiscal.nfe400.classes.lote.consulta.NFLoteConsultaRetorno;
import com.fincatto.documentofiscal.nfe400.webservices.gerado.NFeRetAutorizacao4Stub;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSLoteConsulta
implements DFLog {
    private final NFeConfig config;

    WSLoteConsulta(NFeConfig config) {
        this.config = config;
    }

    NFLoteConsultaRetorno consultaLote(String numeroRecibo, DFModelo modelo) throws Exception {
        OMElement omElementConsulta = AXIOMUtil.stringToOM((String)this.gerarDadosConsulta(numeroRecibo).toString());
        this.getLogger().debug(omElementConsulta.toString());
        OMElement omElementResult = this.efetuaConsulta(omElementConsulta, modelo);
        this.getLogger().debug(omElementResult.toString());
        return (NFLoteConsultaRetorno)this.config.getPersister().read(NFLoteConsultaRetorno.class, omElementResult.toString());
    }

    private OMElement efetuaConsulta(OMElement omElement, DFModelo modelo) throws RemoteException {
        String urlWebService;
        NFeRetAutorizacao4Stub.NfeDadosMsg dados = new NFeRetAutorizacao4Stub.NfeDadosMsg();
        dados.setExtraElement(omElement);
        NFAutorizador400 autorizador = NFAutorizador400.valueOfTipoEmissao(this.config.getTipoEmissao(), this.config.getCUF());
        String string = urlWebService = DFModelo.NFCE.equals((Object)modelo) ? autorizador.getNfceRetAutorizacao(this.config.getAmbiente()) : autorizador.getNfeRetAutorizacao(this.config.getAmbiente());
        if (urlWebService == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para RetAutorizacao " + modelo.name() + ", autorizador " + autorizador.name());
        }
        NFeRetAutorizacao4Stub.NfeResultMsg autorizacaoLoteResult = new NFeRetAutorizacao4Stub(urlWebService, this.config).nfeRetAutorizacaoLote(dados);
        return autorizacaoLoteResult.getExtraElement();
    }

    private NFLoteConsulta gerarDadosConsulta(String numeroRecibo) {
        NFLoteConsulta consulta = new NFLoteConsulta();
        consulta.setRecibo(numeroRecibo);
        consulta.setAmbiente(this.config.getAmbiente());
        consulta.setVersao(new BigDecimal(this.config.getVersao()));
        return consulta;
    }
}

