/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFVersaoQrCode;
import com.fincatto.documentofiscal.nfe.NFTipoEmissao;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.NFAutorizador400;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvio;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvioRetorno;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvioRetornoDados;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoSuplementar;
import com.fincatto.documentofiscal.nfe400.utils.NFGeraChave;
import com.fincatto.documentofiscal.nfe400.utils.qrcode20.NFGeraQRCode20;
import com.fincatto.documentofiscal.nfe400.utils.qrcode20.NFGeraQRCodeContingenciaOffline20;
import com.fincatto.documentofiscal.nfe400.utils.qrcode20.NFGeraQRCodeEmissaoNormal20;
import com.fincatto.documentofiscal.nfe400.utils.qrcode30.NFGeraQRCode30;
import com.fincatto.documentofiscal.nfe400.utils.qrcode30.NFGeraQRCodeContingenciaOffline30;
import com.fincatto.documentofiscal.nfe400.utils.qrcode30.NFGeraQRCodeEmissaoNormal30;
import com.fincatto.documentofiscal.nfe400.webservices.gerado.NFeAutorizacao4Stub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.io.StringReader;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.lang3.StringUtils;

class WSLoteEnvio
implements DFLog {
    private static final String NFE_ELEMENTO = "NFe";
    private final NFeConfig config;

    WSLoteEnvio(NFeConfig config) {
        this.config = config;
    }

    NFLoteEnvioRetorno enviaLoteAssinado(String loteAssinadoXml, DFModelo modelo) throws Exception {
        return this.comunicaLote(loteAssinadoXml, modelo);
    }

    NFLoteEnvioRetornoDados enviaLote(NFLoteEnvio lote, boolean validarXML) throws Exception {
        NFLoteEnvio loteAssinado = this.getLoteAssinado(lote);
        NFLoteEnvioRetorno loteEnvioRetorno = this.comunicaLote(loteAssinado.toString(), loteAssinado.getNotas().get(0).getInfo().getIdentificacao().getModelo(), validarXML);
        return new NFLoteEnvioRetornoDados(loteEnvioRetorno, loteAssinado);
    }

    NFLoteEnvioRetornoDados enviaLote(NFLoteEnvio lote) throws Exception {
        return this.enviaLote(lote, true);
    }

    NFLoteEnvio getLoteAssinado(NFLoteEnvio lote) throws Exception {
        for (NFNota nota : lote.getNotas()) {
            NFGeraChave geraChave = new NFGeraChave(nota);
            nota.getInfo().getIdentificacao().setCodigoRandomico((String)StringUtils.defaultIfBlank((CharSequence)nota.getInfo().getIdentificacao().getCodigoRandomico(), (CharSequence)geraChave.geraCodigoRandomico()));
            nota.getInfo().getIdentificacao().setDigitoVerificador(geraChave.getDV());
            nota.getInfo().setIdentificador(geraChave.getChaveAcesso());
        }
        String documentoAssinado = new DFAssinaturaDigital(this.config).assinarDocumento(lote.toString());
        NFLoteEnvio loteAssinado = (NFLoteEnvio)this.config.getPersister().read(NFLoteEnvio.class, documentoAssinado);
        int qtdNF = 0;
        int qtdNFC = 0;
        block5: for (NFNota nota : loteAssinado.getNotas()) {
            switch (nota.getInfo().getIdentificacao().getModelo()) {
                case NFE: {
                    ++qtdNF;
                    continue block5;
                }
                case NFCE: {
                    Object geraQRCode;
                    if (this.config.getVersaoQrCodeNFCe() == null || DFVersaoQrCode.VERSAO_3.getCodigo() != this.config.getVersaoQrCodeNFCe().shortValue()) {
                        geraQRCode = this.getNfGeraQRCode20(nota);
                        nota.setInfoSuplementar(new NFNotaInfoSuplementar());
                        nota.getInfoSuplementar().setUrlConsultaChaveAcesso(((NFGeraQRCode20)geraQRCode).urlConsultaChaveAcesso());
                        nota.getInfoSuplementar().setQrCode(((NFGeraQRCode20)geraQRCode).getQRCode());
                    } else {
                        geraQRCode = this.getNfGeraQRCode30(nota);
                        nota.setInfoSuplementar(new NFNotaInfoSuplementar());
                        nota.getInfoSuplementar().setUrlConsultaChaveAcesso(((NFGeraQRCode30)geraQRCode).urlConsultaChaveAcesso());
                        nota.getInfoSuplementar().setQrCode(((NFGeraQRCode30)geraQRCode).getQRCode());
                    }
                    ++qtdNFC;
                    continue block5;
                }
            }
            throw new IllegalArgumentException(String.format("Modelo de nota desconhecida: %s", new Object[]{nota.getInfo().getIdentificacao().getModelo()}));
        }
        if (qtdNF > 0 && qtdNFC > 0) {
            throw new IllegalArgumentException("Lote contendo notas de modelos diferentes!");
        }
        return loteAssinado;
    }

    private NFGeraQRCode20 getNfGeraQRCode20(NFNota nota) {
        if (NFTipoEmissao.EMISSAO_NORMAL.equals((Object)nota.getInfo().getIdentificacao().getTipoEmissao())) {
            return new NFGeraQRCodeEmissaoNormal20(nota, this.config);
        }
        if (NFTipoEmissao.CONTIGENCIA_OFFLINE.equals((Object)nota.getInfo().getIdentificacao().getTipoEmissao())) {
            return new NFGeraQRCodeContingenciaOffline20(nota, this.config);
        }
        throw new IllegalArgumentException("QRCode 2.0 Tipo Emissao nao implementado: " + nota.getInfo().getIdentificacao().getTipoEmissao().getDescricao());
    }

    private NFGeraQRCode30 getNfGeraQRCode30(NFNota nota) {
        if (NFTipoEmissao.EMISSAO_NORMAL.equals((Object)nota.getInfo().getIdentificacao().getTipoEmissao())) {
            return new NFGeraQRCodeEmissaoNormal30(nota, this.config);
        }
        if (NFTipoEmissao.CONTIGENCIA_OFFLINE.equals((Object)nota.getInfo().getIdentificacao().getTipoEmissao())) {
            return new NFGeraQRCodeContingenciaOffline30(nota, this.config);
        }
        throw new IllegalArgumentException("QRCode 2.0 Tipo Emissao nao implementado: " + nota.getInfo().getIdentificacao().getTipoEmissao().getDescricao());
    }

    private NFLoteEnvioRetorno comunicaLote(String loteAssinadoXml, DFModelo modelo, boolean validarXML) throws Exception {
        NFeAutorizacao4Stub.NfeResultMsg autorizacaoLoteResult = this.comunicaLoteRaw(loteAssinadoXml, modelo, validarXML);
        NFLoteEnvioRetorno loteEnvioRetorno = (NFLoteEnvioRetorno)this.config.getPersister().read(NFLoteEnvioRetorno.class, autorizacaoLoteResult.getExtraElement().toString());
        this.getLogger().debug(loteEnvioRetorno.toString());
        return loteEnvioRetorno;
    }

    private NFLoteEnvioRetorno comunicaLote(String loteAssinadoXml, DFModelo modelo) throws Exception {
        return this.comunicaLote(loteAssinadoXml, modelo, true);
    }

    NFeAutorizacao4Stub.NfeResultMsg comunicaLoteRaw(String loteAssinadoXml, DFModelo modelo, boolean validarXML) throws Exception {
        String endpoint;
        if (validarXML) {
            DFXMLValidador.validaLote400(loteAssinadoXml);
        }
        OMElement omElement = this.nfeToOMElement(loteAssinadoXml);
        NFeAutorizacao4Stub.NfeDadosMsg dados = new NFeAutorizacao4Stub.NfeDadosMsg();
        dados.setExtraElement(omElement);
        NFAutorizador400 autorizador = NFAutorizador400.valueOfTipoEmissao(this.config.getTipoEmissao(), this.config.getCUF());
        String string = endpoint = DFModelo.NFE.equals((Object)modelo) ? autorizador.getNfeAutorizacao(this.config.getAmbiente()) : autorizador.getNfceAutorizacao(this.config.getAmbiente());
        if (endpoint == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Autorizacao " + modelo.name() + ", autorizador " + autorizador.name());
        }
        return new NFeAutorizacao4Stub(endpoint, this.config).nfeAutorizacaoLote(dados);
    }

    private OMElement nfeToOMElement(String documento) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", false);
        XMLStreamReader reader = factory.createXMLStreamReader(new StringReader(documento));
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        OMElement ome = builder.getDocumentElement();
        Iterator children = ome.getChildrenWithLocalName(NFE_ELEMENTO);
        while (children.hasNext()) {
            OMElement omElement = (OMElement)children.next();
            if (omElement == null || !NFE_ELEMENTO.equals(omElement.getLocalName())) continue;
            omElement.addAttribute("xmlns", "http://www.portalfiscal.inf.br/nfe", null);
        }
        return ome;
    }
}

