/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.NFAutorizador400;
import com.fincatto.documentofiscal.nfe400.classes.statusservico.consulta.NFStatusServicoConsulta;
import com.fincatto.documentofiscal.nfe400.classes.statusservico.consulta.NFStatusServicoConsultaRetorno;
import com.fincatto.documentofiscal.nfe400.webservices.statusservico.consulta.NfeStatusServico4Stub;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSStatusConsulta
implements DFLog {
    private static final String NOME_SERVICO = "STATUS";
    private final NFeConfig config;

    WSStatusConsulta(NFeConfig config) {
        this.config = config;
    }

    NFStatusServicoConsultaRetorno consultaStatus(DFUnidadeFederativa uf, DFModelo modelo) throws Exception {
        OMElement omElementConsulta = AXIOMUtil.stringToOM((String)this.gerarDadosConsulta(uf).toString());
        this.getLogger().debug(omElementConsulta.toString());
        OMElement omElementResult = this.efetuaConsultaStatus(omElementConsulta, uf, modelo);
        this.getLogger().debug(omElementResult.toString());
        return (NFStatusServicoConsultaRetorno)this.config.getPersister().read(NFStatusServicoConsultaRetorno.class, omElementResult.toString());
    }

    private NFStatusServicoConsulta gerarDadosConsulta(DFUnidadeFederativa unidadeFederativa) {
        NFStatusServicoConsulta consStatServ = new NFStatusServicoConsulta();
        consStatServ.setUf(unidadeFederativa);
        consStatServ.setAmbiente(this.config.getAmbiente());
        consStatServ.setVersao(this.config.getVersao());
        consStatServ.setServico(NOME_SERVICO);
        return consStatServ;
    }

    private OMElement efetuaConsultaStatus(OMElement omElement, DFUnidadeFederativa unidadeFederativa, DFModelo modelo) throws RemoteException {
        String endpoint;
        NfeStatusServico4Stub.NfeDadosMsg dados = new NfeStatusServico4Stub.NfeDadosMsg();
        dados.setExtraElement(omElement);
        NFAutorizador400 autorizador = NFAutorizador400.valueOfCodigoUF(unidadeFederativa);
        String string = endpoint = DFModelo.NFCE.equals((Object)modelo) ? autorizador.getNfceStatusServico(this.config.getAmbiente()) : autorizador.getNfeStatusServico(this.config.getAmbiente());
        if (endpoint == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para StatusServico " + modelo.name() + ", autorizador " + autorizador.name() + ", UF " + unidadeFederativa.name());
        }
        return new NfeStatusServico4Stub(endpoint, this.config).nfeStatusServicoNF(dados).getExtraElement();
    }
}

