/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.transformers;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.simpleframework.xml.transform.Transform;

public class DFLocalDateTimeTransformer
implements Transform<LocalDateTime> {
    private static final DateTimeFormatter SIMPLE_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
    private static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX");
    private static final DateTimeFormatter DATETIME_FORMATTER_2 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");

    public LocalDateTime read(String data) {
        try {
            return LocalDateTime.parse(data, DATETIME_FORMATTER);
        }
        catch (Exception e) {
            try {
                return LocalDateTime.parse(data, DATETIME_FORMATTER_2);
            }
            catch (Exception e2) {
                return LocalDateTime.from(SIMPLE_DATETIME_FORMATTER.parse(data));
            }
        }
    }

    public String write(LocalDateTime data) {
        return SIMPLE_DATETIME_FORMATTER.format(data);
    }
}

