/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.transformers;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.simpleframework.xml.transform.Transform;

public class DFLocalDateTransformer
implements Transform<LocalDate> {
    private static final DateTimeFormatter DATATIME_FORMATTER_YYYYMMDDXXX = DateTimeFormatter.ofPattern("yyyy-MM-ddXXX");
    private static final DateTimeFormatter DATATIME_FORMATTER_YYYYMMDDHHMMSSXXXX = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXXXX");
    private static final DateTimeFormatter DATETIME_FORMATTER_YYYYMMDD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter DATETIME_FORMATTER_DDMMYYYY = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private static final DateTimeFormatter DATETIME_FORMATTER_DDMMYYYHHMMSS = DateTimeFormatter.ofPattern("dd/MM/yyyy' 'HH:mm:ss");

    public LocalDate read(String data) {
        try {
            return LocalDate.parse(data, DATETIME_FORMATTER_YYYYMMDD);
        }
        catch (Exception e) {
            try {
                return LocalDate.from(DATATIME_FORMATTER_YYYYMMDDXXX.parse(data));
            }
            catch (Exception e2) {
                try {
                    return LocalDate.from(DATETIME_FORMATTER_DDMMYYYY.parse(data));
                }
                catch (Exception e3) {
                    try {
                        return LocalDate.from(DATETIME_FORMATTER_DDMMYYYHHMMSS.parse(data));
                    }
                    catch (Exception e4) {
                        return LocalDate.from(DATATIME_FORMATTER_YYYYMMDDHHMMSSXXXX.parse(data));
                    }
                }
            }
        }
    }

    public String write(LocalDate data) {
        return DATETIME_FORMATTER_YYYYMMDD.format(data);
    }
}

