/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.utils;

import com.fincatto.documentofiscal.DFConfig;
import com.fincatto.documentofiscal.DFLog;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Signature;
import java.security.UnrecoverableEntryException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import javax.naming.ldap.LdapName;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DFAssinaturaDigital
implements DFLog {
    private static final String C14N_TRANSFORM_METHOD = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private static final String[] ELEMENTOS_ASSINAVEIS = new String[]{"infEvento", "infCanc", "infNFe", "infInut", "infMDFe", "infCte"};
    private final DFConfig config;

    public DFAssinaturaDigital(DFConfig config) {
        this.config = config;
    }

    public boolean isValida(InputStream xmlStream) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document document = dbf.newDocumentBuilder().parse(xmlStream);
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nodeList.getLength() == 0) {
            throw new IllegalStateException("Nao foi encontrada a assinatura do XML.");
        }
        String providerName = System.getProperty("jsr105Provider", "org.jcp.xml.dsig.internal.dom.XMLDSigRI");
        XMLSignatureFactory signatureFactory = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        DOMValidateContext validateContext = new DOMValidateContext(new DFKeySelector(), nodeList.item(0));
        for (String tag : ELEMENTOS_ASSINAVEIS) {
            NodeList elements = document.getElementsByTagName(tag);
            if (elements.getLength() <= 0) continue;
            validateContext.setIdAttributeNS((Element)elements.item(0), null, "Id");
        }
        return signatureFactory.unmarshalXMLSignature(validateContext).validate(validateContext);
    }

    public String assinarDocumento(String conteudoXml) throws Exception {
        return this.assinarDocumento(conteudoXml, ELEMENTOS_ASSINAVEIS);
    }

    public String assinarDocumento(String conteudoXml, String ... elementosAssinaveis) throws Exception {
        try (StringReader reader = new StringReader(conteudoXml);){
            String string;
            try (StringWriter writer = new StringWriter();){
                this.assinarDocumento(reader, writer, elementosAssinaveis);
                string = writer.toString();
            }
            return string;
        }
    }

    public void assinarDocumento(Reader xmlReader, Writer xmlAssinado, String ... elementosAssinaveis) throws Exception {
        KeyStore.PrivateKeyEntry keyEntry = this.getPrivateKeyEntry();
        String dn = ((X509Certificate)keyEntry.getCertificate()).getSubjectX500Principal().getName();
        this.getLogger().debug("DN: {}", (Object)dn);
        String cn = new LdapName(dn).getRdns().stream().filter(rdn -> StringUtils.equalsIgnoreCase((CharSequence)rdn.getType(), (CharSequence)"CN")).map(val -> String.valueOf(val.getValue())).findFirst().orElse("");
        this.getLogger().debug("CN: {}", (Object)cn);
        XMLSignatureFactory signatureFactory = XMLSignatureFactory.getInstance("DOM");
        ArrayList<Transform> transforms = new ArrayList<Transform>(2);
        transforms.add(signatureFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
        transforms.add(signatureFactory.newTransform(C14N_TRANSFORM_METHOD, (TransformParameterSpec)null));
        KeyInfoFactory keyInfoFactory = signatureFactory.getKeyInfoFactory();
        X509Data x509Data = keyInfoFactory.newX509Data(Collections.singletonList((X509Certificate)keyEntry.getCertificate()));
        KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(x509Data));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(xmlReader));
        for (String elementoAssinavel : elementosAssinaveis) {
            NodeList elements = document.getElementsByTagName(elementoAssinavel);
            for (int i = 0; i < elements.getLength(); ++i) {
                Element element = (Element)elements.item(i);
                String id = element.getAttribute("Id");
                element.setIdAttribute("Id", true);
                Reference reference = signatureFactory.newReference("#" + id, signatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), transforms, null, null);
                SignedInfo signedInfo = signatureFactory.newSignedInfo(signatureFactory.newCanonicalizationMethod(C14N_TRANSFORM_METHOD, (C14NMethodParameterSpec)null), signatureFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(reference));
                XMLSignature signature = signatureFactory.newXMLSignature(signedInfo, keyInfo);
                signature.sign(new DOMSignContext(keyEntry.getPrivateKey(), element.getParentNode()));
            }
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(document), new StreamResult(xmlAssinado));
    }

    private KeyStore.PrivateKeyEntry getPrivateKeyEntry() throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(this.config.getCertificadoSenha().toCharArray());
        if (StringUtils.isNotBlank((CharSequence)this.config.getCertificadoAlias())) {
            this.getLogger().debug("Usando alias informado: '{}'", (Object)this.config.getCertificadoAlias());
            return (KeyStore.PrivateKeyEntry)this.config.getCertificadoKeyStore().getEntry(this.config.getCertificadoAlias(), passwordProtection);
        }
        KeyStore ks = this.config.getCertificadoKeyStore();
        Enumeration<String> e = ks.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            if (!ks.isKeyEntry(alias)) continue;
            this.getLogger().debug("Usando alias descoberto: '{}'", (Object)alias);
            return (KeyStore.PrivateKeyEntry)ks.getEntry(alias, passwordProtection);
        }
        throw new KeyStoreException("N\u00e3o foi poss\u00edvel encontrar a chave privada do certificado!");
    }

    public String assinarString(String string) throws Exception {
        byte[] buffer = string.getBytes();
        Signature signatureProvider = Signature.getInstance("SHA1withRSA");
        signatureProvider.initSign(this.getPrivateKeyEntry().getPrivateKey());
        signatureProvider.update(buffer, 0, buffer.length);
        return Base64.getEncoder().encodeToString(signatureProvider.sign());
    }

    static class DFKeySelector
    extends KeySelector {
        DFKeySelector() {
        }

        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
            for (XMLStructure object : keyInfo.getContent()) {
                XMLStructure info = object;
                if (!(info instanceof X509Data)) continue;
                X509Data x509Data = (X509Data)info;
                for (Object certificado : x509Data.getContent()) {
                    if (!(certificado instanceof X509Certificate)) continue;
                    X509Certificate x509Certificate = (X509Certificate)certificado;
                    if (!this.algEquals(method.getAlgorithm(), x509Certificate.getPublicKey().getAlgorithm())) continue;
                    return x509Certificate::getPublicKey;
                }
            }
            throw new KeySelectorException("Nao foi localizada a chave do certificado.");
        }

        private boolean algEquals(String algURI, String algName) {
            return algName.equalsIgnoreCase("DSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1") || algName.equalsIgnoreCase("RSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        }
    }
}

