/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.utils;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.cte300.classes.CTAutorizador31;
import com.fincatto.documentofiscal.mdfe3.classes.MDFAutorizador3;
import com.fincatto.documentofiscal.nfe400.classes.NFAutorizador400;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;

public abstract class DFCadeiaCertificados
implements DFLog {
    private static final int PORT = 443;
    private static final String PROTOCOL = "TLSv1.2";

    /*
     * WARNING - void declaration
     */
    public static byte[] geraCadeiaCertificados(DFAmbiente ambiente, String senha) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, senha.toCharArray());
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            String host;
            String urlNF2;
            void var6_11;
            NFAutorizador400[] nFAutorizador400Array = NFAutorizador400.values();
            int n = nFAutorizador400Array.length;
            boolean bl = false;
            while (var6_11 < n) {
                String string;
                NFAutorizador400 aut = nFAutorizador400Array[var6_11];
                String urlNF = aut.getNfeStatusServico(ambiente);
                if (StringUtils.isNotBlank((CharSequence)urlNF)) {
                    String string2 = new URI(urlNF).getHost();
                    DFCadeiaCertificados.get(keyStore, string2);
                }
                if (StringUtils.isNotBlank((CharSequence)(string = aut.getNfceStatusServico(ambiente)))) {
                    String host3 = new URI(string).getHost();
                    DFCadeiaCertificados.get(keyStore, host3);
                }
                ++var6_11;
            }
            String urlNF1 = NFAutorizador400.AN.getRecepcaoEventoAN(ambiente);
            if (StringUtils.isNotBlank((CharSequence)urlNF1)) {
                String host4 = new URI(urlNF1).getHost();
                DFCadeiaCertificados.get(keyStore, host4);
            }
            if (StringUtils.isNotBlank((CharSequence)(urlNF2 = NFAutorizador400.AN.getNFeDistribuicaoDFe(ambiente)))) {
                String objectArray = new URI(urlNF2).getHost();
                DFCadeiaCertificados.get(keyStore, objectArray);
            }
            for (MDFAutorizador3 mDFAutorizador3 : MDFAutorizador3.values()) {
                String urlMDFe = mDFAutorizador3.getMDFeStatusServico(ambiente);
                if (!StringUtils.isNotBlank((CharSequence)urlMDFe)) continue;
                host = new URI(urlMDFe).getHost();
                DFCadeiaCertificados.get(keyStore, host);
            }
            for (CTAutorizador31 cTAutorizador31 : CTAutorizador31.values()) {
                String urlCTe = cTAutorizador31.getCteStatusServico(ambiente);
                if (!StringUtils.isNotBlank((CharSequence)urlCTe)) continue;
                host = new URI(urlCTe).getHost();
                DFCadeiaCertificados.get(keyStore, host);
            }
            keyStore.store(out, senha.toCharArray());
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    private static void get(KeyStore keyStore, String host) throws Exception {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        X509TrustManager defaultTrustManager = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
        SavingTrustManager savingTrustManager = new SavingTrustManager(defaultTrustManager);
        SSLContext sslContext = SSLContext.getInstance(PROTOCOL);
        sslContext.init(null, new TrustManager[]{savingTrustManager}, null);
        DFLog.getLogger(DFCadeiaCertificados.class).debug("Abrindo conexao para o servidor: {}:{}", (Object)host, (Object)443);
        try (SSLSocket sslSocket = (SSLSocket)sslContext.getSocketFactory().createSocket(host, 443);){
            sslSocket.setSoTimeout(10000);
            sslSocket.startHandshake();
        }
        catch (Exception e) {
            DFLog.getLogger(DFCadeiaCertificados.class).error(String.format("[%s] %s", host, e.toString()));
        }
        if (savingTrustManager.chain != null) {
            DFLog.getLogger(DFCadeiaCertificados.class).debug("Certificados enviados pelo servidor: {}", (Object)savingTrustManager.chain.length);
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            for (int i = 0; i < savingTrustManager.chain.length; ++i) {
                X509Certificate certificate = savingTrustManager.chain[i];
                sha1.update(certificate.getEncoded());
                md5.update(certificate.getEncoded());
                String alias = String.format("%s.%s", host, i + 1);
                keyStore.setCertificateEntry(alias, certificate);
                DFLog.getLogger(DFCadeiaCertificados.class).debug("Adicionado certificado no keystore com o alias: {}", (Object)alias);
            }
        }
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager trustManager;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager trustManager) {
            this.trustManager = trustManager;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustManager.getAcceptedIssuers();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.trustManager.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.trustManager.checkServerTrusted(chain, authType);
        }
    }
}

