/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.utils;

import com.fincatto.documentofiscal.DFConfig;
import com.fincatto.documentofiscal.DFLog;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.X509KeyManager;

public class DFKeyManager
implements X509KeyManager,
DFLog {
    private KeyStore ks;
    private String alias;
    private String password;

    public DFKeyManager(DFConfig config) throws KeyStoreException {
        this.ks = config.getCertificadoKeyStore();
        this.alias = DFKeyManager.getAlias(this.ks);
        this.password = config.getCertificadoSenha();
    }

    @Override
    public String chooseClientAlias(String[] str, Principal[] principal, Socket socket) {
        return this.alias;
    }

    @Override
    public String chooseServerAlias(String str, Principal[] principal, Socket socket) {
        return this.alias;
    }

    @Override
    public String[] getClientAliases(String str, Principal[] principal) {
        return new String[]{this.alias};
    }

    @Override
    public String[] getServerAliases(String str, Principal[] principal) {
        return new String[]{this.alias};
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        try {
            Certificate[] certificates = this.ks.getCertificateChain(alias);
            X509Certificate[] x509Certificates = new X509Certificate[certificates.length];
            System.arraycopy(certificates, 0, x509Certificates, 0, certificates.length);
            return x509Certificates;
        }
        catch (KeyStoreException e) {
            this.getLogger().error("N\u00e3o foi poss\u00edvel carregar o keystore para o alias:" + alias, (Throwable)e);
            return null;
        }
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        try {
            return (PrivateKey)this.ks.getKey(alias, this.password == null ? null : this.password.toCharArray());
        }
        catch (Exception e) {
            this.getLogger().error("N\u00e3o foi poss\u00edvel carregar o keystore para o alias:" + alias, (Throwable)e);
            return null;
        }
    }

    private static String getAlias(KeyStore ks) throws KeyStoreException {
        Enumeration<String> aliasesEnum = ks.aliases();
        while (aliasesEnum.hasMoreElements()) {
            String alias = aliasesEnum.nextElement();
            if (!ks.isKeyEntry(alias)) continue;
            return alias;
        }
        throw new KeyStoreException("Nenhum alias encontrado no certificado");
    }
}

