/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.utils;

import com.fincatto.documentofiscal.DFConfig;
import com.fincatto.documentofiscal.utils.DFKeyManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class DFSocketFactory
implements ProtocolSocketFactory {
    public static final int TIMEOUT_PADRAO_EM_MILLIS = 60000;
    public static final int SO_TIMEOUT_PADRAO_EM_MILLIS = 30000;
    private final DFConfig config;
    private final SSLContext sslContext;

    public DFSocketFactory(DFConfig config) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        this.config = config;
        this.sslContext = this.createSSLContext(config);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException {
        Socket socket = this.sslContext.getSocketFactory().createSocket();
        ((SSLSocket)socket).setEnabledProtocols(this.config.getSSLProtocolos());
        socket.bind(new InetSocketAddress(localAddress, localPort));
        int connectTimeout = params.getConnectionTimeout();
        socket.connect(new InetSocketAddress(host, port), connectTimeout);
        return socket;
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException {
        return this.sslContext.getSocketFactory().createSocket(host, port, clientHost, clientPort);
    }

    public Socket createSocket(String host, int port) throws IOException {
        return this.sslContext.getSocketFactory().createSocket(host, port);
    }

    private SSLContext createSSLContext(DFConfig config) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
        KeyManager[] keyManagers = this.createKeyManagers(config);
        TrustManager[] trustManagers = this.createTrustManagers(config);
        SSLContext sslContext = SSLContext.getInstance(config.getSSLProtocolos()[0]);
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    private KeyManager[] createKeyManagers(DFConfig config) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        return new KeyManager[]{new DFKeyManager(config)};
    }

    private TrustManager[] createTrustManagers(DFConfig config) throws KeyStoreException, NoSuchAlgorithmException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(config.getCadeiaCertificadosKeyStore());
        return trustManagerFactory.getTrustManagers();
    }
}

