/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.utils;

import java.util.Arrays;
import java.util.List;

public abstract class DFUtils {
    private static final List<String> CPFS_INVALIDOS = Arrays.asList("00000000000", "11111111111", "22222222222", "33333333333", "44444444444", "55555555555", "66666666666", "77777777777", "88888888888", "99999999999", "12345678909");

    public static boolean isCnpjValido(String cnpj) {
        int i;
        int i2;
        if (cnpj == null || !cnpj.matches("^[0-9]{14}$")) {
            return false;
        }
        if (cnpj.equalsIgnoreCase("00000000000000")) {
            return false;
        }
        String cnpjCalculado = cnpj.substring(0, 12);
        char[] chrCNPJ = cnpj.toCharArray();
        int soma = 0;
        for (i2 = 0; i2 < 4; ++i2) {
            if (chrCNPJ[i2] - 48 < 0 || chrCNPJ[i2] - 48 > 9) continue;
            soma += (chrCNPJ[i2] - 48) * (6 - (i2 + 1));
        }
        for (i2 = 0; i2 < 8; ++i2) {
            if (chrCNPJ[i2 + 4] - 48 < 0 || chrCNPJ[i2 + 4] - 48 > 9) continue;
            soma += (chrCNPJ[i2 + 4] - 48) * (10 - (i2 + 1));
        }
        int dig = 11 - soma % 11;
        cnpjCalculado = cnpjCalculado + (dig == 10 || dig == 11 ? "0" : Integer.toString(dig));
        soma = 0;
        for (i = 0; i < 5; ++i) {
            if (chrCNPJ[i] - 48 < 0 || chrCNPJ[i] - 48 > 9) continue;
            soma += (chrCNPJ[i] - 48) * (7 - (i + 1));
        }
        for (i = 0; i < 8; ++i) {
            if (chrCNPJ[i + 5] - 48 < 0 || chrCNPJ[i + 5] - 48 > 9) continue;
            soma += (chrCNPJ[i + 5] - 48) * (10 - (i + 1));
        }
        dig = 11 - soma % 11;
        cnpjCalculado = cnpjCalculado + (dig == 10 || dig == 11 ? "0" : Integer.toString(dig));
        return cnpj.equals(cnpjCalculado);
    }

    public static boolean isCpfValido(String cpf) {
        if (cpf == null || !cpf.matches("^[0-9]{11}$")) {
            return false;
        }
        if (CPFS_INVALIDOS.contains(cpf)) {
            return false;
        }
        int d1 = 0;
        int d2 = 0;
        for (int i = 1; i < 10; ++i) {
            int digitoCPF = Integer.parseInt(cpf.substring(i - 1, i));
            d1 += (11 - i) * digitoCPF;
            d2 += (12 - i) * digitoCPF;
        }
        int resto = d1 % 11;
        int digito1 = resto < 2 ? 0 : 11 - resto;
        resto = (d2 + 2 * digito1) % 11;
        int digito2 = resto < 2 ? 0 : 11 - resto;
        String nDigVerific = cpf.substring(cpf.length() - 2);
        String nDigResult = String.valueOf(digito1) + digito2;
        return nDigVerific.equals(nDigResult);
    }
}

