/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.validadores;

import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoItemModalidadeBCICMSST;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class DFStringValidador {
    public static void mmaaaa(String mmaaaa) {
        if (mmaaaa != null) {
            try {
                DateTimeFormatter.ofPattern("mm/yyyy").parse(mmaaaa);
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Formato invalido (mm/aaaa) (%s)", mmaaaa));
            }
        }
    }

    public static void aamm(String aamm) {
        if (aamm != null) {
            try {
                DateTimeFormatter.ofPattern("yymm").parse(aamm);
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Formato invalido (aamm) (%s)", aamm));
            }
        }
    }

    public static void codigoDeBarras(String codigoDeBarras) {
        Matcher matcher;
        if (codigoDeBarras != null && !(matcher = Pattern.compile("^([0-9]{0}|[0-9]{8}|[0-9]{12,14}|SEM GTIN)$").matcher(codigoDeBarras)).find()) {
            throw new IllegalStateException(String.format("Codigo de barras com formato invalido (%s)", codigoDeBarras));
        }
    }

    public static void telefone(String telefone) {
        Matcher matcher;
        if (telefone != null && !(matcher = Pattern.compile("^[0-9]{6,14}$").matcher(telefone)).find()) {
            throw new IllegalStateException(String.format("Telefone de tamanho invalido (%s)", telefone));
        }
    }

    public static String telefone(String telefone, String info) {
        Matcher matcher;
        if (telefone != null && !(matcher = Pattern.compile("^[0-9]{6,14}$").matcher(telefone)).find()) {
            throw new IllegalStateException(String.format("Telefone de tamanho invalido (%s) em %s", telefone, info));
        }
        return telefone;
    }

    public static void email(String email) {
        if (email != null) {
            String regex = "^([_a-zA-Z0-9-]+(\\.[_a-zA-Z0-9-]+)*@[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*(\\.[a-zA-Z]{1,6}))?$";
            Matcher matcher = Pattern.compile("^([_a-zA-Z0-9-]+(\\.[_a-zA-Z0-9-]+)*@[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*(\\.[a-zA-Z]{1,6}))?$").matcher(email);
            if (!matcher.find()) {
                throw new IllegalStateException(String.format("Email invalido (%s)", email));
            }
        }
    }

    public static String email(String email, String info) {
        if (email != null) {
            String regex = "^([_a-zA-Z0-9-]+(\\.[_a-zA-Z0-9-]+)*@[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*(\\.[a-zA-Z]{1,6}))?$";
            Matcher matcher = Pattern.compile("^([_a-zA-Z0-9-]+(\\.[_a-zA-Z0-9-]+)*@[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*(\\.[a-zA-Z]{1,6}))?$").matcher(email);
            if (!matcher.find()) {
                throw new IllegalStateException(String.format("Email invalido (%s) em %s", email, info));
            }
        }
        return email;
    }

    public static void tamanho256(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 256, info);
        }
    }

    public static void tamanho9(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 9, info);
        }
    }

    public static void tamanho60(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 60, info);
        }
    }

    public static void tamanho1ate8(String string, String info) {
        if (string != null) {
            DFStringValidador.intervalo(string, 1, 8, info);
        }
    }

    public static void tamanho2ate60(String string, String info) {
        if (string != null) {
            DFStringValidador.intervalo(string, 2, 60, info);
        }
    }

    public static void tamanho2ate40(String string, String info) {
        if (string != null) {
            DFStringValidador.intervalo(string, 2, 40, info);
        }
    }

    public static void tamanho2ate255(String string, String info) {
        if (string != null) {
            DFStringValidador.intervalo(string, 2, 255, info);
        }
    }

    public static void tamanho2ate2000(String string, String info) {
        if (string != null) {
            DFStringValidador.intervalo(string, 2, 2000, info);
        }
    }

    public static void tamanho25ate250(String string, String info) {
        if (string != null) {
            DFStringValidador.intervalo(string, 25, 250, info);
        }
    }

    public static void tamanho22(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 22, info);
        }
    }

    public static void tamanho21(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 21, info);
        }
    }

    public static void tamanho20(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 20, info);
        }
    }

    public static void tamanho20N(String string, String info) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, info);
            DFStringValidador.tamanho20(string, info);
        }
    }

    public static void tamanho2000(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 2000, info);
        }
    }

    public static void tamanho5000(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 5000, info);
        }
    }

    public static void tamanho40(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 40, info);
        }
    }

    public static void placaDeVeiculo(String placaVeiculo) {
        Matcher matcher;
        if (placaVeiculo != null && !(matcher = Pattern.compile("^([A-Z]{2,3}[0-9]{4}|[A-Z]{3,4}[0-9]{3}|[A-Z]{3}[0-9][A-Z][0-9]{2})$").matcher(placaVeiculo)).find()) {
            throw new IllegalStateException(String.format("Placa de veiculo nao esta no padrao (%s)", placaVeiculo));
        }
    }

    public static void placaDeVeiculo(String placaVeiculo, String info) {
        Matcher matcher;
        if (placaVeiculo != null && !(matcher = Pattern.compile("^([A-Z]{2,3}[0-9]{4}|[A-Z]{3,4}[0-9]{3}|[A-Z]{3}[0-9][A-Z][0-9]{2})$").matcher(placaVeiculo)).find()) {
            throw new IllegalStateException(String.format("%s nao esta no padrao (%s)", info, placaVeiculo));
        }
    }

    public static void cnpj(String cnpj) {
        Matcher matcher;
        if (cnpj != null && !(matcher = Pattern.compile("^[0-9]{14}$").matcher(cnpj)).find()) {
            throw new IllegalStateException(String.format("Formato CNPJ Invalido (%s)", cnpj));
        }
    }

    public static String cnpj(String cnpj, String info) {
        Matcher matcher;
        if (cnpj != null && !(matcher = Pattern.compile("^[0-9]{14}$").matcher(cnpj)).find()) {
            throw new IllegalStateException(String.format("Formato CNPJ Invalido (%s) em %s", cnpj, info));
        }
        return cnpj;
    }

    public static void cpf(String cpf) {
        Matcher matcher;
        if (cpf != null && !(matcher = Pattern.compile("^[0-9]{11}$").matcher(cpf)).find()) {
            throw new IllegalStateException(String.format("Formato CPF Invalido (%s)", cpf));
        }
    }

    public static String cpf(String cpf, String info) {
        Matcher matcher;
        if (cpf != null && !(matcher = Pattern.compile("^[0-9]{11}$").matcher(cpf)).find()) {
            throw new IllegalStateException(String.format("Formato CPF Invalido (%s) em %s", cpf, info));
        }
        return cpf;
    }

    public static void inscricaoEstadual(String inscricaoEstadual) {
        Matcher matcher;
        if (inscricaoEstadual != null && !(matcher = Pattern.compile("^(ISENTO|[0-9]{2,14}|)$").matcher(inscricaoEstadual)).find()) {
            throw new IllegalStateException(String.format("Inscricao estadual invalido (%s)", inscricaoEstadual));
        }
    }

    public static void inscricaoEstadualSemIsencao(String inscricaoEstadual) {
        Matcher matcher;
        if (inscricaoEstadual != null && !(matcher = Pattern.compile("^([0-9]{2,14}|)$").matcher(inscricaoEstadual)).find()) {
            throw new IllegalStateException(String.format("Inscricao estadual invalido (%s)", inscricaoEstadual));
        }
    }

    public static String inscricaoEstadualSemIsencao(String inscricaoEstadual, String info) {
        Matcher matcher;
        if (inscricaoEstadual != null && !(matcher = Pattern.compile("^([0-9]{2,14}|)$").matcher(inscricaoEstadual)).find()) {
            throw new IllegalStateException(String.format("Inscricao estadual invalido (%s) em %s", inscricaoEstadual, info));
        }
        return inscricaoEstadual;
    }

    public static void exatamente3(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 3, info);
        }
    }

    public static void exatamente5(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 5, info);
        }
    }

    public static void exatamente9(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 9, info);
        }
    }

    public static void exatamente9N(String string, String info) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, info);
            DFStringValidador.validaTamanhoExato(string, 9, info);
        }
    }

    public static void exatamente17(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 17, info);
        }
    }

    public static void exatamente4(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 4, info);
        }
    }

    public static void exatamente6(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 6, info);
        }
    }

    public static void exatamente21(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 21, info);
        }
    }

    public static void exatamente1(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 1, info);
        }
    }

    public static void exatamente13(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 13, info);
        }
    }

    public static void codigoProdutoAnvisa(String string, String info) {
        if (string != null) {
            if (string.toUpperCase().matches("[A-Z]*")) {
                if (!Objects.equals(string.toUpperCase(), "ISENTO")) {
                    throw new IllegalStateException(String.format("C\u00f3digo produto anvisa (%s) diferente de ISENTO", string));
                }
            } else if (string.length() <= 11) {
                DFStringValidador.validaTamanhoExato(string, 11, info);
            } else {
                DFStringValidador.validaTamanhoExato(string, 13, info);
            }
        }
    }

    public static void tamanho15(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 15, info);
        }
    }

    public static void tamanho12(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 12, info);
        }
    }

    public static void tamanho12N(String string, String info) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, info);
            DFStringValidador.validaTamanhoMaximo(string, 12, info);
        }
    }

    public static void tamanho120(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 120, info);
        }
    }

    public static void tamanho160(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 160, info);
        }
    }

    public static void tamanho10(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 10, info);
        }
    }

    public static void tamanho10N(String string, String info) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, info);
            DFStringValidador.validaTamanhoMaximo(string, 10, info);
        }
    }

    public static void tamanho100(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 100, info);
        }
    }

    public static void tamanho6(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 6, info);
        }
    }

    public static void tamanho6N(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 6, info);
        }
    }

    public static void tamanho500(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 500, info);
        }
    }

    public static void tamanho3(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 3, info);
        }
    }

    public static void exatamente7(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 7, info);
        }
    }

    public static void exatamente8(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 8, info);
        }
    }

    public static void exatamente8N(String string, String info) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, info);
            DFStringValidador.validaTamanhoExato(string, 8, info);
        }
    }

    public static void exatamente2(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 2, info);
        }
    }

    public static void exatamente2N(String string, String info) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, info);
            DFStringValidador.validaTamanhoExato(string, 2, info);
        }
    }

    public static void tamanho8a9(String string, String info) {
        if (string != null) {
            DFStringValidador.intervalo(string, 8, 9, info);
        }
    }

    public static void tamanho15a256(String string, String info) {
        if (string != null) {
            DFStringValidador.intervalo(string, 15, 256, info);
        }
    }

    public static void tamanho15a255(String string, String info) {
        if (string != null) {
            DFStringValidador.intervalo(string, 15, 255, info);
        }
    }

    public static void tamanho5a20(String string, String info) {
        if (string != null) {
            DFStringValidador.intervalo(string, 5, 20, info);
        }
    }

    public static void tamanho5a14(String string, String info) {
        if (string != null) {
            DFStringValidador.intervalo(string, 5, 14, info);
        }
    }

    public static void tamanho5a60(String string, String info) {
        if (string != null) {
            DFStringValidador.intervalo(string, 5, 60, info);
        }
    }

    public static void tamanho4a60(String string, String info) {
        if (string != null) {
            DFStringValidador.intervalo(string, 4, 60, info);
        }
    }

    public static void tamanho2a4(String string, String info) {
        if (string != null) {
            DFStringValidador.intervalo(string, 2, 4, info);
        }
    }

    public static void tamanho2a9N(String string, String info) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, info);
            DFStringValidador.intervalo(string, 2, 9, info);
        }
    }

    public static void tamanho8a9N(String string, String info) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, info);
            DFStringValidador.intervalo(string, 8, 9, info);
        }
    }

    public static void tamanho15a1000(String string, String info) {
        if (string != null) {
            DFStringValidador.intervalo(string, 15, 1000, info);
        }
    }

    public static void tamanho100a600(String string, String info) {
        if (string != null) {
            DFStringValidador.intervalo(string, 100, 600, info);
        }
    }

    public static void tamanho60a1000(String string, String info) {
        if (string != null) {
            DFStringValidador.intervalo(string, 60, 1000, info);
        }
    }

    public static void tamanho2a95(String string, String info) {
        if (string != null) {
            DFStringValidador.intervalo(string, 2, 95, info);
        }
    }

    public static void tamanho30(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 30, info);
        }
    }

    public static void exatamente44(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 44, info);
        }
    }

    public static void exatamente7N(String string, String info) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, info);
            DFStringValidador.exatamente7(string, info);
        }
    }

    public static void exatamente44N(String string, String info) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, info);
            DFStringValidador.exatamente44(string, info);
        }
    }

    public static void exatamente4N(String string, String info) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, info);
            DFStringValidador.exatamente4(string, info);
        }
    }

    public static void exatamente6N(String string, String info) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, info);
            DFStringValidador.exatamente6(string, info);
        }
    }

    public static void tamanho15N(String string, String info) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, info);
            DFStringValidador.validaTamanhoMaximo(string, 15, info);
        }
    }

    public static void tamanho14N(String string, String info) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, info);
            DFStringValidador.validaTamanhoMaximo(string, 14, info);
        }
    }

    public static void tamanho4(String string, String info) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 4, info);
        }
    }

    public static void tamanho4N(String string, String info) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, info);
            DFStringValidador.validaTamanhoMaximo(string, 4, info);
        }
    }

    public static void tamanho9N(String string, String info) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, info);
            DFStringValidador.validaTamanhoMaximo(string, 9, info);
        }
    }

    public static void tamanho2ou3N(String string, String info) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, info);
            DFStringValidador.intervalo(string, 2, 3, info);
        }
    }

    public static void tamanho3N(String string, String info) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, info);
            DFStringValidador.validaTamanhoMaximo(string, 3, info);
        }
    }

    public static void tamanho2N(String string, String info) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, info);
            DFStringValidador.validaTamanhoMaximo(string, 2, info);
        }
    }

    public static void exatamente20N(String string, String info) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, info);
            DFStringValidador.validaTamanhoExato(string, 20, info);
        }
    }

    public static void tamanho25N(String string, String info) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, info);
            DFStringValidador.validaTamanhoMaximo(string, 25, info);
        }
    }

    public static String validador(String paraValidar, String info, Integer tamanho, Boolean exatamente, Boolean numerico) {
        tamanho = (Integer)ObjectUtils.defaultIfNull((Object)tamanho, (Object)1);
        exatamente = (Boolean)ObjectUtils.defaultIfNull((Object)exatamente, (Object)false);
        numerico = (Boolean)ObjectUtils.defaultIfNull((Object)numerico, (Object)true);
        if (paraValidar != null) {
            if (numerico.booleanValue()) {
                DFStringValidador.apenasNumerico(paraValidar, info);
            }
            if (exatamente.booleanValue()) {
                DFStringValidador.validaTamanhoExato(paraValidar, tamanho, info);
            } else {
                DFStringValidador.validaTamanhoMaximo(paraValidar, tamanho, info);
            }
        }
        return paraValidar;
    }

    public static String validador(String paraValidar, String info, Integer tamanho, Boolean exatamente) {
        return DFStringValidador.validador(paraValidar, info, tamanho, exatamente, null);
    }

    public static String validador(String paraValidar, String info, Integer tamanho) {
        return DFStringValidador.validador(paraValidar, info, tamanho, null, null);
    }

    public static void fci(String numeroControleFCI) {
        Matcher matcher;
        if (numeroControleFCI != null && !(matcher = Pattern.compile("^([A-F0-9]{8}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{12})$").matcher(numeroControleFCI)).find()) {
            throw new IllegalStateException(String.format("FCI fora do padrao (%s)", numeroControleFCI));
        }
    }

    public static void ncm(String ncm) {
        Matcher matcher;
        if (ncm != null && !(matcher = Pattern.compile("^([0-9]{2}|[0-9]{8})$").matcher(ncm)).find()) {
            throw new IllegalStateException(String.format("NCM fora do padrao (%s)", ncm));
        }
    }

    private static void apenasNumerico(String string, String info) {
        if (string != null && !StringUtils.isNumeric((CharSequence)string)) {
            throw new IllegalStateException(String.format("A string %s precisa ser numerica (%s)", info, string));
        }
    }

    public static void validaTamanhoMaximo(String string, int tamanho, String info) {
        if (string != null && (string.length() < 1 || string.length() > tamanho)) {
            throw new IllegalStateException(String.format("%s \"%s\" deve possuir entre 1-%s caracteres", info, string, tamanho));
        }
    }

    private static void validaTamanhoExato(String string, int tamanho, String info) {
        if (string != null && string.length() != tamanho) {
            throw new IllegalStateException(String.format("%s \"%s\" deve possuir %s caracteres", info, string, tamanho));
        }
    }

    private static void intervalo(String string, int inicio, int fim, String info) {
        if (string != null && (string.length() < inicio || string.length() > fim)) {
            throw new IllegalStateException(String.format("%s \"%s\" deve possuir entre %s-%s caracteres", info, string, inicio, fim));
        }
    }

    public static String validaIntervalo(String string, int inicio, int fim, String info) {
        return DFStringValidador.validaIntervalo(string, inicio, fim, info, false);
    }

    public static String validaIntervalo(String string, int inicio, int fim, String info, Boolean isNumeric) {
        if (string != null) {
            if ((isNumeric = (Boolean)ObjectUtils.defaultIfNull((Object)isNumeric, (Object)false)).booleanValue()) {
                DFStringValidador.apenasNumerico(string, info);
            }
            DFStringValidador.intervalo(string, inicio, fim, info);
        }
        return string;
    }

    public static String capacidadeNDigitos(String capacidade, String info, int digitos) {
        Matcher matcher;
        if (capacidade != null && !(matcher = Pattern.compile("^(0|[1-9]{1}[0-9]{0," + digitos + "})$").matcher(capacidade)).find()) {
            throw new IllegalStateException(String.format("%s fora do padrao (%s)", info, capacidade));
        }
        return capacidade;
    }

    public static void nve(String nve) {
        Matcher matcher;
        if (nve != null && !(matcher = Pattern.compile("^[A-Z]{2}[0-9]{4}$").matcher(nve)).find()) {
            throw new IllegalStateException(String.format("NVE fora do padrao (%s)", nve));
        }
    }

    public static void itemListaServico(String itemListaServicos) {
        Matcher matcher;
        if (itemListaServicos != null && !(matcher = Pattern.compile("^\\d{2}\\.\\d{2}$").matcher(itemListaServicos)).find()) {
            throw new IllegalStateException(String.format("Item Lista de servico fora do padrao (%s)", itemListaServicos));
        }
    }

    public static void exatamente54(String string, String info) {
        DFStringValidador.validaTamanhoExato(string, 54, info);
    }

    public static void exatamente55(String string, String info) {
        DFStringValidador.validaTamanhoExato(string, 55, info);
    }

    public static void exatamente15N(String string, String info) {
        DFStringValidador.validaTamanhoExato(string, 15, info);
        DFStringValidador.apenasNumerico(string, info);
    }

    public static void exatamente11N(String string, String info) {
        DFStringValidador.apenasNumerico(string, info);
        DFStringValidador.validaTamanhoExato(string, 11, info);
    }

    public static void modeloDocumentoFiscal(String modeloDocumentoFiscal) {
        if (!modeloDocumentoFiscal.equals("55") && !modeloDocumentoFiscal.equals("65")) {
            throw new IllegalStateException(String.format("Modelo Fiscal Invalido (%s)", modeloDocumentoFiscal));
        }
    }

    public static void identificador(String identificador) {
        Matcher matcher = Pattern.compile("^ID\\d{41}$").matcher(identificador);
        if (!matcher.find()) {
            throw new IllegalStateException(String.format("Identificador fora do padrao (%s)", identificador));
        }
    }

    public static void identificadorCTe(String identificador) {
        Matcher matcher = Pattern.compile("^ID\\d{39}$").matcher(identificador);
        if (!matcher.find()) {
            throw new IllegalStateException(String.format("Identificador fora do padrao (%s)", identificador));
        }
    }

    public static void equals(String test, String tested) {
        if (!StringUtils.equals((CharSequence)test, (CharSequence)tested)) {
            throw new IllegalStateException(String.format("Valor('%s') nao corresponde com o padrao('%s')", tested, test));
        }
    }

    public static void isBase64(String string, String info) {
        if (!Base64.isArrayByteBase64((byte[])string.getBytes())) {
            throw new IllegalStateException(String.format("A string %s com o valor = '%s' precisa ser codificada em Base64. ", info, string));
        }
    }

    public static void validaCodigoRandomico(String string, String info) {
        CharSequence[] codigosInvalidos = new String[]{"00000000", "11111111", "22222222", "33333333", "44444444", "55555555", "66666666", "77777777", "88888888", "99999999", "12345678", "23456789", "34567890", "45678901", "56789012", "67890123", "78901234", "89012345", "90123456", "01234567"};
        if (StringUtils.containsAny((CharSequence)string, (CharSequence[])codigosInvalidos)) {
            throw new IllegalStateException(String.format("%s \"%s\" inv\u00e1lido", info, string));
        }
    }

    public static void validaPreenchimentoDeMargemValorAgregado(NFNotaInfoItemImpostoICMS impostoICMS) throws InvocationTargetException, IllegalAccessException {
        if (impostoICMS != null) {
            for (Method method : impostoICMS.getClass().getMethods()) {
                Object objectValue;
                Class<?> returnType = method.getReturnType();
                Method[] typeMethods = returnType.getMethods();
                boolean present = Arrays.stream(typeMethods).anyMatch(method1 -> method1.getReturnType().equals(NFNotaInfoItemModalidadeBCICMSST.class));
                if (!present || (objectValue = method.invoke((Object)impostoICMS, new Object[0])) == null) continue;
                Method modalidadeMethod = Arrays.stream(typeMethods).filter(method1 -> method1.getReturnType().equals(NFNotaInfoItemModalidadeBCICMSST.class)).findAny().get();
                NFNotaInfoItemModalidadeBCICMSST modalidadeBCICMSST = (NFNotaInfoItemModalidadeBCICMSST)((Object)modalidadeMethod.invoke(objectValue, new Object[0]));
                Method percentualMethod = Arrays.stream(typeMethods).filter(method1 -> method1.getName().contains("getPercentualMargemValorAdicionadoICMSST")).findAny().orElse(null);
                String percentualValue = null;
                if (percentualMethod != null) {
                    percentualValue = (String)percentualMethod.invoke(objectValue, new Object[0]);
                }
                if (modalidadeBCICMSST != null && modalidadeBCICMSST.equals((Object)NFNotaInfoItemModalidadeBCICMSST.MARGEM_VALOR_AGREGADO) && StringUtils.isBlank((CharSequence)percentualValue)) {
                    throw new IllegalStateException("Informada modalidade de determinacao da BC da ST como MVA(modBCST=4) e nao informado o campo pMVAST!");
                }
                if (!StringUtils.isNotBlank(percentualValue) || modalidadeBCICMSST != null && modalidadeBCICMSST.equals((Object)NFNotaInfoItemModalidadeBCICMSST.MARGEM_VALOR_AGREGADO)) continue;
                throw new IllegalStateException(String.format("Informada modalidade de determinacao da BC da ST diferente de MVA(informado[%s]) e informado o campo pMVAST", modalidadeBCICMSST != null ? modalidadeBCICMSST.toString() : "modBCST<>4"));
            }
        }
    }
}

