/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.validadores;

import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public final class DFXMLValidador {
    private static boolean valida(String xml, String xsd) throws IOException, SAXException, URISyntaxException {
        URL xsdPath = DFXMLValidador.class.getClassLoader().getResource(String.format("schemas/PL_008i2/%s", xsd));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(xsdPath.toURI().toString()));
        schema.newValidator().validate(new StreamSource(new StringReader(xml)));
        return true;
    }

    public static boolean validaLote(String arquivoXML) throws Exception {
        return DFXMLValidador.valida(arquivoXML, "enviNFe_v3.10.xsd");
    }

    public static boolean validaNota(String arquivoXML) throws Exception {
        return DFXMLValidador.valida(arquivoXML, "nfe_v3.10.xsd");
    }

    public static boolean valida400(String xml, String xsd) throws IOException, SAXException, URISyntaxException {
        return true;
    }

    public static boolean validaLote400(String arquivoXML) throws Exception {
        return DFXMLValidador.valida400(arquivoXML, "enviNFe_v4.00.xsd");
    }

    public static boolean validaNota400(String arquivoXML) throws Exception {
        return DFXMLValidador.valida400(arquivoXML, "nfe_v4.00.xsd");
    }

    private static boolean validaMDF(String xml, String xsd) throws IOException, SAXException, URISyntaxException {
        System.setProperty("jdk.xml.maxOccurLimit", "10000");
        URL xsdPath = DFXMLValidador.class.getClassLoader().getResource(String.format("schemas/PL_MDFe_300a_NT02020_NFF/%s", xsd));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(xsdPath.toURI().toString()));
        schema.newValidator().validate(new StreamSource(new StringReader(xml)));
        return true;
    }

    public static boolean validaLoteMDFe(String arquivoXML) throws Exception {
        return DFXMLValidador.validaMDF(arquivoXML, "enviMDFe_v3.00.xsd");
    }

    public static boolean validaMDFe(String arquivoXML) throws Exception {
        return DFXMLValidador.validaMDF(arquivoXML, "mdfe_v3.00.xsd");
    }

    public static boolean validaMDFeProcessado(String xml) throws Exception {
        return DFXMLValidador.validaMDF(xml, "procMDFe_v3.00.xsd");
    }

    public static boolean validaEventoMDFe(String xml) throws Exception {
        return DFXMLValidador.validaMDF(xml, "eventoMDFe_v3.00.xsd");
    }

    public static boolean validaEventoPagamentoOperacaoMDFe(String xml) throws Exception {
        return DFXMLValidador.validaMDF(xml, "evPagtoOperMDFe_v3.00.xsd");
    }

    private static boolean validaCTe(String xml, String xsd) throws IOException, SAXException, URISyntaxException {
        URL xsdPath = DFXMLValidador.class.getClassLoader().getResource(String.format("schemas/PL_CTe_300a_NT2022.001/%s", xsd));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(xsdPath.toURI().toString()));
        schema.newValidator().validate(new StreamSource(new StringReader(xml)));
        return true;
    }

    public static boolean validaLoteCTe300(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe(arquivoXML, "enviCTe_v3.00.xsd");
    }

    public static boolean validaCTeOS300(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe(arquivoXML, "cteOS_v3.00.xsd");
    }

    public static boolean validaNotaCte(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe(arquivoXML, "cte_v3.00.xsd");
    }

    public static boolean validaEventoCTe300(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe(arquivoXML, "eventoCTe_v3.00.xsd");
    }

    public static boolean validaEventoCancelamentoCTe300(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe(arquivoXML, "evCancCTe_v3.00.xsd");
    }

    public static boolean validaEventoCancelamentoComprovanteEntregaCTe300(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe(arquivoXML, "evCancCECTe_v3.00.xsd");
    }

    public static boolean validaEventoCartaCorrecaoCTe300(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe(arquivoXML, "evCCeCTe_v3.00.xsd");
    }

    public static boolean validaEventoComprovanteEntregaCTe300(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe(arquivoXML, "evCECTe_v3.00.xsd");
    }

    public static boolean validaEventoEpecCTe300(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe(arquivoXML, "evEPECCTe_v3.00.xsd");
    }

    public static boolean validaEventoGtvCTe300(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe(arquivoXML, "evGTV_v3.00.xsd");
    }

    public static boolean validaEventoPrestacaoEmDesacordoCTe300(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe(arquivoXML, "evPrestDesacordo_v3.00.xsd");
    }

    public static boolean validaEventoRegistroMultimodalCTe300(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe(arquivoXML, "evRegMultimodal_v3.00.xsd");
    }

    private static boolean validaCTe400(String xml, String xsd) throws IOException, SAXException, URISyntaxException {
        URL xsdPath = DFXMLValidador.class.getClassLoader().getResource(String.format("schemas/PL_CTe_400/%s", xsd));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(xsdPath.toURI().toString()));
        schema.newValidator().validate(new StreamSource(new StringReader(xml)));
        return true;
    }

    public static boolean validaNotaCte400(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe400(arquivoXML, "cte_v4.00.xsd");
    }

    public static boolean validaNotaCTeOS400(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe400(arquivoXML, "cteOS_v4.00.xsd");
    }

    public static boolean validaEventoCTe400(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe400(arquivoXML, "eventoCTe_v4.00.xsd");
    }

    public static boolean validaEventoCancelamentoCTe400(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe400(arquivoXML, "evCancCTe_v4.00.xsd");
    }

    public static boolean validaEventoCancelamentoComprovanteEntregaCTe400(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe400(arquivoXML, "evCancCECTe_v4.00.xsd");
    }

    public static boolean validaEventoCartaCorrecaoCTe400(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe400(arquivoXML, "evCCeCTe_v4.00.xsd");
    }

    public static boolean validaEventoComprovanteEntregaCTe400(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe400(arquivoXML, "evCECTe_v4.00.xsd");
    }

    public static boolean validaEventoEpecCTe400(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe400(arquivoXML, "evEPECCTe_v4.00.xsd");
    }

    public static boolean validaEventoGtvCTe400(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe400(arquivoXML, "evGTV_v4.00.xsd");
    }

    public static boolean validaEventoPrestacaoEmDesacordoCTe400(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe400(arquivoXML, "evPrestDesacordo_v4.00.xsd");
    }

    public static boolean validaEventoRegistroMultimodalCTe400(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe400(arquivoXML, "evRegMultimodal_v4.00.xsd");
    }

    public static boolean validaEventoCancelamentoPrestacaoEmDesacordoCTe400(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe400(arquivoXML, "evCancPrestDesacordo_v4.00.xsd");
    }

    public static boolean validaEventoCancelamentoInsucessoEntregaCTe400(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe400(arquivoXML, "evCancIECTe_v4.00.xsd");
    }

    public static boolean validaEventoInsucessoEntregaCTe400(String arquivoXML) throws Exception {
        return DFXMLValidador.validaCTe400(arquivoXML, "evIECTe_v4.00.xsd");
    }

    private static boolean validaDfe(String xml, String xsd) throws IOException, SAXException, URISyntaxException {
        URL xsdPath = DFXMLValidador.class.getClassLoader().getResource(String.format("schemas/PL_NFeDistDFe_102/%s", xsd));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(xsdPath.toURI().toString()));
        schema.newValidator().validate(new StreamSource(new StringReader(xml)));
        return true;
    }

    private static boolean validaDistribuicaoCTe(String xml, String xsd) throws IOException, SAXException, URISyntaxException {
        URL xsdPath = DFXMLValidador.class.getClassLoader().getResource(String.format("schemas/PL_CTeDistDFe_100/%s", xsd));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(xsdPath.toURI().toString()));
        schema.newValidator().validate(new StreamSource(new StringReader(xml)));
        return true;
    }

    public static boolean validaDistribuicaoCTe(String arquivoXML) throws IOException, SAXException, URISyntaxException {
        return DFXMLValidador.validaDistribuicaoCTe(arquivoXML, "distDFeInt_v1.00.xsd");
    }

    public static boolean validaConsultaDfe(String arquivoXML) throws Exception {
        return DFXMLValidador.validaDfe(arquivoXML, "distDFeInt_v1.01.xsd");
    }

    private static boolean validaEpec(String xml, String xsd) throws IOException, SAXException, URISyntaxException {
        URL xsdPath = DFXMLValidador.class.getClassLoader().getResource(String.format("schemas/Evento_EPEC_PL_v1.01/%s", xsd));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(xsdPath.toURI().toString()));
        schema.newValidator().validate(new StreamSource(new StringReader(xml)));
        return true;
    }

    public static boolean validaEpec(String arquivoXML) throws Exception {
        return DFXMLValidador.validaEpec(arquivoXML, "envEPEC_v1.00.xsd");
    }

    public static boolean validaEventoEpec(String arquivoXML) throws Exception {
        return DFXMLValidador.validaEpec(arquivoXML, "EPEC_v1.00.xsd");
    }
}

