/*
 * Decompiled with CFR 0.152.
 */
package com.zenvia.api.sdk.client.apache;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zenvia.api.sdk.client.AbstractClient;
import com.zenvia.api.sdk.client.Channel;
import com.zenvia.api.sdk.client.ChannelType;
import com.zenvia.api.sdk.client.errors.ErrorResponse;
import com.zenvia.api.sdk.client.exceptions.HttpConnectionFailException;
import com.zenvia.api.sdk.client.exceptions.HttpConnectionTimeoutException;
import com.zenvia.api.sdk.client.exceptions.HttpIOException;
import com.zenvia.api.sdk.client.exceptions.HttpSocketTimeoutException;
import com.zenvia.api.sdk.client.exceptions.UnsuccessfulRequestException;
import com.zenvia.api.sdk.client.exceptions.UnsupportedChannelException;
import com.zenvia.api.sdk.client.subscriptions.PartialSubscription;
import com.zenvia.api.sdk.client.subscriptions.Subscription;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client
extends AbstractClient {
    private static final Logger LOG = LoggerFactory.getLogger(Client.class);
    private final ObjectMapper jsonMapper = new ObjectMapper();

    public Client(String apiToken) {
        super(apiToken);
    }

    public Client(String apiToken, Integer maxConnections) {
        super(apiToken, maxConnections);
    }

    public Client(String apiToken, Integer connectionTimeout, Integer socketTimeout, Integer maxConnectionRetries) {
        super(apiToken, connectionTimeout, socketTimeout, maxConnectionRetries);
    }

    public Client(String apiToken, Integer maxConnections, Integer connectionTimeout, Integer socketTimeout, Integer maxConnectionRetries) {
        super(apiToken, maxConnections, connectionTimeout, socketTimeout, maxConnectionRetries);
    }

    public Client(String apiToken, Integer maxConnections, Integer connectionTimeout, Integer socketTimeout, Integer maxConnectionRetries, Integer connectionPoolTimeout, Integer inactivityTimeBeforeStaleCheck) {
        super(apiToken, maxConnections, connectionTimeout, socketTimeout, maxConnectionRetries, connectionPoolTimeout, inactivityTimeBeforeStaleCheck);
    }

    public Client(String apiToken, String apiUrl) {
        super(apiToken, apiUrl);
    }

    public Client(String apiToken, String apiUrl, Integer maxConnections) {
        super(apiToken, apiUrl, maxConnections);
    }

    public Client(String apiToken, String apiUrl, Integer connectionTimeout, Integer socketTimeout, Integer maxConnectionRetries) {
        super(apiToken, apiUrl, connectionTimeout, socketTimeout, maxConnectionRetries);
    }

    public Client(String apiToken, String apiUrl, Integer maxConnections, Integer connectionTimeout, Integer socketTimeout, Integer maxConnectionRetries) {
        super(apiToken, apiUrl, maxConnections, connectionTimeout, socketTimeout, maxConnectionRetries);
    }

    public Client(String apiToken, String apiUrl, Integer maxConnections, Integer connectionTimeout, Integer socketTimeout, Integer maxConnectionRetries, Integer connectionPoolTimeout, Integer inactivityTimeBeforeStaleCheck) {
        super(apiToken, apiUrl, maxConnections, connectionTimeout, socketTimeout, maxConnectionRetries, connectionPoolTimeout, inactivityTimeBeforeStaleCheck);
    }

    public Channel getChannel(String channelType) throws UnsupportedChannelException {
        return super.getChannel(channelType);
    }

    public Channel getChannel(ChannelType channelType) throws UnsupportedChannelException {
        return super.getChannel(channelType);
    }

    public List<Subscription> listSubscriptions() throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        return super.listSubscriptions();
    }

    public <SUBSCRIPTION extends Subscription> SUBSCRIPTION createSubscription(SUBSCRIPTION subscription) throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        return (SUBSCRIPTION)super.createSubscription(subscription);
    }

    public <SUBSCRIPTION extends Subscription> SUBSCRIPTION getSubscription(String id) throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        return (SUBSCRIPTION)super.getSubscription(id);
    }

    public <SUBSCRIPTION extends Subscription> SUBSCRIPTION updateSubscription(SUBSCRIPTION subscription) throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        return (SUBSCRIPTION)super.updateSubscription(subscription);
    }

    public <SUBSCRIPTION extends Subscription> SUBSCRIPTION updateSubscription(String id, PartialSubscription partialSubscription) throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        return (SUBSCRIPTION)super.updateSubscription(id, partialSubscription);
    }

    public void deleteSubscription(String id) throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        super.deleteSubscription(id);
    }

    protected <RESPONSE> RESPONSE list(String url, Class<RESPONSE> responseBodyType) throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        return this.executeRequest((HttpUriRequest)new HttpGet(url), null, responseBodyType);
    }

    protected <RESPONSE> RESPONSE get(String url, String id, Class<RESPONSE> responseBodyType) throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        return this.executeRequest((HttpUriRequest)new HttpGet(url + "/" + id), null, responseBodyType);
    }

    protected <REQUEST, RESPONSE> RESPONSE post(String url, REQUEST requestBody, Class<RESPONSE> responseBodyType) throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        return this.executeRequest((HttpUriRequest)new HttpPost(url), requestBody, responseBodyType);
    }

    protected <REQUEST, RESPONSE> RESPONSE patch(String url, String id, REQUEST requestBody, Class<RESPONSE> responseBodyType) throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        return this.executeRequest((HttpUriRequest)new HttpPatch(url + "/" + id), requestBody, responseBodyType);
    }

    protected void delete(String url, String id) throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        this.executeRequest((HttpUriRequest)new HttpDelete(url + "/" + id), null, null);
    }

    private <RESPONSE> RESPONSE executeRequest(HttpUriRequest httpMethod, Object requestBody, Class<RESPONSE> responseBodyType) throws UnsuccessfulRequestException, HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        HttpResponse httpResponse = this.executeRequest(httpMethod, requestBody);
        int httpStatus = httpResponse.getStatusLine().getStatusCode();
        if (httpStatus < 200 || httpStatus >= 300) {
            throw this.logException(new UnsuccessfulRequestException(httpMethod.getURI().toString(), httpStatus, this.deserialize(httpResponse.getEntity(), ErrorResponse.class, httpMethod.getURI().toString(), httpStatus)));
        }
        return this.deserialize(httpResponse.getEntity(), responseBodyType, httpMethod.getURI().toString(), httpStatus);
    }

    private HttpResponse executeRequest(HttpUriRequest httpMethod, Object requestBody) throws HttpSocketTimeoutException, HttpConnectionTimeoutException, HttpConnectionFailException, HttpIOException {
        HttpClientContext httpContext = new HttpClientContext();
        httpMethod.addHeader("X-API-Token", this.apiToken);
        if (requestBody != null && httpMethod instanceof HttpEntityEnclosingRequest) {
            ((HttpEntityEnclosingRequest)httpMethod).setEntity((HttpEntity)new ByteArrayEntity(this.serialize(requestBody), ContentType.APPLICATION_JSON));
        }
        String url = httpMethod.getURI().toString();
        try {
            return this.httpClient.execute(httpMethod, (HttpContext)httpContext);
        }
        catch (SocketTimeoutException cause) {
            throw this.logException(new HttpSocketTimeoutException(url, (Exception)cause));
        }
        catch (ConnectTimeoutException cause) {
            throw this.logException(new HttpConnectionTimeoutException(url, (Exception)((Object)cause)));
        }
        catch (ConnectException cause) {
            throw this.logException(new HttpConnectionFailException(url, (Exception)cause));
        }
        catch (IOException cause) {
            throw this.logException(new HttpIOException(url, (Exception)cause));
        }
    }

    private <TYPE> TYPE deserialize(HttpEntity entity, Class<TYPE> type, String url, int httpStatus) throws UnsuccessfulRequestException, HttpIOException {
        if (entity == null || entity.getContentLength() == 0L) {
            return null;
        }
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)buffer);
            byte[] data = buffer.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Response body: {}", (Object)new String(data, StandardCharsets.UTF_8));
            }
            return (TYPE)this.jsonMapper.readValue(data, type);
        }
        catch (JsonParseException | JsonMappingException exception) {
            throw this.logException(new UnsuccessfulRequestException(url, httpStatus, (Exception)exception));
        }
        catch (IOException exception) {
            throw this.logException(new HttpIOException(url, (Exception)exception));
        }
    }

    private byte[] serialize(Object data) throws IllegalArgumentException {
        try {
            byte[] serialized = this.jsonMapper.writeValueAsBytes(data);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Request body: {}", (Object)new String(serialized, StandardCharsets.UTF_8));
            }
            return serialized;
        }
        catch (JsonProcessingException exception) {
            LOG.error("Exception serializing request body", (Throwable)exception);
            throw new IllegalArgumentException("Exception serializing request body", exception);
        }
    }

    private <EXCEPTION extends Exception> EXCEPTION logException(EXCEPTION exception) {
        LOG.warn(exception.getMessage());
        LOG.debug("Request error", exception);
        return exception;
    }
}

