/*
 * Decompiled with CFR 0.152.
 */
package com.zenvia.api.sdk.client.subscriptions;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.ser.ZonedDateTimeSerializer;
import com.zenvia.api.sdk.Json;
import com.zenvia.api.sdk.ZonedDateTimeDeserializer;
import com.zenvia.api.sdk.client.subscriptions.Criteria;
import com.zenvia.api.sdk.client.subscriptions.EventType;
import com.zenvia.api.sdk.client.subscriptions.MessageStatusSubscription;
import com.zenvia.api.sdk.client.subscriptions.MessageSubscription;
import com.zenvia.api.sdk.client.subscriptions.PartialSubscription;
import com.zenvia.api.sdk.client.subscriptions.SubscriptionStatus;
import com.zenvia.api.sdk.client.subscriptions.Webhook;
import java.time.ZonedDateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="eventType", include=JsonTypeInfo.As.EXISTING_PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=MessageSubscription.class, name="MESSAGE"), @JsonSubTypes.Type(value=MessageStatusSubscription.class, name="MESSAGE_STATUS")})
@JsonPropertyOrder(value={"eventType"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class Subscription {
    public final String id;
    public final EventType eventType;
    public final Webhook webhook;
    public final Criteria criteria;
    public final SubscriptionStatus status;
    @JsonDeserialize(using=ZonedDateTimeDeserializer.class)
    @JsonSerialize(using=ZonedDateTimeSerializer.class)
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    public final ZonedDateTime createdAt;
    @JsonDeserialize(using=ZonedDateTimeDeserializer.class)
    @JsonSerialize(using=ZonedDateTimeSerializer.class)
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    public final ZonedDateTime updatedAt;

    protected Subscription(String id, EventType eventType, Webhook webhook, Criteria criteria, SubscriptionStatus status, ZonedDateTime createdAt, ZonedDateTime updatedAt) {
        this.id = id;
        this.eventType = eventType;
        this.webhook = webhook;
        this.criteria = criteria;
        this.status = status;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public <SUBSCRIPTION extends Subscription> SUBSCRIPTION apply(PartialSubscription partialSubscription) {
        return this.apply(partialSubscription.webhook, partialSubscription.status);
    }

    public abstract <SUBSCRIPTION extends Subscription> SUBSCRIPTION apply(Webhook var1, SubscriptionStatus var2);

    public MessageSubscription ofMessage() {
        return (MessageSubscription)this;
    }

    public MessageStatusSubscription ofMessageStatus() {
        return (MessageStatusSubscription)this;
    }

    public String toString() {
        return Json.pretty(this);
    }
}

