/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce;

import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.components.TouchButton;
import com.touchcomp.touchnfce.listeners.ShortcutListener;
import com.touchcomp.touchnfce.properties.ConfPropertiesLoader;
import com.touchcomp.touchnfce.properties.PropertiesLoader;
import com.touchcomp.touchnfce.utils.Style;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import lombok.Generated;

public abstract class BaseDialog
implements Initializable,
ShortcutListener {
    private Stage stage;
    private Map params;
    ObservableList<Stage> stages;

    public void initialize(URL location, ResourceBundle resources) {
        this.initializeController(resources);
        this.requestFocusOnOpen();
        this.setStyle();
    }

    public abstract void initializeController(ResourceBundle var1);

    public abstract void eventKey(KeyEvent var1);

    public abstract void eventAltControl(KeyEvent var1);

    @Override
    public void evtKey(KeyEvent evt) {
        this.eventKey(evt);
    }

    @Override
    public void firstEscapeKey(KeyEvent evt) {
    }

    @Override
    public void evtAltControl(KeyEvent event) {
        switch (event.getCode()) {
            case F: {
                this.checkFullScreen();
            }
        }
        this.eventAltControl(event);
    }

    private void checkFullScreen() {
        boolean full = Main.get().getPrimaryStage().isFullScreen();
        Main.get().getPrimaryStage().setFullScreen(!full);
        ConfPropertiesLoader.get().adicionaProperties(ConfPropertiesLoader.FULL_SCREEN, String.valueOf(full));
    }

    public abstract void requestFocusOnOpen();

    public void closeDialog() {
        this.stage.close();
        Main.get().closeDialog(this.stage);
    }

    public Map getParams() {
        return this.params;
    }

    public void setParams(Map params) {
        this.params = params;
    }

    public void posInitialize() {
    }

    private void setStyle() {
        Field[] fields;
        PropertiesLoader props = PropertiesLoader.get();
        Style style = new Style();
        for (Field f : fields = this.getClass().getDeclaredFields()) {
            try {
                f.setAccessible(true);
                Object it = f.get(this);
                if (it instanceof TextField) continue;
                if (it instanceof TouchButton) {
                    TouchButton aux = (TouchButton)((Object)it);
                    if (aux.isScreenStyled()) continue;
                    aux.setStyle(style.getStyleButton(props.getCorBordaButton(), props.getCorRadiusButton1(), props.getCorRadiusButton2(), props.getCorTextoButton()));
                    continue;
                }
                if (it instanceof Button) {
                    ((Button)it).setFocusTraversable(false);
                    ((Button)it).setStyle(style.getStyleButton(props.getCorBordaButton(), props.getCorRadiusButton1(), props.getCorRadiusButton2(), props.getCorTextoButton()));
                    continue;
                }
                if (it instanceof Label) {
                    ((Label)it).setStyle(style.getCorTextoDialog(props.getCorTexto()));
                    continue;
                }
                if (!(it instanceof AnchorPane)) continue;
                ((AnchorPane)it).setStyle(style.getCorBody(props.getCorBackground_1(), props.getCorBackground_2(), props.getCorBackground_3(), props.getCorBackground_4(), props.getCorBackground_5()));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Generated
    public void setStage(Stage stage) {
        this.stage = stage;
    }

    @Generated
    public Stage getStage() {
        return this.stage;
    }
}

