/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce;

import com.touchcomp.touchnfce.listeners.ShortcutListener;
import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import javafx.stage.Window;

public class MainEvents {
    private EventHandler bootHandler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            if (MainEvents.this.getListener() != null) {
                if (MainEvents.this.lastKeyCode != null && MainEvents.this.lastKeyCode == KeyCode.ALT && event.getCode() != KeyCode.ALT) {
                    MainEvents.this.getListener().evtAltControl(event);
                    MainEvents.this.lastKeyCode = null;
                } else if (MainEvents.this.lastKeyCode != null && MainEvents.this.lastKeyCode == KeyCode.ESCAPE && event.getCode() == KeyCode.ESCAPE) {
                    MainEvents.this.getListener().evtKey(event);
                    MainEvents.this.lastKeyCode = null;
                } else if (event.getCode() != KeyCode.ESCAPE) {
                    MainEvents.this.getListener().evtKey(event);
                    MainEvents.this.lastKeyCode = event.getCode();
                } else if (event.getCode() == KeyCode.ESCAPE) {
                    MainEvents.this.getListener().firstEscapeKey(event);
                    MainEvents.this.lastKeyCode = event.getCode();
                } else {
                    MainEvents.this.lastKeyCode = event.getCode();
                }
            }
        }
    };
    private ShortcutListener listener;
    private Stage stage;
    private static MainEvents instance;
    private KeyCode lastKeyCode;

    public static void setInstance(MainEvents instance) {
        MainEvents.instance = instance;
    }

    public static MainEvents getInstance() {
        return instance;
    }

    protected MainEvents(Stage stage) {
        this.stage = stage;
        this.setHandler(stage);
    }

    private void setHandler(Stage stage) {
        stage.addEventHandler(KeyEvent.KEY_RELEASED, this.bootHandler);
    }

    private void setHandler(Window stage) {
        stage.addEventHandler(KeyEvent.KEY_RELEASED, this.bootHandler);
    }

    public ShortcutListener getListener() {
        return this.listener;
    }

    public void setListener(ShortcutListener listener) {
        this.listener = listener;
    }

    public void setListener(ShortcutListener listener, Stage secondary) {
        this.listener = listener;
        this.setHandler(secondary);
    }

    public void setListener(ShortcutListener listener, Window secondary) {
        this.listener = listener;
        this.setHandler(secondary);
    }
}

