/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce;

import br.com.mzsw.PesoLib;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.controller.venda.VendaNFCeController;
import com.touchcomp.touchnfce.model.DadosConfiguracaoLocal;
import com.touchcomp.touchnfce.model.DadosSincronizacao;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.Grupo;
import com.touchcomp.touchnfce.model.ItemPedido;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeCaixa;
import com.touchcomp.touchnfce.model.NFCeControleCaixa;
import com.touchcomp.touchnfce.model.NFCeOpcoes;
import com.touchcomp.touchnfce.model.NFCePeriodoEmissao;
import com.touchcomp.touchnfce.model.Pedido;
import com.touchcomp.touchnfce.model.PeriodoEmissaoNFe;
import com.touchcomp.touchnfce.model.Usuario;
import com.touchcomp.touchnfce.model.UsuarioEmpresa;
import com.touchcomp.touchnfce.modeltemp.ControllerPath;
import com.touchcomp.touchnfce.service.impl.ServiceDadosConfiguracaoLocal;
import com.touchcomp.touchnfce.service.impl.ServiceDadosSincronizacao;
import com.touchcomp.touchnfce.service.impl.ServiceNFCe;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeControleCaixa;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeOpcoes;
import com.touchcomp.touchnfce.service.impl.ServicePedidoEnv;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import com.touchcomp.touchnfce.utils.UtilPeriodoEmissao;
import com.touchcomp.touchnfce.utils.pedido.UtilPedido;
import java.util.Date;
import javafx.application.Platform;
import javafx.stage.Stage;

public class StaticObjects {
    private static Empresa empresa;
    private static Usuario usuario;
    private static NFCeControleCaixa controleCaixa;
    private static NFCe nfceAberta;
    private static Pedido pedidoAberto;
    private static NFCeOpcoes opcoes;
    private static NFCeCaixa nfceCaixa;
    private static NFCePeriodoEmissao periodoEmissaoNFCe;
    private static PeriodoEmissaoNFe periodoEmissaoNFe;
    private static DadosSincronizacao dadosSincronizacao;
    private static DadosConfiguracaoLocal dadosConfiguracaoLocal;
    private static ControllerPath ultimaPagina;
    private static VendaNFCeController vendasController;
    private static Stage stageCentralAbastecimento;
    private static PesoLib pesoLib;

    public static NFCeOpcoes getOpcoes() {
        return opcoes;
    }

    public static void setOpcoes(NFCeOpcoes opcoes) {
        StaticObjects.opcoes = opcoes;
    }

    public static Empresa getEmpresa() {
        return empresa;
    }

    public static Usuario getUsuario() {
        return usuario;
    }

    public static Grupo getGrupo() {
        for (UsuarioEmpresa user : usuario.getEmpresas()) {
            if (!ToolMethods.isEquals((Object)StaticObjects.getEmpresa(), (Object)user.getEmpresa())) continue;
            return user.getGrupo();
        }
        return null;
    }

    public static void setUsuario(Usuario usuario) {
        StaticObjects.usuario = usuario;
    }

    public static NFCeControleCaixa getControleCaixa() {
        return controleCaixa;
    }

    public static void setControleCaixa(NFCeControleCaixa controleCaixa) {
        StaticObjects.controleCaixa = controleCaixa;
    }

    public static NFCe getNfceAberta() {
        if (nfceAberta == null) {
            nfceAberta = UtilNFCe.getCurrent(nfceCaixa);
        }
        return nfceAberta;
    }

    public static NFCe setNfceAberta(NFCe nfCe) {
        nfceAberta = nfCe;
        StaticObjects.refreshNFCe();
        return nfceAberta;
    }

    public static NFCeCaixa getNFCeCaixa() {
        return nfceCaixa;
    }

    public static void setNFCeCaixa(NFCeCaixa caixa) {
        nfceCaixa = caixa;
        empresa = caixa.getEmpresa();
        opcoes = StaticObjects.getOpcoesByEmpresa(empresa);
    }

    private static NFCeOpcoes getOpcoesByEmpresa(Empresa empresa) {
        ServiceNFCeOpcoes serviceNFCeOpcoes = Main.getBean(ServiceNFCeOpcoes.class);
        return serviceNFCeOpcoes.findByEmpresa(empresa);
    }

    public static NFCePeriodoEmissao getNFCePeriodoEmissao() {
        if (periodoEmissaoNFCe == null) {
            periodoEmissaoNFCe = UtilPeriodoEmissao.getCurrentNFCe(nfceCaixa);
        }
        return periodoEmissaoNFCe;
    }

    public static PeriodoEmissaoNFe getNFePeriodoEmissao() {
        if (periodoEmissaoNFe == null) {
            periodoEmissaoNFe = UtilPeriodoEmissao.getCurrentNFe(nfceCaixa);
        }
        return periodoEmissaoNFe;
    }

    public static DadosSincronizacao getDadosSincronizacao() {
        ServiceDadosSincronizacao serviceDadosSincronizacao;
        if (dadosSincronizacao == null && (dadosSincronizacao = (serviceDadosSincronizacao = Main.getBean(ServiceDadosSincronizacao.class)).getDadosSincronizacao()) == null) {
            dadosSincronizacao = new DadosSincronizacao();
        }
        return dadosSincronizacao;
    }

    public static DadosConfiguracaoLocal getDadosConfiguracaoLocal() {
        ServiceDadosConfiguracaoLocal service;
        if (dadosConfiguracaoLocal == null && (dadosConfiguracaoLocal = (service = Main.getBean(ServiceDadosConfiguracaoLocal.class)).getDadosConfiguracao()) == null) {
            dadosConfiguracaoLocal = new DadosConfiguracaoLocal();
        }
        return dadosConfiguracaoLocal;
    }

    public static void setDadosSincronizacao(DadosSincronizacao dados) {
        ServiceDadosSincronizacao serviceDadosSincronizacao = Main.getBean(ServiceDadosSincronizacao.class);
        dadosSincronizacao = serviceDadosSincronizacao.save(dados);
    }

    public static void refreshDadosSincronizacao() {
        StaticObjects.setDadosSincronizacao(dadosSincronizacao);
    }

    public static void refreshDadosConfiguracaoLocal(DadosConfiguracaoLocal dados) {
        ServiceDadosConfiguracaoLocal service = Main.getBean(ServiceDadosConfiguracaoLocal.class);
        dadosConfiguracaoLocal = service.save(dados);
    }

    public static void refreshNFCe() {
        nfceAberta = StaticObjects.refreshNFCe(nfceAberta);
    }

    public static synchronized NFCe refreshNFCe(NFCe nfce) {
        Date in = new Date();
        if (nfce == null) {
            return null;
        }
        if (nfce.getLoteNotas() != null) {
            nfce.getLoteNotas().getNotas().forEach(aux -> aux.setLoteNotas(nfce.getLoteNotas()));
        }
        nfce.getItens().forEach(item -> item.setNfce(nfce));
        ServiceNFCe serviceNFCe = Main.getBean(ServiceNFCe.class);
        NFCe ret = serviceNFCe.save(nfce);
        Date end = new Date();
        System.out.println("Tempo Salvar NFCe: " + ToolDate.difBetweenDatesInMiliseconds((Date)in, (Date)end));
        return ret;
    }

    public static void setPedidoAberto(Pedido ped) {
        pedidoAberto = ped;
        StaticObjects.refreshPedido();
    }

    public static void refreshPedido() {
        pedidoAberto = StaticObjects.refreshPedido(pedidoAberto);
    }

    public static synchronized Pedido refreshPedido(Pedido pedido) {
        Date in = new Date();
        if (pedido == null) {
            return null;
        }
        pedido.getItemPedido().forEach(item -> {
            item.setPedido(pedido);
            item.getGradeItemPedido().forEach(gr -> gr.setItemPedido((ItemPedido)item));
        });
        ServicePedidoEnv servicePedido = Main.getBean(ServicePedidoEnv.class);
        Pedido ped = servicePedido.save(pedido);
        Date end = new Date();
        System.out.println("Tempo Salvar Pedido: " + ToolDate.difBetweenDatesInMiliseconds((Date)in, (Date)end));
        return ped;
    }

    public static void clearNFCe() {
        nfceAberta = null;
        Main.get().getFooterController().atualizaStatusModeloNFCe();
    }

    public static ControllerPath getUltimaPagina() {
        return ultimaPagina;
    }

    public static void setUltimaPagina(ControllerPath ultPagina) {
        ultimaPagina = ultPagina;
    }

    public static void reloadNFCeAberta() {
        StaticObjects.setNfceAberta(null);
        StaticObjects.getNfceAberta();
    }

    public static void setPeriodoEmissaoNFCe(NFCePeriodoEmissao perEmissao) {
        periodoEmissaoNFCe = perEmissao;
    }

    public static void setPeriodoEmissaoNFe(PeriodoEmissaoNFe perEmissao) {
        periodoEmissaoNFe = perEmissao;
    }

    public static Pedido getPedidoAberto() {
        if (pedidoAberto == null) {
            pedidoAberto = UtilPedido.getUltimoPedidoAberto();
        }
        return pedidoAberto;
    }

    public static void clearPedido() {
        pedidoAberto = null;
        Main.get().getFooterController().atualizaStatusPedido();
    }

    public static VendaNFCeController getVendasController() {
        return vendasController;
    }

    public static void setVendasController(VendaNFCeController vendasController) {
        StaticObjects.vendasController = vendasController;
    }

    public static Stage getCentralAbastecimentoController() {
        return stageCentralAbastecimento;
    }

    public static void setCentralAbastecimentoController(Stage centralAbastecimentoController) {
        if (centralAbastecimentoController == null && stageCentralAbastecimento != null) {
            Platform.runLater(() -> {
                if (stageCentralAbastecimento != null) {
                    stageCentralAbastecimento.close();
                    stageCentralAbastecimento = centralAbastecimentoController;
                }
            });
        } else {
            stageCentralAbastecimento = centralAbastecimentoController;
        }
    }

    public static void createPesoBalancaLib() {
        System.loadLibrary("PesoLib32");
        pesoLib = new PesoLib();
    }

    public static PesoLib getPesoLib() {
        return pesoLib;
    }

    public static void checaExcluiNFCeTemp() {
        if (StaticObjects.getNfceAberta() != null && StaticObjects.getNfceAberta().getItens().isEmpty()) {
            if (ToolMethods.isWithData((Number)StaticObjects.getNfceAberta().getIdentificador()) && !ToolMethods.isAffirmative((Number)StaticObjects.getNfceAberta().getEnviado())) {
                ServiceNFCe serviceNFCe = Main.getBean(ServiceNFCe.class);
                serviceNFCe.delete(StaticObjects.getNfceAberta());
            }
            StaticObjects.setNfceAberta(null);
        }
    }

    public static void refreshValoresControleCaixa() {
        ServiceNFCeControleCaixa service = Main.getBean(ServiceNFCeControleCaixa.class);
        NFCeControleCaixa cont = service.calcularValores(StaticObjects.getControleCaixa());
        cont = service.save(cont);
        StaticObjects.setControleCaixa(cont);
    }

    public static void refreshRecalcularValoresControleCaixa() {
        ServiceNFCeControleCaixa service = Main.getBean(ServiceNFCeControleCaixa.class);
        NFCeControleCaixa cont = service.recalcularValores(StaticObjects.getControleCaixa());
        cont = service.save(cont);
        StaticObjects.setControleCaixa(cont);
    }

    static {
        stageCentralAbastecimento = null;
        pesoLib = null;
    }
}

