/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.components;

import com.touchcomp.touchnfce.properties.PropertiesLoader;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.RadioButton;

public class TouchRadioButton
extends RadioButton {
    public TouchRadioButton() {
        this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                if (newPropertyValue.booleanValue()) {
                    TouchRadioButton.this.onFocusGained();
                }
                if (oldPropertyValue.booleanValue()) {
                    TouchRadioButton.this.onFocusLost();
                }
            }
        });
    }

    public void setSelectedRadio(boolean selected) {
        this.setSelected(selected);
        if (this.isSelected()) {
            this.onFocusGained();
        } else {
            this.onFocusLost();
        }
    }

    private void onFocusGained() {
        this.setStyle("-fx-text-fill: #FFFF00;-fx-font-size: 1.4em;");
    }

    private void onFocusLost() {
        PropertiesLoader props = PropertiesLoader.get();
        this.setStyle("-fx-text-fill: " + props.getCorTexto() + ";-fx-font-size: 1.4em;");
    }
}

