/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.components;

import com.touchcomp.touchnfce.components.listener.FocusListener;
import com.touchcomp.touchnfce.properties.PropertiesLoader;
import java.util.LinkedList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;

public class TouchTextArea
extends TextArea {
    private final String STYLE_COLOR_FOCUS = "-fx-control-inner-background: #B0E0E6";
    private final String STYLE_COLOR_NO_FOCUS = "-fx-control-inner-background: #FFFFFF";
    private List<FocusListener> listeners = new LinkedList<FocusListener>();
    private Label label;

    public TouchTextArea() {
        this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                if (newPropertyValue.booleanValue()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TouchTextArea.this.selectAll();
                        }
                    });
                    TouchTextArea.this.onFocusGained();
                }
                if (oldPropertyValue.booleanValue()) {
                    TouchTextArea.this.onFocusLost();
                }
            }
        });
    }

    private void onFocusGained() {
        this.setStyle("-fx-control-inner-background: #B0E0E6");
        this.listeners.forEach(l -> l.onFocusGained());
        if (this.label != null) {
            this.label.setStyle("-fx-text-fill: #FFFF00;-fx-font-size: 1.2em;");
        }
    }

    private void onFocusLost() {
        this.setStyle("-fx-control-inner-background: #FFFFFF");
        this.listeners.forEach(l -> l.onFocusLost());
        if (this.label != null) {
            PropertiesLoader props = PropertiesLoader.get();
            this.label.setStyle("-fx-text-fill: " + props.getCorTexto() + ";-fx-font-size: 1.2em;");
        }
    }

    public void requestFocusColor() {
        if (this.getScene().focusOwnerProperty().get() instanceof TouchTextArea) {
            TextArea focusedTextField = (TextArea)this.getScene().focusOwnerProperty().get();
            focusedTextField.setStyle("-fx-control-inner-background: #B0E0E6");
        }
    }

    public void addFocusListener(FocusListener listener) {
        this.listeners.add(listener);
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }
}

