/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.components.table;

import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import com.touchcomp.touchnfce.utils.UtilPesquisa;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableView;
import javafx.scene.layout.GridPane;

public abstract class PaginationTable<T>
extends GridPane
implements Initializable {
    @FXML
    private TouchTextField tfFilter;
    @FXML
    private Label lblFilter;
    @FXML
    private Button buttonAnt;
    @FXML
    private Button buttonProx;
    @FXML
    private GridPane root;
    protected TableView<T> table;
    private Integer page;
    private List<UnidadeFatCliente> filterElements = new LinkedList<UnidadeFatCliente>();
    private boolean loading = false;
    private boolean pesquisaAutomatica = true;

    public PaginationTable() {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource(this.getPathView()));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.page = 1;
        this.tfFilter.setLabel(this.lblFilter);
        if (this.getInternalTable() != null) {
            this.table = this.getInternalTable();
            this.root.add(this.table, 0, 3);
        }
        if (this.enableButtonAnterior() != null && !this.enableButtonAnterior().booleanValue()) {
            this.buttonAnt.setDisable(true);
            this.buttonAnt.setVisible(false);
        }
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> {
            if (this.pesquisaAutomatica) {
                this.carregaRegistros((String)newValue);
            }
        });
        this.buttonAnt.setOnAction(evt -> this.anterior());
        this.buttonProx.setOnAction(evt -> this.proximo());
    }

    public void carregaRegistros(String aux) {
        if (UtilPesquisa.iniciarPesquisa(aux)) {
            this.page = 1;
            this.buttonAnt.setDisable(false);
            this.buttonProx.setDisable(false);
            this.reloadElementsTable();
        }
    }

    public void anterior() {
        if (this.page == 1) {
            this.buttonAnt.setDisable(true);
            return;
        }
        Integer n = this.page;
        this.page = this.page - 1;
        this.buttonProx.setDisable(false);
        this.reloadElementsTable();
    }

    public void proximo() {
        Integer n = this.page;
        this.page = this.page + 1;
        this.buttonAnt.setDisable(false);
        this.reloadElementsTable();
    }

    public void setStringTextField(String text) {
        if (text != null) {
            this.tfFilter.setText(text);
        }
    }

    public void setItemsTable(List<T> items) {
        if (items != null) {
            this.table.setItems(FXCollections.observableArrayList(items));
            this.table.getSelectionModel().selectFirst();
        }
    }

    public void reloadElementsTable() {
        if (this.table == null) {
            return;
        }
        if (this.loading) {
            return;
        }
        this.loading = true;
        List<T> items = this.loadingMoreItems(this.page, this.tfFilter.getText());
        if (items != null) {
            if (items == null || items.isEmpty()) {
                items = new LinkedList<T>();
                this.buttonProx.setDisable(true);
            }
            this.table.getItems().clear();
            this.table.getItems().addAll(items);
            if (!items.isEmpty()) {
                this.table.getSelectionModel().selectFirst();
            }
            this.table.refresh();
        }
        this.loading = false;
    }

    public abstract TableView<T> getInternalTable();

    public abstract List<T> loadingMoreItems(Integer var1, String var2);

    public abstract Boolean enableButtonAnterior();

    public abstract String getPathView();

    public T getSelectedItem() {
        if (this.table == null) {
            return null;
        }
        return (T)this.table.getSelectionModel().getSelectedItem();
    }

    public TouchTextField getTfFilter() {
        return this.tfFilter;
    }

    public TableView<T> getTable() {
        return this.table;
    }

    public Button getButtonAnt() {
        return this.buttonAnt;
    }

    public Button getButtonProx() {
        return this.buttonProx;
    }

    public void setPesquisaAutomatica(boolean pesquisaAutomatica) {
        this.pesquisaAutomatica = pesquisaAutomatica;
    }
}

