/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.components.table.converter;

import com.touchcomp.touchnfce.controller.Alerts;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javafx.util.StringConverter;

public class MoneyStringConverter
extends StringConverter<Double> {
    DecimalFormat formato = new DecimalFormat("#.##");

    public Double fromString(String value) {
        try {
            if (value == null) {
                return null;
            }
            if ((value = value.trim()).length() < 1) {
                return null;
            }
            if (value.contains(",")) {
                value = value.replaceAll(",", ".");
            }
            Double numero = Double.valueOf(value);
            String aux = this.formato.format(numero);
            NumberFormat format = NumberFormat.getInstance(Locale.getDefault());
            Number number = format.parse(aux);
            Double newValue = number.doubleValue();
            return newValue;
        }
        catch (Exception e) {
            Alerts.showAlertError("Informe um valor v\u00e1lido!");
            return null;
        }
    }

    public String toString(Double value) {
        if (value == null) {
            return "";
        }
        return this.formato.format(value);
    }
}

