/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.controller.dialogs.DialogComboBox;
import com.touchcomp.touchnfce.controller.dialogs.DialogDateTimeTextField;
import com.touchcomp.touchnfce.controller.dialogs.DialogFieldMaxLenght;
import com.touchcomp.touchnfce.controller.dialogs.ReimpressaoFechamentoCaixa;
import com.touchcomp.touchnfce.modeltemp.ControllerPath;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.stage.Window;

public class Alerts {
    public static void showAlertError(String title, String header, String body, Stage stage) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        DialogPane dialogPane = alert.getDialogPane();
        if (stage != null) {
            alert.initOwner((Window)stage);
        } else {
            alert.initOwner((Window)Main.get().getPrimaryStage());
        }
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.setContentText(body);
        dialogPane.setStyle("-fx-background-color: white;");
        alert.showAndWait();
        if (stage != null) {
            stage.requestFocus();
        } else {
            Main.get().getPrimaryStage().requestFocus();
        }
    }

    public static void showAlertError(String title, String message) {
        Alerts.showAlertError(title, "", message, null);
    }

    public static void showAlertError(String message) {
        Alerts.showAlertError("Erro", "", message, null);
    }

    public static void showAlertError(String message, Stage stage) {
        Alerts.showAlertError("Erro", "", message, stage);
    }

    public static void showAlertInfo(String title, String header, String body, boolean showAndWait, Stage stage) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        DialogPane dialogPane = alert.getDialogPane();
        if (stage != null) {
            alert.initOwner((Window)stage);
        } else {
            alert.initOwner((Window)Main.get().getPrimaryStage());
        }
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.setContentText(body);
        dialogPane.setStyle("-fx-background-color: white;");
        if (showAndWait) {
            alert.showAndWait();
        } else {
            alert.show();
        }
    }

    public static void showAlertInfo(String title, String header, String body) {
        Alerts.showAlertInfo(title, header, body, true, null);
    }

    public static void showAlertInfo(String header, String body) {
        Alerts.showAlertInfo("Informa\u00e7\u00e3o", header, body);
    }

    public static void showAlertInfo(String body) {
        Alerts.showAlertInfo("Informa\u00e7\u00e3o", "", body);
    }

    public static void showAlertInfo(String body, boolean showAndWait) {
        Alerts.showAlertInfo("Informa\u00e7\u00e3o", "", body, showAndWait, null);
    }

    public static void showAlertInfo(String body, Stage stage) {
        Alerts.showAlertInfo("Informa\u00e7\u00e3o", "", body, true, stage);
    }

    public static void showAlertWarning(String title, String header, String body, Stage stage) {
        Alert alert = new Alert(Alert.AlertType.WARNING);
        DialogPane dialogPane = alert.getDialogPane();
        if (stage != null) {
            alert.initOwner((Window)stage);
        } else {
            alert.initOwner((Window)Main.get().getPrimaryStage());
        }
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.setContentText(body);
        dialogPane.setStyle("-fx-background-color: white;");
        alert.showAndWait();
        if (stage != null) {
            stage.requestFocus();
        } else {
            Main.get().getPrimaryStage().requestFocus();
        }
    }

    public static void showAlertWarning(String header, String body) {
        Alerts.showAlertWarning("Aten\u00e7\u00e3o", header, body, null);
    }

    public static void showAlertWarning(String body, Stage stage) {
        Alerts.showAlertInfo("Informa\u00e7\u00e3o", "", body, true, stage);
    }

    public static void showAlertWarning(String body) {
        Alerts.showAlertWarning("Informa\u00e7\u00e3o", "", body, null);
    }

    public static EnumConstantsMentorSimNao showQuestionYesNo(String title, String header, String body, Stage stage) {
        ButtonType sim = new ButtonType("Sim", ButtonBar.ButtonData.OK_DONE);
        ButtonType nao = new ButtonType("N\u00e3o", ButtonBar.ButtonData.CANCEL_CLOSE);
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, header, new ButtonType[]{sim, nao});
        DialogPane dialogPane = alert.getDialogPane();
        dialogPane.setStyle("-fx-background-color: white;");
        if (!ToolMethods.isStrWithData((String)title)) {
            title = "Informa\u00e7\u00e3o";
        }
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.setContentText(body);
        Optional<ButtonType> res = Alerts.addPropsAndShow(alert, stage);
        if (res.isPresent() && res.get().getButtonData().equals((Object)ButtonBar.ButtonData.OK_DONE)) {
            return EnumConstantsMentorSimNao.SIM;
        }
        return EnumConstantsMentorSimNao.NAO;
    }

    public static Optional<ButtonType> showQuestion(String title, String header, String body, Stage stage) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, header, new ButtonType[0]);
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.setContentText(body);
        return Alerts.addPropsAndShow(alert, stage);
    }

    private static Optional<ButtonType> addPropsAndShow(Alert alert, Stage stage) {
        EventHandler fireOnEnter = event -> {
            if (KeyCode.ENTER.equals((Object)event.getCode()) && event.getTarget() instanceof Button) {
                ((Button)event.getTarget()).fire();
                alert.close();
            } else if (KeyCode.ESCAPE.equals((Object)event.getCode()) && event.getTarget() instanceof Button) {
                alert.close();
            }
        };
        DialogPane dialogPane = alert.getDialogPane();
        dialogPane.getButtonTypes().stream().map(arg_0 -> ((DialogPane)dialogPane).lookupButton(arg_0)).forEach(button -> button.addEventHandler(KeyEvent.KEY_PRESSED, fireOnEnter));
        if (stage != null) {
            alert.initOwner((Window)stage);
        } else {
            alert.initOwner((Window)Main.get().getPrimaryStage());
        }
        return alert.showAndWait();
    }

    public static <T> T showQuestion(String title, Object[] data, Class<T> type) {
        ChoiceDialog choiceDialog = new ChoiceDialog((Object)title, data);
        choiceDialog.showingProperty().addListener((ov, b, b1) -> {
            if (b1.booleanValue()) {
                choiceDialog.setContentText("");
            } else {
                choiceDialog.setContentText(null);
            }
            if (b1.booleanValue()) {
                Node comboBox = choiceDialog.getDialogPane().lookup(".combo-box");
                comboBox.requestFocus();
            }
        });
        choiceDialog.showAndWait();
        Object sel = choiceDialog.getSelectedItem();
        if (sel != null && type.isAssignableFrom(sel.getClass())) {
            return (T)sel;
        }
        return null;
    }

    public static Optional<ButtonType> showQuestion(String header, String body, Stage stage) {
        return Alerts.showQuestion("Pergunta", header, body, stage);
    }

    public static Optional<ButtonType> showQuestion(String header, String body) {
        return Alerts.showQuestion("Pergunta", header, body, null);
    }

    public static Optional<ButtonType> showQuestion(String body) {
        return Alerts.showQuestion("Pergunta", "", body, null);
    }

    public static Optional<ButtonType> showQuestion(String body, Stage stage) {
        return Alerts.showQuestion("Pergunta", "", body, stage);
    }

    public static String showAlertInput(String message) {
        TextInputDialog dialog = new TextInputDialog("");
        dialog.initOwner((Window)Main.get().getPrimaryStage());
        dialog.setTitle("Informe");
        dialog.setHeaderText(message);
        Optional result = dialog.showAndWait();
        Main.get().getPrimaryStage().requestFocus();
        return result.isPresent() ? (String)result.get() : null;
    }

    public static String showAlertInput(String message, String defaultText) {
        TextInputDialog dialog = new TextInputDialog(defaultText);
        dialog.initOwner((Window)Main.get().getPrimaryStage());
        dialog.setTitle("Informe");
        dialog.setHeaderText(message);
        Optional result = dialog.showAndWait();
        Main.get().getPrimaryStage().requestFocus();
        return result.isPresent() ? (String)result.get() : null;
    }

    public static String showAlertInputMask(String message) {
        TextInputDialog dialog = new TextInputDialog("");
        dialog.initOwner((Window)Main.get().getPrimaryStage());
        dialog.setTitle("Informe");
        dialog.setHeaderText(message);
        PasswordField pwd = new PasswordField();
        HBox content = new HBox();
        content.setAlignment(Pos.CENTER);
        content.setSpacing(50.0);
        content.getChildren().addAll((Object[])new Node[]{pwd});
        dialog.getDialogPane().setContent((Node)content);
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == ButtonType.OK) {
                return pwd.getText();
            }
            return null;
        });
        Optional result = dialog.showAndWait();
        Main.get().getPrimaryStage().requestFocus();
        return result.isPresent() ? (String)result.get() : null;
    }

    public static String showAlertInputMask(String message, String defaultText) {
        TextInputDialog dialog = new TextInputDialog(defaultText);
        dialog.initOwner((Window)Main.get().getPrimaryStage());
        dialog.setTitle("Informe");
        dialog.setHeaderText(message);
        PasswordField pwd = new PasswordField();
        HBox content = new HBox();
        content.setAlignment(Pos.CENTER);
        content.setSpacing(50.0);
        content.getChildren().addAll((Object[])new Node[]{pwd});
        dialog.getDialogPane().setContent((Node)content);
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == ButtonType.OK) {
                return pwd.getText();
            }
            return null;
        });
        Optional result = dialog.showAndWait();
        Main.get().getPrimaryStage().requestFocus();
        return result.isPresent() ? (String)result.get() : null;
    }

    public static DialogComboBox showDialogComboBox(String message, List itens) {
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("itens", itens);
        h.put("label", message);
        DialogComboBox dialog = (DialogComboBox)Main.get().showDialog(Controllers.DIALOG_COMBO, h);
        return dialog;
    }

    public static DialogDateTimeTextField showDialogDateTimeTextField(Stage oldStage) {
        return (DialogDateTimeTextField)Main.get().showDialog(Controllers.DIALOG_DATE_TIME_TEXT_FIELD);
    }

    public static DialogFieldMaxLenght showDialogInputTextMaxSize(String message, int tamanho) {
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("maxLength", tamanho);
        h.put("label", message);
        DialogFieldMaxLenght dialog = (DialogFieldMaxLenght)Main.get().showDialog(Controllers.DIALOG_FIELD_MAX_LENGTH, h);
        return dialog;
    }

    public static ReimpressaoFechamentoCaixa showDialogComboBox(String message, List itens, ControllerPath controller) {
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("itens", itens);
        h.put("label", message);
        ReimpressaoFechamentoCaixa dialog = (ReimpressaoFechamentoCaixa)Main.get().showDialog(controller, h);
        return dialog;
    }

    public static void showAlertErrorRunLater(String string) {
        Platform.runLater(() -> Alerts.showAlertError(string));
    }
}

