/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.abastecimento;

import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoAutenticacao;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoipi.ExceptionImpostoIPI;
import com.touchcomp.basementorexceptions.exceptions.impl.impostopiscofins.ExceptionImpostoPisCofins;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.exception.ToolException;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.constants.ConstEnumTipoPreco;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.MainEvents;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.BaseController;
import com.touchcomp.touchnfce.controller.abastecimento.auxiliar.HelperFuncoesSlave;
import com.touchcomp.touchnfce.controller.abastecimento.threads.ThreadShowAbastecimentosPendentes;
import com.touchcomp.touchnfce.controller.abastecimento.threads.ThreadSincronizacaoAutomacao;
import com.touchcomp.touchnfce.controller.abastecimento.threads.ThreadStatusBicoBombaCombustivelMaster;
import com.touchcomp.touchnfce.controller.abastecimento.threads.ThreadStatusBicoBombaCombustivelSlave;
import com.touchcomp.touchnfce.controller.alteracaopreco.AlteracaoPrecoController;
import com.touchcomp.touchnfce.controller.dialogs.DialogDateTimeTextField;
import com.touchcomp.touchnfce.controller.dialogs.DialogDoubleField;
import com.touchcomp.touchnfce.controller.login.LoginAutorizacaoController;
import com.touchcomp.touchnfce.controller.nfce.StyleChangingRowFactory;
import com.touchcomp.touchnfce.controller.splash.impl.SplashShowBombasCentralAbastecimento;
import com.touchcomp.touchnfce.controller.venda.auxmodelofiscal.AuxModeloFiscal;
import com.touchcomp.touchnfce.exceptions.ExceptionTabelaPrecosDinamica;
import com.touchcomp.touchnfce.helpers.preco.HelperPrecos;
import com.touchcomp.touchnfce.listeners.ShortcutListener;
import com.touchcomp.touchnfce.model.BicoBombaCombustivel;
import com.touchcomp.touchnfce.model.ModeloFiscal;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCePreAbastecimento;
import com.touchcomp.touchnfce.model.NFCeStatusBicoBomba;
import com.touchcomp.touchnfce.model.Produto;
import com.touchcomp.touchnfce.modeltemp.DeParaBicoBomba;
import com.touchcomp.touchnfce.modeltemp.TempPesquisaProduto;
import com.touchcomp.touchnfce.modeltemp.TipoPrecoCombustivel;
import com.touchcomp.touchnfce.properties.ConfPropertiesLoader;
import com.touchcomp.touchnfce.service.impl.ServiceNFCePreAbastecimento;
import com.touchcomp.touchnfce.service.impl.ServiceTabelaPrecoBaseProduto;
import com.touchcomp.touchnfce.utils.MaskField;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import com.touchcomp.touchnfce.utils.UtilNFCeCalculos;
import com.touchcomp.touchnfce.utils.UtilPermissaoUsuario;
import com.touchcomp.touchnfce.utils.abastecimentocompanytec.UtilCentralAbastecimento;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;

public class CentralAbastecimentoSimplificada
extends BaseController {
    private List<NFCeStatusBicoBomba> statusBicosSlave = new ArrayList<NFCeStatusBicoBomba>();
    @FXML
    private Button btnBloquearBombas;
    @FXML
    private Button btnLiberarBombas;
    @FXML
    private Button btnAjustarRelogio;
    @FXML
    private Button btnAbastecimentoAndamento;
    @FXML
    private Button btnNfceAvulsa;
    @FXML
    private Button btnSair;
    @FXML
    private Button btnPreAbastecimento;
    @FXML
    private Button btnGerarNFCe;
    @FXML
    private TableView<NFCePreAbastecimento> tableAbastecPendentes;
    @FXML
    private HBox gridBombas;
    @FXML
    private HBox gridBombas1;
    @FXML
    private HBox gridBombas2;
    @FXML
    private TableColumn<NFCePreAbastecimento, String> columnDataAbastecimento;
    @FXML
    private TableColumn<NFCePreAbastecimento, String> columnBomba;
    @FXML
    private TableColumn<NFCePreAbastecimento, String> columnProduto;
    @FXML
    private TableColumn<NFCePreAbastecimento, String> columnBico;
    @FXML
    private TableColumn<NFCePreAbastecimento, String> columnValorUnit;
    @FXML
    private TableColumn<NFCePreAbastecimento, String> columnQuantidade;
    @FXML
    private TableColumn<NFCePreAbastecimento, String> columnValorTot;
    List<DeParaBicoBomba> listDeParaBicos = new LinkedList<DeParaBicoBomba>();
    final StyleChangingRowFactory<NFCePreAbastecimento> rowFactory = new StyleChangingRowFactory("table-row-cell-green");
    @FXML
    private AnchorPane body;
    @FXML
    private ScrollPane scrollBombas;
    @FXML
    private GridPane gridAbastecimentos;
    @FXML
    private CheckBox chExibeTabela;
    @FXML
    private TabPane tabCentralAbast;
    @FXML
    private Tab tabAbastecimentos;
    @FXML
    private Tab tabOpcoes;
    private Stage currentStage;
    private ConfPropertiesLoader props;
    ThreadStatusBicoBombaCombustivelSlave threadStatusBicoBombaSlave;
    ThreadStatusBicoBombaCombustivelMaster threadStatusBicoBombaMaster;
    ThreadSincronizacaoAutomacao threadSincronizacaoAutomacao;
    ThreadShowAbastecimentosPendentes threadShowAbastecimentosPendentes;
    private ServiceTabelaPrecoBaseProduto serviceProduto = Main.getBean(ServiceTabelaPrecoBaseProduto.class);
    private ServiceNFCePreAbastecimento serviceNFCePreAbastecimento = Main.getBean(ServiceNFCePreAbastecimento.class);
    private HelperFuncoesSlave helperFuncosSlave = new HelperFuncoesSlave();

    public void setElements(Stage currentStage) {
        this.currentStage = currentStage;
        StaticObjects.setCentralAbastecimentoController(currentStage);
        currentStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent t) {
                Optional<ButtonType> res = Alerts.showQuestion("Deseja realmente fechar a central de abastecimentos?");
                if (res.get().equals(ButtonType.YES) || res.get().equals(ButtonType.OK)) {
                    CentralAbastecimentoSimplificada.this.bloquearBombasAoSair();
                    CentralAbastecimentoSimplificada.this.savePropiertsControllerAbastecimento();
                    StaticObjects.setCentralAbastecimentoController(null);
                } else {
                    t.consume();
                }
            }
        });
    }

    @Override
    protected void initializeController(ResourceBundle rb) {
        this.props = ConfPropertiesLoader.get();
        this.setEventsButtons();
        this.setPropertiesColumnsTable();
        this.restaurarLarguras("configuracao_tabela_bombas.txt");
        this.setAbastecimentosPendentesTable();
        this.chExibeTabela.setSelected(false);
        this.showSplashBombas();
        this.hiddenOrShowTableAbastecimentos();
        this.initializeMaster();
        this.startThreads();
    }

    private void showSplashBombas() {
        try {
            SplashShowBombasCentralAbastecimento splash = new SplashShowBombasCentralAbastecimento(this.gridBombas, this.gridBombas1, this.gridBombas2, this.listDeParaBicos);
            splash.showAndWait();
            this.showMenuSuspensoLabelBicos();
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            Alerts.showAlertError("Nao foi possivel liberar a bomba. Erro ao enviar comando a Automacao: " + ex.getMessage(), this.currentStage);
        }
    }

    private void atualizarDataHoraAutomacao() throws Exception {
        if (!UtilCentralAbastecimento.get().isControlMaster()) {
            return;
        }
        if (!ToolMethods.isAffirmative((Number)StaticObjects.getOpcoes().getAtuaAutoDataHoraAutomacao())) {
            return;
        }
        UtilCentralAbastecimento.get().alterarRelogioModoExtendido(new Date());
    }

    public void bloquearBombasAoSair() {
        try {
            if (!UtilCentralAbastecimento.get().isControlMaster()) {
                return;
            }
            if (!ToolMethods.isAffirmative((Number)StaticObjects.getOpcoes().getLibBloquearBombasSaiEntrar())) {
                return;
            }
            UtilCentralAbastecimento.get().bloqueiaAllBombaAbastecimento();
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            Alerts.showAlertErrorRunLater("Erro ao alterar o preco na automacao: " + ex.getMessage());
        }
    }

    private void liberarBombasAoAbrir() throws Exception {
        if (!UtilCentralAbastecimento.get().isControlMaster()) {
            return;
        }
        if (!ToolMethods.isAffirmative((Number)StaticObjects.getOpcoes().getLibBloquearBombasSaiEntrar())) {
            return;
        }
        ObservableList preAbastecimentos = this.tableAbastecPendentes.getItems();
        LinkedList<BicoBombaCombustivel> bicos = new LinkedList<BicoBombaCombustivel>();
        preAbastecimentos.forEach(i -> bicos.add(i.getBico()));
        UtilCentralAbastecimento.get().liberarAllBombaAbastecimentoExceto(bicos);
    }

    @Override
    protected void requestFocusOnOpen() {
    }

    private void setAbastecimentosPendentesTable() {
        this.columnBomba.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCePreAbastecimento, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCePreAbastecimento, String> param) {
                return new SimpleObjectProperty((Object)((NFCePreAbastecimento)param.getValue()).getBico().getBombaCombustivel().toString());
            }
        });
        this.columnBico.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCePreAbastecimento, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCePreAbastecimento, String> param) {
                return new SimpleObjectProperty((Object)((NFCePreAbastecimento)param.getValue()).getBico().getDescricao());
            }
        });
        this.columnProduto.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCePreAbastecimento, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCePreAbastecimento, String> param) {
                Produto produto = ((NFCePreAbastecimento)param.getValue()).getBico().getGradeCor().getProdutoGrade().getProduto();
                String str = ToolMethods.isStrWithData((String)produto.getNomeAuxiliar()) ? produto.getNomeAuxiliar() : produto.getNome();
                return new SimpleObjectProperty((Object)str);
            }
        });
        this.columnDataAbastecimento.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCePreAbastecimento, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCePreAbastecimento, String> param) {
                return new SimpleObjectProperty((Object)ToolDate.dateToStr((Date)((NFCePreAbastecimento)param.getValue()).getDataAbastecimento(), (String)"dd/MM/yyyy hh:mm"));
            }
        });
        this.columnValorUnit.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCePreAbastecimento, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCePreAbastecimento, String> param) {
                return new SimpleObjectProperty((Object)MaskField.monetaryField(((NFCePreAbastecimento)param.getValue()).getValorUnitario()));
            }
        });
        this.columnQuantidade.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCePreAbastecimento, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCePreAbastecimento, String> param) {
                return new SimpleObjectProperty((Object)MaskField.monetaryField(((NFCePreAbastecimento)param.getValue()).getQuantidade()));
            }
        });
        this.columnValorTot.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCePreAbastecimento, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCePreAbastecimento, String> param) {
                return new SimpleObjectProperty((Object)MaskField.monetaryField(((NFCePreAbastecimento)param.getValue()).getValorTotal()));
            }
        });
        this.showMenuSuspensoTable();
    }

    private void setPropertiesColumnsTable() {
        this.tableAbastecPendentes.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_SUBSEQUENT_COLUMNS);
        this.tableAbastecPendentes.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tableAbastecPendentes.setRowFactory(this.rowFactory);
        this.columnBomba.setPrefWidth(100.0);
        this.columnProduto.setPrefWidth(80.0);
        this.columnQuantidade.setPrefWidth(80.0);
        this.columnBico.setPrefWidth(60.0);
        this.columnValorUnit.setPrefWidth(80.0);
        this.columnValorTot.setPrefWidth(100.0);
        this.columnDataAbastecimento.setPrefWidth(50.0);
        this.columnValorUnit.setStyle("-fx-alignment: BOTTOM_RIGHT;");
        this.columnQuantidade.setStyle("-fx-alignment: BOTTOM_RIGHT;");
        this.columnValorTot.setStyle("-fx-alignment: BOTTOM_RIGHT;");
    }

    private void setEventsButtons() {
        this.btnAjustarRelogio.setOnAction(evt -> this.ajustaRelogioByModo());
        this.btnBloquearBombas.setOnAction(evt -> this.bloquearAllBombas());
        this.btnLiberarBombas.setOnAction(evt -> this.liberarAllBombas());
        this.btnAbastecimentoAndamento.setOnAction(evt -> this.abastecimentoAndamentos());
        this.btnNfceAvulsa.setOnAction(evt -> this.nfceAvulsa());
        this.btnSair.setOnAction(evt -> this.voltarMenuPrincipal());
        this.btnPreAbastecimento.setOnAction(evt -> this.selectFirstAbastecimento());
        this.btnGerarNFCe.setOnAction(evt -> this.gerarNFCe());
        this.chExibeTabela.setOnAction(evt -> this.hiddenOrShowTableAbastecimentos());
    }

    private void hiddenOrShowTableAbastecimentos() {
        if (!this.chExibeTabela.isSelected()) {
            this.tableAbastecPendentes.setVisible(true);
        } else {
            this.tableAbastecPendentes.setVisible(false);
        }
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKey(KeyEvent event) {
        switch (event.getCode()) {
            case DOWN: {
                this.selectFirstAbastecimento();
                break;
            }
            case F1: {
                this.tabCentralAbast.getSelectionModel().select((Object)this.tabAbastecimentos);
                break;
            }
            case F2: {
                this.tabCentralAbast.getSelectionModel().select((Object)this.tabOpcoes);
                break;
            }
            case F3: {
                this.hiddenOrShowTableAbastecimentos();
                break;
            }
            case F4: {
                this.bloquearAllBombas();
                break;
            }
            case F5: {
                this.gerarNFCe();
                break;
            }
            case F6: {
                this.liberarAllBombas();
                break;
            }
            case F7: {
                this.ajustaRelogioByModo();
                break;
            }
            case F8: {
                this.abastecimentoAndamentos();
                break;
            }
            case F9: {
                this.nfceAvulsa();
                break;
            }
            case F10: {
                this.selectFirstAbastecimento();
                break;
            }
            case ESCAPE: {
                this.voltarMenuPrincipal();
                break;
            }
        }
    }

    @Override
    public void paramsData(Class<? extends BaseController> aClass, Map data) {
    }

    private void setValorCustoEReferencia(NFCePreAbastecimento pre) throws Exception {
        List<TempPesquisaProduto> prod = this.getProdutosPrecos(pre.getBico().getGradeCor().getProdutoGrade().getProduto().getIdentificador());
        if (prod == null || prod.isEmpty()) {
            throw new Exception("Produto sem tabela de pre\u00e7o: " + String.valueOf(pre.getBico().getGradeCor().getProdutoGrade().getProduto()));
        }
        Double valorCusto = prod.get(0).getPrecoCusto();
        Double valorUnid = prod.get(0).getValorUnitario();
        pre.setValorCusto(valorCusto);
        pre.setValorUnitarioSugerido(valorUnid);
    }

    private boolean criaNFCe() throws ExceptionTabelaPrecosDinamica, ExceptionAvaliadorExpressoes, Exception {
        NFCe vo = this.getNFCe();
        boolean irTelaVendas = true;
        boolean NFCeCriada = false;
        if (vo == null) {
            vo = UtilNFCe.createNFCeModelo65(null);
            vo = StaticObjects.setNfceAberta(vo);
            irTelaVendas = true;
            NFCeCriada = true;
        }
        if (NFCeCriada && (vo == null || vo.getItens() == null || vo.getItens().isEmpty())) {
            StaticObjects.setNfceAberta(null);
            StaticObjects.getNfceAberta();
        }
        return irTelaVendas;
    }

    private void atualizaTelaVendas() {
        this.atualizaCampoSubTotal();
        StaticObjects.refreshNFCe();
    }

    private boolean adicionaItens(NFCe vo) throws Exception {
        boolean irTelaVendas = true;
        ObservableList aux = this.tableAbastecPendentes.getSelectionModel().getSelectedItems();
        LinkedList<NFCeItem> itens = new LinkedList<NFCeItem>();
        int i = 1;
        for (NFCePreAbastecimento pre : aux) {
            ModeloFiscal modeloFiscal = new AuxModeloFiscal().getModeloFiscalNFCe(pre.getBico().getGradeCor().getProdutoGrade().getProduto(), this.getNFCe().getUnidadeFatCliente(), this.getNFCe().getNfcePessoa(), this.getNFCe().getEnderecoEntrega(), this.getNFCe().getNaturezaOperacao(), this.getNFCe().getEmpresa(), true);
            System.out.println("PESQUISA MODELO : " + i + "\n");
            if (modeloFiscal == null) {
                return false;
            }
            this.setValorCustoEReferencia(pre);
            pre.setDataUltModificacao(new Date());
            pre = this.serviceNFCePreAbastecimento.save(pre);
            NFCeItem item = new NFCeItem();
            UtilNFCe.getNewNFCeItem(item, this.getNFCe(), pre.getBico().getGradeCor(), modeloFiscal, pre.getQuantidade(), 0.0, pre.getValorUnitario(), pre.getValorTotal(), pre.getValorCusto(), pre.getBico().getTanqueCombustivel().getCentroEstoque(), "", false).setPreAbastecimento(pre);
            itens.add(item);
            System.out.println("ITEM : " + i + "\n");
            irTelaVendas = true;
            ++i;
        }
        if (irTelaVendas) {
            this.getNFCe().getItens().addAll(itens);
        }
        return irTelaVendas;
    }

    private List<TempPesquisaProduto> getProdutosPrecos(Long idProd) throws ExceptionTabelaPrecosDinamica, ExceptionAvaliadorExpressoes {
        HelperPrecos helper = Main.getBean(HelperPrecos.class);
        List<TempPesquisaProduto> prod = null;
        prod = helper.getProdutos(idProd, StaticObjects.getEmpresa(), this.getNFCe().getUnidadeFatCliente(), StaticObjects.getOpcoes(), this.getNFCe().getRepresentante(), StaticObjects.getUsuario(), StaticObjects.getGrupo(), this.getNFCe().getDadosTransporte().getTipoFrete(), this.getNFCe().getNaturezaOperacao(), this.getNFCe().getCondicoesPagamento(), null, null);
        return prod;
    }

    private NFCe getNFCe() {
        return StaticObjects.getNfceAberta();
    }

    private void atualizaCampoSubTotal() {
        try {
            UtilNFCeCalculos.calcularValores(this.getNFCe());
        }
        catch (ExceptionImpostoPisCofins exceptionImpostoPisCofins) {
            exceptionImpostoPisCofins.printStackTrace();
        }
        catch (ExceptionImpostoIcms exceptionImpostoIcms) {
            exceptionImpostoIcms.printStackTrace();
        }
        catch (ExceptionImpostoIPI exceptionImpostoIcms) {
            exceptionImpostoIcms.printStackTrace();
        }
    }

    private void showAbastecimentosPendentesClear() {
        try {
            this.stopThreads();
            this.startThreads();
        }
        catch (Throwable ex) {
            TLogger.get(this.getClass()).error(ex);
            Alerts.showAlertErrorRunLater("Erro ao conectar na automacao: " + ex.getMessage());
        }
    }

    private synchronized void threadStatusBicoBombaCombustivelSlave() {
        if (this.threadStatusBicoBombaSlave == null || !this.threadStatusBicoBombaSlave.isAlive()) {
            this.threadStatusBicoBombaSlave = new ThreadStatusBicoBombaCombustivelSlave(this.listDeParaBicos);
            this.threadStatusBicoBombaSlave.start();
            System.out.println("\n\nThread Status Bico Bomba Combustivel Slave");
        }
    }

    private synchronized void threadStatusBicoBombaCombustivelMaster() {
        if (this.threadStatusBicoBombaMaster == null || !this.threadStatusBicoBombaMaster.isAlive()) {
            this.threadStatusBicoBombaMaster = new ThreadStatusBicoBombaCombustivelMaster(this.listDeParaBicos, this.statusBicosSlave);
            this.threadStatusBicoBombaMaster.start();
            System.out.println("\n\nThread Status Bico Bomba Combustivel Master");
        }
    }

    private synchronized void threadThreadSincronizacaoAutomacao() {
        if (this.threadSincronizacaoAutomacao == null || !this.threadSincronizacaoAutomacao.isAlive()) {
            this.threadSincronizacaoAutomacao = new ThreadSincronizacaoAutomacao(this.listDeParaBicos);
            this.threadSincronizacaoAutomacao.start();
            System.out.println("\n\nThread Status Bico Bomba Combustivel Master");
        }
    }

    private synchronized void threadShowAbastecimentosPendentes() {
        if (this.threadShowAbastecimentosPendentes == null || !this.threadShowAbastecimentosPendentes.isAlive()) {
            this.threadShowAbastecimentosPendentes = new ThreadShowAbastecimentosPendentes(this.serviceNFCePreAbastecimento, this.tableAbastecPendentes);
            this.threadShowAbastecimentosPendentes.start();
            System.out.println("\n\nThread Abastecimentos pendetens iniciada");
        }
    }

    private void showMenuSuspensoTable() {
        final ContextMenu cm = new ContextMenu();
        MenuItem it = new MenuItem("Gerar NFCe/NFe");
        it.setStyle("-fx-font: 12pt \"Helvetica\"");
        it.setOnAction(evt -> this.gerarNFCe());
        MenuItem it1 = new MenuItem("Abastecimento de Aferi\u00e7\u00e3o");
        it1.setStyle("-fx-font: 12pt \"Helvetica\"");
        it1.setOnAction(evt -> this.gerarAbastecimentoAfericao());
        MenuItem it2 = new MenuItem("Recarregar/Reconectar Automa\u00e7\u00e3o");
        it2.setStyle("-fx-font: 12pt \"Helvetica\"");
        it2.setOnAction(evt -> this.showAbastecimentosPendentesClear());
        cm.getItems().add((Object)it);
        cm.getItems().add((Object)it1);
        cm.getItems().add((Object)it2);
        this.tableAbastecPendentes.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                if (t.getButton() == MouseButton.SECONDARY) {
                    cm.show(CentralAbastecimentoSimplificada.this.tableAbastecPendentes, t.getScreenX(), t.getScreenY());
                }
            }
        });
    }

    private void showMenuSuspensoLabelBicos() {
        for (final DeParaBicoBomba d : this.listDeParaBicos) {
            if (d.getBico().getAtivo() != 1) continue;
            final ContextMenu cm = new ContextMenu();
            cm.getItems().addAll(this.getListOperacoesBomba(d.getLabel()));
            d.getLabel().addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent t) {
                    if (t.getButton() == MouseButton.SECONDARY) {
                        cm.show((Node)d.getLabel(), t.getScreenX(), t.getScreenY());
                    }
                }
            });
            d.getLabel().setOnMouseClicked(evt -> {
                if (evt.getClickCount() != 2 || d.getPreAbastecimento() != null) {
                    // empty if block
                }
            });
        }
    }

    private List<MenuItem> getListOperacoesBomba(Label l) {
        ArrayList<MenuItem> list = new ArrayList<MenuItem>();
        MenuItem m2 = new MenuItem("Alterar Pre\u00e7o");
        m2.setStyle("-fx-font: 12pt \"Helvetica\"");
        m2.setOnAction(evt -> this.methodAlterarPreco(l));
        MenuItem m3 = new MenuItem("Bloqueia Abastecimento");
        m3.setStyle("-fx-font: 12pt \"Helvetica\"");
        m3.setOnAction(evt -> this.methodBloqueiaBomba(l));
        MenuItem m4 = new MenuItem("Liberar Abastecimento");
        m4.setStyle("-fx-font: 12pt \"Helvetica\"");
        m4.setOnAction(evt -> {
            try {
                this.methodLiberarAbastecimento(l);
            }
            catch (Exception ex) {
                TLogger.get(this.getClass()).error((Throwable)ex);
                Alerts.showAlertError("Nao foi possivel liberar a bomba. Erro ao enviar comando a Automacao: " + ex.getMessage(), this.currentStage);
            }
        });
        MenuItem m5 = new MenuItem("Parar Abastecimento");
        m5.setStyle("-fx-font: 12pt \"Helvetica\"");
        m5.setOnAction(evt -> this.methodPararAbastecimento(l));
        MenuItem m7 = new MenuItem("Pr\u00e9 Determinar Abastecimento por Valor");
        m7.setStyle("-fx-font: 12pt \"Helvetica\"");
        m7.setOnAction(evt -> this.methodPreDeterminarValorAbastecimento(l));
        list.add(m2);
        list.add(m3);
        list.add(m4);
        list.add(m5);
        list.add(m7);
        return list;
    }

    private boolean autenticacaoUsuario(EnumConstNFCeTipoAutenticacao tipoAutenticacao) {
        if (UtilCentralAbastecimento.get().isControlMaster()) {
            if (UtilPermissaoUsuario.isPermitidoAcessarAbastecimentoAfericao()) {
                return true;
            }
            HashMap<String, EnumConstNFCeTipoAutenticacao> h = new HashMap<String, EnumConstNFCeTipoAutenticacao>();
            h.put("tipo_autenticacao", tipoAutenticacao);
            LoginAutorizacaoController loginController = (LoginAutorizacaoController)Main.get().showDialog(Controllers.LOGIN_AUTORIZACAO, h);
            if (loginController.getUsuario() == null) {
                Alerts.showAlertError("Voc\u00ea n\u00e3o possui autoriza\u00e7\u00e3o para realizar essa opera\u00e7\u00e3o");
            } else {
                UtilPermissaoUsuario.createLogPermissaoUser(loginController.getUsuario(), tipoAutenticacao, null, null);
                return true;
            }
        }
        return false;
    }

    private void ajustaRelogioByModo() {
        if (!UtilCentralAbastecimento.get().isControlMaster()) {
            return;
        }
        try {
            DialogDateTimeTextField d = Alerts.showDialogDateTimeTextField(this.currentStage);
            if (d != null && d.getDateInf() != null) {
                Date dateAndTime = d.getDateInf();
                int modoAlteracao = d.getModoAlteracaoDate();
                if (dateAndTime != null) {
                    if (modoAlteracao == 0) {
                        UtilCentralAbastecimento.get().alterarRelogioModoNormal(dateAndTime);
                    } else {
                        UtilCentralAbastecimento.get().alterarRelogioModoExtendido(dateAndTime);
                    }
                }
            }
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            Alerts.showAlertErrorRunLater("Erro ao atualizar o relogio: " + ex.getMessage());
        }
    }

    private void gerarNFCe() {
        try {
            boolean showTelaVendas;
            if (this.tableAbastecPendentes.getSelectionModel().getSelectedItems() == null || this.tableAbastecPendentes.getSelectionModel().getSelectedItems().isEmpty()) {
                Platform.runLater(() -> Alerts.showAlertError("Selecione um abastecimento na tabela!"));
                return;
            }
            if (!this.isValidGeraNFCe()) {
                return;
            }
            if (UtilCentralAbastecimento.get().isControlMaster()) {
                this.threadSincronizacaoAutomacao.setBreakThreadSincAutomacao(true);
            }
            this.criaNFCe();
            this.setItemControllerVendas();
            HashMap<String, NFCe> h = new HashMap<String, NFCe>();
            h.put("NFCe", this.getNFCe());
            if (UtilCentralAbastecimento.get().isControlMaster()) {
                this.threadSincronizacaoAutomacao.setBreakThreadSincAutomacao(false);
            }
            if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getAbrirTelaClienteVenda(), (Object)1) && this.getNFCe().getUnidadeFatCliente() == null && this.getNFCe().getNfCeConsumidor() == null && (this.getNFCe().getItens() == null || this.getNFCe().getItens().size() <= 1)) {
                Main.get().showDialog(Controllers.PESQUISA_PESSOAS);
            }
            if (showTelaVendas = this.adicionaItens(this.getNFCe())) {
                this.helperFuncosSlave.setaComandoLiberacaoSlave(this.getNFCe());
                this.liberaBombasAbastecimento(this.getNFCe());
                Main.get().mudaTela(Controllers.VENDA, h);
                StaticObjects.getVendasController().getTfProduto().requestFocus();
                this.atualizaTelaVendas();
            }
        }
        catch (Exception ex) {
            if (ToolException.findException((Throwable)ex, (String)"UK_NFCE_NUM_SER").booleanValue()) {
                TLogger.get(this.getClass()).error((Throwable)ex);
                Alerts.showAlertError("J\u00e1 foi gerado movimenta\u00e7\u00e3o pra este abastecimento.");
            } else {
                TLogger.get(this.getClass()).error((Throwable)ex);
                Alerts.showAlertInfo("Erro ao gerar NFCe: " + ex.getMessage());
            }
        }
        finally {
            if (UtilCentralAbastecimento.get().isControlMaster()) {
                this.threadSincronizacaoAutomacao.setBreakThreadSincAutomacao(false);
            }
        }
    }

    private boolean isValidGeraNFCe() {
        ObservableList aux = this.tableAbastecPendentes.getSelectionModel().getSelectedItems();
        Iterator iterator = aux.iterator();
        if (iterator.hasNext()) {
            NFCePreAbastecimento preAbastecimento = (NFCePreAbastecimento)iterator.next();
            if (preAbastecimento.getQuantidade() <= 0.0) {
                Alerts.showAlertInfo("Quantidade abastecida \u00e9 inv\u00e1lida. Quantidade deve ser maior que 0.");
                return false;
            }
            if (preAbastecimento.getValorTotal() <= 0.0) {
                Alerts.showAlertInfo("Valor Total abastecido \u00e9 inv\u00e1lido. O mesmo deve ser maior que 0.");
                return false;
            }
            return true;
        }
        return true;
    }

    private void bloquearAllBombas() {
        if (!UtilCentralAbastecimento.get().isControlMaster()) {
            return;
        }
        try {
            if (!this.autenticacaoUsuario(EnumConstNFCeTipoAutenticacao.AUTENTICACAO_OPCOES_ABAST_BLOQ_ABAST)) {
                return;
            }
            UtilCentralAbastecimento.get().bloqueiaAllBombaAbastecimento();
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            Alerts.showAlertErrorRunLater("Erro ao alterar o preco na automacao: " + ex.getMessage());
        }
    }

    private void liberarAllBombas() {
        if (!UtilCentralAbastecimento.get().isControlMaster()) {
            return;
        }
        try {
            if (!this.autenticacaoUsuario(EnumConstNFCeTipoAutenticacao.AUTENTICACAO_OPCOES_ABAST_LIB_ABAST)) {
                return;
            }
            UtilCentralAbastecimento.get().liberarAllBombaAbastecimento();
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            Alerts.showAlertErrorRunLater("Erro ao liberar as bombas na automacao: " + ex.getMessage());
        }
    }

    private void abastecimentoAndamentos() {
        if (!UtilCentralAbastecimento.get().isControlMaster()) {
            return;
        }
        try {
            UtilCentralAbastecimento.get().leituraAbastecimentoAndamento();
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            Alerts.showAlertErrorRunLater("Erro ao verificar abastecimentos em andamento na automacao: " + ex.getMessage());
        }
    }

    private void nfceAvulsa() {
        try {
            if (UtilCentralAbastecimento.get().isControlMaster()) {
                this.threadSincronizacaoAutomacao.setBreakThreadSincAutomacao(true);
            }
            Main.get().mudaTela(Controllers.VENDA, Controllers.ABASTECIMENTO);
        }
        finally {
            if (UtilCentralAbastecimento.get().isControlMaster()) {
                this.threadSincronizacaoAutomacao.setBreakThreadSincAutomacao(false);
            }
        }
    }

    private void voltarMenuPrincipal() {
        this.savePropiertsControllerAbastecimento();
    }

    private void selectFirstAbastecimento() {
        if (this.tableAbastecPendentes.getItems() != null && !this.tableAbastecPendentes.getItems().isEmpty() && this.tableAbastecPendentes.getSelectionModel().getSelectedItem() == null) {
            this.tableAbastecPendentes.getSelectionModel().selectFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void gerarAbastecimentoAfericao() {
        List<Object> aux;
        ObservableList sel = this.tableAbastecPendentes.getSelectionModel().getSelectedItems();
        if (sel == null || sel.isEmpty() || !this.autenticacaoUsuarioAfericao(EnumConstNFCeTipoAutenticacao.AUTENTICACAO_ABASTECIMENTO_AFERICAO, aux = Arrays.asList(sel.toArray()))) return;
        Optional<ButtonType> resp = Alerts.showQuestion("O(s) Pr\u00e9 Abastecimento(s) selecionado(s) \u00e9 uma Aferi\u00e7\u00e3o?");
        if (!resp.isPresent() || resp.get() != ButtonType.OK) return;
        try {
            if (!UtilCentralAbastecimento.get().isControlMaster()) return;
            this.threadSincronizacaoAutomacao.setBreakThreadSincAutomacao(true);
            UtilCentralAbastecimento.get().gerarAfericaoPreAbastecimento(aux);
            return;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            if (ToolException.findException((Throwable)ex, (String)"UK_ID_PRE_ABASTECIMENTO").booleanValue()) {
                Alerts.showAlertError("J\u00e1 foi gerado movimenta\u00e7\u00e3o pra este abastecimento.");
                return;
            } else {
                Alerts.showAlertError("Erro ao gerar a aferi\u00e7\u00e3o.");
            }
            return;
        }
        finally {
            if (UtilCentralAbastecimento.get().isControlMaster()) {
                this.threadSincronizacaoAutomacao.setBreakThreadSincAutomacao(false);
            }
        }
    }

    private boolean autenticacaoUsuarioAfericao(EnumConstNFCeTipoAutenticacao tipoAutenticacao, List<NFCePreAbastecimento> list) {
        if (UtilPermissaoUsuario.isPermitidoAcessarAbastecimentoAfericao()) {
            return true;
        }
        HashMap<String, EnumConstNFCeTipoAutenticacao> h = new HashMap<String, EnumConstNFCeTipoAutenticacao>();
        h.put("tipo_autenticacao", tipoAutenticacao);
        LoginAutorizacaoController loginController = (LoginAutorizacaoController)Main.get().showDialog(Controllers.LOGIN_AUTORIZACAO, h);
        if (loginController.getUsuario() != null) {
            list.forEach(pr -> UtilPermissaoUsuario.createLogPermissaoUser(loginController.getUsuario(), tipoAutenticacao, null, pr));
            return true;
        }
        Alerts.showAlertError("Voc\u00ea n\u00e3o possui autoriza\u00e7\u00e3o para realizar essa opera\u00e7\u00e3o", this.currentStage);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void liberaBombasAbastecimento(NFCe nfce) {
        if (!UtilCentralAbastecimento.get().isControlMaster()) {
            return;
        }
        if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getBloquearBombaAuto(), (Object)1)) {
            if (UtilCentralAbastecimento.get().isControlMaster()) {
                this.threadSincronizacaoAutomacao.setBreakThreadSincAutomacao(true);
            }
            try {
                for (NFCeItem i : nfce.getItens()) {
                    if (i.getPreAbastecimento() == null) continue;
                    UtilCentralAbastecimento.get().liberarBombaAbastecimento(i.getPreAbastecimento().getBico());
                }
            }
            catch (Exception ex) {
                TLogger.get(this.getClass()).error((Throwable)ex);
                Alerts.showAlertError("Nao foi possivel liberar a bomba. Erro ao enviar comando a Automacao: " + ex.getMessage(), this.currentStage);
            }
            finally {
                if (UtilCentralAbastecimento.get().isControlMaster()) {
                    this.threadSincronizacaoAutomacao.setBreakThreadSincAutomacao(false);
                }
            }
        }
    }

    private void setItemControllerVendas() {
        if (StaticObjects.getVendasController() != null) {
            StaticObjects.getVendasController().iniciaNFCe();
        }
    }

    private void savePropiertsControllerAbastecimento() {
        this.props.setHeigthAbastecimentoScreen(this.currentStage.getHeight());
        this.props.setWidthAbastecimentoScreen(this.currentStage.getWidth());
        this.props.setXAbastecimentoScreen(this.currentStage.getX());
        this.props.setYAbastecimentoScreen(this.currentStage.getY());
        Stage menuPrincipal = Main.get().getPrimaryStage();
        this.props.setHeigthMenuScreen(menuPrincipal.getHeight());
        this.props.setWidthMenuScreen(menuPrincipal.getWidth());
        this.props.setXMenuScreen(menuPrincipal.getX());
        this.props.setYMenuScreen(menuPrincipal.getY());
        StaticObjects.setCentralAbastecimentoController(null);
        this.stopThreads();
        this.criarArquivoLarguraColunas();
        this.currentStage.close();
        Platform.runLater(() -> MainEvents.getInstance().setListener((ShortcutListener)Main.get().getFxmlLoader().getController(), Main.get().getPrimaryStage()));
    }

    private void methodAlterarPreco(Label l) {
        if (!UtilCentralAbastecimento.get().isControlMaster()) {
            return;
        }
        if (!this.autenticacaoUsuario(EnumConstNFCeTipoAutenticacao.AUTENTICACAO_OPCOES_ABAST_ALT_PRECO)) {
            return;
        }
        BicoBombaCombustivel bicoEvt = null;
        for (DeParaBicoBomba bm : this.listDeParaBicos) {
            if (!l.equals(bm.getLabel())) continue;
            bicoEvt = bm.getBico();
            break;
        }
        if (bicoEvt == null) {
            return;
        }
        HashMap<String, Double> h = new HashMap<String, Double>();
        h.put("precoAnterior", 0.0);
        try {
            AlteracaoPrecoController alteracaoPrecController = (AlteracaoPrecoController)Main.get().showDialog(Controllers.ALTERACAO_PRECO, h);
            HashMap retorno = alteracaoPrecController.getHashRetorno();
            if (retorno != null) {
                Double preco = (Double)retorno.get("novoPreco");
                TipoPrecoCombustivel tp = (TipoPrecoCombustivel)retorno.get("formaPag");
                UtilCentralAbastecimento.get().alterarPrecoCombustivel(bicoEvt, ConstEnumTipoPreco.get((Object)tp.getTipo()), preco);
            }
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            Alerts.showAlertErrorRunLater("Erro ao alterar o preco na automacao: " + ex.getMessage());
        }
    }

    private void methodBloqueiaBomba(Label l) {
        if (!UtilCentralAbastecimento.get().isControlMaster()) {
            return;
        }
        try {
            if (!this.autenticacaoUsuario(EnumConstNFCeTipoAutenticacao.AUTENTICACAO_OPCOES_ABAST_BLOQ_ABAST)) {
                return;
            }
            BicoBombaCombustivel bicoEvt = null;
            for (DeParaBicoBomba bm : this.listDeParaBicos) {
                if (!l.equals(bm.getLabel())) continue;
                bicoEvt = bm.getBico();
                break;
            }
            if (bicoEvt == null) {
                return;
            }
            UtilCentralAbastecimento.get().bloqueiaBombaAbastecimento(bicoEvt);
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            Alerts.showAlertErrorRunLater("Erro ao bloquear as bombas: " + ex.getMessage());
        }
    }

    private void methodLiberarAbastecimento(Label l) throws Exception {
        if (!UtilCentralAbastecimento.get().isControlMaster()) {
            return;
        }
        if (!this.autenticacaoUsuario(EnumConstNFCeTipoAutenticacao.AUTENTICACAO_OPCOES_ABAST_LIB_ABAST)) {
            return;
        }
        BicoBombaCombustivel bicoEvt = null;
        for (DeParaBicoBomba bm : this.listDeParaBicos) {
            if (!l.equals(bm.getLabel())) continue;
            bicoEvt = bm.getBico();
            break;
        }
        if (bicoEvt == null) {
            return;
        }
        UtilCentralAbastecimento.get().liberarBombaAbastecimento(bicoEvt);
    }

    private void methodPararAbastecimento(Label l) {
        if (!UtilCentralAbastecimento.get().isControlMaster()) {
            return;
        }
        try {
            if (!this.autenticacaoUsuario(EnumConstNFCeTipoAutenticacao.AUTENTICACAO_OPCOES_ABAST_PARAR_ABAST)) {
                return;
            }
            BicoBombaCombustivel bicoEvt = null;
            for (DeParaBicoBomba bm : this.listDeParaBicos) {
                if (!l.equals(bm.getLabel())) continue;
                bicoEvt = bm.getBico();
                break;
            }
            if (bicoEvt == null) {
                return;
            }
            UtilCentralAbastecimento.get().pararAbastaecimento(bicoEvt);
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            Alerts.showAlertErrorRunLater("Erro ao parar o abastecimento: " + ex.getMessage());
        }
    }

    private void methodPreDeterminarValorAbastecimento(Label l) {
        if (!UtilCentralAbastecimento.get().isControlMaster()) {
            return;
        }
        try {
            BicoBombaCombustivel bicoEvt = null;
            for (DeParaBicoBomba bm : this.listDeParaBicos) {
                if (!l.equals(bm.getLabel())) continue;
                bicoEvt = bm.getBico();
                break;
            }
            if (bicoEvt == null) {
                return;
            }
            DialogDoubleField d = (DialogDoubleField)Main.get().showDialog(Controllers.DIALOG_DOUBLE_FIELD);
            if (d.getValorInformado() == null || d.getValorInformado() <= 0.0) {
                return;
            }
            UtilCentralAbastecimento.get().preDeterminarValorAbastecimento(bicoEvt, d.getValorInformado());
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            Alerts.showAlertErrorRunLater("Erro ao predeterminar o valor de abastecimento: " + ex.getMessage());
        }
    }

    private void criarArquivoLarguraColunas() {
        try {
            File arquivo = new File("configuracao_tabela_bombas.txt");
            if (arquivo.createNewFile()) {
                System.out.println("Arquivo criado: " + arquivo.getAbsolutePath());
            } else {
                System.out.println("Arquivo j\u00e1 existe.");
            }
            this.salvarLarguras(arquivo.getAbsolutePath());
        }
        catch (IOException ex) {
            Logger.getLogger(CentralAbastecimentoSimplificada.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void salvarLarguras(String nomeArquivo) throws IOException {
        Properties props = new Properties();
        int index = 0;
        for (TableColumn coluna : this.tableAbastecPendentes.getColumns()) {
            props.setProperty("coluna" + index, String.valueOf(coluna.getWidth()));
            ++index;
        }
        try (FileOutputStream out = new FileOutputStream(nomeArquivo);){
            props.store(out, "Larguras das colunas");
        }
    }

    private void restaurarLarguras(String nomeArquivo) {
        try {
            Properties props = new Properties();
            try (FileInputStream in = new FileInputStream(nomeArquivo);){
                props.load(in);
            }
            int index = 0;
            for (TableColumn coluna : this.tableAbastecPendentes.getColumns()) {
                String largura = props.getProperty("coluna" + index);
                if (largura != null) {
                    coluna.setPrefWidth(Double.parseDouble(largura));
                }
                ++index;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initializeMaster() {
        if (UtilCentralAbastecimento.get().isControlMaster()) {
            try {
                UtilCentralAbastecimento.get().connectSocketAutomacao();
                this.liberarBombasAoAbrir();
                this.atualizarDataHoraAutomacao();
            }
            catch (Throwable ex) {
                TLogger.get(this.getClass()).error(ex);
                Alerts.showAlertErrorRunLater("Erro ao conectar na automacao: " + ex.getMessage());
            }
        }
    }

    private void startThreads() {
        if (UtilCentralAbastecimento.get().isControlMaster()) {
            try {
                UtilCentralAbastecimento.get().connectSocketAutomacao();
                this.threadStatusBicoBombaCombustivelMaster();
                this.threadThreadSincronizacaoAutomacao();
            }
            catch (Throwable ex) {
                TLogger.get(this.getClass()).error(ex);
                Alerts.showAlertErrorRunLater("Erro ao conectar na automacao: " + ex.getMessage());
            }
        } else {
            this.threadStatusBicoBombaCombustivelSlave();
        }
        this.threadShowAbastecimentosPendentes();
    }

    private void stopThreads() {
        int count = 0;
        do {
            if (this.threadStatusBicoBombaMaster != null) {
                this.threadStatusBicoBombaMaster.interrupt();
            }
            if (this.threadShowAbastecimentosPendentes != null) {
                this.threadShowAbastecimentosPendentes.interrupt();
            }
            if (this.threadStatusBicoBombaSlave != null) {
                this.threadStatusBicoBombaSlave.interrupt();
            }
            if (this.threadSincronizacaoAutomacao != null) {
                this.threadSincronizacaoAutomacao.interrupt();
            }
            try {
                Thread.sleep(Duration.ofSeconds(5L));
            }
            catch (InterruptedException ex) {
                Logger.getLogger(CentralAbastecimentoSimplificada.class.getName()).log(Level.SEVERE, null, ex);
            }
        } while ((this.threadSincronizacaoAutomacao == null || !this.threadSincronizacaoAutomacao.isInterrupted() || this.threadStatusBicoBombaMaster != null && !this.threadStatusBicoBombaMaster.isInterrupted() || this.threadShowAbastecimentosPendentes != null && !this.threadShowAbastecimentosPendentes.isInterrupted() || this.threadStatusBicoBombaSlave != null && !this.threadStatusBicoBombaSlave.isInterrupted()) && ++count < 5);
        if (count >= 5) {
            Alerts.showAlertError("Nao foi possivel parar todas as Threads de comunicacao. Reinicie o sistema.");
        }
        this.threadSincronizacaoAutomacao = null;
        this.threadStatusBicoBombaSlave = null;
        this.threadStatusBicoBombaMaster = null;
        this.threadShowAbastecimentosPendentes = null;
    }
}

