/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.abastecimento.threads;

import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.model.NFCePreAbastecimento;
import com.touchcomp.touchnfce.service.impl.ServiceNFCePreAbastecimento;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.TableView;

public class ThreadShowAbastecimentosPendentes
extends Thread {
    private final ServiceNFCePreAbastecimento serviceNFCePreAbastecimento;
    @FXML
    private final TableView<NFCePreAbastecimento> tableAbastecPendentes;
    private boolean clearingData = false;
    private boolean atualiza;
    private boolean continueThread;

    public ThreadShowAbastecimentosPendentes(ServiceNFCePreAbastecimento serviceNFCePreAbastecimento, TableView<NFCePreAbastecimento> tableAbastecPendentes) {
        this.serviceNFCePreAbastecimento = serviceNFCePreAbastecimento;
        this.tableAbastecPendentes = tableAbastecPendentes;
        this.continueThread = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.isContinueThread()) {
                if (!this.isClearingData()) {
                    try {
                        Optional<NFCePreAbastecimento> found;
                        this.atualiza = true;
                        List listOrdenada = this.getOrdenarListPreAbastecimento(this.serviceNFCePreAbastecimento.getRepository().getAbastecimentosPendentes());
                        ObservableList added = this.tableAbastecPendentes.getItems();
                        LinkedList<NFCePreAbastecimento> toAdd = new LinkedList<NFCePreAbastecimento>();
                        LinkedList<NFCePreAbastecimento> toRem = new LinkedList<NFCePreAbastecimento>();
                        for (NFCePreAbastecimento aux : listOrdenada) {
                            found = added.stream().filter(i -> i.equals(aux)).findFirst();
                            if (found.isPresent()) continue;
                            toAdd.add(aux);
                        }
                        for (NFCePreAbastecimento aux : added) {
                            found = listOrdenada.stream().filter(i -> i.equals(aux)).findFirst();
                            if (found.isPresent()) continue;
                            toRem.add(aux);
                        }
                        this.tableAbastecPendentes.getItems().addAll(toAdd);
                        this.tableAbastecPendentes.getItems().removeAll(toRem);
                    }
                    catch (Throwable ex) {
                        TLogger.get(this.getClass()).error(ex);
                        Alerts.showAlertErrorRunLater("Erro ao atualizar os pre abastecimentos: " + ex.getMessage());
                    }
                    finally {
                        this.atualiza = false;
                    }
                }
                ThreadShowAbastecimentosPendentes.sleep(500L);
            }
        }
        catch (InterruptedException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
        }
    }

    @Override
    public void interrupt() {
        this.setContinueThread(false);
        super.interrupt();
    }

    private List getOrdenarListPreAbastecimento(List<NFCePreAbastecimento> aux) {
        if (aux != null) {
            Collections.sort(aux, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    NFCePreAbastecimento n1 = (NFCePreAbastecimento)o1;
                    NFCePreAbastecimento n2 = (NFCePreAbastecimento)o2;
                    return n2.getIdentificador().compareTo(n1.getIdentificador());
                }
            });
            return aux;
        }
        return null;
    }

    public void clearAbastecimentos() {
        try {
            this.setClearingData(true);
            while (this.atualiza) {
                ThreadShowAbastecimentosPendentes.sleep(Duration.ofNanos(100L));
            }
            try {
                List listOrdenada = this.getOrdenarListPreAbastecimento(this.serviceNFCePreAbastecimento.getRepository().getAbastecimentosPendentes());
                this.tableAbastecPendentes.getItems().clear();
                this.tableAbastecPendentes.getItems().addAll((Collection)listOrdenada);
                this.tableAbastecPendentes.refresh();
            }
            finally {
                this.setClearingData(false);
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(ThreadShowAbastecimentosPendentes.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean isContinueThread() {
        return this.continueThread;
    }

    public void setContinueThread(boolean continueThread) {
        this.continueThread = continueThread;
    }

    public boolean isClearingData() {
        return this.clearingData;
    }

    public void setClearingData(boolean clearingData) {
        this.clearingData = clearingData;
    }
}

