/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.abastecimento.threads;

import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.ComunicadorResposta;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.constants.ConstEnumStatus;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.model.LeituraStatusBombas;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.model.NFCeGerenMaqAbastecimento;
import com.touchcomp.touchnfce.model.NFCeStatusBicoBomba;
import com.touchcomp.touchnfce.modeltemp.DeParaBicoBomba;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeStatusBicoBomba;
import com.touchcomp.touchnfce.utils.abastecimentocompanytec.UtilCentralAbastecimento;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ThreadStatusBicoBombaCombustivelMaster
extends Thread {
    List<DeParaBicoBomba> listDeParaBicos = new LinkedList<DeParaBicoBomba>();
    private List<NFCeStatusBicoBomba> statusBicosSlave = new ArrayList<NFCeStatusBicoBomba>();
    private Boolean continueThread;
    private int countErros = 0;

    public ThreadStatusBicoBombaCombustivelMaster(List<DeParaBicoBomba> listDeParaBicos, List<NFCeStatusBicoBomba> statusBicosSlave) {
        this.listDeParaBicos = listDeParaBicos;
        this.statusBicosSlave = statusBicosSlave;
        this.continueThread = true;
    }

    @Override
    public void run() {
        try {
            while (this.getContinueThread().booleanValue()) {
                block14: {
                    try {
                        ComunicadorResposta<LeituraStatusBombas> ret = UtilCentralAbastecimento.get().getStatuAtualBombas();
                        this.setColorLabelByStatusBicoBomba(((LeituraStatusBombas)ret.getResultado()).getStatusBicos());
                        this.atualizaStatusBicoBombaSlave();
                        this.countErros = 0;
                    }
                    catch (Exception ex) {
                        this.colorAllGeneralError();
                        Alerts.showAlertErrorRunLater("Erro ao enviar comandos para automacao: " + ex.getMessage());
                        TLogger.get(this.getClass()).error((Throwable)ex);
                        ++this.countErros;
                        if (this.countErros <= 3) break block14;
                        Alerts.showAlertErrorRunLater("Apos falhas sucessivas, a sincronizacao com automacao sera interrompida. Reconecte na automa\u00e7\u00e3o manualmente");
                        this.setContinueThread(false);
                        break;
                    }
                }
                ThreadStatusBicoBombaCombustivelMaster.sleep(500L);
            }
        }
        catch (InterruptedException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
        }
        finally {
            try {
                UtilCentralAbastecimento.get().disconnectSocketAutomacao();
            }
            catch (Exception ex) {
                TLogger.get(this.getClass()).error((Throwable)ex);
            }
        }
    }

    @Override
    public void interrupt() {
        this.setContinueThread(false);
        super.interrupt();
    }

    private synchronized void setColorLabelByStatusBicoBomba(List statusBicos) {
        if (statusBicos == null || statusBicos.isEmpty()) {
            return;
        }
        for (Object o : statusBicos) {
            for (DeParaBicoBomba b : this.listDeParaBicos) {
                Integer nrSequencial = 0;
                char status = ' ';
                if (o instanceof LeituraStatusBombas.StatusBico) {
                    nrSequencial = ((LeituraStatusBombas.StatusBico)o).getNrSeqBico();
                    status = ((LeituraStatusBombas.StatusBico)o).getStatus().getCodigo();
                } else {
                    nrSequencial = ((NFCeStatusBicoBomba)o).getBico().getNumeroSequencial();
                    status = ((NFCeStatusBicoBomba)o).getStatus().charAt(0);
                }
                if (!b.getBico().getNumeroSequencial().equals(nrSequencial)) continue;
                if (!ToolMethods.isEquals((Object)b.getBico().getAtivo(), (Object)1)) {
                    b.getLabel().setStyle("-fx-text-fill: #FFFFFF ;-fx-background-color: gray;-fx-min-width:20;-fx-width:Infinity;-fx-font: 12pt \"Microsoft New Tai Lue\";-fx-font-weight: bold;-fx-alignment: center;");
                    b.setStatus(ConstEnumStatus.BOMBA_NAO_PRESENTE_OU_EM_FALHA.getCodigo());
                    continue;
                }
                if (status == ConstEnumStatus.BOMBA_LIVRE_ABASTECIMENTOS.getCodigo()) {
                    b.getLabel().setStyle("-fx-text-fill: #FFFFFF ;-fx-background-color: green;-fx-min-width:20;-fx-width:Infinity;-fx-font: 12pt \"Microsoft New Tai Lue\";-fx-font-weight: bold;-fx-alignment: center;");
                    b.setStatus(ConstEnumStatus.BOMBA_LIVRE_ABASTECIMENTOS.getCodigo());
                    continue;
                }
                if (status == ConstEnumStatus.BOMBA_EM_ABASTECIMENTO.getCodigo()) {
                    b.getLabel().setStyle("-fx-text-fill: #FFFFFF ;-fx-background-color: yellow;-fx-min-width:20;-fx-width:Infinity;-fx-font: 12pt \"Microsoft New Tai Lue\";-fx-font-weight: bold;-fx-alignment: center;");
                    b.setStatus(ConstEnumStatus.BOMBA_EM_ABASTECIMENTO.getCodigo());
                    continue;
                }
                if (status == ConstEnumStatus.BOMBA_AGUARDANDO_LIBERACAO.getCodigo()) {
                    b.getLabel().setStyle("-fx-text-fill: #FFFFFF ;-fx-background-color: orange;-fx-min-width:20;-fx-width:Infinity;-fx-font: 12pt \"Microsoft New Tai Lue\";-fx-font-weight: bold;-fx-alignment: center;");
                    b.setStatus(ConstEnumStatus.BOMBA_AGUARDANDO_LIBERACAO.getCodigo());
                    continue;
                }
                if (status == ConstEnumStatus.BOMBA_CONCLUIU_ABASTECIMENTO.getCodigo()) {
                    b.getLabel().setStyle("-fx-text-fill: #FFFFFF ;-fx-background-color: brown;-fx-min-width:20;-fx-width:Infinity;-fx-font: 12pt \"Microsoft New Tai Lue\";-fx-font-weight: bold;-fx-alignment: center;");
                    b.setStatus(ConstEnumStatus.BOMBA_CONCLUIU_ABASTECIMENTO.getCodigo());
                    continue;
                }
                if (status == ConstEnumStatus.BOMBA_NAO_PRESENTE_OU_EM_FALHA.getCodigo()) {
                    b.getLabel().setStyle("-fx-text-fill: #FFFFFF ;-fx-background-color: gray;-fx-min-width:20;-fx-width:Infinity;-fx-font: 12pt \"Microsoft New Tai Lue\";-fx-font-weight: bold;-fx-alignment: center;");
                    b.setStatus(ConstEnumStatus.BOMBA_NAO_PRESENTE_OU_EM_FALHA.getCodigo());
                    continue;
                }
                if (status == ConstEnumStatus.BOMBA_PRONTA_ABASTECIMENTO.getCodigo()) {
                    b.getLabel().setStyle("-fx-text-fill: #FFFFFF ;-fx-background-color: blue;-fx-min-width:20;-fx-width:Infinity;-fx-font: 12pt \"Microsoft New Tai Lue\";-fx-font-weight: bold;-fx-alignment: center;");
                    b.setStatus(ConstEnumStatus.BOMBA_PRONTA_ABASTECIMENTO.getCodigo());
                    continue;
                }
                b.getLabel().setStyle("-fx-text-fill: #FFFFFF ;-fx-background-color: red;-fx-min-width:20;-fx-width:Infinity;-fx-font: 12pt \"Microsoft New Tai Lue\";-fx-font-weight: bold;-fx-alignment: center;");
                b.setStatus(ConstEnumStatus.BOMBA_BLOQUEADA.getCodigo());
            }
        }
    }

    private void atualizaStatusBicoBombaSlave() {
        ServiceNFCeStatusBicoBomba service;
        List statusBicos;
        boolean possuiSlave = false;
        for (NFCeGerenMaqAbastecimento ger : StaticObjects.getOpcoes().getGerenciamentoMaquinas()) {
            if (ToolMethods.isEquals((Object)ger.getAcessoMaster(), (Object)1)) continue;
            possuiSlave = true;
            break;
        }
        if (!possuiSlave) {
            return;
        }
        if (this.statusBicosSlave.isEmpty() && (statusBicos = (service = Main.getBean(ServiceNFCeStatusBicoBomba.class)).getAll()) != null && !statusBicos.isEmpty()) {
            this.statusBicosSlave = statusBicos;
        }
        ArrayList<NFCeStatusBicoBomba> aux = new ArrayList<NFCeStatusBicoBomba>();
        Long identificador = 1L;
        block1: for (DeParaBicoBomba d : this.listDeParaBicos) {
            if (!this.statusBicosSlave.isEmpty()) {
                for (NFCeStatusBicoBomba n : this.statusBicosSlave) {
                    if (!n.getBico().equals(d.getBico())) continue;
                    n.setStatus(Character.toString(d.getStatus()));
                    n.setPreAbastecimento(d.getPreAbastecimento());
                    continue block1;
                }
                continue;
            }
            NFCeStatusBicoBomba newStatus = new NFCeStatusBicoBomba();
            newStatus.setIdentificador(identificador);
            newStatus.setBico(d.getBico());
            newStatus.setStatus(Character.toString(d.getStatus()));
            newStatus.setPreAbastecimento(d.getPreAbastecimento());
            aux.add(newStatus);
            identificador = identificador + 1L;
        }
        if (!aux.isEmpty()) {
            this.statusBicosSlave = aux;
        }
        ServiceNFCeStatusBicoBomba service2 = Main.getBean(ServiceNFCeStatusBicoBomba.class);
        service2.saveAll(this.statusBicosSlave);
    }

    public Boolean getContinueThread() {
        return this.continueThread;
    }

    public void setContinueThread(Boolean continueThread) {
        this.continueThread = continueThread;
    }

    private void colorAllGeneralError() {
        for (DeParaBicoBomba b : this.listDeParaBicos) {
            b.getLabel().setStyle("-fx-text-fill: #FFFFFF ;-fx-background-color: orange;-fx-min-width:20;-fx-width:Infinity;-fx-font: 12pt \"Microsoft New Tai Lue\";-fx-font-weight: bold;-fx-alignment: center;");
            b.setStatus(ConstEnumStatus.BOMBA_NAO_PRESENTE_OU_EM_FALHA.getCodigo());
        }
    }
}

