/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.abastecimento.threads;

import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.constants.ConstEnumStatus;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.model.LeituraStatusBombas;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.model.NFCeStatusBicoBomba;
import com.touchcomp.touchnfce.modeltemp.DeParaBicoBomba;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeStatusBicoBomba;
import java.util.LinkedList;
import java.util.List;

public class ThreadStatusBicoBombaCombustivelSlave
extends Thread {
    List<DeParaBicoBomba> listDeParaBicos = new LinkedList<DeParaBicoBomba>();
    private Boolean continueThread;

    public ThreadStatusBicoBombaCombustivelSlave(List<DeParaBicoBomba> listDeParaBicos) {
        this.listDeParaBicos = listDeParaBicos;
        this.continueThread = true;
    }

    @Override
    public void run() {
        try {
            while (this.getContinueThread().booleanValue()) {
                try {
                    ServiceNFCeStatusBicoBomba service = Main.getBean(ServiceNFCeStatusBicoBomba.class);
                    List statusBicos = service.getAll();
                    this.setColorLabelByStatusBicoBomba(statusBicos);
                }
                catch (Throwable ex) {
                    TLogger.get(this.getClass()).error(ex);
                }
                ThreadStatusBicoBombaCombustivelSlave.sleep(1000L);
            }
        }
        catch (InterruptedException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
        }
    }

    @Override
    public void interrupt() {
        this.setContinueThread(false);
        super.interrupt();
    }

    private synchronized void setColorLabelByStatusBicoBomba(List statusBicos) {
        if (statusBicos == null || statusBicos.isEmpty()) {
            return;
        }
        for (Object o : statusBicos) {
            for (DeParaBicoBomba b : this.listDeParaBicos) {
                Integer nrSequencial = 0;
                char status = ' ';
                if (o instanceof LeituraStatusBombas.StatusBico) {
                    nrSequencial = ((LeituraStatusBombas.StatusBico)o).getNrSeqBico();
                    status = ((LeituraStatusBombas.StatusBico)o).getStatus().getCodigo();
                } else {
                    nrSequencial = ((NFCeStatusBicoBomba)o).getBico().getNumeroSequencial();
                    status = ((NFCeStatusBicoBomba)o).getStatus().charAt(0);
                }
                if (!b.getBico().getNumeroSequencial().equals(nrSequencial)) continue;
                if (!ToolMethods.isEquals((Object)b.getBico().getAtivo(), (Object)1)) {
                    b.getLabel().setStyle("-fx-text-fill: #FFFFFF ;-fx-background-color: gray;-fx-min-width:20;-fx-width:Infinity;-fx-font: 12pt \"Microsoft New Tai Lue\";-fx-font-weight: bold;-fx-alignment: center;");
                    b.setStatus(ConstEnumStatus.BOMBA_NAO_PRESENTE_OU_EM_FALHA.getCodigo());
                    continue;
                }
                if (status == ConstEnumStatus.BOMBA_LIVRE_ABASTECIMENTOS.getCodigo()) {
                    b.getLabel().setStyle("-fx-text-fill: #FFFFFF ;-fx-background-color: green;-fx-min-width:20;-fx-width:Infinity;-fx-font: 12pt \"Microsoft New Tai Lue\";-fx-font-weight: bold;-fx-alignment: center;");
                    b.setStatus(ConstEnumStatus.BOMBA_LIVRE_ABASTECIMENTOS.getCodigo());
                    continue;
                }
                if (status == ConstEnumStatus.BOMBA_EM_ABASTECIMENTO.getCodigo()) {
                    b.getLabel().setStyle("-fx-text-fill: #FFFFFF ;-fx-background-color: yellow;-fx-min-width:20;-fx-width:Infinity;-fx-font: 12pt \"Microsoft New Tai Lue\";-fx-font-weight: bold;-fx-alignment: center;");
                    b.setStatus(ConstEnumStatus.BOMBA_EM_ABASTECIMENTO.getCodigo());
                    continue;
                }
                if (status == ConstEnumStatus.BOMBA_AGUARDANDO_LIBERACAO.getCodigo()) {
                    b.getLabel().setStyle("-fx-text-fill: #FFFFFF ;-fx-background-color: orange;-fx-min-width:20;-fx-width:Infinity;-fx-font: 12pt \"Microsoft New Tai Lue\";-fx-font-weight: bold;-fx-alignment: center;");
                    b.setStatus(ConstEnumStatus.BOMBA_AGUARDANDO_LIBERACAO.getCodigo());
                    continue;
                }
                if (status == ConstEnumStatus.BOMBA_CONCLUIU_ABASTECIMENTO.getCodigo()) {
                    b.getLabel().setStyle("-fx-text-fill: #FFFFFF ;-fx-background-color: brown;-fx-min-width:20;-fx-width:Infinity;-fx-font: 12pt \"Microsoft New Tai Lue\";-fx-font-weight: bold;-fx-alignment: center;");
                    b.setStatus(ConstEnumStatus.BOMBA_CONCLUIU_ABASTECIMENTO.getCodigo());
                    continue;
                }
                if (status == ConstEnumStatus.BOMBA_NAO_PRESENTE_OU_EM_FALHA.getCodigo()) {
                    b.getLabel().setStyle("-fx-text-fill: #FFFFFF ;-fx-background-color: gray;-fx-min-width:20;-fx-width:Infinity;-fx-font: 12pt \"Microsoft New Tai Lue\";-fx-font-weight: bold;-fx-alignment: center;");
                    b.setStatus(ConstEnumStatus.BOMBA_NAO_PRESENTE_OU_EM_FALHA.getCodigo());
                    continue;
                }
                if (status == ConstEnumStatus.BOMBA_PRONTA_ABASTECIMENTO.getCodigo()) {
                    b.getLabel().setStyle("-fx-text-fill: #FFFFFF ;-fx-background-color: blue;-fx-min-width:20;-fx-width:Infinity;-fx-font: 12pt \"Microsoft New Tai Lue\";-fx-font-weight: bold;-fx-alignment: center;");
                    b.setStatus(ConstEnumStatus.BOMBA_PRONTA_ABASTECIMENTO.getCodigo());
                    continue;
                }
                b.getLabel().setStyle("-fx-text-fill: #FFFFFF ;-fx-background-color: red;-fx-min-width:20;-fx-width:Infinity;-fx-font: 12pt \"Microsoft New Tai Lue\";-fx-font-weight: bold;-fx-alignment: center;");
                b.setStatus(ConstEnumStatus.BOMBA_BLOQUEADA.getCodigo());
            }
        }
    }

    public Boolean getContinueThread() {
        return this.continueThread;
    }

    public void setContinueThread(Boolean continueThread) {
        this.continueThread = continueThread;
    }
}

