/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.caixa;

import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoAutenticacao;
import com.touchcomp.basementorexceptions.exceptions.impl.jasperreports.ExceptionJasperReports;
import com.touchcomp.basementorexceptions.exceptions.impl.print.ExceptionPrint;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.TouchDoubleField;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.BaseController;
import com.touchcomp.touchnfce.controller.login.LoginAutorizacaoController;
import com.touchcomp.touchnfce.controller.splash.impl.SplashSaveFechamentoNFCeEncerranteAbastecimento;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeControleCaixa;
import com.touchcomp.touchnfce.model.NFCeControleCaixaRes;
import com.touchcomp.touchnfce.modeltemp.ResumoRecebimento;
import com.touchcomp.touchnfce.print.impl.PrintFechamentoCaixaComp;
import com.touchcomp.touchnfce.print.impl.PrintFechamentoCaixaRes;
import com.touchcomp.touchnfce.service.impl.ServiceNFCe;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeControleCaixa;
import com.touchcomp.touchnfce.utils.MaskField;
import com.touchcomp.touchnfce.utils.UtilPermissaoUsuario;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.Text;
import javafx.util.Callback;

public class FechamentoCaixaController
extends BaseController {
    @FXML
    private Label lblAbertura;
    @FXML
    private Label lblFechamento;
    @FXML
    private Label lblDataAbertura;
    @FXML
    private Label lblDataFechamento;
    @FXML
    private Label lblUsuario;
    @FXML
    private Label lblDiferenca;
    @FXML
    private Label lblVlrPresente;
    @FXML
    private Label lblVlrSistema;
    @FXML
    private Label lblVlrRemanesc;
    @FXML
    private Label lblVlrPresenteRemanesc;
    @FXML
    private Label lblVlrRemanescAnt;
    @FXML
    private Label lblDiferencaVlrRem;
    @FXML
    private Label lblVlrTotEnt;
    @FXML
    private Label lblVlrTotSaida;
    @FXML
    private TouchTextField tfUsuario;
    @FXML
    private TouchDoubleField tfVlrSistema;
    @FXML
    private TouchDoubleField tfVlrPresente;
    @FXML
    private TouchDoubleField tfDiferenca;
    @FXML
    private TouchDoubleField tfVlrPresenteRemanesc;
    @FXML
    private TouchDoubleField tfVlrRemanesc;
    @FXML
    private TouchDoubleField tfVlrRemanescAnt;
    @FXML
    private TouchDoubleField tfDiferencaVlrRem;
    @FXML
    private TouchDoubleField tfVlrTotSaida;
    @FXML
    private TouchDoubleField tfVlrTotEnt;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnSair;
    @FXML
    private Button btnImprimirResumo;
    @FXML
    private AnchorPane body;
    @FXML
    private TabPane tabPanePrincipal;
    @FXML
    private TabPane tabPaneValores;
    @FXML
    private Tab tabDados;
    @FXML
    private Tab tabResumoRec;
    @FXML
    private Tab tabVlrTotal;
    @FXML
    private Tab tabVlrRemanesc;
    @FXML
    private Tab tabVlrMov;
    @FXML
    private TableView<NFCeControleCaixaRes> tableResumoRecebimentos;
    @FXML
    private TableColumn<NFCeControleCaixaRes, String> descTipoPag;
    @FXML
    private TableColumn<NFCeControleCaixaRes, String> vlrRecebido;
    @FXML
    private TableColumn<NFCeControleCaixaRes, String> vlrLiquido;
    @FXML
    private TableColumn<NFCeControleCaixaRes, String> vlrLiquidoInf;
    @FXML
    private TableColumn<NFCeControleCaixaRes, String> vlrRecebidoDif;
    @FXML
    private TableColumn<NFCeControleCaixaRes, String> columnTroco;
    double difValoresVlrReceb = 0.0;
    double difValoresVlrRem = 0.0;

    @Override
    protected void initializeController(ResourceBundle rb) {
        this.tableResumoRecebimentos.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        StaticObjects.refreshValoresControleCaixa();
        this.configureTable();
        this.setResumoTable();
        this.setPropertiesTextFields();
        this.tfVlrSistema.textProperty().addListener((observable, oldValue, newValue) -> {
            this.difValoresVlrReceb = StaticObjects.getControleCaixa().getValorTotalInformadoDinh() - this.tfVlrSistema.getDouble();
            this.difValoresVlrReceb = StaticObjects.getControleCaixa().getValorTotalSistemaDinh() - this.tfVlrSistema.getDouble();
            this.tfDiferenca.setDouble(this.difValoresVlrReceb);
        });
        this.tfVlrPresente.textProperty().addListener((observable, oldValue, newValue) -> {
            this.difValoresVlrRem = this.tfVlrSistema.getDouble() - this.tfVlrPresente.getDouble();
            this.tfDiferenca.setDouble(this.difValoresVlrRem);
        });
        if (this.getControleCaixa() != null) {
            this.tfUsuario.setEditable(false);
            this.tfUsuario.setText(StaticObjects.getControleCaixa().getUsuario().getPessoa().getNome());
            this.tfVlrSistema.setDouble(StaticObjects.getControleCaixa().getValorTotalSistema());
            this.tfVlrPresenteRemanesc.setDouble(StaticObjects.getControleCaixa().getValorRemanescenteCaixaDinh());
            this.tfVlrPresente.setDouble(StaticObjects.getControleCaixa().getValorTotalInformadoDinh());
            this.tfVlrRemanescAnt.setDouble(StaticObjects.getControleCaixa().getValorRemanescenteCaixaAnterior());
            this.tfVlrTotEnt.setDouble(StaticObjects.getControleCaixa().getValorTotalSaidasMov());
            this.tfVlrTotSaida.setDouble(StaticObjects.getControleCaixa().getValorTotalEntradasMov());
            this.lblDataAbertura.setText(ToolDate.dateToStr((Date)StaticObjects.getControleCaixa().getDataAbertura(), (String)"dd/MM/yyyy hh:mm"));
            this.lblDataFechamento.setText(ToolDate.dateToStr((Date)new Date(), (String)"dd/MM/yyyy hh:mm"));
        }
        this.setActionButtons();
        this.setLabelsTextField();
    }

    @Override
    public void beforeShow() {
    }

    private void setLabelsTextField() {
        this.tfUsuario.setFocusTraversable(false);
        this.tfVlrSistema.setLabel(this.lblVlrSistema);
        this.tfVlrPresente.setLabel(this.lblVlrPresente);
        this.tfDiferenca.setLabel(this.lblDiferenca);
        this.tfVlrRemanesc.setLabel(this.lblVlrRemanesc);
        this.tfVlrPresenteRemanesc.setLabel(this.lblVlrPresenteRemanesc);
        this.tfVlrRemanescAnt.setLabel(this.lblVlrRemanescAnt);
        this.tfDiferencaVlrRem.setLabel(this.lblDiferencaVlrRem);
        this.tfVlrTotEnt.setLabel(this.lblVlrTotEnt);
        this.tfVlrTotSaida.setLabel(this.lblVlrTotSaida);
        this.btnConfirmar.setFocusTraversable(false);
        this.btnImprimirResumo.setFocusTraversable(false);
        this.btnSair.setFocusTraversable(false);
        this.tfVlrPresente.requestFocus();
    }

    @Override
    protected void requestFocusOnOpen() {
        this.tfVlrPresente.requestFocus();
        this.tfVlrPresente.setDouble(null);
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKey(KeyEvent event) {
        switch (event.getCode()) {
            case ENTER: {
                this.geraFechamentoCaixa();
                break;
            }
            case F12: {
                this.geraFechamentoCaixa();
                break;
            }
            case F2: {
                this.showAlertOpcaoImpressao();
                break;
            }
            case F3: {
                this.tabPanePrincipal.getSelectionModel().select((Object)this.tabDados);
                if (((Tab)this.tabPanePrincipal.getSelectionModel().getSelectedItem()).equals(this.tabVlrTotal)) {
                    this.tfVlrPresente.requestFocus();
                    break;
                }
                if (!((Tab)this.tabPanePrincipal.getSelectionModel().getSelectedItem()).equals(this.tabVlrRemanesc)) break;
                this.tfVlrPresenteRemanesc.requestFocus();
                break;
            }
            case F4: {
                this.tabPanePrincipal.getSelectionModel().select((Object)this.tabResumoRec);
                this.tableResumoRecebimentos.requestFocus();
                this.tableResumoRecebimentos.getSelectionModel().selectFirst();
                break;
            }
            case F5: {
                this.tabPaneValores.getSelectionModel().select((Object)this.tabVlrTotal);
                this.tfVlrSistema.requestFocus();
                break;
            }
            case F6: {
                this.tabPaneValores.getSelectionModel().select((Object)this.tabVlrRemanesc);
                this.tfVlrRemanesc.requestFocus();
                break;
            }
            case F7: {
                this.tabPaneValores.getSelectionModel().select((Object)this.tabVlrMov);
                break;
            }
            case ESCAPE: {
                Main.get().mudaTela(Controllers.MENU_PRINCIPAL);
                break;
            }
            case F10: {
                this.showAlertOpcaoImpressao();
                break;
            }
        }
    }

    private void setResumoTable() {
        this.descTipoPag.setCellValueFactory(cellData -> new SimpleStringProperty(((NFCeControleCaixaRes)cellData.getValue()).getTipoPagamentoNFe().getDescricao()));
        this.descTipoPag.setCellFactory((Callback)new Callback<TableColumn<NFCeControleCaixaRes, String>, TableCell<NFCeControleCaixaRes, String>>(){

            public TableCell<NFCeControleCaixaRes, String> call(TableColumn<NFCeControleCaixaRes, String> param) {
                TableCell<NFCeControleCaixaRes, String> cell = new TableCell<NFCeControleCaixaRes, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty() && item != null) {
                            this.text = new Text(item.toString());
                            this.text.setWrappingWidth(FechamentoCaixaController.this.descTipoPag.getWidth());
                            this.setGraphic((Node)this.text);
                        }
                    }
                };
                return cell;
            }
        });
        this.vlrRecebido.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCeControleCaixaRes, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCeControleCaixaRes, String> param) {
                return new SimpleObjectProperty((Object)MaskField.monetaryField(((NFCeControleCaixaRes)param.getValue()).getValorRecebido()));
            }
        });
        this.vlrLiquidoInf.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCeControleCaixaRes, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCeControleCaixaRes, String> param) {
                return new SimpleObjectProperty((Object)MaskField.monetaryField(((NFCeControleCaixaRes)param.getValue()).getValorLiquidoInf()));
            }
        });
        this.vlrRecebidoDif.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCeControleCaixaRes, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCeControleCaixaRes, String> param) {
                return new SimpleObjectProperty((Object)MaskField.monetaryField(((NFCeControleCaixaRes)param.getValue()).getValorDiferenca()));
            }
        });
        this.columnTroco.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCeControleCaixaRes, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCeControleCaixaRes, String> param) {
                return new SimpleObjectProperty((Object)MaskField.monetaryField(((NFCeControleCaixaRes)param.getValue()).getValorTroco()));
            }
        });
        this.vlrLiquido.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCeControleCaixaRes, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCeControleCaixaRes, String> param) {
                return new SimpleObjectProperty((Object)MaskField.monetaryField(((NFCeControleCaixaRes)param.getValue()).getValorLiquido()));
            }
        });
        if (this.getControleCaixa() != null) {
            ServiceNFCeControleCaixa serviceNFCeControleCaixa = Main.getBean(ServiceNFCeControleCaixa.class);
            NFCeControleCaixa nfceControleCaixa = serviceNFCeControleCaixa.calcularValores(this.getControleCaixa());
            StaticObjects.setControleCaixa(nfceControleCaixa);
            this.tableResumoRecebimentos.setItems(FXCollections.observableArrayList(this.getControleCaixa().getResumoRecebimentos()));
        }
    }

    public void geraFechamentoCaixa() {
        StaticObjects.getControleCaixa().setValorTotalInformadoDinh(this.tfVlrPresente.getDouble());
        if (this.isValidFechamento()) {
            try {
                NFCeControleCaixa caixaAberto = StaticObjects.getControleCaixa();
                SplashSaveFechamentoNFCeEncerranteAbastecimento splash = new SplashSaveFechamentoNFCeEncerranteAbastecimento(caixaAberto);
                splash.show();
            }
            catch (Exception e) {
                TLogger.get(this.getClass()).error((Throwable)e);
                Alerts.showAlertError("Erro", e.toString());
            }
        }
    }

    private void showAlertOpcaoImpressao(NFCeControleCaixa controleCaixa) {
        Alert dialogoExe = new Alert(Alert.AlertType.CONFIRMATION);
        ButtonType btnCompleto = new ButtonType("Completo", ButtonBar.ButtonData.OK_DONE);
        ButtonType btnSimplificado = new ButtonType("Simplificado");
        ButtonType btnCancelar = new ButtonType("Cancelar");
        dialogoExe.setTitle("Fechamento do caixa");
        dialogoExe.setHeaderText("Deseja imprimir o resumo do caixa como?");
        dialogoExe.getButtonTypes().setAll((Object[])new ButtonType[]{btnCompleto, btnSimplificado, btnCancelar});
        List<ResumoRecebimento> resumo = ResumoRecebimento.convertListControleCaixaRes(controleCaixa.getResumoRecebimentos());
        dialogoExe.showAndWait().ifPresent(b -> {
            if (b == btnCompleto) {
                try {
                    new PrintFechamentoCaixaComp().printResumoCompleto(controleCaixa, resumo);
                }
                catch (ExceptionJasperReports | ExceptionPrint ex) {
                    Logger.getLogger(FechamentoCaixaController.class.getName()).log(Level.SEVERE, null, ex);
                    Alerts.showAlertError(ex.getMessage());
                }
            } else if (b == btnSimplificado) {
                try {
                    new PrintFechamentoCaixaRes().printResumoCompleto(controleCaixa);
                }
                catch (ExceptionJasperReports | ExceptionPrint ex) {
                    Logger.getLogger(FechamentoCaixaController.class.getName()).log(Level.SEVERE, null, ex);
                    Alerts.showAlertError(ex.getMessage());
                }
            } else {
                dialogoExe.close();
            }
        });
    }

    private void showAlertOpcaoImpressao() {
        this.showAlertOpcaoImpressao(StaticObjects.getControleCaixa());
    }

    private NFCeControleCaixa getControleCaixa() {
        return StaticObjects.getControleCaixa();
    }

    private void setPropertiesTextFields() {
        this.tfVlrSistema.setEditable(false);
        this.tfDiferenca.setEditable(false);
        this.tfUsuario.setEditable(false);
        this.tfVlrPresenteRemanesc.setEditable(false);
        this.tfVlrRemanescAnt.setEditable(false);
        this.tfDiferencaVlrRem.setEditable(false);
        this.tfVlrTotEnt.setEditable(false);
        this.tfVlrTotSaida.setEditable(false);
    }

    private void configureTable() {
        Platform.runLater(() -> {
            double totalWidth = Main.get().getPrimaryStage().getWidth();
            this.descTipoPag.setMinWidth(totalWidth * 30.0 / 100.0);
            this.descTipoPag.setMaxWidth(totalWidth * 30.0 / 100.0);
            this.vlrLiquido.setMinWidth(totalWidth * 14.0 / 100.0);
            this.vlrLiquido.setMaxWidth(totalWidth * 14.0 / 100.0);
            this.vlrLiquidoInf.setMinWidth(totalWidth * 14.0 / 100.0);
            this.vlrLiquidoInf.setMaxWidth(totalWidth * 14.0 / 100.0);
            this.vlrRecebidoDif.setMinWidth(totalWidth * 12.0 / 100.0);
            this.vlrRecebidoDif.setMaxWidth(totalWidth * 12.0 / 100.0);
            this.vlrRecebido.setMinWidth(totalWidth * 13.0 / 100.0);
            this.vlrRecebido.setMaxWidth(totalWidth * 13.0 / 100.0);
            this.columnTroco.setMinWidth(totalWidth * 13.0 / 100.0);
            this.columnTroco.setMaxWidth(totalWidth * 13.0 / 100.0);
        });
        this.vlrLiquido.setStyle("-fx-alignment: BOTTOM_RIGHT;");
        this.vlrLiquidoInf.setStyle("-fx-alignment: BOTTOM_RIGHT;");
        this.vlrRecebidoDif.setStyle("-fx-alignment: BOTTOM_RIGHT;");
        this.vlrRecebido.setStyle("-fx-alignment: BOTTOM_RIGHT;");
        this.columnTroco.setStyle("-fx-alignment: BOTTOM_RIGHT;");
    }

    private void setActionButtons() {
        this.btnConfirmar.setOnAction(event -> this.geraFechamentoCaixa());
        this.btnSair.setOnAction(event -> Main.get().mudaTela(Controllers.MENU_PRINCIPAL));
        this.btnImprimirResumo.setOnAction(event -> this.showAlertOpcaoImpressao());
    }

    private boolean isValidFechamento() {
        Optional<ButtonType> res;
        if (!StaticObjects.getControleCaixa().getUsuario().equals(StaticObjects.getUsuario())) {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "O usu\u00e1rio que fez a abertura deve ser o mesmo para fazer o encerramento!", "");
            return false;
        }
        ServiceNFCe serviceNFCe = Main.getBean(ServiceNFCe.class);
        if (this.tfVlrPresente.getDouble() == null) {
            Alerts.showQuestion("Informe o valor de fechamento do seu caixa.");
            return false;
        }
        if (this.tfVlrPresente.getDouble() <= 0.0 && !(res = Alerts.showQuestion("Voc\u00ea n\u00e3o informou o valor presente no seu caixa. Deseja continuar?")).get().equals(ButtonType.YES) && !res.get().equals(ButtonType.OK)) {
            return false;
        }
        List<NFCe> nfces = serviceNFCe.getNotasProblemaEnvio(StaticObjects.getNFCeCaixa());
        if (nfces != null && !nfces.isEmpty()) {
            Optional<ButtonType> resp = Alerts.showQuestion("Existem notas pendentes para envio. Deseja fechar o caixa mesmo assim?");
            if (resp.isPresent() && resp.get() == ButtonType.OK) {
                if (UtilPermissaoUsuario.isPermitidoCancelarNFCeItem()) {
                    return true;
                }
                HashMap<String, EnumConstNFCeTipoAutenticacao> h = new HashMap<String, EnumConstNFCeTipoAutenticacao>();
                h.put("tipo_autenticacao", EnumConstNFCeTipoAutenticacao.AUTENTICACAO_FECHAMENTO_CAIXA);
                LoginAutorizacaoController loginController = (LoginAutorizacaoController)Main.get().showDialog(Controllers.LOGIN_AUTORIZACAO, h);
                if (loginController.getUsuario() == null) {
                    Alerts.showAlertError("Voc\u00ea n\u00e3o possui autoriza\u00e7\u00e3o para realizar essa opera\u00e7\u00e3o");
                    return false;
                }
                for (NFCe n : nfces) {
                    UtilPermissaoUsuario.createAndAddLogNotExists(loginController.getUsuario(), EnumConstNFCeTipoAutenticacao.AUTENTICACAO_FECHAMENTO_CAIXA, n, null);
                }
            } else {
                Main.get().mudaTela(Controllers.CONSISTENCIA_NFCE);
                return false;
            }
        }
        return true;
    }
}

