/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.cheque;

import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.AutoCompleteTextField;
import com.touchcomp.touchnfce.components.TouchMonetaryField;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.model.NFCeChequeTerceiros;
import com.touchcomp.touchnfce.model.NFCeOpcoes;
import com.touchcomp.touchnfce.model.TipoPagamentoNFe;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeChequeTerceiros;
import com.touchcomp.touchnfce.utils.MaskField;
import com.touchcomp.touchnfce.utils.UtilNFCeSerial;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.Text;
import javafx.stage.WindowEvent;
import javafx.util.Callback;

public class LancamentoChequeController
extends BaseDialog
implements AutoCompleteTextField.ItemSelListener,
AutoCompleteTextField.ItemSourceFilter {
    public static final String VLR_TOT_CHEQUES = "vlrCheques";
    @FXML
    private Label lblBanco;
    @FXML
    private Label lblValor;
    @FXML
    private Label lblAgencia;
    @FXML
    private Label lblAgendaDC;
    @FXML
    private Label lblNumero;
    @FXML
    private Label lblContaCorrente;
    @FXML
    private Label lblContaCorrenteDC;
    @FXML
    private Label lblDataEntrada;
    @FXML
    private Label lblDataVencimento;
    @FXML
    private Label lblTitular;
    @FXML
    private Label lblVlrTotCheques;
    @FXML
    private Label lblVlrTotRec;
    @FXML
    private Label lblTroco;
    @FXML
    private Label lblLeituraCheques;
    @FXML
    private Label lblCnpjTitular;
    @FXML
    private Label lblDataBomPara;
    @FXML
    private Label lblC1C2C3;
    @FXML
    private TouchTextField tfBanco;
    @FXML
    private TouchTextField tfAgencia;
    @FXML
    private TouchTextField tfAgenciaDC;
    @FXML
    private TouchTextField tfNumero;
    @FXML
    private TouchTextField tfContaCorrente;
    @FXML
    private TouchTextField tfContaCorrenteDC;
    @FXML
    private TouchTextField tfDataEntrada;
    @FXML
    private TouchTextField tfDataVencimento;
    @FXML
    private TouchTextField tfTitular;
    @FXML
    private TouchTextField tfC1C2C3;
    @FXML
    private TouchTextField tfDataBomPara;
    @FXML
    private AutoCompleteTextField tfLeituraCheques;
    @FXML
    private AutoCompleteTextField tfCnpjTitular;
    @FXML
    private TouchMonetaryField tfValor;
    @FXML
    private TouchMonetaryField tfVlrTotCheque;
    @FXML
    private TouchMonetaryField tfVlrTotRec;
    @FXML
    private TouchMonetaryField tfTroco;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnCancelar;
    @FXML
    private Button btnAddCheque;
    @FXML
    private Button btnCheques;
    @FXML
    private TableView<NFCeChequeTerceiros> tableCheques;
    @FXML
    private TableColumn<NFCeChequeTerceiros, String> columnBanco;
    @FXML
    private TableColumn<NFCeChequeTerceiros, String> columnTitular;
    @FXML
    private TableColumn<NFCeChequeTerceiros, String> columnNumero;
    @FXML
    private TableColumn<NFCeChequeTerceiros, String> columnDataVenc;
    @FXML
    private TableColumn<NFCeChequeTerceiros, String> columnValor;
    @FXML
    private AnchorPane body;
    private List<NFCeChequeTerceiros> cheques = new LinkedList<NFCeChequeTerceiros>();
    private TipoPagamentoNFe tipoPagCheque;
    final PseudoClass errorClass = PseudoClass.getPseudoClass((String)"error");
    Double vlrTotCheques = 0.0;
    Double vlrTotRec = 0.0;

    @Override
    public void initializeController(ResourceBundle rb) {
        this.tableCheques.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.configureTable();
        this.setPropertiesTextFields();
        this.tfLeituraCheques.setItemSelListener(this);
        this.tfLeituraCheques.setItemSourceFilter(this);
        this.setActionsButtons();
        this.setChequesTable();
        this.tfLeituraCheques.requestFocus();
        this.setLabelsTextFields();
        this.btnAddCheque.setFocusTraversable(false);
        this.btnCancelar.setFocusTraversable(false);
        this.btnCheques.setFocusTraversable(false);
        this.btnConfirmar.setFocusTraversable(false);
        MaskField.cpfCnpjField(this.tfCnpjTitular);
        this.setDadosCheque();
    }

    private void setDadosCheque() {
        if (StaticObjects.getNfceAberta() != null && StaticObjects.getNfceAberta().getUnidadeFatCliente() != null) {
            this.tfTitular.setText(StaticObjects.getNfceAberta().getUnidadeFatCliente().getPessoa().getNome());
            this.tfCnpjTitular.setText(StaticObjects.getNfceAberta().getUnidadeFatCliente().getPessoa().getComplemento().getCnpj());
        }
    }

    private void setLabelsTextFields() {
        this.tfAgencia.setLabel(this.lblAgencia);
        this.tfAgenciaDC.setLabel(this.lblAgendaDC);
        this.tfBanco.setLabel(this.lblBanco);
        this.tfContaCorrente.setLabel(this.lblContaCorrente);
        this.tfContaCorrenteDC.setLabel(this.lblContaCorrenteDC);
        this.tfDataEntrada.setLabel(this.lblDataEntrada);
        this.tfDataVencimento.setLabel(this.lblDataVencimento);
        this.tfLeituraCheques.setLabel(this.lblLeituraCheques);
        this.tfNumero.setLabel(this.lblNumero);
        this.tfTitular.setLabel(this.lblTitular);
        this.tfTroco.setLabel(this.lblTroco);
        this.tfValor.setLabel(this.lblValor);
        this.tfVlrTotCheque.setLabel(this.lblVlrTotCheques);
        this.tfVlrTotRec.setLabel(this.lblVlrTotRec);
        this.tfCnpjTitular.setLabel(this.lblCnpjTitular);
        this.tfDataBomPara.setLabel(this.lblDataBomPara);
        this.tfC1C2C3.setLabel(this.lblC1C2C3);
    }

    private void setPropertiesTextFields() {
        MaskField.dateField(this.tfDataVencimento);
        MaskField.dateField(this.tfDataBomPara);
        MaskField.numericField(this.tfNumero);
        MaskField.monetaryField(this.tfValor);
        this.tfDataEntrada.setEditable(false);
        this.tfDataEntrada.setText(ToolDate.dateToStr((Date)new Date(), (String)"dd/MM/yyyy"));
        this.tfVlrTotCheque.setAmount(this.vlrTotCheques);
        this.tfVlrTotCheque.setEditable(false);
        this.tfVlrTotRec.setEditable(false);
        this.tfTroco.setEditable(false);
    }

    @Override
    public void posInitialize() {
        this.vlrTotCheques = (Double)this.getParams().get(VLR_TOT_CHEQUES);
        this.atualizaCampos();
        this.tfValor.setAmount(this.vlrTotCheques);
        this.getStage().setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent t) {
                if (LancamentoChequeController.this.isValidChequeSalvos()) {
                    LancamentoChequeController.this.closeDialog();
                } else {
                    Optional<ButtonType> resp = Alerts.showQuestion("Alguns cheques n\u00e3o foram salvos, se sair do recurso os mesmos seram removidos. Deseja continuar?");
                    if (resp.isPresent() && resp.get() == ButtonType.OK) {
                        LancamentoChequeController.this.removeChequesNaoSalvos();
                        LancamentoChequeController.this.closeDialog();
                    }
                }
            }
        });
    }

    private void setActionsButtons() {
        this.btnCancelar.setOnAction(event -> {
            if (this.isValidChequeSalvos()) {
                this.closeDialog();
            } else {
                Optional<ButtonType> resp = Alerts.showQuestion("Alguns cheques n\u00e3o foram salvos, se sair do recurso os mesmos seram removidos. Deseja continuar?");
                if (resp.isPresent() && resp.get() == ButtonType.OK) {
                    this.removeChequesNaoSalvos();
                    this.closeDialog();
                }
            }
        });
        this.btnConfirmar.setOnAction(event -> {
            try {
                this.adicionaChequePagamentos();
            }
            catch (Exception ex) {
                Logger.getLogger(LancamentoChequeController.class.getName()).log(Level.SEVERE, null, ex);
                Alerts.showAlertError("Erro ao tentar salvar o cheque. Verique se j\u00e1 existe um cheque com este mesmo n\u00famero.\n" + ex.getMessage());
            }
        });
        this.btnAddCheque.setOnAction(event -> this.criaCheque());
        this.btnCheques.setOnAction(event -> {
            this.tableCheques.requestFocus();
            this.tableCheques.getSelectionModel().selectFirst();
            this.setDadosTextField();
        });
    }

    private boolean isValidChequeSalvos() {
        ObservableList cheques = this.tableCheques.getItems();
        if (cheques == null || cheques.isEmpty()) {
            return true;
        }
        for (NFCeChequeTerceiros c : cheques) {
            if (c.getIdentificador() != null && c.getIdentificador() != 0L) continue;
            return false;
        }
        return true;
    }

    private void removeChequesNaoSalvos() {
        ObservableList listCheques = this.tableCheques.getItems();
        ArrayList<NFCeChequeTerceiros> chequesNaoSalvos = new ArrayList<NFCeChequeTerceiros>();
        for (NFCeChequeTerceiros c : listCheques) {
            if (c.getIdentificador() != null && c.getIdentificador() != 0L) continue;
            chequesNaoSalvos.add(c);
        }
        if (!chequesNaoSalvos.isEmpty()) {
            this.cheques.removeAll(chequesNaoSalvos);
            this.tableCheques.getItems().removeAll(chequesNaoSalvos);
            this.tableCheques.refresh();
        }
    }

    private void excluiCheque() {
        this.vlrTotRec = this.vlrTotRec - ((NFCeChequeTerceiros)this.tableCheques.getSelectionModel().getSelectedItem()).getValor();
        this.atualizaCampos();
        this.cheques.remove(this.tableCheques.getSelectionModel().getSelectedItem());
        this.tableCheques.getItems().remove(this.tableCheques.getSelectionModel().getSelectedItem());
        this.tableCheques.refresh();
        this.limpaCampos();
    }

    private NFCeOpcoes getOpcoes() {
        return StaticObjects.getOpcoes();
    }

    private void setChequesTable() {
        this.columnBanco.setCellValueFactory(cellData -> new SimpleStringProperty(((NFCeChequeTerceiros)cellData.getValue()).getBanco()));
        this.columnBanco.setCellFactory((Callback)new Callback<TableColumn<NFCeChequeTerceiros, String>, TableCell<NFCeChequeTerceiros, String>>(){

            public TableCell<NFCeChequeTerceiros, String> call(TableColumn<NFCeChequeTerceiros, String> param) {
                TableCell<NFCeChequeTerceiros, String> cell = new TableCell<NFCeChequeTerceiros, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty() && item != null) {
                            this.text = new Text(item.toString());
                            this.text.setWrappingWidth(LancamentoChequeController.this.columnBanco.getWidth());
                            this.setGraphic((Node)this.text);
                        }
                    }
                };
                return cell;
            }
        });
        this.columnNumero.setCellValueFactory(cellData -> new SimpleStringProperty(String.valueOf(((NFCeChequeTerceiros)cellData.getValue()).getNumero())));
        this.columnNumero.setCellFactory((Callback)new Callback<TableColumn<NFCeChequeTerceiros, String>, TableCell<NFCeChequeTerceiros, String>>(){

            public TableCell<NFCeChequeTerceiros, String> call(TableColumn<NFCeChequeTerceiros, String> param) {
                TableCell<NFCeChequeTerceiros, String> cell = new TableCell<NFCeChequeTerceiros, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty() && item != null) {
                            this.text = new Text(item.toString());
                            this.text.setWrappingWidth(LancamentoChequeController.this.columnNumero.getWidth());
                            this.setGraphic((Node)this.text);
                        }
                    }
                };
                return cell;
            }
        });
        this.columnTitular.setCellValueFactory(cellData -> new SimpleStringProperty(((NFCeChequeTerceiros)cellData.getValue()).getTitular()));
        this.columnTitular.setCellFactory((Callback)new Callback<TableColumn<NFCeChequeTerceiros, String>, TableCell<NFCeChequeTerceiros, String>>(){

            public TableCell<NFCeChequeTerceiros, String> call(TableColumn<NFCeChequeTerceiros, String> param) {
                TableCell<NFCeChequeTerceiros, String> cell = new TableCell<NFCeChequeTerceiros, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty() && item != null) {
                            this.text = new Text(item.toString());
                            this.text.setWrappingWidth(LancamentoChequeController.this.columnTitular.getWidth());
                            this.setGraphic((Node)this.text);
                        }
                    }
                };
                return cell;
            }
        });
        this.columnDataVenc.setCellValueFactory(cellData -> new SimpleStringProperty(ToolDate.dateToStr((Date)((NFCeChequeTerceiros)cellData.getValue()).getDataVencimento(), (String)"dd/MM/yyyy")));
        this.columnValor.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCeChequeTerceiros, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCeChequeTerceiros, String> param) {
                return new SimpleObjectProperty((Object)MaskField.monetaryField(((NFCeChequeTerceiros)param.getValue()).getValor()));
            }
        });
        this.tableCheques.setItems(FXCollections.observableArrayList(this.cheques));
    }

    @Override
    public void requestFocusOnOpen() {
        Platform.runLater(() -> this.tfLeituraCheques.requestFocus());
    }

    public void atualizaCampos() {
        this.tfTroco.setAmount(this.vlrTotRec - this.vlrTotCheques);
        if (this.tfTroco.getAmount() >= 0.0) {
            this.tfTroco.setStyle("-fx-text-fill: #0000FF");
        } else {
            this.tfTroco.setStyle("-fx-text-fill: #FF0000");
        }
        this.tfVlrTotRec.setAmount(this.vlrTotRec);
    }

    public boolean isValidBefore() {
        boolean isValid = true;
        if (this.tfNumero.getText().isEmpty()) {
            this.tfNumero.pseudoClassStateChanged(this.errorClass, true);
            isValid = false;
        } else {
            this.tfNumero.pseudoClassStateChanged(this.errorClass, false);
        }
        if (this.tfAgencia.getText().isEmpty()) {
            this.tfAgencia.pseudoClassStateChanged(this.errorClass, true);
            isValid = false;
        } else {
            this.tfAgencia.pseudoClassStateChanged(this.errorClass, false);
        }
        if (this.tfBanco.getText().isEmpty()) {
            this.tfBanco.pseudoClassStateChanged(this.errorClass, true);
            isValid = false;
        } else {
            this.tfBanco.pseudoClassStateChanged(this.errorClass, false);
        }
        if (this.tfContaCorrente.getText().isEmpty()) {
            this.tfContaCorrente.pseudoClassStateChanged(this.errorClass, true);
            isValid = false;
        } else {
            this.tfContaCorrente.pseudoClassStateChanged(this.errorClass, false);
        }
        if (this.tfDataVencimento.getText().isEmpty()) {
            this.tfDataVencimento.pseudoClassStateChanged(this.errorClass, true);
            isValid = false;
        } else {
            this.tfDataVencimento.pseudoClassStateChanged(this.errorClass, false);
        }
        if (this.tfTitular.getText().isEmpty()) {
            this.tfTitular.pseudoClassStateChanged(this.errorClass, true);
            isValid = false;
        } else {
            this.tfTitular.pseudoClassStateChanged(this.errorClass, false);
        }
        if (this.tfValor.getText().isEmpty() || this.tfValor.getAmount() == 0.0) {
            this.tfValor.pseudoClassStateChanged(this.errorClass, true);
            isValid = false;
        } else {
            this.tfValor.pseudoClassStateChanged(this.errorClass, false);
        }
        return isValid;
    }

    private void criaCheque() {
        try {
            if (this.isValidBefore()) {
                NFCeChequeTerceiros cheque = new NFCeChequeTerceiros();
                cheque.setSerialForSinc(UtilNFCeSerial.getSerial(cheque));
                cheque.setAgencia(this.tfAgencia.getText());
                cheque.setCodigoCMC(this.tfLeituraCheques.getText());
                cheque.setAgenciaDC(this.tfAgenciaDC.getText());
                cheque.setBanco(this.tfBanco.getText());
                cheque.setC1c2c3(this.tfC1C2C3.getText());
                cheque.setContaCorrente(this.tfContaCorrente.getText());
                cheque.setContaCorrenteDC(this.tfContaCorrenteDC.getText());
                cheque.setDataEntrada(new Date());
                cheque.setDataVencimento(ToolDate.strToDate((String)this.tfDataVencimento.getText(), (String)"dd/MM/yyyy"));
                cheque.setDataBomPara(ToolDate.strToDate((String)this.tfDataBomPara.getText(), (String)"dd/MM/yyyy"));
                cheque.setNumero(Integer.valueOf(this.tfNumero.getText()));
                cheque.setTitular(this.tfTitular.getText());
                cheque.setCnpjTitular(ToolString.refina((String)this.tfCnpjTitular.getText()));
                cheque.setValor(this.tfValor.getAmount());
                this.vlrTotRec = this.vlrTotRec + this.tfValor.getAmount();
                this.atualizaCampos();
                this.cheques.add(cheque);
                this.setChequesTable();
                this.tableCheques.refresh();
                this.limpaCampos();
                this.tfLeituraCheques.requestFocus();
                this.setValorNewCheque();
            }
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            Alerts.showAlertInfo("Erro ao adicionar os cheques. Verifique os dados informados: " + ex.getMessage());
        }
    }

    private void configureTable() {
        this.columnValor.setMinWidth(80.0);
        this.columnBanco.setMinWidth(260.0);
        this.columnTitular.setMinWidth(188.0);
        this.columnNumero.setMinWidth(200.0);
        this.columnDataVenc.setMinWidth(108.0);
        this.columnValor.setStyle("-fx-alignment: BOTTOM_RIGHT;");
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt == null) {
            return;
        }
        switch (evt.getCode()) {
            case F12: {
                try {
                    this.adicionaChequePagamentos();
                }
                catch (Exception ex) {
                    Logger.getLogger(LancamentoChequeController.class.getName()).log(Level.SEVERE, null, ex);
                    Alerts.showAlertError("Erro ao tentar salvar o cheque. Verique se j\u00e1 existe um cheque com este mesmo n\u00famero.\n" + ex.getMessage());
                }
                break;
            }
            case ESCAPE: {
                this.getStage().close();
                break;
            }
            case F1: {
                this.tfLeituraCheques.requestFocus();
                break;
            }
            case F2: {
                this.limpaCampos();
                this.tfNumero.requestFocus();
                this.tableCheques.getSelectionModel().select(null);
                break;
            }
            case F3: {
                this.criaCheque();
                break;
            }
            case F4: {
                this.tableCheques.requestFocus();
                this.tableCheques.getSelectionModel().selectFirst();
                this.setDadosTextField();
                break;
            }
            case UP: {
                this.setDadosTextField();
                break;
            }
            case DOWN: {
                this.setDadosTextField();
                break;
            }
            case DELETE: {
                if (!this.tableCheques.isFocused() || this.tableCheques.getSelectionModel().getSelectedItem() == null) break;
                this.excluiCheque();
            }
        }
    }

    private void setDadosTextField() {
        NFCeChequeTerceiros cheque = (NFCeChequeTerceiros)this.tableCheques.getSelectionModel().getSelectedItem();
        if (cheque != null) {
            this.tfNumero.setText(String.valueOf(cheque.getNumero()));
            this.tfValor.setAmount(cheque.getValor());
            this.tfAgencia.setText(cheque.getAgencia());
            this.tfAgenciaDC.setText(cheque.getAgenciaDC());
            this.tfBanco.setText(cheque.getBanco());
            this.tfContaCorrente.setText(cheque.getContaCorrente());
            this.tfContaCorrenteDC.setText(cheque.getContaCorrenteDC());
            this.tfTitular.setText(cheque.getTitular());
            this.tfDataEntrada.setText(ToolDate.dateToStr((Date)cheque.getDataEntrada(), (String)"dd/MM/yyyy"));
            this.tfDataVencimento.setText(ToolDate.dateToStr((Date)cheque.getDataEntrada(), (String)"dd/MM/yyyy"));
        }
    }

    private void limpaCampos() {
        this.tfNumero.setText("");
        this.tfValor.setText("");
        this.tfAgencia.setText("");
        this.tfAgenciaDC.setText("");
        this.tfBanco.setText("");
        this.tfContaCorrente.setText("");
        this.tfContaCorrenteDC.setText("");
        this.tfTitular.setText("");
        this.tfDataVencimento.setText("");
        this.tfLeituraCheques.setText("");
        this.tfCnpjTitular.setText("");
        this.tfDataBomPara.setText("");
        this.tfC1C2C3.setText("");
    }

    public void setTipoPagCheque(TipoPagamentoNFe tipoPagCheque) {
        this.tipoPagCheque = tipoPagCheque;
    }

    private void adicionaChequePagamentos() throws Exception {
        ServiceNFCeChequeTerceiros serviceCheque = Main.getBean(ServiceNFCeChequeTerceiros.class);
        if (this.isValidBeforeSaveCheque()) {
            for (NFCeChequeTerceiros cheque : this.cheques) {
                serviceCheque.save(cheque);
            }
            this.closeDialog();
        }
    }

    public List<NFCeChequeTerceiros> getChequesInformados() {
        return this.cheques;
    }

    public List<NFCeChequeTerceiros> getCheques() {
        return this.cheques;
    }

    public void onItemListener(Object data) {
        this.preencherDadosCheque();
    }

    @Override
    public SortedSet onTextChange(String text) {
        this.preencherDadosCheque();
        return null;
    }

    private void preencherDadosCheque() {
        String cmc = this.tfLeituraCheques.getText();
        if (cmc != null && cmc.trim().length() > 29) {
            cmc = cmc.replace("<", "");
            cmc = cmc.replace(">", "");
            cmc = cmc.replace("\u00c7", "");
            String banco = cmc.substring(0, 3);
            this.tfBanco.setText(banco);
            switch (banco) {
                case "033": {
                    this.tfAgencia.setText(cmc.substring(3, 7));
                    this.tfContaCorrente.setText(cmc.substring(21, 28));
                    this.tfContaCorrenteDC.setText(cmc.substring(28, 29));
                    this.tfNumero.setText(cmc.substring(11, 17));
                    this.clearDataVencimento();
                    break;
                }
                case "104": {
                    this.tfAgencia.setText(cmc.substring(3, 7));
                    this.tfContaCorrente.setText(cmc.substring(20, 28));
                    this.tfContaCorrenteDC.setText(cmc.substring(28, 29));
                    this.tfNumero.setText(cmc.substring(11, 17));
                    this.clearDataVencimento();
                    break;
                }
                case "341": {
                    this.tfAgencia.setText(cmc.substring(3, 7));
                    this.tfContaCorrente.setText(cmc.substring(23, 28));
                    this.tfContaCorrenteDC.setText(cmc.substring(28, 29));
                    this.tfNumero.setText(cmc.substring(11, 17));
                    this.clearDataVencimento();
                    break;
                }
                case "756": {
                    this.tfAgencia.setText(cmc.substring(3, 7));
                    this.tfContaCorrente.setText(cmc.substring(19, 28));
                    this.tfContaCorrenteDC.setText(cmc.substring(28, 29));
                    this.tfNumero.setText(cmc.substring(11, 17));
                    this.clearDataVencimento();
                    break;
                }
                case "237": {
                    this.tfAgencia.setText(cmc.substring(3, 7));
                    this.tfAgenciaDC.setText(cmc.substring(7, 8));
                    this.tfContaCorrente.setText(cmc.substring(22, 28));
                    this.tfContaCorrenteDC.setText(cmc.substring(28, 29));
                    this.tfNumero.setText(cmc.substring(11, 17));
                    this.clearDataVencimento();
                    break;
                }
                case "389": {
                    this.tfAgencia.setText(cmc.substring(3, 7));
                    this.tfContaCorrente.setText(cmc.substring(19, 28));
                    this.tfContaCorrenteDC.setText(cmc.substring(28, 29));
                    this.tfNumero.setText(cmc.substring(11, 17));
                    this.clearDataVencimento();
                    break;
                }
                case "356": {
                    this.tfAgencia.setText(cmc.substring(3, 7));
                    this.tfContaCorrente.setText(cmc.substring(22, 29));
                    this.tfContaCorrenteDC.setText(cmc.substring(29, 30));
                    this.tfNumero.setText(cmc.substring(11, 17));
                    this.clearDataVencimento();
                    break;
                }
                default: {
                    this.tfAgencia.setText(cmc.substring(3, 7));
                    this.tfContaCorrente.setText(cmc.substring(19, 28));
                    this.tfContaCorrenteDC.setText(cmc.substring(28, 29));
                    this.tfNumero.setText(cmc.substring(11, 17));
                    this.clearDataVencimento();
                }
            }
            this.tfDataVencimento.requestFocus();
        }
    }

    private boolean isValidBeforeSaveCheque() {
        if (this.getOpcoes().getValidarValorCheques().equals((short)1)) {
            Double valor = 0.0;
            for (NFCeChequeTerceiros cheque : this.cheques) {
                valor = valor + cheque.getValor();
            }
            valor = ToolFormatter.arrredondarNumero((Double)valor, (int)2);
            this.vlrTotCheques = ToolFormatter.arrredondarNumero((Double)this.vlrTotCheques, (int)2);
            if (!valor.equals(this.vlrTotCheques)) {
                Alerts.showAlertError("O valor informado dos cheques n\u00e3o \u00e9 igual ao valor informado do pagamento");
                return false;
            }
        }
        return true;
    }

    private void setValorNewCheque() {
        if (this.vlrTotRec < this.vlrTotCheques) {
            this.tfValor.setAmount(this.vlrTotCheques - this.vlrTotRec);
        }
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    private void clearDataVencimento() {
        new Thread(){

            @Override
            public void run() {
                do {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(LancamentoChequeController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } while (!LancamentoChequeController.this.tfDataVencimento.isFocused());
                LancamentoChequeController.this.tfDataVencimento.selectAll();
                LancamentoChequeController.this.tfDataVencimento.clear();
            }
        }.start();
    }
}

