/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.consistencianfce;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostopiscofins.ExceptionImpostoPisCofins;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.BaseController;
import com.touchcomp.touchnfce.controller.nfce.StyleChangingRowFactory;
import com.touchcomp.touchnfce.controller.splash.impl.SplashResolvePendNFCe;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.service.impl.ServiceNFCe;
import com.touchcomp.touchnfce.utils.MaskField;
import com.touchcomp.touchnfce.utils.UtilNFCeCancelamento;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.Text;
import javafx.util.Callback;

public class ConsistenciaNFCeController
extends BaseController {
    @FXML
    private Label lblBusca;
    @FXML
    private TouchTextField tfCampoBusca;
    @FXML
    private Button btnSelecionarNFCe;
    @FXML
    private Button btnEnviaTodasNFCe;
    @FXML
    private Button btnEnviaNFCeSelecionadas;
    @FXML
    private Button btnVoltar;
    @FXML
    private Button btnCancelarNFCe;
    @FXML
    private Button btnVisualizarNFCe;
    @FXML
    private Button btnAlterarTpEmissao;
    @FXML
    private TableView<NFCe> tableNotas;
    @FXML
    private TableColumn<NFCe, String> columnCliente;
    @FXML
    private TableColumn<NFCe, String> columnDataEmissao;
    @FXML
    private TableColumn<NFCe, String> columnNumero;
    @FXML
    private TableColumn<NFCe, String> columnValor;
    @FXML
    private TableColumn<NFCe, String> columnStatus;
    @FXML
    private AnchorPane body;
    StyleChangingRowFactory<NFCe> rowFactory = new StyleChangingRowFactory("table-row-cell-green");
    private List<NFCe> allElements = new LinkedList<NFCe>();
    private List<NFCe> filterElements = new LinkedList<NFCe>();

    @Override
    protected void initializeController(ResourceBundle rb) {
        this.tableNotas.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.tableNotas.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tableNotas.setRowFactory(this.rowFactory);
        this.btnVoltar.setOnAction(event -> Main.get().mudaTela(Controllers.MENU_PRINCIPAL));
        this.btnEnviaNFCeSelecionadas.setOnAction(event -> {
            this.resolver((ObservableList<NFCe>)this.tableNotas.getSelectionModel().getSelectedItems());
            this.tableNotas.getItems().clear();
            this.iniciaElementosTable();
        });
        this.btnEnviaTodasNFCe.setOnAction(event -> {
            this.resolver((ObservableList<NFCe>)this.tableNotas.getItems());
            this.tableNotas.getItems().clear();
            this.iniciaElementosTable();
        });
        this.btnSelecionarNFCe.setOnAction(event -> this.seleciona());
        this.btnVisualizarNFCe.setOnAction(event -> this.vaiTelaVisualizacaoNFCe());
        this.btnAlterarTpEmissao.setOnAction(event -> this.alterarTipoEmissao());
        this.btnCancelarNFCe.setOnAction(event -> {
            try {
                this.cancelarNFCe();
                this.tableNotas.getItems().clear();
                this.iniciaElementosTable();
            }
            catch (ExceptionImpostoIcms | ExceptionImpostoPisCofins ex) {
                Logger.getLogger(ConsistenciaNFCeController.class.getName()).log(Level.SEVERE, null, ex);
                Alerts.showAlertError("Erro", ex.getMessage());
            }
        });
        this.tfCampoBusca.textProperty().addListener((observable, oldValue, newValue) -> {});
        this.iniciaElementosTable();
        StaticObjects.clearNFCe();
        this.tfCampoBusca.setLabel(this.lblBusca);
        this.configureTable();
    }

    private void alterarTipoEmissao() {
    }

    private void configureTable() {
        this.columnCliente.setMinWidth(310.0);
        this.columnStatus.setMinWidth(180.0);
        this.columnDataEmissao.setMinWidth(60.0);
        this.columnNumero.setMinWidth(180.0);
        this.columnValor.setMinWidth(50.0);
        this.columnValor.setStyle("-fx-alignment: BOTTOM_RIGHT;");
    }

    private void cancelarNFCe() throws ExceptionImpostoPisCofins, ExceptionImpostoIcms {
        NFCe selected = (NFCe)this.tableNotas.getSelectionModel().getSelectedItem();
        if (selected == null) {
            Alerts.showAlertError("Erro", "Selecione uma NFCe para continuar!");
            return;
        }
        try {
            if (selected == null) {
                Alerts.showAlertError("Erro", "Selecione uma NFCe para continuar!");
                return;
            }
            UtilNFCeCancelamento.confirmaCancelamentoNFCe(selected);
        }
        catch (Exception e) {
            TLogger.get(this.getClass()).error((Throwable)e);
            Alerts.showAlertError("Houve um erro ao realizar o cancelamento. Tente Novamente mais tarde.");
        }
    }

    private void seleciona() {
        NFCe sel = (NFCe)this.tableNotas.getSelectionModel().getSelectedItem();
        if (sel == null) {
            Alerts.showAlertInfo("Selecione uma NFCe.");
            return;
        }
        EnumConstNFeStatus status = EnumConstNFeStatus.getByCodigo((Integer)sel.getStatus());
        if (status != null && !EnumConstNFeStatus.isRejeitadaOuNaoEnv((EnumConstNFeStatus)status)) {
            Alerts.showAlertInfo("Status da NFCe n\u00e3o permite edi\u00e7\u00e3o: " + status.getDescricao());
            return;
        }
        StaticObjects.setNfceAberta(sel);
        Main.get().mudaTela(Controllers.VENDA);
    }

    @Override
    protected void requestFocusOnOpen() {
        this.tfCampoBusca.requestFocus();
    }

    private void setNotasTable() {
        this.columnValor.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCe, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCe, String> param) {
                return new SimpleObjectProperty((Object)MaskField.monetaryField(((NFCe)param.getValue()).getTotalizadores().getValorTotalBruto()));
            }
        });
        this.columnCliente.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCe, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCe, String> param) {
                if (((NFCe)param.getValue()).getUnidadeFatCliente() != null) {
                    return new SimpleObjectProperty((Object)(((NFCe)param.getValue()).getUnidadeFatCliente().getPessoa().getNome() + " / " + ((NFCe)param.getValue()).getUnidadeFatCliente().getPessoa().getNomeFantasia()));
                }
                if (((NFCe)param.getValue()).getNfCeConsumidor() != null) {
                    return new SimpleObjectProperty((Object)((NFCe)param.getValue()).getNfCeConsumidor().getNome());
                }
                return new SimpleObjectProperty();
            }
        });
        this.columnCliente.setCellFactory((Callback)new Callback<TableColumn<NFCe, String>, TableCell<NFCe, String>>(){

            public TableCell<NFCe, String> call(TableColumn<NFCe, String> param) {
                TableCell<NFCe, String> cell = new TableCell<NFCe, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.text = !this.isEmpty() && item != null ? new Text(item.toString()) : new Text("");
                        this.text.setWrappingWidth(ConsistenciaNFCeController.this.columnCliente.getWidth());
                        this.setGraphic((Node)this.text);
                    }
                };
                return cell;
            }
        });
        this.columnDataEmissao.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCe, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCe, String> param) {
                return new SimpleObjectProperty((Object)ToolDate.dateToStr((Date)((NFCe)param.getValue()).getDataEmissao(), (String)"dd/MM/yyyy"));
            }
        });
        this.columnNumero.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCe, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCe, String> param) {
                return new SimpleObjectProperty((Object)String.valueOf(((NFCe)param.getValue()).getNumero()));
            }
        });
        this.columnStatus.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCe, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCe, String> param) {
                return new SimpleObjectProperty((Object)ConsistenciaNFCeController.this.getMotivoStatusNFCe((NFCe)param.getValue()));
            }
        });
        this.columnStatus.setCellFactory((Callback)new Callback<TableColumn<NFCe, String>, TableCell<NFCe, String>>(){

            public TableCell<NFCe, String> call(TableColumn<NFCe, String> param) {
                TableCell<NFCe, String> cell = new TableCell<NFCe, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.text = !this.isEmpty() && item != null ? new Text(item.toString()) : new Text("");
                        this.text.setWrappingWidth(ConsistenciaNFCeController.this.columnStatus.getWidth());
                        this.setGraphic((Node)this.text);
                    }
                };
                return cell;
            }
        });
        this.tableNotas.setItems(FXCollections.observableArrayList(this.filterElements));
    }

    private String getMotivoStatusNFCe(NFCe nfce) {
        String str = nfce.getStatus() + " - " + nfce.getMotivo();
        if (nfce.getNfceEventoEpec() != null) {
            str = nfce.getNfceEventoEpec().getStatus() + " - " + nfce.getNfceEventoEpec().getMotivo();
        }
        return str;
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKey(KeyEvent evt) {
        switch (evt.getCode()) {
            case F12: {
                this.seleciona();
                break;
            }
            case F2: {
                this.vaiTelaVisualizacaoNFCe();
                break;
            }
            case F4: {
                this.resolver((ObservableList<NFCe>)this.tableNotas.getSelectionModel().getSelectedItems());
                break;
            }
            case F3: {
                this.resolver((ObservableList<NFCe>)this.tableNotas.getItems());
                break;
            }
            case F5: {
                try {
                    this.cancelarNFCe();
                    this.tableNotas.getItems().clear();
                    this.iniciaElementosTable();
                }
                catch (ExceptionImpostoIcms | ExceptionImpostoPisCofins ex) {
                    Logger.getLogger(ConsistenciaNFCeController.class.getName()).log(Level.SEVERE, null, ex);
                    Alerts.showAlertError("Erro", ex.getMessage());
                }
                break;
            }
            case F6: {
                this.alterarTipoEmissao();
                break;
            }
            case F7: {
                this.tfCampoBusca.requestFocus();
                this.tableNotas.getSelectionModel().select(null);
                break;
            }
            case F8: {
                this.tableNotas.requestFocus();
                this.tableNotas.getSelectionModel().selectFirst();
                break;
            }
            case ESCAPE: {
                Main.get().mudaTela(Controllers.MENU_PRINCIPAL);
                break;
            }
            case DOWN: {
                if (!this.tfCampoBusca.isFocused()) break;
                this.tableNotas.requestFocus();
                this.tableNotas.getSelectionModel().selectFirst();
                break;
            }
            case F10: {
                if (!this.tfCampoBusca.isFocused()) break;
                this.tableNotas.requestFocus();
                this.tableNotas.getSelectionModel().selectFirst();
                break;
            }
        }
    }

    private void vaiTelaVisualizacaoNFCe() {
        if (this.tableNotas.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("NFCe", this.tableNotas.getSelectionModel().getSelectedItem());
            Main.get().mudaTela(Controllers.VISUALIZAR_NFCE, data);
        } else {
            Alerts.showAlertError("Selecione uma nota da tabela!");
        }
    }

    private void resolver(ObservableList<NFCe> selectedItems) {
        ServiceNFCe serviceNFCe = Main.getBean(ServiceNFCe.class);
        Iterator aux = selectedItems.iterator();
        List<NFCe> lista = new ArrayList<NFCe>();
        Boolean notaAtualizada = false;
        while (aux.hasNext()) {
            NFCe nfce = (NFCe)aux.next();
            lista.add(nfce);
            nfce = (NFCe)serviceNFCe.get(nfce.getIdentificador());
            if (!EnumConstNFeStatus.isStatusFinal((Integer)nfce.getStatus())) {
                lista.add(nfce);
                continue;
            }
            notaAtualizada = true;
        }
        if (notaAtualizada.booleanValue()) {
            Alerts.showAlertInfo("Algumas notas ja foram atualizadas anteriormente pela tarefa de envio automatico!");
        }
        lista = this.ordenarListaEmissaoPorPeriodo(lista);
        SplashResolvePendNFCe sp = new SplashResolvePendNFCe();
        sp.setParams(lista, this);
        sp.show();
    }

    public void iniciaElementosTable() {
        ServiceNFCe serviceNFCe = Main.getBean(ServiceNFCe.class);
        this.allElements = serviceNFCe.getNotasProblemaEnvio(StaticObjects.getNFCeCaixa());
        this.filterElements = this.allElements;
        this.setNotasTable();
    }

    private List<NFCe> ordenarListaEmissaoPorPeriodo(List<NFCe> lista) {
        if (lista != null) {
            Collections.sort(lista, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    NFCe nfce1 = (NFCe)o1;
                    NFCe nfce2 = (NFCe)o2;
                    Short codigo2 = nfce2.getPeriodoEmissaoNFCe() != null ? nfce2.getPeriodoEmissaoNFCe().getTipoEmissaoNfe().getCodigo() : nfce2.getPeriodoEmissaoNFe().getTipoEmissaoNfe().getCodigo();
                    Short codigo1 = nfce1.getPeriodoEmissaoNFCe() != null ? nfce2.getPeriodoEmissaoNFCe().getTipoEmissaoNfe().getCodigo() : nfce1.getPeriodoEmissaoNFe().getTipoEmissaoNfe().getCodigo();
                    return codigo2.compareTo(codigo1);
                }
            });
            return lista;
        }
        return new ArrayList<NFCe>();
    }
}

