/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.cupomdesconto;

import com.touchcomp.basementor.constants.enums.cupomdesconto.EnumConstCupomDesconto;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.exceptions.ExceptionSincronizacao;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCePagamento;
import com.touchcomp.touchnfce.sinc.receive.SincOthers;
import com.touchcomp.touchvomodel.vo.cupomdesconto.nfce.DTOCupomDesconto;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;

public class CupomDescontoController
extends BaseDialog {
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnCancelar;
    @FXML
    private TableView<DTOCupomDesconto> tableCupons;
    @FXML
    private TableColumn<DTOCupomDesconto, String> columnCodigo;
    @FXML
    private TableColumn<DTOCupomDesconto, String> columnValor;
    @FXML
    private TableColumn<DTOCupomDesconto, String> columnDataCadastro;
    @FXML
    private TableColumn<DTOCupomDesconto, String> columnStatus;
    @FXML
    private AnchorPane body;
    public static final String NFCE_PAGAMENTO = "nfce_pagamento";
    private NFCePagamento nfcePagamento;

    @Override
    public void initializeController(ResourceBundle resources) {
        this.initTable();
        this.btnCancelar.setOnAction(evt -> this.closeDialog());
        this.btnConfirmar.setOnAction(evt -> this.confirmar());
    }

    private void initTable() {
        this.columnCodigo.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<DTOCupomDesconto, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<DTOCupomDesconto, String> param) {
                return new SimpleObjectProperty((Object)((DTOCupomDesconto)param.getValue()).getCodigo());
            }
        });
        this.columnDataCadastro.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<DTOCupomDesconto, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<DTOCupomDesconto, String> param) {
                if (((DTOCupomDesconto)param.getValue()).getDataCadastro() != null) {
                    return new SimpleObjectProperty((Object)ToolDate.dateToStr((Date)((DTOCupomDesconto)param.getValue()).getDataCadastro(), (String)"dd/MM/yyyy"));
                }
                return new SimpleObjectProperty((Object)"");
            }
        });
        this.columnValor.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<DTOCupomDesconto, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<DTOCupomDesconto, String> param) {
                return new SimpleObjectProperty((Object)(((DTOCupomDesconto)param.getValue()).getValor() != null ? ((DTOCupomDesconto)param.getValue()).getValor().toString() : ""));
            }
        });
        this.columnStatus.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<DTOCupomDesconto, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<DTOCupomDesconto, String> param) {
                if (ToolMethods.isEquals((Object)((DTOCupomDesconto)param.getValue()).getStatus(), (Object)EnumConstCupomDesconto.ABERTO.getValue())) {
                    return new SimpleObjectProperty((Object)"Aberto");
                }
                return new SimpleObjectProperty((Object)"Fechado");
            }
        });
        this.tableCupons.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        try {
            List<DTOCupomDesconto> cupons = this.getCupons();
            if (cupons == null || cupons.isEmpty()) {
                Alerts.showAlertError("Nenhum cupom encontrado!");
                return;
            }
            this.tableCupons.setItems(FXCollections.observableList(cupons));
        }
        catch (ExceptionSincronizacao e) {
            e.printStackTrace();
            Alerts.showAlertError("N\u00e3o foi poss\u00edvel buscar os cupons: \n" + e.getMessage());
        }
    }

    private List<DTOCupomDesconto> getCupons() throws ExceptionSincronizacao {
        NFCe nfceAberta = StaticObjects.getNfceAberta();
        if (nfceAberta != null) {
            List<DTOCupomDesconto> cupons = SincOthers.getCupomDesconto(nfceAberta.getUnidadeFatCliente().getCliente().getPessoa().getIdentificador());
            return cupons;
        }
        return new ArrayList<DTOCupomDesconto>();
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt != null && evt.getCode() != null) {
            switch (evt.getCode()) {
                case ESCAPE: {
                    this.closeDialog();
                    break;
                }
                case F12: {
                    this.confirmar();
                    break;
                }
                case F1: {
                    this.tableCupons.requestFocus();
                    this.tableCupons.getSelectionModel().selectFirst();
                    break;
                }
            }
        }
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void requestFocusOnOpen() {
        this.tableCupons.requestFocus();
        this.tableCupons.getSelectionModel().selectFirst();
    }

    private void confirmar() {
        try {
            DTOCupomDesconto cupom = (DTOCupomDesconto)this.tableCupons.getSelectionModel().getSelectedItem();
            if (cupom == null) {
                Alerts.showAlertError("Primeiro selecione um cupom da tabela!");
                return;
            }
            if (this.nfcePagamento != null && cupom.getValor() < this.nfcePagamento.getValorLiquido()) {
                Alerts.showAlertError("O valor do cupom de desconto n\u00e3o pode ser menor que o valor do pagamento!");
                return;
            }
            if (this.nfcePagamento != null) {
                this.nfcePagamento.setSerialForSincCupomDesconto(cupom.getSerialForSinc());
                SincOthers.fecharCupomDesconto(cupom.getIdentificador());
            }
            this.closeDialog();
        }
        catch (ExceptionSincronizacao e) {
            e.printStackTrace();
            Alerts.showAlertError(e.getMessage());
        }
    }

    @Override
    public void posInitialize() {
        this.nfcePagamento = (NFCePagamento)this.getParams().get(NFCE_PAGAMENTO);
    }
}

