/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.dialogs;

import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoAutenticacao;
import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoDesconto;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoipi.ExceptionImpostoIPI;
import com.touchcomp.basementorexceptions.exceptions.impl.impostopiscofins.ExceptionImpostoPisCofins;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.TouchDoubleField;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.login.LoginAutorizacaoController;
import com.touchcomp.touchnfce.model.ItemPedido;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.utils.UtilNFCeCalculos;
import com.touchcomp.touchnfce.utils.UtilPermissaoUsuario;
import com.touchcomp.touchnfce.utils.pedido.UtilPedidoCalculos;
import java.util.HashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;

public class DescontoAcrescimoItemVenda
extends BaseDialog {
    public static final String ITEM = "item";
    public static final String DOC = "doc";
    @FXML
    private AnchorPane body;
    @FXML
    private Label lblProduto;
    @FXML
    private Label lblVrBruto;
    @FXML
    private Label lblVrTotal;
    @FXML
    private Label lblDesconto;
    @FXML
    private Label lblAcrescimo;
    @FXML
    private Label lblVrAcresc;
    @FXML
    private Label lblPercAcresc;
    @FXML
    private Label lblVrDesconto;
    @FXML
    private Label lblPercDesconto;
    @FXML
    private Label lblTotalDesconto;
    @FXML
    private Label lblTotalAcresc;
    @FXML
    private Label lblDescontoPromocao;
    @FXML
    private TouchTextField tfProduto;
    @FXML
    private TouchDoubleField tfVrBruto;
    @FXML
    private TouchDoubleField tfVrTotal;
    @FXML
    private TouchDoubleField tfPercDesconto;
    @FXML
    private TouchDoubleField tfVrDesconto;
    @FXML
    private TouchDoubleField tfPercAcresc;
    @FXML
    private TouchDoubleField tfVrAcresc;
    @FXML
    private TouchDoubleField tfTotalDesconto;
    @FXML
    private TouchDoubleField tfTotalAcresc;
    @FXML
    private TouchDoubleField tfDescontoPromocao;
    @FXML
    private RadioButton rbPercDesconto;
    @FXML
    private RadioButton rbValorDesconto;
    @FXML
    private RadioButton rbPercAcresc;
    @FXML
    private RadioButton rbValorAcresc;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnCancelar;
    private ToggleGroup toggleDesconto = new ToggleGroup();
    private ToggleGroup toggleAcrescimo = new ToggleGroup();
    private HashMap h = new HashMap();
    NFCeItem itemNFCe = null;
    ItemPedido itemPedido = null;
    NFCe nfce;

    @Override
    public void initializeController(ResourceBundle resources) {
        this.setLabelsTextFields();
        this.setPropsRadioButtons();
        this.btnConfirmar.setOnAction(evt -> this.confirmar());
        this.btnCancelar.setOnAction(evt -> this.closeDialog());
        this.tfVrDesconto.setOnKeyPressed(evt -> {
            if (evt.getCode() != null && evt.getCode() == KeyCode.ENTER) {
                this.aplicarDesconto();
            }
        });
        this.tfPercDesconto.setOnKeyPressed(evt -> {
            if (evt.getCode() != null && evt.getCode() == KeyCode.ENTER) {
                this.aplicarDesconto();
            }
        });
        this.tfVrAcresc.setOnKeyPressed(evt -> {
            if (evt.getCode() != null && evt.getCode() == KeyCode.ENTER) {
                this.aplicarAcrescimo();
            }
        });
        this.tfPercAcresc.setOnKeyPressed(evt -> {
            if (evt.getCode() != null && evt.getCode() == KeyCode.ENTER) {
                this.aplicarAcrescimo();
            }
        });
    }

    private void setLabelsTextFields() {
        this.tfPercAcresc.setLabel(this.lblPercAcresc);
        this.tfPercDesconto.setLabel(this.lblPercDesconto);
        this.tfVrAcresc.setLabel(this.lblVrAcresc);
        this.tfVrDesconto.setLabel(this.lblVrDesconto);
        this.tfDescontoPromocao.setLabel(this.lblDescontoPromocao);
        this.tfVrBruto.setEditable(false);
        this.tfVrTotal.setEditable(false);
        this.tfProduto.setEditable(false);
        this.tfTotalAcresc.setEditable(false);
        this.tfTotalDesconto.setEditable(false);
        this.tfDescontoPromocao.setEditable(false);
        this.tfVrBruto.setFocusTraversable(false);
        this.tfVrTotal.setFocusTraversable(false);
        this.tfProduto.setFocusTraversable(false);
        this.tfTotalAcresc.setFocusTraversable(false);
        this.tfTotalDesconto.setFocusTraversable(false);
        this.tfDescontoPromocao.setFocusTraversable(false);
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt != null) {
            switch (evt.getCode()) {
                case F12: {
                    this.confirmar();
                    break;
                }
                case ENTER: {
                    if (this.btnConfirmar.isFocused()) {
                        this.confirmar();
                        break;
                    }
                    this.btnConfirmar.setFocusTraversable(true);
                    this.btnConfirmar.requestFocus();
                    break;
                }
                case ESCAPE: {
                    this.closeDialog();
                    break;
                }
                case F1: {
                    if (!this.rbValorDesconto.isSelected()) break;
                    this.tfPercDesconto.setDisable(false);
                    this.tfVrDesconto.setDisable(true);
                    this.tfPercDesconto.requestFocus();
                    this.tfPercDesconto.selectAll();
                    this.rbPercDesconto.setSelected(true);
                    this.rbValorDesconto.setSelected(false);
                    break;
                }
                case F2: {
                    if (!this.rbPercDesconto.isSelected()) break;
                    this.tfVrDesconto.setDisable(false);
                    this.tfPercDesconto.setDisable(true);
                    this.tfVrDesconto.requestFocus();
                    this.tfVrDesconto.selectAll();
                    this.rbValorDesconto.setSelected(true);
                    this.rbPercDesconto.setSelected(false);
                    break;
                }
                case F3: {
                    this.tfPercAcresc.setDisable(false);
                    this.tfVrAcresc.setDisable(true);
                    this.tfPercAcresc.requestFocus();
                    this.tfPercAcresc.selectAll();
                    this.rbPercAcresc.setSelected(true);
                    this.rbValorAcresc.setSelected(false);
                    break;
                }
                case F4: {
                    this.tfVrAcresc.setDisable(false);
                    this.tfPercAcresc.setDisable(true);
                    this.tfVrAcresc.requestFocus();
                    this.tfVrAcresc.selectAll();
                    this.rbValorAcresc.setSelected(true);
                    this.rbPercAcresc.setSelected(false);
                    break;
                }
            }
        }
    }

    private void confirmar() {
        this.calcularValores();
        if (!this.aplicarDesconto().booleanValue()) {
            return;
        }
        if (!this.aplicarAcrescimo().booleanValue()) {
            return;
        }
        if (!this.isValidDescAcresc()) {
            return;
        }
        if (this.itemNFCe != null) {
            this.setValoresNFCe();
        } else {
            try {
                this.setValoresPedido();
            }
            catch (Exception e) {
                TLogger.get((Object)e).error((Throwable)e);
                Alerts.showAlertInfo(e.getMessage());
            }
        }
    }

    private void calcularValores() {
        double valorTotalBruto = 0.0;
        valorTotalBruto = this.itemNFCe != null ? this.itemNFCe.getValorTotalBruto().doubleValue() : this.itemPedido.getValorTotalBruto().doubleValue();
        if (this.rbPercDesconto.isSelected()) {
            this.tfVrDesconto.setDouble(valorTotalBruto * this.tfPercDesconto.getDouble() / 100.0);
        } else {
            this.tfPercDesconto.setDouble(this.tfVrDesconto.getDouble() / valorTotalBruto * 100.0);
        }
        if (this.rbPercAcresc.isSelected()) {
            this.tfVrAcresc.setDouble(valorTotalBruto * this.tfPercAcresc.getDouble() / 100.0);
        } else {
            this.tfPercAcresc.setDouble(this.tfVrAcresc.getDouble() / valorTotalBruto * 100.0);
        }
    }

    private boolean isValidDescAcresc() {
        boolean res;
        Double percAcrescimo = this.tfPercAcresc.getDouble();
        Double percDesconto = this.tfPercDesconto.getDouble();
        if (percDesconto > 99.0) {
            Alerts.showAlertInfo("Desconto acima de 99%.");
            return false;
        }
        if (percAcrescimo > 0.0 && !(res = this.verificaPermissaoAcrescimo(EnumConstNFCeTipoAutenticacao.AUTENTICACAO_ACRESCIMO_ITEM, percAcrescimo))) {
            Alerts.showAlertInfo("Percentual Acr\u00e9scimo \u00e9 maior que o permitido para o seu grupo de usu\u00e1rios.");
            return false;
        }
        if (percDesconto > 0.0) {
            if (this.itemNFCe != null && ToolMethods.isEquals((Object)this.itemNFCe.getTipoDesconto(), (Object)EnumConstNFCeTipoDesconto.DESCONTO_ACRESCIMO_GERAL.getValue()) && ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getPermitirDescSobDesc(), (Object)0)) {
                Alerts.showAlertError("N\u00e3o \u00e9 permitido conceder desconto sobre desconto!");
                return false;
            }
            res = this.verificaPermissaoDesc(EnumConstNFCeTipoAutenticacao.AUTENTICACAO_DESCONTO_ITEM, percDesconto);
            if (!res) {
                Alerts.showAlertInfo("Percentual Desconto \u00e9 maior que o permitido para o seu grupo de usu\u00e1rios.");
                return false;
            }
        }
        return true;
    }

    protected boolean verificaPermissaoAcrescimo(EnumConstNFCeTipoAutenticacao tipoAutenticacao, Double percAcrescimo) {
        boolean res = UtilPermissaoUsuario.isPermitidoAcrescimo(StaticObjects.getUsuario(), percAcrescimo);
        if (res) {
            return true;
        }
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("tipo_autenticacao", tipoAutenticacao);
        h.put("percentual", percAcrescimo);
        LoginAutorizacaoController loginController = (LoginAutorizacaoController)Main.get().showDialog(Controllers.LOGIN_AUTORIZACAO, h);
        if (loginController.getUsuario() == null) {
            Alerts.showAlertError("Voc\u00ea n\u00e3o possui autoriza\u00e7\u00e3o para realizar essa opera\u00e7\u00e3o");
            return false;
        }
        if (StaticObjects.getNfceAberta() != null) {
            UtilPermissaoUsuario.createAndAddLogNotExists(loginController.getUsuario(), tipoAutenticacao, StaticObjects.getNfceAberta(), null);
        }
        return true;
    }

    protected boolean verificaPermissaoDesc(EnumConstNFCeTipoAutenticacao tipoAutenticacao, Double percDesconto) {
        boolean res = UtilPermissaoUsuario.isPermitidoDesconto(StaticObjects.getUsuario(), percDesconto);
        if (res) {
            return true;
        }
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("tipo_autenticacao", tipoAutenticacao);
        h.put("percentual", percDesconto);
        LoginAutorizacaoController loginController = (LoginAutorizacaoController)Main.get().showDialog(Controllers.LOGIN_AUTORIZACAO, h);
        if (loginController.getUsuario() == null) {
            Alerts.showAlertError("Voc\u00ea n\u00e3o possui autoriza\u00e7\u00e3o para realizar essa opera\u00e7\u00e3o");
            return false;
        }
        if (StaticObjects.getNfceAberta() != null) {
            UtilPermissaoUsuario.createAndAddLogNotExists(loginController.getUsuario(), tipoAutenticacao, StaticObjects.getNfceAberta(), null);
        }
        return true;
    }

    private void setValoresPedido() throws Exception {
        this.itemPedido.setTipoDesconto(this.getTipoDesconto());
        this.itemPedido.setPercDesconto(this.tfPercDesconto.getDouble());
        this.itemPedido.setValorDesconto(this.tfVrDesconto.getDouble());
        if (this.tfPercDesconto.getDouble() > 0.0 || this.tfVrDesconto.getDouble() > 0.0) {
            this.itemPedido.setDescontoItem((short)1);
        } else {
            this.itemPedido.setDescontoItem((short)0);
        }
        this.itemPedido.setTipoDespAcessoria(this.getTipoAcrescimo());
        this.itemPedido.setPercDespesaAcessoria(this.tfPercAcresc.getDouble());
        this.itemPedido.setValorDespesaAcessoria(this.tfVrAcresc.getDouble());
        if (this.tfPercAcresc.getDouble() != null && this.tfVrAcresc.getDouble() > 0.0) {
            this.itemPedido.setDespAcessItem((short)1);
        } else {
            this.itemPedido.setDespAcessItem((short)0);
        }
        UtilPedidoCalculos.calcularValores(StaticObjects.getPedidoAberto());
        this.closeDialog();
    }

    private void setValoresNFCe() {
        this.itemNFCe.setValorDescontoInf(this.tfVrDesconto.getDouble());
        this.itemNFCe.setValorDespesasAcessoriasInf(this.tfVrAcresc.getDouble());
        this.itemNFCe.setPercentualDescontoInf(this.tfPercDesconto.getDouble());
        this.itemNFCe.setPercentualDespAcessInf(this.tfPercAcresc.getDouble());
        this.itemNFCe.setPercValorDesconto(this.getTipoDesconto());
        this.itemNFCe.setPercValorDespAcess(this.getTipoAcrescimo());
        if (this.rbPercDesconto.isSelected()) {
            this.itemNFCe.setPercValorDesconto((short)0);
        } else {
            this.itemNFCe.setPercValorDesconto((short)1);
        }
        if (this.rbPercAcresc.isSelected()) {
            this.itemNFCe.setPercValorDespAcess((short)0);
        } else {
            this.itemNFCe.setPercValorDespAcess((short)1);
        }
        if (this.tfVrDesconto.getDouble() > 0.0 || this.tfVrAcresc.getDouble() > 0.0 || this.tfPercDesconto.getDouble() > 0.0 || this.tfPercAcresc.getDouble() > 0.0) {
            this.itemNFCe.setTipoDesconto(EnumConstNFCeTipoDesconto.DESCONTO_ACRESCIMO_ITEM.getValue());
        } else {
            this.itemNFCe.setTipoDesconto(EnumConstNFCeTipoDesconto.DESCONTO_ACRESCIMO_GERAL.getValue());
        }
        try {
            UtilNFCeCalculos.calcularValores(this.nfce);
            StaticObjects.setNfceAberta(this.nfce);
            this.closeDialog();
        }
        catch (ExceptionImpostoIcms | ExceptionImpostoIPI | ExceptionImpostoPisCofins ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void requestFocusOnOpen() {
        this.tfVrDesconto.requestFocus();
        this.tfVrDesconto.selectAll();
    }

    private void setPropsRadioButtons() {
        this.rbValorDesconto.setSelected(true);
        this.tfPercDesconto.setDisable(true);
        this.rbValorAcresc.setSelected(true);
        this.tfPercAcresc.setDisable(true);
        this.rbPercAcresc.setToggleGroup(this.toggleAcrescimo);
        this.rbValorAcresc.setToggleGroup(this.toggleAcrescimo);
        this.rbPercDesconto.setToggleGroup(this.toggleDesconto);
        this.rbValorDesconto.setToggleGroup(this.toggleDesconto);
        this.rbValorAcresc.setOnAction(evt -> {
            this.tfVrAcresc.setDisable(false);
            this.tfPercAcresc.setDisable(true);
            this.tfVrAcresc.selectAll();
        });
        this.rbPercAcresc.setOnAction(evt -> {
            this.tfPercAcresc.setDisable(false);
            this.tfVrAcresc.setDisable(true);
            this.tfPercAcresc.selectAll();
        });
        this.rbValorDesconto.setOnAction(evt -> {
            this.tfVrDesconto.setDisable(false);
            this.tfPercDesconto.setDisable(true);
            this.tfVrDesconto.selectAll();
        });
        this.rbPercDesconto.setOnAction(evt -> {
            this.tfPercDesconto.setDisable(false);
            this.tfVrDesconto.setDisable(true);
            this.tfPercDesconto.selectAll();
        });
    }

    @Override
    public void posInitialize() {
        Object item = this.getParams().get(ITEM);
        Object doc = this.getParams().get(DOC);
        if (item instanceof NFCeItem) {
            this.itemNFCe = (NFCeItem)item;
            this.nfce = (NFCe)doc;
        } else {
            this.itemPedido = (ItemPedido)item;
        }
        this.currentToScreen();
    }

    private void currentToScreen() {
        String produto = this.itemNFCe != null ? this.itemNFCe.getProduto().getNome() : this.itemPedido.getProduto().getNome();
        Double vrBruto = this.itemNFCe != null ? this.itemNFCe.getValorTotalBruto() : this.itemPedido.getValorTotalBruto();
        Double vrTotal = this.itemNFCe != null ? this.itemNFCe.getValorTotal() : this.itemPedido.getValorTotal();
        Double vrDesconto = this.itemNFCe != null ? this.itemNFCe.getValorDescontoInf() : this.itemPedido.getValorDesconto();
        Double percDesconto = this.itemNFCe != null ? this.itemNFCe.getPercentualDescontoInf() : this.itemPedido.getPercDesconto();
        Double vrAcrescimo = this.itemNFCe != null ? this.itemNFCe.getValorDespesasAcessoriasInf() : this.itemPedido.getValorDespesaAcessoria();
        Double percAcrescimo = this.itemNFCe != null ? this.itemNFCe.getPercentualDespAcessInf() : this.itemPedido.getPercDespesaAcessoria();
        Double vrDescontoPromo = this.itemNFCe != null ? this.itemNFCe.getValorDescontoPromocional() : this.itemPedido.getValorDescontoPromocional();
        this.tfProduto.setText(produto);
        this.tfVrBruto.setDouble(vrBruto);
        this.tfVrTotal.setDouble(vrTotal);
        this.tfDescontoPromocao.setDouble(vrDescontoPromo);
        this.tfPercDesconto.setDouble(percDesconto);
        this.tfVrDesconto.setDouble(vrDesconto);
        if (percDesconto != null && percDesconto != 0.0) {
            this.rbPercDesconto.setSelected(true);
            this.tfPercDesconto.setDisable(false);
            this.rbValorDesconto.setSelected(false);
            this.tfVrDesconto.setDisable(true);
        } else {
            this.rbValorDesconto.setSelected(true);
            this.tfVrDesconto.setDisable(false);
            this.rbPercDesconto.setSelected(false);
            this.tfPercDesconto.setDisable(true);
        }
        this.tfPercAcresc.setDouble(percAcrescimo);
        this.tfVrAcresc.setDouble(vrAcrescimo);
        if (percAcrescimo != null && percAcrescimo != 0.0) {
            this.rbPercAcresc.setSelected(true);
            this.tfPercAcresc.setDisable(false);
            this.rbValorAcresc.setSelected(false);
            this.tfVrAcresc.setDisable(true);
        } else {
            this.rbValorAcresc.setSelected(true);
            this.tfVrAcresc.setDisable(false);
            this.rbPercAcresc.setSelected(false);
            this.tfPercAcresc.setDisable(true);
        }
        this.tfVrDesconto.requestFocus();
        this.tfVrDesconto.selectAll();
    }

    private Boolean aplicarDesconto() {
        Short tipoDesconto = this.getTipoDesconto();
        if (this.rbPercDesconto.isSelected()) {
            return this.calcularValoresDesconto(tipoDesconto, this.tfPercDesconto.getDouble());
        }
        return this.calcularValoresDesconto(tipoDesconto, this.tfVrDesconto.getDouble());
    }

    private Boolean aplicarAcrescimo() {
        Short tipoAcresc = this.getTipoAcrescimo();
        if (this.rbPercAcresc.isSelected()) {
            return this.calcularValoresAcrescimo(tipoAcresc, this.tfPercAcresc.getDouble());
        }
        return this.calcularValoresAcrescimo(tipoAcresc, this.tfVrAcresc.getDouble());
    }

    private Boolean calcularValoresDesconto(Short percentualValor, Double valorPercentual) {
        if (percentualValor == 0) {
            if (valorPercentual <= 100.0) {
                Double valorDesconto = ToolFormatter.arrredondarNumero((Double)(valorPercentual / 100.0 * this.tfVrBruto.getDouble()), (int)2);
                if (this.itemPedido != null && ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getNaoPermitirDescontoAcimaTabela(), (Object)1)) {
                    Double percMin = ToolFormatter.arrredondarNumero((Double)(100.0 - this.itemPedido.getValorMinimo() * 100.0 / this.itemPedido.getValorUnitario()), (int)4);
                    if (valorPercentual > percMin) {
                        Alerts.showAlertError("O percentual de desconto informado (" + ToolFormatter.formataNumero((Number)valorPercentual, (int)2) + ") \u00e9 maior que o percentual dispon\u00edvel para este item (" + ToolFormatter.formataNumero((Number)percMin, (int)2) + ")");
                        this.tfVrDesconto.setDouble(0.0);
                        this.tfPercDesconto.setDouble(0.0);
                        return false;
                    }
                }
                this.tfVrDesconto.setDouble(valorDesconto);
                this.tfPercDesconto.setDouble(valorPercentual);
                this.tfVrTotal.setDouble(this.tfVrBruto.getDouble() + this.tfVrAcresc.getDouble() - this.tfVrDesconto.getDouble());
                this.tfTotalDesconto.setDouble(valorDesconto);
            }
        } else if (percentualValor == 1 && valorPercentual < this.tfVrBruto.getDouble()) {
            Double percDescontoCalc = 0.0;
            percDescontoCalc = valorPercentual > 0.0 ? ToolFormatter.arrredondarNumero((Double)(valorPercentual / this.tfVrBruto.getDouble() * 100.0), (int)4) : Double.valueOf(0.0);
            if (this.itemPedido != null && ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getNaoPermitirDescontoAcimaTabela(), (Object)1)) {
                Double percMin = ToolFormatter.arrredondarNumero((Double)(100.0 - this.itemPedido.getValorMinimo() * 100.0 / this.itemPedido.getValorUnitario()), (int)4);
                if (percDescontoCalc > percMin) {
                    Alerts.showAlertError("O percentual de desconto informado (" + ToolFormatter.formataNumero((Number)percDescontoCalc, (int)2) + ") \u00e9 maior que o percentual dispon\u00edvel para este item (" + ToolFormatter.formataNumero((Number)percMin, (int)2) + ")");
                    this.tfVrDesconto.setDouble(0.0);
                    this.tfPercDesconto.setDouble(0.0);
                    return false;
                }
            }
            this.tfVrDesconto.setDouble(valorPercentual);
            this.tfPercDesconto.setDouble(percDescontoCalc);
            this.tfVrTotal.setDouble(this.tfVrBruto.getDouble() + this.tfVrAcresc.getDouble() - this.tfVrDesconto.getDouble());
            this.tfTotalDesconto.setDouble(this.tfVrDesconto.getDouble());
        }
        return true;
    }

    private Boolean calcularValoresAcrescimo(Short percentualValor, Double valorPercentual) {
        if (percentualValor == 0) {
            Double valorAcrescimo = ToolFormatter.arrredondarNumero((Double)(valorPercentual / 100.0 * this.tfVrBruto.getDouble()), (int)2);
            this.tfVrAcresc.setDouble(valorAcrescimo);
            this.tfPercAcresc.setDouble(valorPercentual);
            this.tfVrTotal.setDouble(this.tfVrBruto.getDouble() + this.tfVrAcresc.getDouble() - this.tfVrDesconto.getDouble());
            this.tfTotalAcresc.setDouble(valorAcrescimo);
        } else if (percentualValor == 1) {
            Double percDescontoCalc = 0.0;
            percDescontoCalc = valorPercentual > 0.0 ? ToolFormatter.arrredondarNumero((Double)(valorPercentual / this.tfVrBruto.getDouble() * 100.0), (int)4) : Double.valueOf(0.0);
            this.tfVrAcresc.setDouble(valorPercentual);
            this.tfPercAcresc.setDouble(percDescontoCalc);
            this.tfVrTotal.setDouble(this.tfVrBruto.getDouble() + this.tfVrAcresc.getDouble() - this.tfVrDesconto.getDouble());
            this.tfTotalAcresc.setDouble(this.tfVrAcresc.getDouble());
        }
        return true;
    }

    private Short getTipoDesconto() {
        return this.rbPercDesconto.isSelected() ? (short)0 : 1;
    }

    private Short getTipoAcrescimo() {
        return this.rbPercAcresc.isSelected() ? (short)0 : 1;
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }
}

