/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.dialogs;

import com.touchcomp.touchnfce.BaseDialog;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.util.Callback;

public class DialogTable<T>
extends BaseDialog {
    public static final String ITENS = "itens";
    public static final String LABEL = "label";
    public static final String COLUNAS = "colunas";
    public static final String CLASSE = "classe";
    private TableView tableItens = new TableView();
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnCancelar;
    @FXML
    private Label lblDescricao;
    @FXML
    private AnchorPane body;
    @FXML
    private GridPane gridFields;
    private List<T> itens = new LinkedList<T>();
    private T selectedItem;
    private String label;
    private Class classe;
    private List<String> fieldsTable;
    private int status;

    @Override
    public void initializeController(ResourceBundle resources) {
        this.btnCancelar.setOnAction(evt -> {
            this.selectedItem = null;
            this.setStatus(1);
            this.closeDialog();
        });
        this.btnConfirmar.setOnAction(evt -> this.confirma());
        this.tableItens.setOnKeyPressed(evt -> {
            if (evt.getCode() != null) {
                switch (evt.getCode()) {
                    case ENTER: {
                        evt.consume();
                        this.confirma();
                        break;
                    }
                }
            }
        });
    }

    @Override
    public void posInitialize() {
        this.itens = (List)this.getParams().get(ITENS);
        this.label = (String)this.getParams().get(LABEL);
        this.fieldsTable = (List)this.getParams().get(COLUNAS);
        this.classe = (Class)this.getParams().get(CLASSE);
        if (this.itens != null && this.fieldsTable != null && this.classe != null) {
            this.createTable();
        }
        if (this.label != null) {
            this.lblDescricao.setText(this.label);
        }
    }

    @Override
    public void requestFocusOnOpen() {
    }

    private void confirma() {
        this.selectedItem = this.tableItens.getSelectionModel().getSelectedItem();
        this.setStatus(0);
        this.closeDialog();
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt != null) {
            switch (evt.getCode()) {
                case F12: {
                    this.confirma();
                    break;
                }
                case ESCAPE: {
                    this.setStatus(1);
                    this.closeDialog();
                    break;
                }
                case F10: {
                    this.setStatus(2);
                }
            }
        }
    }

    public T getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void eventAltControl(KeyEvent event) {
    }

    public void createTable() {
        for (String column : this.fieldsTable) {
            try {
                Field field = this.classe.getDeclaredField(column);
                Platform.runLater(() -> {
                    TableColumn c = new TableColumn(column.toUpperCase());
                    double totalWidth = this.tableItens.getWidth();
                    double percWidth = totalWidth / (double)this.fieldsTable.size();
                    if (field.getType().equals(Double.class) || field.getType().equals(Integer.class) || field.getType().equals(Long.class)) {
                        c.setStyle("-fx-alignment: TOP_RIGHT;");
                    }
                    c.setMinWidth(percWidth);
                    c.setMaxWidth(percWidth);
                    c.setCellValueFactory((Callback)new PropertyValueFactory(column));
                    this.tableItens.getColumns().add((Object)c);
                });
            }
            catch (NoSuchFieldException | SecurityException ex) {
                ex.printStackTrace();
                Logger.getLogger(DialogTable.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.getStage() != null) {
            this.getStage().setOnCloseRequest(event -> this.setStatus(2));
        }
        this.tableItens.setItems(FXCollections.observableArrayList(this.itens));
        this.gridFields.add((Node)this.tableItens, 1, 2);
        this.tableItens.requestFocus();
        this.tableItens.getSelectionModel().selectFirst();
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }
}

