/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.dialogs;

import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.components.TouchComboBox;
import com.touchcomp.touchnfce.controller.Alerts;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;

public class ReimpressaoFechamentoCaixa<T>
extends BaseDialog {
    public static final String ITENS = "itens";
    public static final String LABEL = "label";
    @FXML
    private Label descricao;
    @FXML
    private TouchComboBox<T> cmbItens;
    @FXML
    private Button btnRecalcular;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnCancelar;
    @FXML
    private AnchorPane body;
    private List<T> itens = new LinkedList<T>();
    private T selectedItem;
    private String label;
    private int status;

    @Override
    public void initializeController(ResourceBundle resources) {
        this.btnCancelar.setOnAction(evt -> {
            this.selectedItem = null;
            this.setStatus(1);
            this.closeDialog();
        });
        this.btnConfirmar.setOnAction(evt -> {
            this.setStatus(0);
            this.closeDialog();
        });
        this.btnRecalcular.setOnAction(evt -> this.recalcularFechamento());
        this.cmbItens.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                ReimpressaoFechamentoCaixa.this.selectedItem = newValue;
            }
        });
        this.cmbItens.setLabel(this.descricao);
    }

    @Override
    public void posInitialize() {
        this.itens = (List)this.getParams().get(ITENS);
        this.label = (String)this.getParams().get(LABEL);
        if (this.itens != null && !this.itens.isEmpty()) {
            this.cmbItens.setItems(FXCollections.observableArrayList(this.itens));
            this.cmbItens.getSelectionModel().select(this.itens.get(0));
        }
        this.descricao.setText(this.label);
    }

    @Override
    public void requestFocusOnOpen() {
        this.cmbItens.requestFocus();
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt != null) {
            switch (evt.getCode()) {
                case F12: {
                    this.setStatus(0);
                    this.closeDialog();
                    break;
                }
                case ESCAPE: {
                    this.selectedItem = null;
                    this.setStatus(1);
                    this.closeDialog();
                    break;
                }
                case F10: {
                    this.setStatus(2);
                    this.closeDialog();
                    break;
                }
                case ENTER: {
                    if (this.btnConfirmar.isFocused()) {
                        this.setStatus(0);
                        this.closeDialog();
                        break;
                    }
                    this.btnConfirmar.requestFocus();
                }
            }
        }
    }

    public T getSelectedItem() {
        return this.selectedItem;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public void eventAltControl(KeyEvent event) {
    }

    private void recalcularFechamento() {
        Alerts.showAlertInfo("Op\u00e7\u00e3o n\u00e3o dispon\u00edvel!");
    }
}

