/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.dialogs.dialogoutrasopcoes;

import br.com.caelum.stella.validation.CPFValidator;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.TouchComboBox;
import com.touchcomp.touchnfce.components.TouchMonetaryField;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.dialogs.dialogoutrasopcoes.model.TempDadosReceitaAgro;
import com.touchcomp.touchnfce.model.DadosRecAgrNFCe;
import com.touchcomp.touchnfce.model.DadosRecAgrPedido;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeTransp;
import com.touchcomp.touchnfce.model.Pedido;
import com.touchcomp.touchnfce.model.TipoFrete;
import com.touchcomp.touchnfce.model.Transportador;
import com.touchcomp.touchnfce.model.UnidadeFederativa;
import com.touchcomp.touchnfce.service.impl.ServiceTipoFrete;
import com.touchcomp.touchnfce.service.impl.ServiceTransportador;
import com.touchcomp.touchnfce.service.impl.ServiceUnidadeFederativa;
import com.touchcomp.touchnfce.utils.MaskField;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;

public class DialogOutrasOpcoes
extends BaseDialog {
    public static final String PEDIDO = "PEDIDO";
    @FXML
    private TouchTextField tfDataPrevSaida;
    @FXML
    private TouchTextField tfPlaca;
    @FXML
    private TouchTextField tfAntt;
    @FXML
    private TouchTextField txtObservacao;
    @FXML
    private TouchTextField tfCpfTecnicoReceita;
    @FXML
    private TouchTextField tfNumeroReceita;
    @FXML
    private TouchTextField tfIdentificadorReceita;
    @FXML
    private TouchMonetaryField tfVrFrete;
    @FXML
    private TabPane tabPaneOpcoes;
    @FXML
    private Tab tabAgro;
    @FXML
    private Tab tabDadosTransporte;
    @FXML
    private Label lblDataPrevSaida;
    @FXML
    private Label lblTransportador;
    @FXML
    private Label lblVrFrete;
    @FXML
    private Label lblTipoFrete;
    @FXML
    private Label lblPlaca;
    @FXML
    private Label lblAntt;
    @FXML
    private Label lblUF;
    @FXML
    private Label lblObservacao;
    @FXML
    private Label lblIdentificadorReceita;
    @FXML
    private Label lblNumeroReceita;
    @FXML
    private Label lblCpfTecnicoReceita;
    @FXML
    private Label lblTabelaReceitas;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnCancelar;
    @FXML
    private Button btnAdicionar;
    @FXML
    private Button btnRemover;
    @FXML
    private Button btnConfirmarRec;
    @FXML
    private Button btnCancelarRec;
    @FXML
    private AnchorPane body;
    @FXML
    private TableView<TempDadosReceitaAgro> tableReceitas;
    @FXML
    private TableColumn<TempDadosReceitaAgro, Long> columnId;
    @FXML
    private TableColumn<TempDadosReceitaAgro, String> columnNrReceita;
    @FXML
    private TableColumn<TempDadosReceitaAgro, String> columnCpfTecnico;
    @FXML
    private TouchComboBox<Transportador> cmbTransportador;
    @FXML
    private TouchComboBox<UnidadeFederativa> cmbUF;
    @FXML
    private TouchComboBox<TipoFrete> cmbTipoFrete;
    private String auxData;
    private SimpleDateFormat format;
    private Date dateInf;
    private NFCeTransp dadosTransporte;
    private boolean isPedido = false;

    @Override
    public void initializeController(ResourceBundle resources) {
        this.format = new SimpleDateFormat("dd/MM/yyyy");
        this.carregarTransportadores();
        ServiceTipoFrete serviceTipoFrete = Main.getBean(ServiceTipoFrete.class);
        this.cmbTipoFrete.setItems(FXCollections.observableArrayList(serviceTipoFrete.getAll()));
        ServiceUnidadeFederativa serviceUF = Main.getBean(ServiceUnidadeFederativa.class);
        this.cmbUF.setItems(FXCollections.observableArrayList(serviceUF.getAll()));
        this.cmbUF.getSelectionModel().select((Object)StaticObjects.getEmpresa().getPessoa().getEndereco().getCidade().getUf());
        this.setPropertieFieldDate();
        this.setActionsButtons();
        this.setPropertiesColumnsTable();
    }

    private void setActionsButtons() {
        this.btnConfirmar.setOnAction(evt -> this.confirmaDadosTransporte());
        this.btnCancelar.setOnAction(evt -> this.closeDialog());
        this.btnRemover.setOnAction(evt -> this.removerReceita());
        this.btnConfirmarRec.setOnAction(evt -> this.confirmaDadosReceitaAgro());
        this.btnAdicionar.setOnAction(evt -> this.adicionarReceita());
        this.btnCancelarRec.setOnAction(evt -> this.closeDialog());
    }

    private void setPropertiesColumnsTable() {
        this.tableReceitas.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_SUBSEQUENT_COLUMNS);
        this.columnId.setPrefWidth(100.0);
        this.columnNrReceita.setPrefWidth(80.0);
        this.columnCpfTecnico.setPrefWidth(80.0);
        this.columnId.setCellValueFactory((Callback)new PropertyValueFactory("identificador"));
        this.columnNrReceita.setCellValueFactory((Callback)new PropertyValueFactory("nrReceitaAgro"));
        this.columnCpfTecnico.setCellValueFactory((Callback)new PropertyValueFactory("cpfTecnicoReceita"));
    }

    private NFCe getNFCe() {
        return StaticObjects.getNfceAberta();
    }

    private Pedido getPedido() {
        return StaticObjects.getPedidoAberto();
    }

    @Override
    public void posInitialize() {
        this.isPedido = (Boolean)this.getParams().get(PEDIDO);
        this.objectToScreen();
    }

    private void desabilitaCamposPedido() {
        this.tfAntt.setDisable(true);
        this.lblAntt.setVisible(false);
        this.tfAntt.setVisible(false);
        this.tfPlaca.setDisable(true);
        this.lblPlaca.setVisible(false);
        this.tfPlaca.setVisible(false);
        this.tfVrFrete.setDisable(true);
        this.lblVrFrete.setVisible(false);
        this.tfVrFrete.setVisible(false);
        this.cmbUF.setDisable(true);
        this.lblUF.setVisible(false);
        this.cmbUF.setVisible(false);
        this.txtObservacao.setDisable(true);
        this.lblObservacao.setVisible(false);
        this.txtObservacao.setVisible(false);
    }

    private void removerReceita() {
        TempDadosReceitaAgro item = (TempDadosReceitaAgro)this.tableReceitas.getSelectionModel().getSelectedItem();
        if (item != null) {
            this.tableReceitas.getItems().remove((Object)item);
            this.tableReceitas.getSelectionModel().clearSelection();
            this.tableReceitas.refresh();
        }
    }

    private void adicionarReceita() {
        if (this.validarDadosReceita()) {
            TempDadosReceitaAgro receita = new TempDadosReceitaAgro();
            receita.setNrReceitaAgro(Long.valueOf(this.tfNumeroReceita.getText()));
            receita.setCpfTecnicoReceita(ToolString.refina((String)this.tfCpfTecnicoReceita.getText()));
            this.tableReceitas.getItems().add((Object)receita);
            this.tableReceitas.refresh();
            this.limparCamposReceita();
        }
    }

    private void limparCamposReceita() {
        this.tfIdentificadorReceita.clear();
        this.tfCpfTecnicoReceita.clear();
        this.tfNumeroReceita.clear();
        this.tfNumeroReceita.requestFocus();
    }

    private void objectToScreen() {
        if (this.isPedido) {
            this.desabilitaCamposPedido();
            if (this.getPedido() != null) {
                this.txtObservacao.setText(this.getPedido().getObservacao());
                this.cmbTransportador.getSelectionModel().select((Object)this.getPedido().getTransportador());
                this.cmbTipoFrete.getSelectionModel().select((Object)this.getPedido().getTipoFrete());
                this.tfVrFrete.setAmount(this.getPedido().getValorFrete());
                if (this.getPedido().getDataPrevisaoSaida() != null) {
                    this.tfDataPrevSaida.setText(ToolDate.dateToStr((Date)this.getPedido().getDataPrevisaoSaida(), (String)"dd/MM/yyyy"));
                }
                this.putDadosReceitaAgroPedido(this.getPedido());
            }
        } else if (this.getNFCe() != null) {
            if (this.getNFCe().getDadosTransporte() != null) {
                this.dadosTransporte = this.getNFCe().getDadosTransporte();
                this.txtObservacao.setText(this.getNFCe().getInfAdicManualNFCe());
                this.cmbUF.getSelectionModel().select((Object)this.getNFCe().getDadosTransporte().getUfVeiculo());
                if (this.cmbUF.getSelectionModel().getSelectedItem() == null) {
                    this.cmbUF.getSelectionModel().select((Object)StaticObjects.getEmpresa().getPessoa().getEndereco().getCidade().getUf());
                }
                this.cmbTransportador.getSelectionModel().select((Object)this.getNFCe().getDadosTransporte().getTransportador());
                this.cmbTipoFrete.getSelectionModel().select((Object)this.getNFCe().getDadosTransporte().getTipoFrete());
                this.tfVrFrete.setAmount(this.getNFCe().getDadosTransporte().getValorFrete());
                if (this.getNFCe().getDataPrevSaida() != null) {
                    this.tfDataPrevSaida.setText(ToolDate.dateToStr((Date)StaticObjects.getNfceAberta().getDataPrevSaida(), (String)"dd/MM/yyyy"));
                }
                this.tfAntt.setText(this.getNFCe().getDadosTransporte().getRegistroANTTVeiculo());
                this.tfPlaca.setText(this.getNFCe().getDadosTransporte().getPlacaVeiculo());
            }
            this.putDadosReceitaAgroNFCe(this.getNFCe());
        }
    }

    private void putDadosReceitaAgroNFCe(NFCe nfce) {
        if (ToolMethods.isWithData(nfce.getReceitasAgronomicas())) {
            for (DadosRecAgrNFCe data : nfce.getReceitasAgronomicas()) {
                this.tableReceitas.getItems().add((Object)new TempDadosReceitaAgro(data));
            }
            this.tableReceitas.refresh();
        }
    }

    private void putDadosReceitaAgroPedido(Pedido pedido) {
        if (ToolMethods.isWithData(pedido.getReceitasAgronomicas())) {
            for (DadosRecAgrPedido data : pedido.getReceitasAgronomicas()) {
                this.tableReceitas.getItems().add((Object)new TempDadosReceitaAgro(data));
            }
            this.tableReceitas.refresh();
        }
    }

    private boolean validarDadosReceita() {
        if (!ToolMethods.isStrWithData((String)this.tfNumeroReceita.getText())) {
            Alerts.showAlertError("Informe o n\u00famero da receita");
            return false;
        }
        if (!ToolString.isALongNumber((String)this.tfNumeroReceita.getText())) {
            Alerts.showAlertError("Informe um n\u00famero de receita v\u00e1lido");
            return false;
        }
        if (!ToolMethods.isStrWithData((String)this.tfCpfTecnicoReceita.getText())) {
            Alerts.showAlertError("Informe o CPF do t\u00e9cnico respons\u00e1vel pela receita");
            return false;
        }
        CPFValidator cpfValidator = new CPFValidator();
        try {
            cpfValidator.assertValid(ToolString.refina((String)this.tfCpfTecnicoReceita.getText()));
            return true;
        }
        catch (Exception e) {
            Alerts.showAlertError("CPF informado n\u00e3o \u00e9 v\u00e1lido");
            return false;
        }
    }

    private void confirmaDadosReceitaAgro() {
        if (!this.isPedido) {
            this.getNFCe().setReceitasAgronomicas(this.getReceitasAgroNFCe(this.getNFCe()));
            StaticObjects.refreshNFCe();
        } else {
            this.getPedido().setReceitasAgronomicas(this.getReceitasAgroPedido(this.getPedido()));
            StaticObjects.refreshPedido();
        }
        this.closeDialog();
    }

    private List<DadosRecAgrNFCe> getReceitasAgroNFCe(NFCe nfce) {
        ObservableList receitas = this.tableReceitas.getItems();
        LinkedList<DadosRecAgrNFCe> ret = new LinkedList<DadosRecAgrNFCe>();
        if (ToolMethods.isWithData((Collection)receitas)) {
            for (TempDadosReceitaAgro temp : receitas) {
                DadosRecAgrNFCe vo = new DadosRecAgrNFCe();
                vo.setCpfTecnicoReceita(temp.getCpfTecnicoReceita());
                vo.setIdentificador(temp.getIdentificador());
                vo.setNrReceitaAgro(temp.getNrReceitaAgro());
                vo.setNfce(nfce);
                ret.add(vo);
            }
        }
        return ret;
    }

    private List<DadosRecAgrPedido> getReceitasAgroPedido(Pedido pedido) {
        ObservableList receitas = this.tableReceitas.getItems();
        LinkedList<DadosRecAgrPedido> ret = new LinkedList<DadosRecAgrPedido>();
        if (ToolMethods.isWithData((Collection)receitas)) {
            for (TempDadosReceitaAgro temp : receitas) {
                DadosRecAgrPedido vo = new DadosRecAgrPedido();
                vo.setCpfTecnicoReceita(temp.getCpfTecnicoReceita());
                vo.setIdentificador(temp.getIdentificador());
                vo.setNrReceitaAgro(temp.getNrReceitaAgro());
                vo.setPedido(pedido);
                ret.add(vo);
            }
        }
        return ret;
    }

    private void confirmaDadosTransporte() {
        this.format.setLenient(false);
        try {
            if (StaticObjects.getNfceAberta() == null) {
                StaticObjects.setNfceAberta(UtilNFCe.createNFCeModelo65(null));
            }
            this.dateInf = ToolMethods.isStrWithData((String)this.tfDataPrevSaida.getText()) ? this.format.parse(this.tfDataPrevSaida.getText()) : null;
            if (!this.isPedido) {
                if (this.dateInf != null && ToolDate.dataSemHora((Date)this.dateInf).before(ToolDate.dataSemHora((Date)StaticObjects.getNfceAberta().getDataEmissao()))) {
                    Alerts.showAlertError("A data de previs\u00e3o de saida n\u00e3o pode ser menor que a data de emiss\u00e3o da nota!");
                    return;
                }
                if (!this.isValidBeforeDadosPlaca()) {
                    return;
                }
                this.getNFCe().setInfAdicManualNFCe(this.txtObservacao.getText());
                this.getNFCe().setDataPrevSaida(this.dateInf);
                this.dadosTransporte.setPlacaVeiculo(this.getPlaca());
                this.dadosTransporte.setRegistroANTTVeiculo(this.getANTT());
                this.dadosTransporte.setValorFrete(this.tfVrFrete.getAmount());
                if (this.cmbTransportador.getSelectionModel() != null && this.cmbTransportador.getSelectionModel().getSelectedItem() != null) {
                    this.dadosTransporte.setTransportador((Transportador)this.cmbTransportador.getSelectionModel().getSelectedItem());
                }
                if (this.cmbTipoFrete.getSelectionModel() != null && this.cmbTipoFrete.getSelectionModel().getSelectedItem() != null) {
                    this.dadosTransporte.setTipoFrete((TipoFrete)this.cmbTipoFrete.getSelectionModel().getSelectedItem());
                }
                if (this.cmbUF.getSelectionModel() != null && this.cmbUF.getSelectionModel().getSelectedItem() != null) {
                    this.dadosTransporte.setUfVeiculo((UnidadeFederativa)this.cmbUF.getSelectionModel().getSelectedItem());
                }
                this.getNFCe().setDadosTransporte(this.dadosTransporte);
                StaticObjects.refreshNFCe();
            } else {
                if (this.dateInf != null && ToolDate.dataSemHora((Date)this.dateInf).before(ToolDate.dataSemHora((Date)this.getPedido().getDataEmissao()))) {
                    Alerts.showAlertError("A data de previs\u00e3o de saida n\u00e3o pode ser menor que a data de emiss\u00e3o do pedido!");
                    return;
                }
                this.getPedido().setObservacao(this.txtObservacao.getText());
                this.getPedido().setDataPrevisaoSaida(this.dateInf);
                if (this.cmbTransportador.getSelectionModel() != null && this.cmbTransportador.getSelectionModel().getSelectedItem() != null) {
                    this.getPedido().setTransportador((Transportador)this.cmbTransportador.getSelectionModel().getSelectedItem());
                    this.getPedido().setValorFrete(this.tfVrFrete.getAmount());
                }
                if (this.cmbTipoFrete.getSelectionModel() != null && this.cmbTipoFrete.getSelectionModel().getSelectedItem() != null) {
                    this.getPedido().setTipoFrete((TipoFrete)this.cmbTipoFrete.getSelectionModel().getSelectedItem());
                }
                StaticObjects.refreshPedido();
            }
            this.closeDialog();
        }
        catch (ParseException e) {
            Alerts.showAlertError("Informe uma data e hora v\u00e1lida!");
        }
    }

    public String getPlaca() {
        String placa = this.tfPlaca.getText();
        placa = placa != null ? placa.toUpperCase() : null;
        return placa;
    }

    public String getANTT() {
        return this.tfAntt.getText();
    }

    private boolean isValidBeforeDadosPlaca() {
        boolean retValuePlaca;
        String placa = this.tfPlaca.getText();
        String antt = this.tfAntt.getText();
        boolean bl = retValuePlaca = placa != null && !placa.isEmpty();
        if (retValuePlaca) {
            if (placa.length() != 7) {
                Alerts.showAlertInfo("Placa deve possuir 7 digitos/caracteres.");
                this.tfPlaca.requestFocus();
                return false;
            }
            if (this.cmbUF.getSelectionModel().getSelectedItem() == null) {
                Alerts.showAlertInfo("Selecione uma UF.");
                this.cmbUF.requestFocus();
                return false;
            }
        }
        return true;
    }

    private void setPropertieFieldDate() {
        this.tfDataPrevSaida.lengthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (DialogOutrasOpcoes.this.tfDataPrevSaida.getText().length() <= 10) {
                    Platform.runLater(() -> {
                        String value = DialogOutrasOpcoes.this.tfDataPrevSaida.getText();
                        value = value.replaceAll("[^0-9]", "");
                        value = value.replaceFirst("(\\d{2})(\\d)", "$1/$2");
                        value = value.replaceFirst("(\\d{2})\\/(\\d{2})(\\d)", "$1/$2/$3");
                        DialogOutrasOpcoes.this.tfDataPrevSaida.setText(value);
                        DialogOutrasOpcoes.this.auxData = value;
                        MaskField.positionCaret(DialogOutrasOpcoes.this.tfDataPrevSaida);
                    });
                } else {
                    DialogOutrasOpcoes.this.tfDataPrevSaida.setText(DialogOutrasOpcoes.this.auxData);
                }
            }
        });
        this.tfDataPrevSaida.setLabel(this.lblDataPrevSaida);
        this.tfAntt.setLabel(this.lblAntt);
        this.tfPlaca.setLabel(this.lblPlaca);
        this.cmbTransportador.setLabel(this.lblTransportador);
        this.cmbTipoFrete.setLabel(this.lblTipoFrete);
        this.cmbUF.setLabel(this.lblUF);
        this.tfVrFrete.setLabel(this.lblVrFrete);
        this.txtObservacao.setLabel(this.lblObservacao);
        this.tfDataPrevSaida.setText(ToolDate.dateToStr((Date)new Date(), (String)"dd/MM/yyyy"));
        this.tfIdentificadorReceita.setLabel(this.lblIdentificadorReceita);
        this.tfNumeroReceita.setLabel(this.lblNumeroReceita);
        this.tfCpfTecnicoReceita.setLabel(this.lblCpfTecnicoReceita);
        this.tfIdentificadorReceita.setEditable(false);
        MaskField.cpfCnpjField(this.tfCpfTecnicoReceita);
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt == null) {
            return;
        }
        switch (evt.getCode()) {
            case F1: {
                this.tabPaneOpcoes.getSelectionModel().select((Object)this.tabDadosTransporte);
                break;
            }
            case F2: {
                this.tabPaneOpcoes.getSelectionModel().select((Object)this.tabAgro);
                break;
            }
            case ESCAPE: {
                this.closeDialog();
                break;
            }
            case F7: {
                this.tfNumeroReceita.requestFocus();
                break;
            }
            case F8: {
                this.tfCpfTecnicoReceita.requestFocus();
                break;
            }
            case F9: {
                this.tableReceitas.getSelectionModel().selectFirst();
                this.tableReceitas.requestFocus();
                break;
            }
            case F10: {
                this.adicionarReceita();
                break;
            }
            case F11: {
                this.removerReceita();
                break;
            }
            case F12: {
                if (this.tabPaneOpcoes.getSelectionModel().getSelectedItem() == this.tabDadosTransporte) {
                    this.confirmaDadosTransporte();
                    break;
                }
                this.confirmaDadosReceitaAgro();
                break;
            }
            case ENTER: {
                if (this.tabPaneOpcoes.getSelectionModel().getSelectedItem() == this.tabDadosTransporte) {
                    this.confirmaDadosTransporte();
                    break;
                }
                this.confirmaDadosReceitaAgro();
            }
        }
    }

    @Override
    public void requestFocusOnOpen() {
        this.tfDataPrevSaida.requestFocus();
    }

    @Override
    public void eventAltControl(KeyEvent event) {
    }

    private void carregarTransportadores() {
        ServiceTransportador service = Main.getBean(ServiceTransportador.class);
        List transportadores = service.getAll();
        ArrayList<Transportador> transportadoresAtivos = new ArrayList<Transportador>();
        for (Transportador t : transportadores) {
            if (t.getAtivo() != null && (!ToolMethods.isEquals((Object)t.getAtivo(), (Object)1) || !ToolMethods.isEquals((Object)t.getPessoa().getAtivo(), (Object)1))) continue;
            transportadoresAtivos.add(t);
        }
        this.cmbTransportador.setItems(FXCollections.observableArrayList(transportadoresAtivos));
    }
}

