/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.formapagamento.venda;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoPagNFe;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.AutoCompleteTextField;
import com.touchcomp.touchnfce.components.listener.FocusListener;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.cheque.LancamentoChequeController;
import com.touchcomp.touchnfce.controller.dialogs.DialogDoubleField;
import com.touchcomp.touchnfce.controller.formapagamento.TipoPagamentoConverter;
import com.touchcomp.touchnfce.controller.formapagamento.venda.GrupoFormaPagamentoNFCe;
import com.touchcomp.touchnfce.controller.titulo.TituloController;
import com.touchcomp.touchnfce.model.BandeiraTEF;
import com.touchcomp.touchnfce.model.ClienteNFCeMeioPagamento;
import com.touchcomp.touchnfce.model.CondicoesPagamento;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeChequeTerceiros;
import com.touchcomp.touchnfce.model.NFCeOpcoesCondPagamento;
import com.touchcomp.touchnfce.model.NFCePagamento;
import com.touchcomp.touchnfce.model.TipoPagamentoNFe;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import com.touchcomp.touchnfce.service.ServiceEntityAPI;
import com.touchcomp.touchnfce.service.impl.ServiceCondicoesPagamento;
import com.touchcomp.touchnfce.service.impl.ServiceTipoPagamentoNFe;
import com.touchcomp.touchnfce.utils.MaskField;
import com.touchcomp.touchnfce.utils.UtilClienteCondicoesPagamento;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import com.touchcomp.touchnfce.utils.UtilNFCeSerial;
import com.touchcomp.touchnfce.utils.UtilShowDialogTable;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

class AuxInformaPagamento
implements AutoCompleteTextField.ItemSelListener {
    NFCePagamento currentPagamento = null;
    AutoCompleteTextField txtOperacaoPagamento;
    private boolean processNextEvent = true;
    private KeyEvent lastEvent;
    ChangeListener onChangeListener;
    GrupoFormaPagamentoNFCe grupoFormas;
    TreeSet<TipoPagamentoConverter> tiposPagamentos = new TreeSet();
    PagamentoEstagio estagioPagamento = PagamentoEstagio.PAG_NAO_INICIADO;
    Label lblOpPagamento;

    AuxInformaPagamento(GrupoFormaPagamentoNFCe grupoFormas, AutoCompleteTextField txtOperacaoPagamento, Label lblOpPagamento) {
        this.txtOperacaoPagamento = txtOperacaoPagamento;
        this.grupoFormas = grupoFormas;
        this.lblOpPagamento = lblOpPagamento;
        this.initProperties();
    }

    public boolean isProcessNextEvent() {
        return this.processNextEvent;
    }

    private void initProperties() {
        this.txtOperacaoPagamento.setItemSelListener(this);
        this.setEventsTxtOpPagamento();
        this.txtOperacaoPagamento.addFocusListener(new FocusListener(){

            @Override
            public void onFocusGained() {
                if (AuxInformaPagamento.this.getEstagioPagamento() == PagamentoEstagio.PAG_NAO_INICIADO && AuxInformaPagamento.this.getValorFalta() > 0.0) {
                    AuxInformaPagamento.this.beforeSelecionaTpPagamento(true);
                }
            }

            @Override
            public void onFocusLost() {
            }
        });
        this.txtOperacaoPagamento.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                AuxInformaPagamento.this.trataEventosTextField(event);
            }
        });
        this.onChangeListener = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                String value = AuxInformaPagamento.this.txtOperacaoPagamento.getText();
                switch (AuxInformaPagamento.this.getEstagioPagamento().ordinal()) {
                    case 2: {
                        AuxInformaPagamento.this.maskIntegerField(value);
                        break;
                    }
                    case 4: {
                        AuxInformaPagamento.this.maskMonetaryField(value);
                        break;
                    }
                }
            }
        };
        this.txtOperacaoPagamento.lengthProperty().addListener(this.onChangeListener);
    }

    private void maskIntegerField(String value) {
        this.txtOperacaoPagamento.setAlignment(Pos.BASELINE_RIGHT);
        value = value.replaceAll("[^0-9]", "");
        this.txtOperacaoPagamento.setText(value);
    }

    private void maskMonetaryField(String value) {
        this.txtOperacaoPagamento.setAlignment(Pos.BASELINE_RIGHT);
        value = value.replaceAll("[^0-9]", "");
        value = value.replaceAll("([0-9]{1})([0-9]{14})$", "$1.$2");
        value = value.replaceAll("([0-9]{1})([0-9]{11})$", "$1.$2");
        value = value.replaceAll("([0-9]{1})([0-9]{8})$", "$1.$2");
        value = value.replaceAll("([0-9]{1})([0-9]{5})$", "$1.$2");
        value = value.replaceAll("([0-9]{1})([0-9]{2})$", "$1,$2");
        this.txtOperacaoPagamento.setText(value);
        MaskField.positionCaret(this.txtOperacaoPagamento);
    }

    public void setProcessNextEvent(boolean processNextEvent) {
        System.out.println("Setting Process Next Event " + processNextEvent);
        this.processNextEvent = processNextEvent;
    }

    private void setAcrescimoMarjoracaoCondicaoPagamento(CondicoesPagamento condicoesPagamento) {
        if (condicoesPagamento.getMajoracaoPreco() > 0.0) {
            this.grupoFormas.aplicaAcrescimoCondicaoPagamento(condicoesPagamento.getMajoracaoPreco());
        }
    }

    private String getDescricaoLabelPag(CondicoesPagamento c) {
        if (!UtilNFCe.permiteTroco(c, StaticObjects.getOpcoes())) {
            return "Informe um valor menor ou igual ao restante do pagamento";
        }
        return "Informe o valor do pagamento";
    }

    void beforeInformaParcelas() {
        if ((ToolMethods.isEquals((Object)this.getCurrentPagamento().getTipoPagamentoNFe().getCodigo(), (Object)EnumConstNFeTipoPagNFe.CREDITO_LOJA.getCodigo()) || ToolMethods.isEquals((Object)this.getCurrentPagamento().getTipoPagamentoNFe().getCodigo(), (Object)EnumConstNFeTipoPagNFe.BOLETO_BANCARIO.getCodigo())) && this.getCurrentPagamento().getCondicoesPagamento() != null) {
            this.getCurrentPagamento().setNumeroParcelas(this.getCurrentPagamento().getCondicoesPagamento().getNumeroParcelas().shortValue());
            this.beforeInformaCondicaoPagamento();
        } else {
            this.txtOperacaoPagamento.clear();
            if (this.getCurrentPagamento().getTipoPagamentoNFe().getNumeroParcelasFixas() != null && this.getCurrentPagamento().getTipoPagamentoNFe().getNumeroParcelasFixas() > 0) {
                this.getCurrentPagamento().setNumeroParcelas(this.getCurrentPagamento().getTipoPagamentoNFe().getNumeroParcelasFixas());
                this.beforeInformaCondicaoPagamento();
            } else {
                this.lblOpPagamento.setText("Selecione o Plano/Condi\u00e7\u00e3o de Pagamento: " + this.getCurrentPagamento().getTipoPagamentoNFe().getDescricao());
                this.setEstagioPagamento(PagamentoEstagio.PAG_SELECIONANDO_CONDICAO_PAG);
                if (StaticObjects.getNfceAberta().getCondicoesPagamento() != null && StaticObjects.getNfceAberta().getCondicoesPagamento().getNumeroParcelas() > 0) {
                    this.setEstagioPagamento(PagamentoEstagio.PAG_INFORMANDO_PARCELAS);
                    this.txtOperacaoPagamento.setText(StaticObjects.getNfceAberta().getCondicoesPagamento().getNumeroParcelas().toString());
                } else {
                    this.beforeInformaCondicaoPagamento();
                }
            }
            this.txtOperacaoPagamento.selectEndOfNextWord();
        }
    }

    void afterInformaParcelas() {
        if (this.getCurrentPagamento() == null || this.getCurrentPagamento().getTipoPagamentoNFe() == null) {
            return;
        }
        String text = ToolString.onlyNumbers((String)this.txtOperacaoPagamento.getText());
        if (text == null || text.length() == 0) {
            return;
        }
        this.getCurrentPagamento().setNumeroParcelas(new Short(text));
        this.beforeInformaCondicaoPagamento();
    }

    public void beforeSelecionaTpPagamento(TipoPagamentoNFe tpPag) {
        this.txtOperacaoPagamento.clear();
        this.getCurrentPagamento().setTipoPagamentoNFe(tpPag);
        this.beforeInformaParcelas();
    }

    void afterSelecionaTipoPagamento() {
        String text = ToolString.onlyNumbers((String)this.txtOperacaoPagamento.getText());
        if (text == null || text.length() == 0) {
            return;
        }
        Integer index = new Integer(text);
        Optional<TipoPagamentoConverter> sel = this.tiposPagamentos.stream().filter(i -> Objects.equals(i.getSequencia(), index)).findFirst();
        if (sel.isPresent()) {
            this.getCurrentPagamento().setTipoPagamentoNFe(sel.get().getTipoPagamentoNFe());
            this.beforeInformaParcelas();
        }
    }

    void beforeSelecionaTpPagamento(boolean showPop) {
        this.txtOperacaoPagamento.setAlignment(Pos.CENTER);
        this.txtOperacaoPagamento.clear();
        if (this.verificaSePodeRealizarPagamento(false)) {
            if (StaticObjects.getNfceAberta().getCondicoesPagamento() != null && StaticObjects.getNfceAberta().getPagamentos().isEmpty()) {
                this.getCurrentPagamento().setCondicoesPagamento(StaticObjects.getNfceAberta().getCondicoesPagamento());
                this.getCurrentPagamento().setMeioPagamento(this.getCurrentPagamento().getCondicoesPagamento().getMeioPagamento());
                this.getCurrentPagamento().setTipoPagamentoNFe(this.getCurrentPagamento().getCondicoesPagamento().getMeioPagamento().getTipoPagamentoNFe());
                this.getCurrentPagamento().setNumeroParcelas(this.getCurrentPagamento().getCondicoesPagamento().getNumeroParcelas().shortValue());
                this.beforeInformaParcelas();
                this.afterAdicionaCondPag(this.getCurrentPagamento().getCondicoesPagamento());
            } else {
                this.lblOpPagamento.setText("Selecione uma forma de pagamento");
                this.setEstagioPagamento(PagamentoEstagio.PAG_SELECIONANDO_TIPO_PAG);
                ServiceTipoPagamentoNFe serviceTipoPagamentoNFe = Main.getBean(ServiceTipoPagamentoNFe.class);
                List<TipoPagamentoNFe> tipos = UtilClienteCondicoesPagamento.getTiposPagamento(StaticObjects.getNfceAberta().getUnidadeFatCliente());
                this.tiposPagamentos = TipoPagamentoConverter.converterList(tipos);
                this.txtOperacaoPagamento.setItems(this.tiposPagamentos);
                if (this.txtOperacaoPagamento.isFocused() && this.txtOperacaoPagamento.getText() != null && this.txtOperacaoPagamento.getText().length() == 0 && showPop) {
                    this.txtOperacaoPagamento.showPopupAllItems();
                }
            }
        }
    }

    void afterAdicionaTpPagamento(TipoPagamentoConverter tp) {
        this.txtOperacaoPagamento.clear();
        this.getCurrentPagamento().setTipoPagamentoNFe(tp.getTipoPagamentoNFe());
        this.beforeInformaParcelas();
    }

    void beforeInformaCondicaoPagamento() {
        this.txtOperacaoPagamento.clear();
        this.lblOpPagamento.setText("Selecione o Plano/Condi\u00e7\u00e3o de Pagamento: " + this.getCurrentPagamento().getTipoPagamentoNFe().getDescricao());
        this.setEstagioPagamento(PagamentoEstagio.PAG_SELECIONANDO_CONDICAO_PAG);
        List<CondicoesPagamento> condicoes = ToolMethods.isWithData((Number)this.getCurrentPagamento().getNumeroParcelas()) ? UtilClienteCondicoesPagamento.getCondicaoPagamento(StaticObjects.getNfceAberta().getUnidadeFatCliente(), this.getCurrentPagamento().getTipoPagamentoNFe(), this.getCurrentPagamento().getNumeroParcelas()) : UtilClienteCondicoesPagamento.getCondicaoPagamento(StaticObjects.getNfceAberta().getUnidadeFatCliente(), this.getCurrentPagamento().getTipoPagamentoNFe());
        if (condicoes.isEmpty()) {
            Alerts.showAlertInfo("Nenhuma condi\u00e7\u00e3o de pagamento cadastrada em Op\u00e7\u00f5es NFCe para esta empresa!");
            return;
        }
        if (condicoes.size() == 1) {
            this.afterAdicionaCondPag(condicoes.get(0));
        } else {
            this.txtOperacaoPagamento.clear();
            this.txtOperacaoPagamento.setItems(new TreeSet<CondicoesPagamento>(condicoes));
            if (this.txtOperacaoPagamento.isFocused() && this.txtOperacaoPagamento.getText() != null && this.txtOperacaoPagamento.getText().length() == 0) {
                this.txtOperacaoPagamento.showPopupAllItems();
            }
            this.trataEnterMudancaAuto(false);
        }
    }

    void afterAdicionaCondPag(CondicoesPagamento cond) {
        this.getCurrentPagamento().setCondicoesPagamento(cond);
        this.getCurrentPagamento().setMeioPagamento(cond.getMeioPagamento());
        this.getCurrentPagamento().setTipoPagamentoNFe(cond.getMeioPagamento().getTipoPagamentoNFe());
        this.getCurrentPagamento().setNumeroParcelas(cond.getNumeroParcelas().shortValue());
        this.setAcrescimoMarjoracaoCondicaoPagamento(cond);
        this.beforeInformaValor();
    }

    void beforeInformaValor() {
        this.txtOperacaoPagamento.hidePopup();
        this.trataEnterMudancaAuto(false);
        this.txtOperacaoPagamento.clear();
        this.txtOperacaoPagamento.setAlignment(Pos.CENTER_RIGHT);
        this.setEstagioPagamento(PagamentoEstagio.PAG_INFORMANDO_VALOR);
        this.lblOpPagamento.setText("Informe o valor a ser pago: " + this.getCurrentPagamento().getTipoPagamentoNFe().getDescricao());
        if (!this.getCurrentPagamento().getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.DINHEIRO.getCodigo())) {
            this.txtOperacaoPagamento.setText(ToolFormatter.formataNumero((Number)this.getValorFalta(), (int)2));
        } else {
            this.txtOperacaoPagamento.clear();
        }
        this.txtOperacaoPagamento.selectAll();
        System.out.println("Before Informa valor " + this.processNextEvent);
    }

    private void setEventsTxtOpPagamento() {
    }

    void afterAdicionaPagamentoValor() {
        if (this.txtOperacaoPagamento.getText() == null || this.txtOperacaoPagamento.getText().length() == 0) {
            return;
        }
        try {
            DecimalFormat nf = new DecimalFormat("#,###.00");
            if (this.txtOperacaoPagamento.isEditable() && this.txtOperacaoPagamento.getText().isEmpty()) {
                Alerts.showAlertError("Erro", "Informe um valor v\u00e1lido!");
                return;
            }
            double value = ToolFormatter.arrredondarNumero((Double)nf.parse(this.txtOperacaoPagamento.getText()).doubleValue(), (int)2);
            if (value <= 0.0) {
                Alerts.showAlertError("Erro", "Informe um valor v\u00e1lido!");
                return;
            }
            if (value > 999999.0) {
                Alerts.showAlertError("Erro", "O valor n\u00e3o pode superar R$999.999,00");
                this.txtOperacaoPagamento.clear();
                return;
            }
            if (!UtilNFCe.permiteTroco(this.getCurrentPagamento().getTipoPagamentoNFe(), StaticObjects.getOpcoes()) && value > this.getValorFalta()) {
                Alerts.showAlertError("Erro", "Para esta forma de pagamento, o valor de pagamento n\u00e3o poder\u00e1 ser maior que o valor restante!");
                return;
            }
            this.getCurrentPagamento().setValor(value);
            this.getCurrentPagamento().setValorTroco(this.grupoFormas.getValorTroco(this.getCurrentPagamento()));
            this.getCurrentPagamento().setValorLiquido(this.getCurrentPagamento().getValor() - this.getCurrentPagamento().getValorTroco());
            this.beforeInformaOutrosDados();
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            Alerts.showAlertError("Dados inv\u00e1lidos.\n" + ex.getMessage());
            this.beforeInformaValor();
        }
    }

    void beforeInformaOutrosDados() {
        this.setEstagioPagamento(PagamentoEstagio.PAG_INFORMANDO_DADOS_ADICIONAIS);
        TipoPagamentoNFe tipoPagamento = this.getCurrentPagamento().getTipoPagamentoNFe();
        if (ToolMethods.isEquals((Object)tipoPagamento.getCodigo(), (Object)EnumConstNFeTipoPagNFe.BOLETO_BANCARIO.getCodigo())) {
            this.mostraTitulosParcelas();
        } else if (ToolMethods.isEquals((Object)tipoPagamento.getCodigo(), (Object)EnumConstNFeTipoPagNFe.CHEQUE.getCodigo())) {
            this.mostraLancaCheques();
        } else if (ToolMethods.isEquals((Object)tipoPagamento.getCodigo(), (Object)EnumConstNFeTipoPagNFe.CREDITO_LOJA.getCodigo())) {
            this.mostraTitulosParcelas();
        } else if (ToolMethods.isEquals((Object)tipoPagamento.getCodigo(), (Object)EnumConstNFeTipoPagNFe.DUPLICATA.getCodigo())) {
            this.mostraTitulosParcelas();
        } else if ((ToolMethods.isEquals((Object)tipoPagamento.getCodigo(), (Object)EnumConstNFeTipoPagNFe.CARTAO_CREDITO.getCodigo()) || ToolMethods.isEquals((Object)tipoPagamento.getCodigo(), (Object)EnumConstNFeTipoPagNFe.CARTAO_DEBITO.getCodigo()) || ToolMethods.isEquals((Object)tipoPagamento.getCodigo(), (Object)EnumConstNFeTipoPagNFe.VALE_REFEICAO.getCodigo()) || ToolMethods.isEquals((Object)tipoPagamento.getCodigo(), (Object)EnumConstNFeTipoPagNFe.VALE_COMBUSTIVEL.getCodigo()) || ToolMethods.isEquals((Object)tipoPagamento.getCodigo(), (Object)EnumConstNFeTipoPagNFe.VALE_ALIMENTACAO.getCodigo())) && ToolMethods.isEquals((Object)this.getCurrentPagamento().getCondicoesPagamento().getExibirBandeiraCartao(), (Object)1)) {
            this.mostraBandeiraCartao(tipoPagamento);
        } else {
            this.adicionaPagamento();
        }
    }

    private void mostraBandeiraCartao(TipoPagamentoNFe tipoPagamento) {
        BandeiraTEF bandeiraTEF = null;
        bandeiraTEF = ToolMethods.isEquals((Object)tipoPagamento.getCodigo(), (Object)EnumConstNFeTipoPagNFe.CARTAO_CREDITO.getCodigo()) ? UtilShowDialogTable.getBandeiraTEF((short)1) : UtilShowDialogTable.getBandeiraTEF((short)0);
        if (ToolMethods.isEquals((Object)bandeiraTEF, null)) {
            Alerts.showAlertInfo("Pagamento Cancelado!");
            return;
        }
        this.getCurrentPagamento().setBandeiraTEF(bandeiraTEF);
        this.adicionaPagamento();
    }

    private void mostraTitulosParcelas() {
        if (this.getNFCe().getUnidadeFatCliente() == null) {
            Alerts.showAlertInfo("Para este tipo de pagamento deve ser informado o Cliente da NFCe!");
            return;
        }
        HashMap<String, Serializable> h = new HashMap<String, Serializable>();
        h.put("vlrTitulos", this.getCurrentPagamento().getValor());
        h.put("nmrParcelas", this.getCurrentPagamento().getNumeroParcelas());
        h.put("nfcePagamento", this.getCurrentPagamento());
        h.put("nrDiasVencimento", this.getCurrentPagamento().getCondicoesPagamento().getNumeroDiasVencimento());
        TituloController tituloController = (TituloController)Main.get().showDialog(Controllers.TITULO_NFCE, h);
        if (tituloController.getTitulos() != null && !tituloController.getTitulos().isEmpty()) {
            this.getCurrentPagamento().setTitulos(tituloController.getTitulos());
            if (this.getCurrentPagamento().getTitulos() != null) {
                this.getCurrentPagamento().getTitulos().forEach(titulo -> titulo.setNfcePagamento(this.getCurrentPagamento()));
                this.adicionaPagamento();
            }
        } else {
            this.beforeSelecionaTpPagamento(true);
        }
    }

    void adicionaPagamento() {
        this.getCurrentPagamento().setNfce(this.getNFCe());
        this.getCurrentPagamento().setStatus((short)1);
        this.grupoFormas.atualizarNFCe(this.getCurrentPagamento());
        this.grupoFormas.atualizaCamposValores();
        this.grupoFormas.setFormasPagTable();
        this.currentPagamento = null;
        this.beforeSelecionaTpPagamento(true);
        GrupoFormaPagamentoNFCe.pagamentoEmAndamento = false;
        if (!this.verificaSePodeRealizarPagamento(false) && this.existeFormaTEF()) {
            this.grupoFormas.fecharDocumentoFiscal();
        }
    }

    public void trataEnterMudancaAuto(boolean processNextEvent) {
        this.setProcessNextEvent(processNextEvent);
    }

    boolean trataEventosTextField(KeyEvent evt) {
        if (evt.getCode() == KeyCode.ENTER) {
            System.out.println("Event Ocurred ENTER");
        }
        if (!this.isProcessNextEvent()) {
            this.setProcessNextEvent(true);
            return true;
        }
        if (!this.verificaSePodeRealizarPagamento(false)) {
            return false;
        }
        if (evt.getCode() == KeyCode.ENTER) {
            switch (this.getEstagioPagamento().ordinal()) {
                case 0: {
                    System.out.println("Pagamento nao iniciado.");
                    return false;
                }
                case 1: {
                    GrupoFormaPagamentoNFCe.pagamentoEmAndamento = true;
                    System.out.println("Pagamento seleciona Tipo Pagamento.");
                    this.afterSelecionaTipoPagamento();
                    return true;
                }
                case 2: {
                    GrupoFormaPagamentoNFCe.pagamentoEmAndamento = true;
                    this.afterInformaParcelas();
                    return true;
                }
                case 3: {
                    GrupoFormaPagamentoNFCe.pagamentoEmAndamento = true;
                    System.out.println("Pagamento seleciona Condicao Pagamento.");
                    return true;
                }
                case 4: {
                    GrupoFormaPagamentoNFCe.pagamentoEmAndamento = true;
                    System.out.println("Pagamento seleciona informa valor.");
                    this.afterAdicionaPagamentoValor();
                    return true;
                }
            }
        }
        return false;
    }

    boolean trataEventos(KeyEvent evt) {
        if (evt.getCode() == KeyCode.DOWN && this.getEstagioPagamento() == PagamentoEstagio.PAG_SELECIONANDO_TIPO_PAG && !this.txtOperacaoPagamento.popupIsShowing()) {
            this.txtOperacaoPagamento.showPopupAllItems();
        }
        if (evt.getCode() == KeyCode.ESCAPE && this.txtOperacaoPagamento.isFocused()) {
            if (this.txtOperacaoPagamento.popupIsShowing()) {
                this.txtOperacaoPagamento.getPopup().hide();
            } else if (this.getEstagioPagamento() == PagamentoEstagio.PAG_NAO_INICIADO || this.getEstagioPagamento() == PagamentoEstagio.PAG_SELECIONANDO_TIPO_PAG) {
                this.grupoFormas.goBack();
                this.lastEvent = null;
            }
            if (this.lastEvent != null && this.lastEvent.getCode() == evt.getCode()) {
                this.grupoFormas.goBack();
                this.lastEvent = null;
            }
            this.beforeSelecionaTpPagamento(false);
            this.lastEvent = evt;
            return true;
        }
        return false;
    }

    private boolean verificaSePodeRealizarPagamento(Boolean condManual) {
        if (this.getValorFalta() <= 0.0 && (this.txtOperacaoPagamento.isFocused() || condManual.booleanValue())) {
            this.txtOperacaoPagamento.setText("Pagamento conclu\u00eddo, finalize a emiss\u00e3o.");
            this.lblOpPagamento.setText("Pagamento conclu\u00eddo, finalize a emiss\u00e3o.");
            return false;
        }
        return true;
    }

    PagamentoEstagio getEstagioPagamento() {
        return this.estagioPagamento;
    }

    NFCePagamento getCurrentPagamento() {
        if (this.currentPagamento == null) {
            this.currentPagamento = new NFCePagamento();
            this.currentPagamento.setSerialForSinc(UtilNFCeSerial.getSerial(this.currentPagamento));
        }
        return this.currentPagamento;
    }

    public void onItemListener(Object data) {
        switch (this.getEstagioPagamento().ordinal()) {
            case 1: {
                TipoPagamentoConverter tp = (TipoPagamentoConverter)data;
                this.afterAdicionaTpPagamento(tp);
                break;
            }
            case 3: {
                CondicoesPagamento cond = (CondicoesPagamento)data;
                this.afterAdicionaCondPag(cond);
            }
        }
    }

    Double getValorFalta() {
        if (this.getNFCe() != null && this.grupoFormas != null) {
            return ToolFormatter.arrredondarNumero((Double)(this.getNFCe().getTotalizadores().getValorTotalNFe() - this.grupoFormas.getValorPago()), (int)2);
        }
        return 0.0;
    }

    void setEstagioPagamento(PagamentoEstagio estagioPagamento) {
        this.estagioPagamento = estagioPagamento;
    }

    NFCe getNFCe() {
        return StaticObjects.getNfceAberta();
    }

    private void mostraLancaCheques() {
        HashMap<String, Double> h = new HashMap<String, Double>();
        h.put("vlrCheques", this.getCurrentPagamento().getValor());
        LancamentoChequeController controller = (LancamentoChequeController)Main.get().showDialog(Controllers.LANCAMENTO_CHEQUES, h);
        List<NFCeChequeTerceiros> chequeTerceiros = controller.getChequesInformados();
        if (chequeTerceiros.isEmpty()) {
            this.beforeSelecionaTpPagamento(true);
        } else {
            chequeTerceiros.forEach(ch -> ch.setNfcePagamento(this.getCurrentPagamento()));
            this.getCurrentPagamento().setChequeTerceiros(chequeTerceiros);
            this.adicionaPagamento();
        }
    }

    public void informarCondicoesPagamento() {
        NFCe nfce = StaticObjects.getNfceAberta();
        CondicoesPagamento c = this.setCondicaoPagamento(nfce.getUnidadeFatCliente());
        if (c != null) {
            Double valor = this.getValorPagamentoCondManual(c);
            if (valor == null || valor <= 0.0) {
                return;
            }
            this.setAcrescimoMarjoracaoCondicaoPagamento(c);
            NFCePagamento n = new NFCePagamento();
            n.setSerialForSinc(UtilNFCeSerial.getSerial(n));
            n.setCondicoesPagamento(c);
            n.setMeioPagamento(c.getMeioPagamento());
            n.setStatus((short)1);
            n.setTipoPagamentoNFe(c.getMeioPagamento().getTipoPagamentoNFe());
            n.setNumeroParcelas(this.getNrParcelasTEFCondManual(c));
            n.setValor(valor);
            this.currentPagamento = n;
            nfce.setCondicoesPagamento(c);
            this.getCurrentPagamento().setValorTroco(this.grupoFormas.getValorTroco(this.getCurrentPagamento()));
            this.getCurrentPagamento().setValorLiquido(this.getCurrentPagamento().getValor() - this.getCurrentPagamento().getValorTroco());
            this.beforeInformaOutrosDados();
            this.verificaSePodeRealizarPagamento(true);
        }
    }

    private CondicoesPagamento setCondicaoPagamento(UnidadeFatCliente u) {
        ServiceEntityAPI service;
        List<Object> tiposPagamentos = new ArrayList();
        if (u != null && u.getCliente().getClienteNFCeMeioPagamento() != null && !u.getCliente().getClienteNFCeMeioPagamento().isEmpty()) {
            for (ClienteNFCeMeioPagamento m : u.getCliente().getClienteNFCeMeioPagamento()) {
                if (!m.getAtivo().equals((short)1)) continue;
                tiposPagamentos.add(m.getTipoPagamentoNFe());
            }
        }
        if (tiposPagamentos.isEmpty()) {
            service = Main.getBean(ServiceTipoPagamentoNFe.class);
            tiposPagamentos = service.getAll();
        }
        service = Main.getBean(ServiceCondicoesPagamento.class);
        List condicoesPagamento = service.getAll();
        ArrayList<CondicoesPagamento> condicoesPagamentoNew = new ArrayList<CondicoesPagamento>();
        for (TipoPagamentoNFe tipoPagamentoNFe : tiposPagamentos) {
            for (CondicoesPagamento c : condicoesPagamento) {
                if (c.getMeioPagamento() == null || c.getMeioPagamento().getTipoPagamentoNFe() == null || !c.getMeioPagamento().getTipoPagamentoNFe().equals(tipoPagamentoNFe)) continue;
                condicoesPagamentoNew.add(c);
            }
        }
        ArrayList<CondicoesPagamento> lista = new ArrayList<CondicoesPagamento>();
        for (NFCeOpcoesCondPagamento cond : StaticObjects.getOpcoes().getCondicoesPagamento()) {
            for (CondicoesPagamento condNew : condicoesPagamentoNew) {
                if (!ToolMethods.isEquals((Object)cond.getCondicoesPagamento(), (Object)condNew) || !ToolMethods.isEquals((Object)cond.getAtivo(), (Object)1)) continue;
                lista.add(cond.getCondicoesPagamento());
            }
        }
        if (!lista.isEmpty()) {
            return UtilShowDialogTable.getCondicaoPagamento(lista);
        }
        return null;
    }

    private Short getNrParcelasTEFCondManual(CondicoesPagamento c) {
        String nrParcelas;
        if (c.getMeioPagamento() == null) {
            return (short)1;
        }
        if (c.getMeioPagamento().getTipoPagamentoNFe().getCartaoDebCred().equals((short)1) && c.getMeioPagamento().getTipoPagamentoNFe().getCodigo().equalsIgnoreCase(EnumConstNFeTipoPagNFe.CARTAO_DEBITO.getCodigo())) {
            return (short)1;
        }
        if (c.getMeioPagamento().getTipoPagamentoNFe().getCartaoDebCred().equals((short)1) && c.getMeioPagamento().getTipoPagamentoNFe().getCodigo().equalsIgnoreCase(EnumConstNFeTipoPagNFe.CARTAO_CREDITO.getCodigo()) && (nrParcelas = Alerts.showAlertInput("Informe o n\u00famero de parcelas!")) != null) {
            Short nrParc = new Short(nrParcelas);
            return nrParc;
        }
        if (ToolMethods.isEquals((Object)c.getMeioPagamento().getTipoPagamentoNFe().getCodigo(), (Object)EnumConstNFeTipoPagNFe.CREDITO_LOJA.getCodigo()) || ToolMethods.isEquals((Object)c.getMeioPagamento().getTipoPagamentoNFe().getCodigo(), (Object)EnumConstNFeTipoPagNFe.BOLETO_BANCARIO.getCodigo())) {
            return c.getNumeroParcelas().shortValue();
        }
        return (short)1;
    }

    private Double getValorPagamentoCondManual(CondicoesPagamento c) {
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("label", this.getDescricaoLabelPag(c));
        h.put("valor", this.getValorFalta());
        DialogDoubleField d = (DialogDoubleField)Main.get().showDialog(Controllers.DIALOG_DOUBLE_FIELD, h);
        if (d.getValorInformado() != null && d.getValorInformado() > 0.0) {
            if (!UtilNFCe.permiteTroco(c.getMeioPagamento().getTipoPagamentoNFe(), StaticObjects.getOpcoes()) && d.getValorInformado() > this.getValorFalta()) {
                Alerts.showAlertInfo("Informe um valor menor ou igual ao restante que falta");
                return this.getValorPagamentoCondManual(c);
            }
            return d.getValorInformado();
        }
        return 0.0;
    }

    private boolean existeFormaTEF() {
        for (NFCePagamento pag : this.getNFCe().getPagamentos()) {
            if (!ToolMethods.isEquals((Object)pag.getStatus(), (Object)1) || pag.getNfcePagamentoCDC() == null) continue;
            return true;
        }
        return false;
    }

    static enum PagamentoEstagio {
        PAG_NAO_INICIADO,
        PAG_SELECIONANDO_TIPO_PAG,
        PAG_INFORMANDO_PARCELAS,
        PAG_SELECIONANDO_CONDICAO_PAG,
        PAG_INFORMANDO_VALOR,
        PAG_INFORMANDO_DADOS_ADICIONAIS;

    }
}

