/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.formapagamento.venda;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.condicoespagamento.EnumConstCondPagVistaPrazo;
import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoDesconto;
import com.touchcomp.basementor.constants.enums.tef.EnumTEFTipoTef;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoipi.ExceptionImpostoIPI;
import com.touchcomp.basementorexceptions.exceptions.impl.impostopiscofins.ExceptionImpostoPisCofins;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.formapagamento.GrupoFormaPagamento;
import com.touchcomp.touchnfce.controller.formapagamento.venda.AuxInformaPagamento;
import com.touchcomp.touchnfce.controller.splash.impl.SplashEnvioNFCe;
import com.touchcomp.touchnfce.controller.splash.impl.SplashEnvioNFCeEmail;
import com.touchcomp.touchnfce.controller.splash.impl.SplashPagamentoCartao;
import com.touchcomp.touchnfce.controller.splash.impl.SplashTEFPagamento;
import com.touchcomp.touchnfce.controller.venda.StyleChangingRowFactory;
import com.touchcomp.touchnfce.controller.vendedor.VendedorFechamentoController;
import com.touchcomp.touchnfce.exceptions.ExceptionClienteFinanceiro;
import com.touchcomp.touchnfce.exceptions.ExceptionSincronizacao;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCeOpcoesValidMeioPagamento;
import com.touchcomp.touchnfce.model.NFCePagamento;
import com.touchcomp.touchnfce.model.NFCeTitulo;
import com.touchcomp.touchnfce.model.TipoPagamentoNFe;
import com.touchcomp.touchnfce.sinc.receive.SincOthers;
import com.touchcomp.touchnfce.utils.MaskField;
import com.touchcomp.touchnfce.utils.UtilCliente;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import com.touchcomp.touchnfce.utils.UtilNFCeCalculos;
import com.touchcomp.touchnfce.utils.sitef.UtilSitefPagamento;
import com.touchcomp.touchnfce.utils.sitef.model.AuxFormaPagNFCe;
import com.touchcomp.touchnfce.utils.sitef.model.AuxPagamentoNFCe;
import com.touchcomp.touchnfce.utils.sitef.model.AuxTipoPagamentoNFCe;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.DoubleStream;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;

public class GrupoFormaPagamentoNFCe
extends GrupoFormaPagamento {
    private AuxInformaPagamento auxInformaPagamento;
    protected StyleChangingRowFactory<NFCePagamento> rowFactory = new StyleChangingRowFactory("table-row-cell-yellow");
    private boolean cancelaTransacao;
    private String texto = "";
    private String CABECALHO = "";
    private static String textoVisor = "";
    private Boolean stop;
    SplashPagamentoCartao splash;
    @FXML
    protected TableColumn<NFCePagamento, String> columnDescricao;
    @FXML
    protected TableColumn<NFCePagamento, String> columnValor;
    @FXML
    protected Label lblIcmsDesonerado;

    @Override
    protected void requestFocusOnOpen() {
        this.txtOperacaoPagamento.requestFocus();
    }

    private NFCe getNFCe() {
        return StaticObjects.getNfceAberta();
    }

    void setFormasPagTable() {
        this.columnDescricao.setCellValueFactory(cellData -> new SimpleStringProperty(((NFCePagamento)cellData.getValue()).getTipoPagamentoNFe().getDescricao()));
        this.columnValor.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCePagamento, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCePagamento, String> param) {
                return new SimpleObjectProperty((Object)MaskField.monetaryField(((NFCePagamento)param.getValue()).getValor()));
            }
        });
        if (this.getNFCe() != null) {
            this.tableFormasPag.setItems(FXCollections.observableArrayList(this.getNFCe().getPagamentos()));
        }
    }

    private void enviaNFCe() {
        this.vaiTelaSplashFechaNFCe();
    }

    private void vaiTelaSplashFechaNFCe() {
        this.calcularValores();
        if (!this.isValidBefore()) {
            return;
        }
        if (this.getNFCe().getUnidadeFatCliente() != null) {
            try {
                this.validarLimiteFinanceiro(this.getNFCe());
            }
            catch (ExceptionClienteFinanceiro | ExceptionSincronizacao exceptionClienteFinanceiro) {
                exceptionClienteFinanceiro.printStackTrace();
                Alerts.showAlertInfo(exceptionClienteFinanceiro.getMessage());
                return;
            }
        }
        SplashEnvioNFCe splashEnvioNFCe = new SplashEnvioNFCe();
        splashEnvioNFCe.show();
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKeyAux(KeyEvent evt) {
        switch (evt.getCode()) {
            case F8: {
                this.auxInformaPagamento.informarCondicoesPagamento();
                break;
            }
            case F1: {
                this.setTipoAcrescimo((short)0);
                this.verificaAplicacaoAcrescimo();
                break;
            }
            case F2: {
                this.setTipoAcrescimo((short)1);
                this.verificaAplicacaoAcrescimo();
                break;
            }
            case F3: {
                this.setTipoDesconto((short)0);
                this.verificaAplicacaoDesconto();
                break;
            }
            case F4: {
                this.setTipoDesconto((short)1);
                this.verificaAplicacaoDesconto();
                break;
            }
        }
    }

    @Override
    public void firstEscapeKey(KeyEvent evt) {
        this.cancelarPagamento();
    }

    private boolean isValidBefore() {
        NFCe nf = this.getNFCe();
        boolean ret = this.validate(nf.getPagamentos());
        if (!ret) {
            Alerts.showAlertInfo("Informe os pagamentos.");
            return false;
        }
        if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getBloquearVendaCfopRecVen(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            Boolean formaPagamento = false;
            for (NFCePagamento n : nf.getPagamentos()) {
                if (!ToolMethods.isEquals((Object)n.getStatus(), (Object)1) || !ToolMethods.isEquals((Object)n.getTipoPagamentoNFe().getCodigo(), (Object)"90")) continue;
                formaPagamento = true;
            }
            if (formaPagamento.booleanValue()) {
                for (NFCeItem item : nf.getItens()) {
                    if (!ToolMethods.isEquals((Object)item.getStatus(), (Object)1) || !ToolMethods.isEquals((Object)item.getCfop().getCfopReceitaVenda(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) continue;
                    Alerts.showAlertInfo("N\u00e3o pode utilizar Forma de Pagamento do tipo SEM PAGAMENTO para NFCe que cont\u00e9m itens cujo CFOP \u00e9 de Receita/Venda!");
                    return false;
                }
            }
        }
        if (this.exigeIdentificacao(this.getNFCe()) && this.getNFCe().getUnidadeFatCliente() == null) {
            Alerts.showAlertInfo("Voc\u00ea informou um pagamento que exige identifica\u00e7\u00e3o, logo deve identificar o cliente.");
            return false;
        }
        if (!this.validarExisteTrocoIndevido(nf)) {
            return false;
        }
        Double valorPago = this.getValorPago();
        Double valorNFCe = nf.getTotalizadores().getValorTotalNFe();
        boolean bl = ret = valorPago >= valorNFCe;
        if (!ret) {
            Alerts.showAlertInfo("O valor informado como pagamento \u00e9 menor que o valor da NFCe.");
            return false;
        }
        for (NFCePagamento pag : nf.getPagamentos()) {
            if (!ToolMethods.isEquals((Object)pag.getStatus(), (Object)1)) continue;
            Double valor = 0.0;
            Boolean achou = false;
            for (NFCeTitulo titulo : pag.getTitulos()) {
                valor = valor + titulo.getValor();
                achou = true;
            }
            valor = ToolFormatter.arrredondarNumero((Double)valor, (int)2);
            Double valorPag = ToolFormatter.arrredondarNumero((Double)pag.getValorLiquido(), (int)2);
            if (!achou.booleanValue() || ToolMethods.isEquals((Object)valor, (Object)valorPag)) continue;
            Alerts.showAlertInfo("O valor informado dos t\u00edtulos \u00e9 menor que o valor informado no pagamento.");
            return false;
        }
        return true;
    }

    private boolean validarExisteTrocoIndevido(NFCe nf) {
        for (NFCePagamento np : nf.getPagamentos()) {
            if (!ToolMethods.isAffirmative((Number)np.getStatus()) || UtilNFCe.permiteTroco(np.getTipoPagamentoNFe(), StaticObjects.getOpcoes()) || !ToolMethods.isWithData((Number)np.getValorTroco())) continue;
            Alerts.showAlertInfo("Voc\u00ea informou troco em uma condi\u00e7\u00e3o que n\u00e3o permite " + String.valueOf(np.getTipoPagamentoNFe()));
            return false;
        }
        return true;
    }

    private boolean exigeIdentificacao(NFCe nfCe) {
        for (NFCePagamento pag : nfCe.getPagamentos()) {
            if (!ToolMethods.isAffirmative((Number)pag.getStatus()) || !UtilNFCe.obrigaIdentificacao(pag.getTipoPagamentoNFe(), StaticObjects.getOpcoes())) continue;
            return true;
        }
        return false;
    }

    protected Double getValorPago() {
        DoubleStream st = this.getNFCe().getPagamentos().stream().mapToDouble(pg -> pg.getStatus() == 1 ? pg.getValor() : 0.0);
        return ToolFormatter.arrredondarNumero((Double)st.sum(), (int)2);
    }

    private void setActionsButtons() {
        this.btnPreferenciaTP1.setOnAction(event -> this.adicionaPagamento((TipoPagamentoNFe)this.btnPreferenciaTP1.getUserData()));
        this.btnPreferenciaTP2.setOnAction(event -> this.adicionaPagamento((TipoPagamentoNFe)this.btnPreferenciaTP2.getUserData()));
        this.btnPreferenciaTP3.setOnAction(event -> this.adicionaPagamento((TipoPagamentoNFe)this.btnPreferenciaTP3.getUserData()));
        this.btnPreferenciaTP4.setOnAction(event -> this.adicionaPagamento((TipoPagamentoNFe)this.btnPreferenciaTP4.getUserData()));
        this.btnCondicoesPagamento.setOnAction(event -> this.auxInformaPagamento.informarCondicoesPagamento());
    }

    protected Double getValorTroco(NFCePagamento pag) {
        Double res = 0.0;
        for (NFCePagamento pagamento : this.getNFCe().getPagamentos()) {
            if (pagamento.getStatus() != 1) continue;
            res = res + pagamento.getValor();
        }
        res = res + pag.getValor();
        return (res = Double.valueOf(res - this.getNFCe().getTotalizadores().getValorTotalNFe())) > 0.0 ? res : 0.0;
    }

    void atualizarNFCe(NFCePagamento pag) {
        boolean ret = this.gerarTEF(pag);
        if (ret) {
            this.getNFCe().getPagamentos().add(pag);
            this.refreshNFCe();
        }
    }

    boolean verificaMaximoPagamento() {
        double totPag = 0.0;
        for (NFCePagamento pagamento : this.getNFCe().getPagamentos()) {
            if (pagamento.getStatus() != 1) continue;
            totPag += pagamento.getValor().doubleValue();
        }
        if (totPag >= this.getNFCe().getTotalizadores().getValorTotalNFe()) {
            Alerts.showAlertInfo("Pagamento da NFCe j\u00e1 est\u00e1 conclu\u00eddo. Para adicionar mais um pagamento \u00e9 preciso remover um existente", "");
            return true;
        }
        return false;
    }

    void atualizaCamposValores() {
        this.tfTotalCompra.setDouble(this.getNFCe().getTotalizadores().getValorTotalNFe());
        Double res = 0.0;
        for (NFCePagamento pagamento : this.getNFCe().getPagamentos()) {
            if (pagamento.getStatus() != 1) continue;
            res = res + pagamento.getValor();
        }
        this.tfVlrRecebido.setDouble(res);
        this.tfTroco.setDouble(res - this.tfTotalCompra.getDouble());
        if (this.tfTroco.getDouble() > 0.0) {
            this.troco.setText("Troco");
        } else {
            this.troco.setText("Falta");
        }
        if (this.tfTroco.getDouble() >= 0.0) {
            this.tfTroco.setStyle("-fx-text-fill: #0000FF");
        } else {
            this.tfTroco.setStyle("-fx-text-fill: #FF0000");
        }
        this.tfTotalItens.setDouble(this.getNFCe().getTotalizadores().getValorTotalBruto());
        this.tfTotalCompra.setDouble(this.getNFCe().getTotalizadores().getValorTotalNFe());
        this.tfDesconto.setDouble(this.getNFCe().getTotalizadores().getValorTotalDesconto());
        this.tfAcrescimo.setDouble(this.getNFCe().getTotalizadores().getValorTotalDespAcessorias());
        Double totIcmsDeso = this.getNFCe().getItens().stream().mapToDouble(i -> ToolMethods.isAffirmative((Number)i.getStatus()) ? i.getIcms().getValorIcmsDesonerado() : 0.0).sum();
        if (totIcmsDeso > 0.0) {
            this.lblIcmsDesonerado.setVisible(true);
            this.lblIcmsDesonerado.setText("ICMS Desonerado: " + ToolFormatter.formataNumero((Number)totIcmsDeso, (int)2));
        } else {
            this.lblIcmsDesonerado.setVisible(false);
        }
    }

    private void refreshNFCe() {
        StaticObjects.refreshNFCe();
        this.setFormasPagTable();
    }

    private void adicionaPagamento(TipoPagamentoNFe tpPag) {
        if (!this.verificaMaximoPagamento() && this.isValidIniciaNovoPag()) {
            this.tableFormasPag.getSelectionModel().select(null);
            this.txtOperacaoPagamento.requestFocus();
            this.auxInformaPagamento.beforeSelecionaTpPagamento(tpPag);
        }
    }

    private void enviaNFCeEmail() {
        SplashEnvioNFCeEmail splashEnvioNFCe = new SplashEnvioNFCeEmail(this.getNFCe(), StaticObjects.getOpcoes());
        splashEnvioNFCe.show();
    }

    @Override
    public void removeDescontoAcrescimoNFCe() {
        for (NFCeItem i : this.getNFCe().getItens()) {
            i.setTipoDesconto(EnumConstNFCeTipoDesconto.SEM_DESCONTO_ACRESCIMO.getValue());
            i.setValorDescontoInf(0.0);
            i.setValorDespesasAcessoriasInf(0.0);
            i.setPercentualDescontoInf(0.0);
            i.setPercentualDespAcessInf(0.0);
        }
        this.getNFCe().getTotalizadores().setPercDescontoInf(0.0);
        this.getNFCe().getTotalizadores().setValorDescontoInf(0.0);
        this.getNFCe().getTotalizadores().setPercDespAcessInf(0.0);
        this.getNFCe().getTotalizadores().setValorDespAcessoriasInf(0.0);
        this.calcularValores();
        this.tfDesconto.setDouble(0.0);
        this.tfAcrescimo.setDouble(0.0);
    }

    private void aplicaDescontoInterno(Short tipoDesconto) {
        if (!this.isPagamentoFinalizado(true)) {
            return;
        }
        if (tipoDesconto == 0) {
            for (NFCeItem i : this.getNFCe().getItens()) {
                i.setTipoDesconto(EnumConstNFCeTipoDesconto.DESCONTO_ACRESCIMO_GERAL.getValue());
            }
            this.getNFCe().getTotalizadores().setPercDescontoInf(this.tfDesconto.getDouble());
            this.getNFCe().getTotalizadores().setPercValorDesconto((short)0);
            this.tfDesconto.setText(this.tfDesconto.getText());
            this.txtOperacaoPagamento.requestFocus();
        } else if (tipoDesconto == 1) {
            Double valorDescontoInf = this.tfDesconto.getDouble();
            Double valorDescontoItens = this.getValorDescontoItens(this.getNFCe());
            if (valorDescontoInf + valorDescontoItens > this.getNFCe().getTotalizadores().getValorTotalBruto()) {
                Alerts.showAlertError("N\u00e3o \u00e9 permitido conceder desconto acima do valor total dos itens da nota. \nValor desconto informado nos itens : " + ToolFormatter.formataNumero((Number)valorDescontoItens, (int)2) + " \nValor desconto informado no fechamento : " + ToolFormatter.formataNumero((Number)valorDescontoInf, (int)2));
                this.tfDesconto.setDouble(this.getNFCe().getTotalizadores().getValorTotalDesconto());
                return;
            }
            for (NFCeItem i : this.getNFCe().getItens()) {
                i.setTipoDesconto(EnumConstNFCeTipoDesconto.DESCONTO_ACRESCIMO_GERAL.getValue());
            }
            this.getNFCe().getTotalizadores().setValorDescontoInf(this.tfDesconto.getDouble());
            this.getNFCe().getTotalizadores().setPercValorDesconto((short)1);
            this.txtOperacaoPagamento.requestFocus();
        }
        this.calcularValores();
        this.atualizaCamposValores();
    }

    @Override
    public boolean isPagamentoFinalizado(boolean showMessage) {
        if (this.tfTotalCompra.getDouble() <= this.tfVlrRecebido.getDouble()) {
            if (showMessage) {
                Alerts.showAlertInfo("Documento est\u00e1 finalizado. Remova um ou mais pagamentos para dar desconto.");
            }
            return false;
        }
        return true;
    }

    private void calcularValores() {
        try {
            UtilNFCeCalculos.calcularValores(this.getNFCe());
        }
        catch (ExceptionImpostoPisCofins exceptionImpostoPisCofins) {
            exceptionImpostoPisCofins.printStackTrace();
        }
        catch (ExceptionImpostoIcms exceptionImpostoIcms) {
            exceptionImpostoIcms.printStackTrace();
        }
        catch (ExceptionImpostoIPI exceptionImpostoIcms) {
            exceptionImpostoIcms.printStackTrace();
        }
        this.atualizaCamposValores();
    }

    private void aplicaAcrescimoInterno(Short tipoAcrescimo) {
        if (!this.isPagamentoFinalizado(true)) {
            return;
        }
        if (tipoAcrescimo == 0) {
            this.getNFCe().getTotalizadores().setPercDespAcessInf(this.tfAcrescimo.getDouble());
            this.getNFCe().getTotalizadores().setPercValorDespAcess((short)0);
            this.tfAcrescimo.setText(this.tfAcrescimo.getText());
            this.txtOperacaoPagamento.requestFocus();
        } else if (tipoAcrescimo == 1) {
            this.getNFCe().getTotalizadores().setValorDespAcessoriasInf(this.tfAcrescimo.getDouble());
            this.getNFCe().getTotalizadores().setPercValorDespAcess((short)1);
            this.txtOperacaoPagamento.requestFocus();
        }
        this.calcularValores();
        this.atualizaCamposValores();
    }

    public void aplicaAcrescimoCondicaoPagamento(Double percMajoracao) {
        this.getNFCe().getTotalizadores().setPercDespAcessInf(percMajoracao);
        this.getNFCe().getTotalizadores().setPercValorDespAcess((short)0);
        this.calcularValores();
        this.tfAcrescimo.setDouble(this.getNFCe().getTotalizadores().getValorDespAcessoriasInf());
    }

    @Override
    public void setPropertiesTablePagamentos() {
        this.tableFormasPag.setRowFactory(this.rowFactory);
        this.tableFormasPag.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        if (this.getNFCe() != null) {
            for (int i = 0; i < this.getNFCe().getPagamentos().size(); ++i) {
                if (this.getNFCe().getPagamentos().get(i).getStatus() != 0) continue;
                this.rowFactory.getStyledRowIndices().add((Object)i);
            }
        }
    }

    @Override
    public void initialize() {
        this.setActionsButtons();
        this.calcularValores();
        this.setFormasPagTable();
        Platform.runLater(() -> {
            this.auxInformaPagamento = new AuxInformaPagamento(this, this.txtOperacaoPagamento, this.lblOpPagamento);
            this.auxInformaPagamento.beforeSelecionaTpPagamento(true);
            this.columnValor.setMaxWidth(300.0);
            this.columnValor.setMinWidth(200.0);
            this.columnValor.setStyle("-fx-alignment: BOTTOM_RIGHT;");
        });
    }

    @Override
    public void voltar() {
        this.refreshNFCe();
    }

    @Override
    public void aplicaDesconto(Short tipoDesconto) {
        this.aplicaDescontoInterno(tipoDesconto);
    }

    @Override
    public void aplicaAcrescimo(Short tipoAcrescimo) {
        this.aplicaAcrescimoInterno(tipoAcrescimo);
    }

    @Override
    public void enviaDocumentoFiscalEmail() {
        this.enviaNFCeEmail();
    }

    @Override
    public void fecharDocumentoFiscal() {
        this.enviaNFCe();
    }

    @Override
    public void removePagamento() {
        this.rowFactory.getStyledRowIndices().removeAll((Object[])new Integer[0]);
        NFCePagamento pagamento = (NFCePagamento)this.tableFormasPag.getSelectionModel().getSelectedItem();
        if (pagamento != null) {
            pagamento.setStatus((short)0);
            this.atualizaCamposValores();
            this.rowFactory.getStyledRowIndices().add((Object)this.tableFormasPag.getSelectionModel().getFocusedIndex());
            this.tableFormasPag.refresh();
            this.cancelarPagamentoCDC(pagamento);
            pagamento.getChequeTerceiros().clear();
            this.refreshNFCe();
            this.auxInformaPagamento.beforeSelecionaTpPagamento(true);
            this.txtOperacaoPagamento.requestFocus();
            this.reabrirCupomDesconto(pagamento);
        }
    }

    private void reabrirCupomDesconto(NFCePagamento pagamento) {
        try {
            if (pagamento != null && pagamento.getSerialForSincCupomDesconto() != null) {
                SincOthers.abrirCupomDesconto(pagamento.getSerialForSincCupomDesconto());
            }
        }
        catch (ExceptionSincronizacao e) {
            e.printStackTrace();
            Alerts.showAlertError(e.getMessage());
        }
    }

    private boolean gerarTEF(NFCePagamento pag) {
        if (pag != null) {
            if (!ToolMethods.isEquals((Object)StaticObjects.getNFCeCaixa().getTipoTEF(), (Object)EnumTEFTipoTef.TIPO_TEF_DEDICADO.getValue()) || ToolMethods.isEquals((Object)pag.getCondicoesPagamento().getNaoUtilizaTEF(), (Object)1)) {
                return true;
            }
            if (pag.getCondicoesPagamento().getMeioPagamento() != null && ToolMethods.isEquals((Object)pag.getCondicoesPagamento().getMeioPagamento().getTipoPagamentoNFe().getCartaoDebCred(), (Object)1) && (!ToolMethods.isEquals((Object)pag.getCondicoesPagamento().getMeioPagamento().getTipoPagamentoNFe().getCodigo(), (Object)"17") || ToolMethods.isEquals((Object)pag.getCondicoesPagamento().getMeioPagamento().getTipoPagamentoNFe().getCodigo(), (Object)"17") && ToolMethods.isEquals((Object)pag.getCondicoesPagamento().getUtilizaTEFPix(), (Object)1))) {
                AuxPagamentoNFCe aux = this.criarDadosTEF(pag);
                return this.splashTEF(aux);
            }
        }
        return true;
    }

    private AuxPagamentoNFCe criarDadosTEF(NFCePagamento pag) {
        TipoPagamentoNFe t = pag.getCondicoesPagamento().getMeioPagamento().getTipoPagamentoNFe();
        AuxTipoPagamentoNFCe auxTipo = new AuxTipoPagamentoNFCe();
        auxTipo.setCodigo(t.getCodigo());
        auxTipo.setDescricao(t.getDescricao());
        auxTipo.setIdentificador(t.getIdentificador());
        AuxFormaPagNFCe auxForma = new AuxFormaPagNFCe();
        auxForma.setDescricao(pag.getCondicoesPagamento().getNome());
        auxForma.setIdentificador(pag.getCondicoesPagamento().getIdentificador());
        auxForma.setTipoDebito((short)0);
        if (pag.getNumeroParcelas() == null || pag.getNumeroParcelas() <= 1) {
            auxForma.setTipoCredito((short)0);
        } else {
            auxForma.setTipoCredito((short)1);
        }
        auxForma.setNomeCondicaoPagamento(pag.getCondicoesPagamento().getNome());
        auxForma.setNumeroParcelas(pag.getNumeroParcelas().intValue());
        auxForma.setTipoPagamento(auxTipo);
        AuxPagamentoNFCe aux = new AuxPagamentoNFCe();
        aux.setTipoCartao((short)0);
        aux.setValor(pag.getValor());
        aux.setValorAcrescimo(0.0);
        aux.setValorDesconto(0.0);
        aux.setFormaPagNFCe(auxForma);
        aux.setNfcePagamento(pag);
        return aux;
    }

    private void cancelarPagamentoCDC(NFCePagamento n) {
        int retorno;
        NFCe nfce = n.getNfce();
        if (n.getNfcePagamentoCDC() != null && (retorno = new UtilSitefPagamento().finalizarTransacaoSiTef(0, n.getSerialForSinc(), nfce.getDataEmissao(), nfce.getDataEmissao())) == 0) {
            n.getNfcePagamentoCDC().setStatus((short)2);
            Alerts.showAlertInfo("Transa\u00e7\u00e3o de cart\u00e3o de cr\u00e9dito cancelada!");
        }
    }

    private boolean splashTEF(AuxPagamentoNFCe aux) {
        SplashTEFPagamento s = new SplashTEFPagamento(aux);
        s.showAndWait();
        return aux.getNfcePagamento() != null && aux.getNfcePagamento().getNfcePagamentoCDC() != null;
    }

    private void validarLimiteFinanceiro(NFCe nfce) throws ExceptionClienteFinanceiro, ExceptionSincronizacao {
        Double valor = 0.0;
        for (NFCePagamento inf : nfce.getPagamentos()) {
            if (!inf.getStatus().equals((short)1)) continue;
            TipoPagamentoNFe tipoPagamento = inf.getTipoPagamentoNFe();
            if (StaticObjects.getOpcoes().getMeiosPagamentoValid().size() > 0) {
                for (NFCeOpcoesValidMeioPagamento mp : StaticObjects.getOpcoes().getMeiosPagamentoValid()) {
                    if (!mp.getAtivo().equals((short)1) || !mp.getTipoPagamentoNFe().equals(tipoPagamento)) continue;
                    valor = valor + inf.getValorLiquido();
                }
                continue;
            }
            if (!inf.getCondicoesPagamento().getTpCondicao().equals(EnumConstCondPagVistaPrazo.PAGAMENTO_A_PRAZO.getValue())) continue;
            valor = valor + inf.getValorLiquido();
        }
        if (valor > 0.0) {
            try {
                UtilCliente.analiseCreditoCliente(this.getNFCe(), valor);
            }
            catch (InterruptedException | ExecutionException ex) {
                TLogger.get(UtilCliente.class).error((Throwable)ex);
                Alerts.showAlertInfo("Houve problemas ao consultar os dados do cliente");
            }
        } else {
            try {
                UtilCliente.consultarEDefinirLimiteCliente(this.getNFCe());
            }
            catch (ExceptionSincronizacao | InterruptedException | ExecutionException ex) {
                TLogger.get(UtilCliente.class).error((Throwable)ex);
                Alerts.showAlertInfo("Houve problemas ao consultar os dados do cliente");
            }
        }
    }

    private boolean isValidIniciaNovoPag() {
        return !this.auxInformaPagamento.getEstagioPagamento().equals((Object)AuxInformaPagamento.PagamentoEstagio.PAG_NAO_INICIADO);
    }

    private void cancelarPagamento() {
        if (!this.isPagamentoFinalizado(false)) {
            return;
        }
        Optional<ButtonType> resp = Alerts.showQuestion("Deseja realmente cancelar a forma de pagamento?");
        if (!resp.isPresent() || resp.get() != ButtonType.OK) {
            return;
        }
        if (this.auxInformaPagamento.currentPagamento == null) {
            return;
        }
        StaticObjects.getNfceAberta().setCondicoesPagamento(null);
        this.auxInformaPagamento.beforeSelecionaTpPagamento(true);
        this.txtOperacaoPagamento.requestFocus();
    }

    private void informaVendedor() {
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("representante", this.getNFCe().getRepresentante());
        h.put("lastPath", Controllers.VENDA);
        VendedorFechamentoController consumidorController = (VendedorFechamentoController)Main.get().showDialog(Controllers.VENDEDOR_FECHAMENTO, h);
        this.getNFCe().setRepresentante(consumidorController.getRepresentanteNFCe());
        StaticObjects.refreshNFCe();
    }

    private Double getValorDescontoItens(NFCe nfCe) {
        Double valorDescontoInf = 0.0;
        for (NFCeItem i : nfCe.getItens()) {
            if (!ToolMethods.isEquals((Object)i.getStatus(), (Object)1)) continue;
            valorDescontoInf = i.getValorDescontoInf();
        }
        return valorDescontoInf;
    }
}

