/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.item;

import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.autocomplete.AutoCompleteLazyLoad;
import com.touchcomp.touchnfce.components.autocomplete.impl.AutoCompleteLazyLoadCliente;
import com.touchcomp.touchnfce.components.table.impl.PaginationTableItens;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.BaseController;
import com.touchcomp.touchnfce.controller.venda.TempPesquisaClienteConverter;
import com.touchcomp.touchnfce.model.CentroEstoque;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import com.touchcomp.touchnfce.modeltemp.TempPesquisaProduto;
import com.touchcomp.touchnfce.modeltemp.TempSaldoProdutoByCentroEst;
import com.touchcomp.touchnfce.service.impl.ServiceCentroEstoque;
import com.touchcomp.touchnfce.service.impl.ServiceUnidadeFatCliente;
import com.touchcomp.touchnfce.utils.UtilConsultaSaldoEstoque;
import com.touchcomp.touchnfce.utils.UtilShowDialogTable;
import com.touchcomp.touchvomodel.vo.saldoestoque.DTOSaldoEstoqueGeral;
import impl.org.controlsfx.autocompletion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;

public class ConsultaItemController
extends BaseController
implements AutoCompleteLazyLoad.ItemSelLazyFilter,
AutoCompleteLazyLoad.ItemLazyFilter {
    @FXML
    private AnchorPane body;
    @FXML
    private PaginationTableItens tableItens;
    @FXML
    private Button btnVoltar;
    @FXML
    private Button btnSelecionarItem;
    @FXML
    private Button btnConsultaSaldoItem;
    @FXML
    private Button btnConsultaSaldoTodos;
    @FXML
    private Label lblProdutoF2;
    @FXML
    private Label lblTabela;
    @FXML
    private Label lblSaldo;
    @FXML
    private Label lblCliente;
    @FXML
    private AutoCompleteLazyLoadCliente tfCliente;
    private List<TempPesquisaProduto> filterElements = new LinkedList<TempPesquisaProduto>();
    AutoCompletionBinding<TempPesquisaProduto> autoCompletionBindingProduto;
    Set<TempPesquisaProduto> autoCompletions = new HashSet<TempPesquisaProduto>();
    SuggestionProvider<TempPesquisaProduto> providerProduto = SuggestionProvider.create(this.autoCompletions);
    public static final String CURRENT_PESQUISA_PROD = "pesquisa_prod";
    public static final String QTD_CURRENT_PESQUISA_PROD = "qtd_pesquisa_prod";
    public static final String UNIDADE_FAT_CLIENTE_INF_NFCE = "unidade_fat_cliente_inf_nfce";
    private Double qtdCurrentItem = 1.0;
    private TLogger logger = TLogger.get(ConsultaItemController.class);
    private TreeSet<TempPesquisaClienteConverter> clientes;
    private UnidadeFatCliente unidadeFatCliente;
    private Date last;
    private boolean flagFocusOnTxtProd;
    private UnidadeFatCliente unidadeFatClienteNFCe;

    @Override
    protected void initializeController(ResourceBundle rb) {
        this.btnVoltar.setOnAction(event -> this.goBack());
        this.btnSelecionarItem.setOnAction(event -> this.selecionaItem());
        this.btnConsultaSaldoItem.setOnAction(event -> {
            if (this.tableItens.getTable().getSelectionModel().getSelectedItem() != null) {
                this.consultaSaldoByItemAndShowCentroEstoque((TempPesquisaProduto)this.tableItens.getTable().getSelectionModel().getSelectedItem());
            }
        });
        this.btnConsultaSaldoTodos.setOnAction(event -> this.consultaSaldoAllItens());
        this.autoCompletionBindingProduto = TextFields.bindAutoCompletion((TextField)this.tableItens.getTfFilter(), this.providerProduto);
        this.autoCompletionBindingProduto.setVisibleRowCount(5);
        this.tfCliente.setItemSelListener(this);
        this.tfCliente.setLazyLoading(this);
        this.tfCliente.setLabel(this.lblCliente);
        this.tableItens.setPesquisaAutomatica(false);
        this.tableItens.getTfFilter().setOnKeyReleased(eh -> {
            if (eh.getCode() == KeyCode.ENTER) {
                this.tableItens.carregaRegistros(this.tableItens.getTfFilter().getText());
            }
        });
    }

    @Override
    protected void requestFocusOnOpen() {
        this.tfCliente.requestFocus();
    }

    @Override
    public void paramsData(Class<? extends BaseController> aClass, Map data) {
        if (data.get(QTD_CURRENT_PESQUISA_PROD) != null) {
            this.qtdCurrentItem = (Double)data.get(QTD_CURRENT_PESQUISA_PROD);
        }
        if (data.get(UNIDADE_FAT_CLIENTE_INF_NFCE) != null) {
            this.unidadeFatCliente = this.unidadeFatClienteNFCe = (UnidadeFatCliente)data.get(UNIDADE_FAT_CLIENTE_INF_NFCE);
            this.tfCliente.setText(this.unidadeFatCliente.toString());
            this.tableItens.setUnidadeFatCliente(this.unidadeFatCliente);
            this.tableItens.getTfFilter().requestFocus();
        }
    }

    private void selecionaItem() {
        TempPesquisaProduto selected = (TempPesquisaProduto)this.tableItens.getTable().getSelectionModel().getSelectedItem();
        if (selected != null) {
            if (this.unidadeFatCliente != null && this.unidadeFatClienteNFCe == null) {
                Alerts.showAlertError("Informe o cliente na nota, antes de selecionar o produto com condi\u00e7\u00e3o espec\u00edfica para cliente!");
                return;
            }
            if (this.unidadeFatCliente == null && this.unidadeFatClienteNFCe != null) {
                Alerts.showAlertError("Informe o cliente que foi informado na nota. Cliente: " + this.unidadeFatClienteNFCe.toString());
                return;
            }
            if (this.unidadeFatCliente != null && this.unidadeFatClienteNFCe != null && !ToolMethods.isEquals((Object)this.unidadeFatCliente, (Object)this.unidadeFatClienteNFCe)) {
                Alerts.showAlertError("O cliente informado na nota est\u00e1 diferente do cliente informado para busca de pre\u00e7o!");
                return;
            }
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put(CURRENT_PESQUISA_PROD, selected);
            h.put(QTD_CURRENT_PESQUISA_PROD, this.qtdCurrentItem);
            this.goBack(h);
        } else {
            Alerts.showAlertError("Selecione um item da tabela para continuar");
        }
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKey(KeyEvent evt) {
        switch (evt.getCode()) {
            case DOWN: {
                if (!this.tableItens.getTfFilter().isFocused()) break;
                this.tableItens.getTable().requestFocus();
                this.tableItens.getTable().getSelectionModel().selectFirst();
                break;
            }
            case ESCAPE: {
                this.goBack();
                break;
            }
            case F1: {
                if (this.tableItens.getTable().getSelectionModel().getSelectedItem() == null) break;
                this.consultaSaldoByItemAndShowCentroEstoque((TempPesquisaProduto)this.tableItens.getTable().getSelectionModel().getSelectedItem());
                break;
            }
            case F12: {
                this.selecionaItem();
                break;
            }
            case F2: {
                this.tableItens.getTfFilter().requestFocus();
                break;
            }
            case F3: {
                this.tableItens.requestFocus();
                this.tableItens.getTable().getSelectionModel().selectFirst();
                break;
            }
            case F4: {
                this.consultaSaldoAllItens();
                break;
            }
            case F8: {
                this.tableItens.proximo();
                break;
            }
            case ENTER: {
                break;
            }
        }
    }

    private void consultaSaldoByItemAndShowCentroEstoque(TempPesquisaProduto temp) {
        List<DTOSaldoEstoqueGeral> list = this.consultaSaldoByItem(temp);
        ArrayList<DTOSaldoEstoqueGeral> novaLista = new ArrayList<DTOSaldoEstoqueGeral>();
        for (DTOSaldoEstoqueGeral dto : list) {
            if (!ToolMethods.isEquals((Object)dto.getCentroEstoqueIdentificador(), (Object)StaticObjects.getOpcoes().getCentroEstoque().getIdentificador())) continue;
            novaLista.add(dto);
        }
        if (!novaLista.isEmpty()) {
            UtilShowDialogTable.showSaldoEstoqueGeralByCentroEstoque(this.convertInTempSaldoCentroEst(novaLista));
        }
    }

    private List<DTOSaldoEstoqueGeral> consultaSaldoByItem(TempPesquisaProduto temp) {
        List<DTOSaldoEstoqueGeral> result = new ArrayList<DTOSaldoEstoqueGeral>();
        if (temp == null) {
            return result;
        }
        result = UtilConsultaSaldoEstoque.findSaldoIdGradeCorLista(temp.getIdProduto(), temp.getIdProduto(), StaticObjects.getEmpresa().getIdentificador(), StaticObjects.getEmpresa().getIdentificador());
        if (!result.isEmpty()) {
            Double qtd = 0.0;
            for (DTOSaldoEstoqueGeral dto : result) {
                qtd = qtd + dto.getQuantidade();
            }
            temp.setSaldoQuantitativo(qtd);
        }
        return result;
    }

    private void consultaSaldoAllItens() {
        ObservableList list = this.tableItens.getTable().getItems();
        if (list == null || list.isEmpty()) {
            return;
        }
        new Thread((List)list){
            final /* synthetic */ List val$list;
            {
                this.val$list = list;
            }

            @Override
            public void run() {
                for (TempPesquisaProduto t : this.val$list) {
                    List<DTOSaldoEstoqueGeral> result = UtilConsultaSaldoEstoque.findSaldoIdGradeCorLista(t.getIdProduto(), t.getIdProduto(), StaticObjects.getEmpresa().getIdentificador(), StaticObjects.getEmpresa().getIdentificador());
                    if (!result.isEmpty()) {
                        Double qtd = 0.0;
                        for (DTOSaldoEstoqueGeral dto : result) {
                            if (!ToolMethods.isEquals((Object)dto.getCentroEstoqueIdentificador(), (Object)StaticObjects.getOpcoes().getCentroEstoque().getIdentificador())) continue;
                            qtd = qtd + dto.getQuantidade();
                        }
                        t.setSaldoQuantitativo(qtd);
                    }
                    ConsultaItemController.this.tableItens.getTable().refresh();
                }
            }
        }.start();
    }

    private List<TempSaldoProdutoByCentroEst> convertInTempSaldoCentroEst(List<DTOSaldoEstoqueGeral> list) {
        ArrayList<TempSaldoProdutoByCentroEst> aux = new ArrayList<TempSaldoProdutoByCentroEst>();
        for (DTOSaldoEstoqueGeral d : list) {
            aux.add(new TempSaldoProdutoByCentroEst(d.getQuantidade(), this.getCentroEstoque(d.getCentroEstoqueIdentificador())));
        }
        return aux;
    }

    private String getCentroEstoque(Long centroEstoqueIdentificador) {
        Object str = "";
        ServiceCentroEstoque serviceCentroEstoque = Main.getBean(ServiceCentroEstoque.class);
        CentroEstoque ce = (CentroEstoque)serviceCentroEstoque.get(centroEstoqueIdentificador);
        if (ce != null) {
            str = ce.getIdentificador() + " - " + ce.getDescricao();
        }
        return str;
    }

    public void onItemListener(Object data) {
        try {
            TempPesquisaClienteConverter aux = (TempPesquisaClienteConverter)data;
            if (aux != null) {
                this.unidadeFatCliente = aux.getTempPesqProd();
                this.tfCliente.setText(this.unidadeFatCliente.toString());
                this.tableItens.setUnidadeFatCliente(this.unidadeFatCliente);
                this.tableItens.getTfFilter().requestFocus();
            } else {
                this.unidadeFatCliente = null;
                this.clearItens();
            }
            this.clearItens();
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
            Alerts.showAlertError("Ocorreu um erro: " + ex.getMessage());
        }
    }

    private void clearItens() {
        this.tableItens.getTfFilter().clear();
        this.tableItens.getTable().getItems().clear();
        this.tableItens.getTable().refresh();
    }

    @Override
    public SortedSet loadingMoreItems(String text, int page, int registrosPorCarregamento) {
        try {
            ServiceUnidadeFatCliente service = Main.getBean(ServiceUnidadeFatCliente.class);
            List<UnidadeFatCliente> temp = service.searchUnidadeFatCliente(text, registrosPorCarregamento, page);
            TreeSet<TempPesquisaClienteConverter> items = TempPesquisaClienteConverter.converterList(temp);
            return items;
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
            Alerts.showAlertInfo("Erro ao carregar os clientes: " + ex.getMessage());
            return null;
        }
    }
}

