/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.item;

import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.TouchTextArea;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.components.table.converter.MoneyStringConverter;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.BaseController;
import com.touchcomp.touchnfce.controller.splash.impl.SplashEnvioControleEntrega;
import com.touchcomp.touchnfce.model.ControleEntregaNotaPropria;
import com.touchcomp.touchnfce.model.ItemControleEntregaNotaPropria;
import com.touchcomp.touchnfce.model.ItemPedido;
import com.touchcomp.touchnfce.utils.MaskField;
import com.touchcomp.touchnfce.utils.UtilNFCeSerial;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.Text;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class ControleEntregaItensController
extends BaseController {
    @FXML
    private AnchorPane body;
    @FXML
    private TableView<ItemControleEntregaNotaPropria> tableItens;
    @FXML
    private TouchTextField tfItem;
    @FXML
    private TouchTextField tfDataEntrega;
    @FXML
    private TouchTextArea txtObservacao;
    @FXML
    private TableColumn<ItemControleEntregaNotaPropria, String> columnCodAux;
    @FXML
    private TableColumn<ItemControleEntregaNotaPropria, String> columnProduto;
    @FXML
    private TableColumn<ItemControleEntregaNotaPropria, String> columnQtdTotal;
    @FXML
    private TableColumn<ItemControleEntregaNotaPropria, Double> columnQtdEntregue;
    @FXML
    private Button btnEntregarTodoPed;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnEditQtdEntrega;
    @FXML
    private Button btnVoltar;
    @FXML
    private Button btnEditObservacao;
    @FXML
    private Label lblItem;
    @FXML
    private Label lblDica;
    @FXML
    private Label lblDataEntrega;
    private ControleEntregaNotaPropria controleEntrega;
    public static String CONTROLE_ENTREGA = "controle_entrega";
    List<ItemControleEntregaNotaPropria> itensTable;

    @Override
    public void initializeController(ResourceBundle rb) {
        this.itensTable = new LinkedList<ItemControleEntregaNotaPropria>();
        Main.get().getHeaderController().setTextHeader("");
        this.initColumnsTable();
        this.initTextAndButtons();
    }

    private void initTextAndButtons() {
        this.btnConfirmar.setOnAction(event -> this.confirma());
        this.btnVoltar.setOnAction(event -> this.cancelaOperacao());
        this.btnEntregarTodoPed.setOnAction(event -> this.marcarTodos());
        this.btnEditObservacao.setOnAction(event -> this.txtObservacao.requestFocus());
        this.btnEditQtdEntrega.setOnAction(event -> this.editQtdItem());
        this.tfItem.setLabel(this.lblItem);
        this.tfDataEntrega.setLabel(this.lblDataEntrega);
        MaskField.dateField(this.tfDataEntrega);
        this.tfItem.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && !newValue.isEmpty()) {
                LinkedList<ItemControleEntregaNotaPropria> itens = new LinkedList<ItemControleEntregaNotaPropria>();
                for (ItemControleEntregaNotaPropria it : this.controleEntrega.getItemControleEntregaNotaPropria()) {
                    if (!it.getItemPedido().getProduto().getNome().toLowerCase().contains(newValue.toLowerCase()) && !it.getItemPedido().getProduto().getNomeAuxiliar().toLowerCase().contains(newValue.toLowerCase())) continue;
                    itens.add(it);
                }
                this.itensTable = itens;
                Platform.runLater(() -> this.iniciaTabela());
            }
        });
    }

    private void editQtdItem() {
        Integer row = this.tableItens.getSelectionModel().getSelectedIndex();
        this.tableItens.edit(row.intValue(), this.columnQtdEntregue);
    }

    private void marcarTodos() {
        for (ItemControleEntregaNotaPropria it : this.itensTable) {
            it.setQuantidadeEntregue(it.getItemPedido().getQuantidadeTotal());
        }
        Platform.runLater(() -> this.iniciaTabela());
    }

    private void initColumnsTable() {
        this.tableItens.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.columnQtdEntregue.setOnEditCommit(value -> {
            if (value.getNewValue() != null) {
                List<ItemControleEntregaNotaPropria> itensCont = this.controleEntrega.getItemControleEntregaNotaPropria();
                if ((Double)value.getNewValue() < 0.0) {
                    Alerts.showAlertError("Informe uma quantidade v\u00e1lida para o item " + itensCont.get(this.tableItens.getSelectionModel().getFocusedIndex()).getItemPedido().getProduto().getNome());
                    return;
                }
                if ((Double)value.getNewValue() > itensCont.get(this.tableItens.getSelectionModel().getFocusedIndex()).getItemPedido().getQuantidadeTotal()) {
                    Alerts.showAlertError("Quantidade entregue deve ser igual ou inferior a quantidade total d o item " + itensCont.get(this.tableItens.getSelectionModel().getFocusedIndex()).getItemPedido().getProduto().getNome());
                    return;
                }
                itensCont.get(this.tableItens.getSelectionModel().getFocusedIndex()).setQuantidadeEntregue((Double)value.getNewValue());
            }
        });
        Platform.runLater(() -> {
            Double totalWidth = this.tableItens.getWidth();
            this.columnCodAux.setMinWidth(totalWidth * 15.0 / 100.0);
            this.columnCodAux.setMaxWidth(totalWidth * 15.0 / 100.0);
            this.columnProduto.setMinWidth(totalWidth * 45.0 / 100.0);
            this.columnCodAux.setMaxWidth(totalWidth * 45.0 / 100.0);
            this.columnQtdTotal.setMinWidth(totalWidth * 20.0 / 100.0);
            this.columnQtdTotal.setMaxWidth(totalWidth * 20.0 / 100.0);
            this.columnQtdEntregue.setMinWidth(totalWidth * 20.0 / 100.0);
            this.columnQtdEntregue.setMaxWidth(totalWidth * 20.0 / 100.0);
        });
    }

    private void iniciaTabela() {
        this.columnProduto.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ItemControleEntregaNotaPropria, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ItemControleEntregaNotaPropria, String> param) {
                return new SimpleObjectProperty((Object)((ItemControleEntregaNotaPropria)param.getValue()).getItemPedido().getProduto().getNome());
            }
        });
        this.columnProduto.setCellFactory((Callback)new Callback<TableColumn<ItemControleEntregaNotaPropria, String>, TableCell<ItemControleEntregaNotaPropria, String>>(){

            public TableCell<ItemControleEntregaNotaPropria, String> call(TableColumn<ItemControleEntregaNotaPropria, String> param) {
                TableCell<ItemControleEntregaNotaPropria, String> cell = new TableCell<ItemControleEntregaNotaPropria, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty() && item != null) {
                            this.text = new Text(item.toString());
                            this.text.setWrappingWidth(ControleEntregaItensController.this.columnProduto.getWidth());
                            this.setGraphic((Node)this.text);
                        }
                    }
                };
                return cell;
            }
        });
        this.columnCodAux.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ItemControleEntregaNotaPropria, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ItemControleEntregaNotaPropria, String> param) {
                return new SimpleObjectProperty((Object)(StaticObjects.getOpcoes().getUsarCodAuxiliar() == 1 ? ((ItemControleEntregaNotaPropria)param.getValue()).getItemPedido().getProduto().getCodigoAuxiliar() : String.valueOf(((ItemControleEntregaNotaPropria)param.getValue()).getItemPedido().getProduto().getIdentificador())));
            }
        });
        this.columnCodAux.setCellFactory((Callback)new Callback<TableColumn<ItemControleEntregaNotaPropria, String>, TableCell<ItemControleEntregaNotaPropria, String>>(){

            public TableCell<ItemControleEntregaNotaPropria, String> call(TableColumn<ItemControleEntregaNotaPropria, String> param) {
                TableCell<ItemControleEntregaNotaPropria, String> cell = new TableCell<ItemControleEntregaNotaPropria, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.text = !this.isEmpty() && item != null ? new Text(item.toString()) : new Text("");
                        this.text.setWrappingWidth(ControleEntregaItensController.this.columnCodAux.getWidth());
                        this.setGraphic((Node)this.text);
                    }
                };
                return cell;
            }
        });
        this.columnQtdTotal.setCellValueFactory(cellData -> new SimpleStringProperty(((ItemControleEntregaNotaPropria)cellData.getValue()).getItemPedido().getQuantidadeTotal().toString()));
        this.columnQtdEntregue.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new MoneyStringConverter()));
        this.columnQtdEntregue.setCellValueFactory((Callback)new PropertyValueFactory("quantidadeEntregue"));
        this.tableItens.setEditable(true);
        this.tableItens.setItems(FXCollections.observableArrayList(this.itensTable));
    }

    @Override
    public void requestFocusOnOpen() {
    }

    private void initComponents() {
        this.iniciaTabela();
        if (this.controleEntrega.getDataEntrega() == null) {
            this.controleEntrega.setDataEntrega(new Date());
        }
        this.tfDataEntrega.setText(ToolDate.dateToStr((Date)this.controleEntrega.getDataEntrega(), (String)"dd/MM/yyyy"));
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    private void confirma() {
        if (this.tfDataEntrega.getText() == null || this.tfDataEntrega.getText().isEmpty()) {
            Alerts.showAlertError("Informe a data de entrega");
            return;
        }
        try {
            Date dataEntrega = ToolDate.strToDate((String)this.tfDataEntrega.getText());
            this.controleEntrega.setDataEntrega(dataEntrega);
            this.controleEntrega.setObservacao(this.txtObservacao.getText());
        }
        catch (Exception e) {
            Alerts.showAlertError("Informe uma data de entrega v\u00e1lida");
            return;
        }
        this.vaiTelaSplashEnvioControleEntrega();
    }

    @Override
    public void paramsData(Class<? extends BaseController> aClass, Map data) {
        if (data.get(CONTROLE_ENTREGA) != null) {
            this.controleEntrega = (ControleEntregaNotaPropria)data.get(CONTROLE_ENTREGA);
            this.itensTable = this.controleEntrega.getItemControleEntregaNotaPropria();
            this.initComponents();
        } else {
            this.controleEntrega = new ControleEntregaNotaPropria();
            this.controleEntrega.setEmpresa(StaticObjects.getEmpresa());
            this.controleEntrega.setPedido(StaticObjects.getPedidoAberto());
            this.controleEntrega.setUsuario(StaticObjects.getUsuario());
            this.controleEntrega.setSerialForSincPedido(StaticObjects.getPedidoAberto().getSerialForSync());
            this.controleEntrega.setSerialForSinc(UtilNFCeSerial.getSerial());
            LinkedList<ItemControleEntregaNotaPropria> itensCont = new LinkedList<ItemControleEntregaNotaPropria>();
            for (ItemPedido it : StaticObjects.getPedidoAberto().getItemPedido()) {
                ItemControleEntregaNotaPropria item = new ItemControleEntregaNotaPropria();
                item.setItemPedido(it);
                item.setNrItemPedido(it.getNrItemPedido());
                itensCont.add(item);
            }
            this.controleEntrega.setItemControleEntregaNotaPropria(itensCont);
            this.itensTable = this.controleEntrega.getItemControleEntregaNotaPropria();
            this.initComponents();
        }
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt != null) {
            switch (evt.getCode()) {
                case DOWN: {
                    this.tableItens.requestFocus();
                    if (this.tableItens.getSelectionModel().getSelectedIndex() == -1) {
                        this.tableItens.getSelectionModel().selectFirst();
                        break;
                    }
                    this.tableItens.getSelectionModel().select(this.tableItens.getSelectionModel().getSelectedIndex());
                    break;
                }
                case ESCAPE: {
                    this.cancelaOperacao();
                    break;
                }
                case F1: {
                    this.tfItem.requestFocus();
                    break;
                }
                case F2: {
                    this.tfDataEntrega.requestFocus();
                    this.tfDataEntrega.selectAll();
                    break;
                }
                case F3: {
                    this.tableItens.requestFocus();
                    if (this.tableItens.getSelectionModel().getSelectedIndex() == -1) {
                        this.tableItens.getSelectionModel().selectFirst();
                        break;
                    }
                    this.tableItens.getSelectionModel().select(this.tableItens.getSelectionModel().getSelectedIndex());
                    break;
                }
                case F4: {
                    this.editQtdItem();
                    break;
                }
                case F5: {
                    this.txtObservacao.requestFocus();
                    break;
                }
                case F6: {
                    this.marcarTodos();
                    break;
                }
                case F12: {
                    this.confirma();
                    break;
                }
            }
        }
    }

    private void vaiTelaSplashEnvioControleEntrega() {
        SplashEnvioControleEntrega splashEnvioNFCe = new SplashEnvioControleEntrega(this.controleEntrega);
        splashEnvioNFCe.show();
    }

    private void cancelaOperacao() {
        this.controleEntrega = null;
        StaticObjects.clearPedido();
        Main.get().mudaTela(Controllers.PRE_VENDA);
    }
}

