/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.login;

import com.touchcomp.basementor.constants.enums.codigobarras.EnumConstCodigoBarras;
import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoAutenticacao;
import com.touchcomp.basementorexceptions.exceptions.impl.criptografia.ExceptionCriptografia;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.model.Login;
import com.touchcomp.touchnfce.model.Representante;
import com.touchcomp.touchnfce.model.Usuario;
import com.touchcomp.touchnfce.service.impl.ServiceLogin;
import com.touchcomp.touchnfce.service.impl.ServiceRepresentante;
import com.touchcomp.touchnfce.service.impl.ServiceUsuario;
import com.touchcomp.touchnfce.utils.UtilPermissaoUsuario;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import org.springframework.stereotype.Controller;

@Controller
public class LoginAutorizacaoController
extends BaseDialog {
    public static final String TIPO_AUTENTICACAO = "tipo_autenticacao";
    public static final String PERCENTUAL = "percentual";
    public static final String VALIDACOES_LIBERACAO_FINANCEIRA = "validacoes_liberacao_financeira";
    @FXML
    private Button btnEntrar;
    @FXML
    private Button btnCancelar;
    @FXML
    private Label lblLogin;
    @FXML
    private Label lblSenha;
    @FXML
    private TextField tfLogin;
    @FXML
    private PasswordField pfSenha;
    @FXML
    private AnchorPane body;
    private Usuario usuario;
    private Representante representante;
    private EnumConstNFCeTipoAutenticacao enumTipoAutenticacao;
    private Double percentual = 0.0;
    private List<Integer> errorCode;

    @Override
    public void initializeController(ResourceBundle rb) {
        this.usuario = null;
        this.tfLogin.setOnAction(event -> this.pfSenha.requestFocus());
        this.btnEntrar.setOnAction(event -> this.login());
        this.btnCancelar.setOnAction(event -> {
            this.usuario = null;
            this.closeDialog();
        });
        this.pfSenha.setOnAction(event -> this.login());
        this.tfLogin.setOnKeyPressed(evt -> {
            if (evt.getCode() != null) {
                switch (evt.getCode()) {
                    case ENTER: {
                        this.verificaUsuarioCodigoBarras(this.tfLogin.getText());
                        break;
                    }
                }
            }
        });
        this.pfSenha.setOnKeyPressed(evt -> {
            if (evt.getCode() != null) {
                switch (evt.getCode()) {
                    case ENTER: {
                        this.verificaUsuarioCodigoBarras(this.pfSenha.getText());
                        break;
                    }
                }
            }
        });
    }

    private void verificaUsuarioCodigoBarras(String valor) {
        if (valor.startsWith(EnumConstCodigoBarras.CODIGO_BARRAS_USUARIO.getCodigo()) && valor.length() == 16) {
            valor = valor.substring(2);
            if (ToolString.isAIntegerNumber((String)(valor = ToolString.removerZerosAEsquerda((String)valor)))) {
                Long identificadorUsuario = Long.parseLong(valor);
                ServiceUsuario serviceUsuario = Main.getBean(ServiceUsuario.class);
                Usuario usuario = (Usuario)serviceUsuario.get(identificadorUsuario);
                if (usuario == null) {
                    if (!this.tfLogin.getText().isEmpty()) {
                        this.tfLogin.clear();
                    }
                    if (!this.pfSenha.getText().isEmpty()) {
                        this.pfSenha.clear();
                    }
                    return;
                }
                this.validaUsuario(usuario);
            }
        }
    }

    @Override
    public void posInitialize() {
        this.enumTipoAutenticacao = (EnumConstNFCeTipoAutenticacao)this.getParams().get(TIPO_AUTENTICACAO);
        this.percentual = (Double)this.getParams().get(PERCENTUAL);
        this.errorCode = (List)this.getParams().get(VALIDACOES_LIBERACAO_FINANCEIRA);
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt == null) {
            return;
        }
        switch (evt.getCode()) {
            case ESCAPE: 
            case F2: {
                this.usuario = null;
                this.closeDialog();
                break;
            }
            case F1: {
                this.login();
            }
        }
    }

    @Override
    public void requestFocusOnOpen() {
        Platform.runLater(() -> this.tfLogin.requestFocus());
    }

    private void login() {
        if (this.tfLogin.getText() != null && this.tfLogin.getText().isEmpty()) {
            return;
        }
        ServiceLogin service = Main.getBean(ServiceLogin.class);
        Login login = null;
        try {
            login = service.findByLoginAndSenha(this.tfLogin.getText(), this.pfSenha.getText());
        }
        catch (ExceptionCriptografia ex) {
            ex.printStackTrace();
            Alerts.showAlertError("Erro ao consultar usuario." + String.valueOf(ex.getCause()));
        }
        if (login == null) {
            Alerts.showAlertError("Nenhum usu\u00e1rio encontrado com esses dados!");
            return;
        }
        Usuario u = login.getUsuario();
        this.validaUsuario(u);
    }

    private void validaUsuario(Usuario u) {
        if (EnumConstNFCeTipoAutenticacao.isGrupoLibFinanceira((EnumConstNFCeTipoAutenticacao)this.enumTipoAutenticacao) || EnumConstNFCeTipoAutenticacao.AUTENTICACAO_LIBERACAO_FINANCEIRA_CLIENTE.equals((Object)this.enumTipoAutenticacao)) {
            if (UtilPermissaoUsuario.isPermitidoLiberacaoFinanceira(u, this.errorCode)) {
                this.usuario = u;
                this.closeDialog();
            } else {
                Alerts.showAlertError("Usu\u00e1rio sem permiss\u00e3o para libera\u00e7\u00e3o financeira!");
            }
        } else if (EnumConstNFCeTipoAutenticacao.isGrupoCancelamentoNFCe((EnumConstNFCeTipoAutenticacao)this.enumTipoAutenticacao) || EnumConstNFCeTipoAutenticacao.AUTENTICACAO_CANCELAMENTO.equals((Object)this.enumTipoAutenticacao)) {
            if (UtilPermissaoUsuario.isPermitidoCancelarNFCeItem(u)) {
                this.usuario = u;
                this.closeDialog();
            } else {
                Alerts.showAlertError("Usu\u00e1rio sem permiss\u00e3o para cancelamento!");
            }
        } else if (EnumConstNFCeTipoAutenticacao.isGrupoDescontoAndAcrescimoNFCe((EnumConstNFCeTipoAutenticacao)this.enumTipoAutenticacao)) {
            if (UtilPermissaoUsuario.isPermitidoDesconto(u, this.percentual)) {
                this.usuario = u;
                this.closeDialog();
            } else {
                Alerts.showAlertError("Usu\u00e1rio sem permiss\u00e3o!");
            }
        } else if (EnumConstNFCeTipoAutenticacao.isGrupoDescontoAndAcrescimoNFCe((EnumConstNFCeTipoAutenticacao)this.enumTipoAutenticacao)) {
            if (UtilPermissaoUsuario.isPermitidoAcrescimo(u, this.percentual)) {
                this.usuario = u;
                this.closeDialog();
            } else {
                Alerts.showAlertError("Usu\u00e1rio sem permiss\u00e3o!");
            }
        } else if (EnumConstNFCeTipoAutenticacao.isGrupoOpcoesAvanAbastecimento((EnumConstNFCeTipoAutenticacao)this.enumTipoAutenticacao)) {
            if (UtilPermissaoUsuario.isPermitidoAcessarOpcoesAvancadasAbastecimento(u)) {
                this.usuario = u;
                this.closeDialog();
            } else {
                Alerts.showAlertError("Usu\u00e1rio sem permiss\u00e3o!");
            }
        } else if (EnumConstNFCeTipoAutenticacao.isGrupoAfericaoPreAbastecimento((EnumConstNFCeTipoAutenticacao)this.enumTipoAutenticacao)) {
            if (UtilPermissaoUsuario.isPermitidoAcessarAbastecimentoAfericao(u)) {
                this.usuario = u;
                this.closeDialog();
            } else {
                Alerts.showAlertError("Usu\u00e1rio sem permiss\u00e3o!");
            }
        } else if (EnumConstNFCeTipoAutenticacao.isAutenticacaoRepresentante((EnumConstNFCeTipoAutenticacao)this.enumTipoAutenticacao)) {
            ServiceRepresentante serviceRep = Main.getBean(ServiceRepresentante.class);
            this.representante = serviceRep.getRepresentanteByPessoa(u.getPessoa().getIdentificador());
            this.usuario = u;
            this.closeDialog();
        } else {
            Alerts.showAlertError("N\u00e3o foi encontrado nenhum tipo de autentica\u00e7\u00e3o");
        }
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public Representante getRepresentante() {
        return this.representante;
    }

    @Override
    public void eventAltControl(KeyEvent event) {
    }
}

