/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.movimentocaixa;

import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoMovimentoCaixa;
import com.touchcomp.basementorexceptions.exceptions.impl.jasperreports.ExceptionJasperReports;
import com.touchcomp.basementorexceptions.exceptions.impl.print.ExceptionPrint;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.ToastText;
import com.touchcomp.touchnfce.components.TouchDoubleField;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.BaseController;
import com.touchcomp.touchnfce.model.NFCeControleCaixa;
import com.touchcomp.touchnfce.model.NFCeMovimentoCaixa;
import com.touchcomp.touchnfce.modeltemp.ControllerPath;
import com.touchcomp.touchnfce.modeltemp.MovimentacaoCaixa;
import com.touchcomp.touchnfce.print.impl.PrintMovimentacaoCaixa;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeControleCaixa;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeMovimentoCaixa;
import com.touchcomp.touchnfce.utils.UtilNFCeSerial;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;

public class MovimentacaoCaixaController
extends BaseController {
    @FXML
    private Label lblEntradaMov;
    @FXML
    private Label lblCaixa;
    @FXML
    private Label lblCaixaValue;
    @FXML
    private Label lblData;
    @FXML
    private Label lblDataValue;
    @FXML
    private Label lblObservacao;
    @FXML
    private TouchDoubleField tfEntradaMov;
    @FXML
    private TouchTextField tfObservacao;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnSair;
    @FXML
    private AnchorPane body;
    private static final String LBL_VLR_ENTRADA = "Valor entrada:";
    private static final String LBL_VLR_SAIDA = "Valor sa\u00edda:";

    @Override
    protected void initializeController(ResourceBundle rb) {
        this.lblCaixaValue.setText(StaticObjects.getControleCaixa().getUsuario().getPessoa().getNome());
        this.lblDataValue.setText(ToolDate.dateToStr((Date)new Date(), (String)"dd/MM/yyyy hh:mm"));
        this.tfEntradaMov.setLabel(this.lblEntradaMov);
        this.tfObservacao.setOnKeyTyped(event -> {
            if (this.tfObservacao.getText().length() > 499) {
                this.tfObservacao.setText(this.tfObservacao.getText().substring(0, 500));
                event.consume();
            }
        });
    }

    @Override
    public void initEvents() {
        this.setActionsButtons();
    }

    @Override
    public void beforeShow() {
        StaticObjects.refreshValoresControleCaixa();
    }

    @Override
    protected void requestFocusOnOpen() {
        this.tfEntradaMov.requestFocus();
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKey(KeyEvent evt) {
        switch (evt.getCode()) {
            case F12: {
                if (this.getUltimaPagina().equals(Controllers.ENTRADA_MOV)) {
                    this.realizaEntradaMov();
                    break;
                }
                if (!this.getUltimaPagina().equals(Controllers.SAIDA_MOV)) break;
                this.realizaSaidaMov();
                break;
            }
            case ESCAPE: {
                this.goBack();
                break;
            }
        }
    }

    private void realizaEntradaMov() {
        if (this.tfEntradaMov.getDouble() >= 0.0) {
            this.criaMovimentacao(EnumConstNFCeTipoMovimentoCaixa.ENTRADA_SUPRIMENTO.getValue());
            ToastText.makeText(Main.get().getPrimaryStage(), "Entrada realizada com sucesso", 3500, 500, 500);
            this.goBack();
        } else {
            Alerts.showAlertError("Informe um valor v\u00e1lido para entrada!");
        }
    }

    private void criaMovimentacao(Integer tipoMovimentacao) {
        NFCeMovimentoCaixa entradaMov = new NFCeMovimentoCaixa();
        entradaMov.setDataMovimento(new Date());
        entradaMov.setValor(this.tfEntradaMov.getDouble());
        entradaMov.setTipoMovimento(tipoMovimentacao);
        entradaMov.setObservacao(this.tfObservacao.getText());
        entradaMov.setSerialForSinc(UtilNFCeSerial.getSerial(StaticObjects.getNFCeCaixa()));
        if (tipoMovimentacao.equals(EnumConstNFCeTipoMovimentoCaixa.ENTRADA_SUPRIMENTO.getValue())) {
            this.getNFCeControleCaixa().setValorTotalEntradasMov(this.tfEntradaMov.getDouble() + this.getNFCeControleCaixa().getValorTotalEntradasMov());
            this.getNFCeControleCaixa().setValorTotalSistema(this.tfEntradaMov.getDouble() + this.getNFCeControleCaixa().getValorTotalSistema());
        } else {
            this.getNFCeControleCaixa().setValorTotalSaidasMov(this.tfEntradaMov.getDouble() + this.getNFCeControleCaixa().getValorTotalSaidasMov());
            this.getNFCeControleCaixa().setValorTotalSistema(this.getNFCeControleCaixa().getValorTotalSistema() - this.tfEntradaMov.getDouble());
        }
        entradaMov.setControleCaixa(this.getNFCeControleCaixa());
        ServiceNFCeMovimentoCaixa serviceMov = Main.getBean(ServiceNFCeMovimentoCaixa.class);
        serviceMov.save(entradaMov);
        this.imprimeComprovante(tipoMovimentacao, entradaMov);
        ServiceNFCeControleCaixa serviceContCaixa = Main.getBean(ServiceNFCeControleCaixa.class);
        NFCeControleCaixa controleCaixa = serviceContCaixa.save(this.getNFCeControleCaixa());
        StaticObjects.setControleCaixa(controleCaixa);
    }

    private void realizaSaidaMov() {
        if (this.tfEntradaMov.getDouble() > 0.0) {
            if (this.tfEntradaMov.getDouble() <= this.getNFCeControleCaixa().getValorTotalSistemaDinh()) {
                this.criaMovimentacao(EnumConstNFCeTipoMovimentoCaixa.SAIDA_SANGRIA.getValue());
                ToastText.makeText(Main.get().getPrimaryStage(), "Sangria realizada com sucesso", 3500, 500, 500);
                this.goBack();
            } else {
                Alerts.showAlertError("O caixa n\u00e3o disp\u00f5e dessa quantia para retirada!");
            }
        } else {
            Alerts.showAlertError("Informe um valor v\u00e1lido para sa\u00edda!");
        }
    }

    private NFCeControleCaixa getNFCeControleCaixa() {
        return StaticObjects.getControleCaixa();
    }

    private ControllerPath getUltimaPagina() {
        return StaticObjects.getUltimaPagina();
    }

    private void setActionsButtons() {
        this.btnSair.setOnAction(event -> this.goBack());
        if (this.getUltimaPagina().equals(Controllers.ENTRADA_MOV)) {
            this.btnConfirmar.setOnAction(event -> this.realizaEntradaMov());
            this.lblEntradaMov.setText(LBL_VLR_ENTRADA);
        } else if (this.getUltimaPagina().equals(Controllers.SAIDA_MOV)) {
            this.btnConfirmar.setOnAction(event -> this.realizaSaidaMov());
            this.lblEntradaMov.setText(LBL_VLR_SAIDA);
        }
    }

    private void imprimeComprovante(Integer tipoMovimentacao, NFCeMovimentoCaixa entradaMov) {
        try {
            MovimentacaoCaixa mov = new MovimentacaoCaixa();
            mov.setEmpresa(this.getNFCeControleCaixa().getNFCeCaixa().getEmpresa());
            mov.setUsuario(this.getNFCeControleCaixa().getUsuario());
            mov.setValor(entradaMov.getValor());
            mov.setTipoMovimentacao(tipoMovimentacao);
            mov.setCaixa(this.getNFCeControleCaixa().getNFCeCaixa().getDescricao());
            mov.setDataMovimento(entradaMov.getDataMovimento());
            mov.setObservacao(entradaMov.getObservacao());
            new PrintMovimentacaoCaixa().printResumoCompleto(mov);
        }
        catch (ExceptionJasperReports | ExceptionPrint ex) {
            Logger.getLogger(MovimentacaoCaixaController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
    }
}

