/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.nfce;

import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.controller.BaseController;
import com.touchcomp.touchnfce.controller.nfce.StyleChangingRowFactory;
import com.touchcomp.touchnfce.controller.splash.impl.SplashEnvioNFCeEmail;
import com.touchcomp.touchnfce.controller.splash.impl.SplashImpressaoDanfce;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCePagamento;
import com.touchcomp.touchnfce.utils.MaskField;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.Text;
import javafx.util.Callback;

public class ResumoNFCeController
extends BaseController {
    @FXML
    private TabPane tabPaneDados;
    @FXML
    private Tab tabProdutos;
    @FXML
    private Tab tabPagamentos;
    @FXML
    private Tab tabClienteCons;
    @FXML
    private Tab tabEnderecoEnt;
    @FXML
    private TableView<NFCeItem> tableItens;
    @FXML
    private TableView<NFCePagamento> tableFormasPag;
    @FXML
    private TableColumn<NFCeItem, String> columnProduto;
    @FXML
    private TableColumn<NFCeItem, String> columnUM;
    @FXML
    private TableColumn<NFCeItem, String> columnQuantidade;
    @FXML
    private TableColumn<NFCeItem, String> columnVlrUnitario;
    @FXML
    private TableColumn<NFCeItem, String> columnVlrDesconto;
    @FXML
    private TableColumn<NFCeItem, String> columnVlrTot;
    @FXML
    private TableColumn<NFCeItem, String> columnNmrItem;
    @FXML
    private TableColumn<NFCeItem, String> columIdCodAux;
    @FXML
    private TableColumn<NFCePagamento, String> columnDescricao;
    @FXML
    private TableColumn<NFCePagamento, String> columnValor;
    @FXML
    private AnchorPane body;
    @FXML
    private Button btnVoltar;
    @FXML
    private Button btnEnviarEmail;
    @FXML
    private Button btnImprimir;
    @FXML
    private Label lblNome;
    @FXML
    private Label lblEmail;
    @FXML
    private Label lblCpfCnpj;
    @FXML
    private Label lblPassaporte;
    @FXML
    private Label lblResponsavel;
    @FXML
    private Label lblCpfCnpjRes;
    @FXML
    private Label lblLogradouro;
    @FXML
    private Label lblNumero;
    @FXML
    private Label lblCidade;
    @FXML
    private Label lblBairro;
    @FXML
    private Label lblReferencia;
    @FXML
    private Label lblObservacao;
    @FXML
    private Label lblCep;
    @FXML
    private TouchTextField tfNome;
    @FXML
    private TouchTextField tfCpfCnpj;
    @FXML
    private TouchTextField tfEmail;
    @FXML
    private TouchTextField tfPassaporte;
    @FXML
    private TouchTextField tfResponsavel;
    @FXML
    private TouchTextField tfCpfCnpjRes;
    @FXML
    private TouchTextField tfLogradouro;
    @FXML
    private TouchTextField tfNumero;
    @FXML
    private TouchTextField tfCidade;
    @FXML
    private TouchTextField tfBairro;
    @FXML
    private TouchTextField tfReferencia;
    @FXML
    private TouchTextField tfObservacao;
    @FXML
    private TouchTextField tfCep;
    private NFCe currentNFCe;
    private Short exibirProduto;
    final StyleChangingRowFactory<NFCeItem> rowFactoryProdutos = new StyleChangingRowFactory("table-row-cell-yellow");
    final StyleChangingRowFactory<NFCePagamento> rowFactoryPagamentos = new StyleChangingRowFactory("table-row-cell-yellow");

    @Override
    protected void initializeController(ResourceBundle rb) {
        this.exibirProduto = StaticObjects.getOpcoes().getUsarCodAuxiliar();
        this.tableItens.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.tableFormasPag.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.configureTableProdutos();
        this.inativaCampos();
        this.setActionsButtons();
        this.setLabelsTextField();
    }

    private void setLabelsTextField() {
        this.tfBairro.setLabel(this.lblBairro);
        this.tfCep.setLabel(this.lblCep);
        this.tfCidade.setLabel(this.lblCidade);
        this.tfCpfCnpj.setLabel(this.lblCpfCnpj);
        this.tfCpfCnpjRes.setLabel(this.lblCpfCnpjRes);
        this.tfEmail.setLabel(this.lblEmail);
        this.tfLogradouro.setLabel(this.lblLogradouro);
        this.tfNome.setLabel(this.lblNome);
        this.tfNumero.setLabel(this.lblNumero);
        this.tfObservacao.setLabel(this.lblObservacao);
        this.tfPassaporte.setLabel(this.lblPassaporte);
        this.tfReferencia.setLabel(this.lblReferencia);
        this.tfResponsavel.setLabel(this.lblResponsavel);
    }

    private void setActionsButtons() {
        this.btnVoltar.setOnAction(evt -> Main.get().mudaTela(Controllers.PESQUISA_NFCE));
        this.btnImprimir.setOnAction(evt -> {
            SplashImpressaoDanfce splashImpDanfce = new SplashImpressaoDanfce(this.currentNFCe);
            splashImpDanfce.show();
        });
        this.btnEnviarEmail.setOnAction(evt -> {
            SplashEnvioNFCeEmail splashEnvioNFCe = new SplashEnvioNFCeEmail(this.currentNFCe, StaticObjects.getOpcoes());
            splashEnvioNFCe.show();
        });
    }

    @Override
    protected void requestFocusOnOpen() {
    }

    @Override
    public void paramsData(Class<? extends BaseController> aClass, Map data) {
        this.currentNFCe = (NFCe)data.get("NFCe");
        if (this.currentNFCe != null) {
            this.setProdutosTable();
            this.setFormasPagTable();
            this.setClienteConsumidor();
            this.setEndereco();
            this.adicionaProdutosCancelados();
            this.adicionaPagamentosCancelados();
        }
    }

    private void inativaCampos() {
        this.tfBairro.setEditable(false);
        this.tfCep.setEditable(false);
        this.tfCidade.setEditable(false);
        this.tfCpfCnpj.setEditable(false);
        this.tfCpfCnpjRes.setEditable(false);
        this.tfEmail.setEditable(false);
        this.tfLogradouro.setEditable(false);
        this.tfNome.setEditable(false);
        this.tfNumero.setEditable(false);
        this.tfObservacao.setEditable(false);
        this.tfPassaporte.setEditable(false);
        this.tfReferencia.setEditable(false);
        this.tfResponsavel.setEditable(false);
    }

    private void adicionaProdutosCancelados() {
        this.tableItens.getSelectionModel().selectFirst();
        for (int i = 0; i < this.currentNFCe.getItens().size(); ++i) {
            NFCeItem item = (NFCeItem)this.tableItens.getSelectionModel().getSelectedItem();
            if (item.getStatus() == 0) {
                this.rowFactoryProdutos.getStyledRowIndices().add((Object)i);
            }
            this.tableItens.getSelectionModel().selectNext();
        }
        this.tableItens.getSelectionModel().select(null);
    }

    private void adicionaPagamentosCancelados() {
        this.tableFormasPag.getSelectionModel().selectFirst();
        for (int i = 0; i < this.currentNFCe.getPagamentos().size(); ++i) {
            NFCePagamento pag = (NFCePagamento)this.tableFormasPag.getSelectionModel().getSelectedItem();
            if (pag.getStatus() == 0) {
                this.rowFactoryPagamentos.getStyledRowIndices().add((Object)this.tableFormasPag.getSelectionModel().getSelectedIndex());
            }
            this.tableFormasPag.getSelectionModel().selectNext();
        }
        this.tableFormasPag.getSelectionModel().select(null);
    }

    private void setProdutosTable() {
        this.columnUM.setCellValueFactory(cellData -> new SimpleStringProperty(((NFCeItem)cellData.getValue()).getProduto().getUnidadeMedida().getSigla()));
        this.columnNmrItem.setCellValueFactory((Callback)new PropertyValueFactory("numeroItem"));
        this.columnProduto.setCellValueFactory(cellData -> new SimpleStringProperty(((NFCeItem)cellData.getValue()).getProduto().getNome()));
        this.columnProduto.setCellFactory((Callback)new Callback<TableColumn<NFCeItem, String>, TableCell<NFCeItem, String>>(){

            public TableCell<NFCeItem, String> call(TableColumn<NFCeItem, String> param) {
                TableCell<NFCeItem, String> cell = new TableCell<NFCeItem, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty() && item != null) {
                            this.text = new Text(item.toString());
                            this.text.setWrappingWidth(ResumoNFCeController.this.columnProduto.getWidth());
                            this.setGraphic((Node)this.text);
                        }
                    }
                };
                return cell;
            }
        });
        this.columnQuantidade.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCeItem, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCeItem, String> param) {
                return new SimpleObjectProperty((Object)MaskField.double3Casas(((NFCeItem)param.getValue()).getQuantidadeComercial()));
            }
        });
        this.columnVlrDesconto.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCeItem, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCeItem, String> param) {
                return new SimpleObjectProperty((Object)MaskField.monetaryField(((NFCeItem)param.getValue()).getValorDesconto()));
            }
        });
        this.columnVlrTot.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCeItem, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCeItem, String> param) {
                return new SimpleObjectProperty((Object)MaskField.monetaryField(((NFCeItem)param.getValue()).getValorTotal()));
            }
        });
        this.columnVlrUnitario.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCeItem, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCeItem, String> param) {
                return new SimpleObjectProperty((Object)MaskField.monetaryField(((NFCeItem)param.getValue()).getValorUnitarioComercial()));
            }
        });
        this.columIdCodAux.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCeItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCeItem, String> param) {
                return new SimpleObjectProperty((Object)(ResumoNFCeController.this.exibirProduto == 1 ? ((NFCeItem)param.getValue()).getProduto().getCodigoAuxiliar() : String.valueOf(((NFCeItem)param.getValue()).getProduto().getIdentificador())));
            }
        });
        this.tableItens.setItems(FXCollections.observableArrayList(this.currentNFCe.getItens()));
        this.tableItens.setRowFactory(this.rowFactoryProdutos);
    }

    void setFormasPagTable() {
        this.columnDescricao.setCellValueFactory(cellData -> new SimpleStringProperty(((NFCePagamento)cellData.getValue()).getTipoPagamentoNFe().getDescricao()));
        this.columnValor.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NFCePagamento, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NFCePagamento, String> param) {
                return new SimpleObjectProperty((Object)MaskField.monetaryField(((NFCePagamento)param.getValue()).getValorLiquido()));
            }
        });
        this.tableFormasPag.setItems(FXCollections.observableArrayList(this.currentNFCe.getPagamentos()));
        this.tableFormasPag.setRowFactory(this.rowFactoryPagamentos);
    }

    private void setClienteConsumidor() {
        if (this.currentNFCe.getUnidadeFatCliente() != null) {
            this.tfNome.setText(this.currentNFCe.getUnidadeFatCliente().getPessoa().getNome());
            this.tfCpfCnpj.setText(this.currentNFCe.getUnidadeFatCliente().getPessoa().getComplemento().getCnpj());
            this.tfPassaporte.setText(this.currentNFCe.getUnidadeFatCliente().getPessoa().getComplemento().getPassaporte());
            if (!this.currentNFCe.getUnidadeFatCliente().getPessoa().getComplemento().getEmails().isEmpty()) {
                this.tfEmail.setText(this.currentNFCe.getUnidadeFatCliente().getPessoa().getComplemento().getEmails().get(0).getEmail());
            }
        } else if (this.currentNFCe.getNfCeConsumidor() != null) {
            this.tfNome.setText(this.currentNFCe.getNfCeConsumidor().getNome());
            this.tfCpfCnpj.setText(this.currentNFCe.getNfCeConsumidor().getCpfCnpj());
            this.tfPassaporte.setText(this.currentNFCe.getNfCeConsumidor().getPassaporte());
            this.tfEmail.setText(this.currentNFCe.getNfCeConsumidor().getEmail());
        }
    }

    private void setEndereco() {
        if (this.currentNFCe.getEnderecoEntrega() != null) {
            this.tfResponsavel.setText(this.currentNFCe.getEnderecoEntrega().getNomePessoaResp());
            this.tfCpfCnpjRes.setText(this.currentNFCe.getEnderecoEntrega().getCpfCnpj());
            this.tfCep.setText(this.currentNFCe.getEnderecoEntrega().getCep());
            this.tfLogradouro.setText(this.currentNFCe.getEnderecoEntrega().getLogradouro());
            this.tfNumero.setText(this.currentNFCe.getEnderecoEntrega().getNumero());
            this.tfBairro.setText(this.currentNFCe.getEnderecoEntrega().getBairro());
            this.tfReferencia.setText(this.currentNFCe.getEnderecoEntrega().getReferencia());
            this.tfObservacao.setText(this.currentNFCe.getEnderecoEntrega().getObservacao());
        }
    }

    private void configureTableProdutos() {
        this.columnProduto.setMinWidth(450.0);
        this.columnNmrItem.setMinWidth(60.0);
        this.columnUM.setMinWidth(60.0);
        this.columnQuantidade.setMinWidth(80.0);
        this.columnVlrUnitario.setMinWidth(90.0);
        this.columIdCodAux.setMinWidth(90.0);
        this.columnVlrDesconto.setMinWidth(90.0);
        this.columnVlrTot.setMinWidth(110.0);
        this.columnVlrDesconto.setStyle("-fx-alignment: BOTTOM_RIGHT;");
        this.columnVlrTot.setStyle("-fx-alignment: BOTTOM_RIGHT;");
        this.columnVlrUnitario.setStyle("-fx-alignment: BOTTOM_RIGHT;");
        this.columnQuantidade.setStyle("-fx-alignment: BOTTOM_RIGHT;");
        this.columIdCodAux.setStyle("-fx-alignment: BOTTOM_RIGHT;");
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt.getCode() != null) {
            switch (evt.getCode()) {
                case ESCAPE: {
                    Main.get().mudaTela(Controllers.PESQUISA_NFCE);
                    break;
                }
                case F1: {
                    this.tabPaneDados.getSelectionModel().select((Object)this.tabProdutos);
                    this.tableItens.requestFocus();
                    this.tableItens.getSelectionModel().select(null);
                    break;
                }
                case F2: {
                    this.tabPaneDados.getSelectionModel().select((Object)this.tabPagamentos);
                    this.tableFormasPag.requestFocus();
                    this.tableFormasPag.getSelectionModel().select(null);
                    break;
                }
                case F3: {
                    this.tabPaneDados.getSelectionModel().select((Object)this.tabClienteCons);
                    break;
                }
                case F4: {
                    this.tabPaneDados.getSelectionModel().select((Object)this.tabEnderecoEnt);
                    break;
                }
            }
        }
    }
}

