/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.opcoes;

import br.com.softwareexpress.sitef.JCliSiTefI;
import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoMovimentoCaixa;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoipi.ExceptionImpostoIPI;
import com.touchcomp.basementorexceptions.exceptions.impl.impostopiscofins.ExceptionImpostoPisCofins;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jasperreports.ExceptionJasperReports;
import com.touchcomp.basementorexceptions.exceptions.impl.print.ExceptionPrint;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.TouchCheckBox;
import com.touchcomp.touchnfce.components.TouchComboBox;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.BaseController;
import com.touchcomp.touchnfce.controller.caixa.FechamentoCaixaController;
import com.touchcomp.touchnfce.controller.dialogs.DialogComboBox;
import com.touchcomp.touchnfce.controller.dialogs.ReimpressaoFechamentoCaixa;
import com.touchcomp.touchnfce.controller.movimentocaixa.MovimentacaoCaixaController;
import com.touchcomp.touchnfce.controller.opcoes.AuxValidaProdutosSemModelo;
import com.touchcomp.touchnfce.controller.splash.impl.SplashImpressaoComprovanteTransacaoGerencial;
import com.touchcomp.touchnfce.controller.splash.impl.SplashTEFTransacaoGerencial;
import com.touchcomp.touchnfce.controller.venda.auxmodelofiscal.AuxModeloFiscal;
import com.touchcomp.touchnfce.model.Cliente;
import com.touchcomp.touchnfce.model.DadosConfiguracaoLocal;
import com.touchcomp.touchnfce.model.GradeCor;
import com.touchcomp.touchnfce.model.ModeloFiscal;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeControleCaixa;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCeMovimentoCaixa;
import com.touchcomp.touchnfce.model.NFCeOpcoes;
import com.touchcomp.touchnfce.model.NFCePeriodoEmissao;
import com.touchcomp.touchnfce.model.NaturezaOperacao;
import com.touchcomp.touchnfce.model.PeriodoEmissaoNFe;
import com.touchcomp.touchnfce.model.TabelaPrecoBase;
import com.touchcomp.touchnfce.model.TabelaPrecoBaseProduto;
import com.touchcomp.touchnfce.model.TipoEmissaoNFe;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import com.touchcomp.touchnfce.modeltemp.MovimentacaoCaixa;
import com.touchcomp.touchnfce.modeltemp.ResumoRecebimento;
import com.touchcomp.touchnfce.print.impl.PrintAberturaCaixa;
import com.touchcomp.touchnfce.print.impl.PrintFechamentoCaixaComp;
import com.touchcomp.touchnfce.print.impl.PrintFechamentoCaixaRes;
import com.touchcomp.touchnfce.print.impl.PrintMovimentacaoCaixa;
import com.touchcomp.touchnfce.properties.ConfPropertiesLoader;
import com.touchcomp.touchnfce.service.impl.ServiceCliente;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeControleCaixa;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeMovimentoCaixa;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeOpcoes;
import com.touchcomp.touchnfce.service.impl.ServiceNaturezaOperacao;
import com.touchcomp.touchnfce.service.impl.ServiceTabelaPrecoBase;
import com.touchcomp.touchnfce.service.impl.ServiceTipoEmissaoNFe;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import com.touchcomp.touchnfce.utils.UtilNFCeCalculos;
import com.touchcomp.touchnfce.utils.UtilPeriodoEmissao;
import com.touchcomp.touchnfce.utils.sitef.UtilSitefTransacaoGerencial;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.KeyEvent;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;

public class OutrasOpcoesController
extends BaseController {
    @FXML
    private TouchCheckBox chFullScreen;
    @FXML
    private TouchCheckBox chLiberarVenda;
    @FXML
    private TouchCheckBox chcValidarModeloFiscalNFCe;
    @FXML
    private TouchCheckBox chcValidarModeloFiscalNFe;
    @FXML
    private TouchCheckBox chcGerarNFCe;
    @FXML
    private TouchCheckBox chcGerarNFe;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnCancelar;
    @FXML
    private Button btnTransacoesGerenciais;
    @FXML
    private Button btnCriarNovoPeriodo;
    @FXML
    private Button btnCriarNovoPeriodoNfe;
    @FXML
    private Button btnGerarAnalise;
    @FXML
    private Button btnReimprimirAbertCaixa;
    @FXML
    private Button btnReimprimirFecCaixa;
    @FXML
    private Button btnReimprimirMovSaida;
    @FXML
    private Button btnReimprimirMovEntrada;
    @FXML
    private Button btnAtualizarStatus;
    @FXML
    private Label lblImpressoraLaser;
    @FXML
    private Label lblImpressoraTermica;
    @FXML
    private Label lblInformacoes;
    @FXML
    private TouchComboBox cmbImpressoraLaser;
    @FXML
    private TouchComboBox cmbImpressoraTermica;
    @FXML
    private TabPane tabPaneOpcoes;
    @FXML
    private Tab tabConfigGerais;
    @FXML
    private Tab tabTEF;
    @FXML
    private Tab tabPeriodoEmissao;
    @FXML
    private Tab tabReimprimir;
    @FXML
    private Tab tabOutrasOpcoes;
    private final String FULL_SCREEN = "fullScreen";
    private ConfPropertiesLoader props;
    private DadosConfiguracaoLocal dados;

    @Override
    protected void initializeController(ResourceBundle rb) {
        this.props = ConfPropertiesLoader.get();
        this.setConfiguracoes();
        this.btnConfirmar.setOnAction(event -> this.salvaConf(this.props));
        this.btnCancelar.setOnAction(event -> this.goBack());
        this.btnTransacoesGerenciais.setOnAction(event -> this.realizarTransacoesGerenciais());
        this.btnCriarNovoPeriodo.setOnAction(event -> this.cadastrarNovoPeriodoEmissaoNFCe());
        this.btnCriarNovoPeriodoNfe.setOnAction(event -> this.cadastrarNovoPeriodoEmissaoNFe());
        this.btnGerarAnalise.setOnAction(event -> this.validEmissaoProdutos());
        this.btnReimprimirMovSaida.setOnAction(event -> this.reimprimirMovCaixa(EnumConstNFCeTipoMovimentoCaixa.SAIDA_SANGRIA));
        this.btnReimprimirMovEntrada.setOnAction(event -> this.reimprimirMovCaixa(EnumConstNFCeTipoMovimentoCaixa.ENTRADA_SUPRIMENTO));
        this.btnReimprimirFecCaixa.setOnAction(event -> this.reimprimirFechamentoCaixa());
        this.btnReimprimirAbertCaixa.setOnAction(event -> this.reimprimirAberturaCaixa());
        this.btnAtualizarStatus.setOnAction(event -> this.atualizarStatus());
        this.setComboBoxImpressoras();
        this.lblInformacoes.setStyle("-fx-text-fill: #FFFF00;-fx-font-size: 2em;");
    }

    private void reimprimirMovCaixa(EnumConstNFCeTipoMovimentoCaixa tipoMovimento) {
        ServiceNFCeMovimentoCaixa service = Main.getBean(ServiceNFCeMovimentoCaixa.class);
        List<Object> movs = new LinkedList();
        if (tipoMovimento == EnumConstNFCeTipoMovimentoCaixa.ENTRADA_SUPRIMENTO) {
            movs = service.getUltimosMovimentosEntrada();
        } else if (tipoMovimento == EnumConstNFCeTipoMovimentoCaixa.SAIDA_SANGRIA) {
            movs = service.getUltimosMovimentosSaida();
        }
        DialogComboBox res = Alerts.showDialogComboBox("Selecione um movimento", movs);
        if (res.getSelectedItem() != null) {
            NFCeMovimentoCaixa mov = (NFCeMovimentoCaixa)res.getSelectedItem();
            this.imprimeComprovante(mov.getTipoMovimento(), mov);
        }
    }

    private void imprimeComprovante(Integer tipoMovimentacao, NFCeMovimentoCaixa entradaMov) {
        try {
            MovimentacaoCaixa mov = new MovimentacaoCaixa();
            mov.setEmpresa(StaticObjects.getControleCaixa().getNFCeCaixa().getEmpresa());
            mov.setUsuario(StaticObjects.getControleCaixa().getUsuario());
            mov.setValor(entradaMov.getValor());
            mov.setTipoMovimentacao(tipoMovimentacao);
            mov.setCaixa(StaticObjects.getControleCaixa().getNFCeCaixa().getDescricao());
            mov.setDataMovimento(entradaMov.getDataMovimento());
            new PrintMovimentacaoCaixa().printResumoCompleto(mov);
        }
        catch (ExceptionJasperReports | ExceptionPrint ex) {
            Logger.getLogger(MovimentacaoCaixaController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
    }

    private void reimprimirAberturaCaixa() {
        ServiceNFCeControleCaixa service = Main.getBean(ServiceNFCeControleCaixa.class);
        if (StaticObjects.getControleCaixa() != null) {
            NFCeControleCaixa mov = StaticObjects.getControleCaixa();
            new PrintAberturaCaixa().imprimeComprovante(mov);
        } else {
            Alerts.showAlertInfo("Nenhum caixa aberto.");
        }
    }

    private void reimprimirFechamentoCaixa() {
        ServiceNFCeControleCaixa service = Main.getBean(ServiceNFCeControleCaixa.class);
        List<NFCeControleCaixa> movs = service.getUltimosMovimentos();
        ReimpressaoFechamentoCaixa res = Alerts.showDialogComboBox("Selecione um fechamento", movs, Controllers.REIMPRESSAO_FECHAMENTO_CAIXA);
        if (res.getSelectedItem() != null) {
            NFCeControleCaixa mov = (NFCeControleCaixa)res.getSelectedItem();
            this.showAlertOpcaoImpressao(mov);
        }
    }

    private void atualizarStatus() {
        ServiceNFCeControleCaixa service = Main.getBean(ServiceNFCeControleCaixa.class);
        List<NFCeControleCaixa> movs = service.getUltimosMovimentos();
        ReimpressaoFechamentoCaixa res = Alerts.showDialogComboBox("Selecione um fechamento para atualizar status!", movs, Controllers.REIMPRESSAO_FECHAMENTO_CAIXA);
        if (res.getSelectedItem() != null) {
            NFCeControleCaixa mov = (NFCeControleCaixa)res.getSelectedItem();
            service.updateStatus(ToolDate.toTimestamp((Date)new Date()), mov.getIdentificador());
            Alerts.showAlertInfo("Controle de Caixa atualizado com sucesso! Sincronize o envio novamente!");
        }
    }

    private void showAlertOpcaoImpressao(NFCeControleCaixa controleCaixa) {
        Alert dialogoExe = new Alert(Alert.AlertType.CONFIRMATION);
        ButtonType btnCompleto = new ButtonType("Completo", ButtonBar.ButtonData.OK_DONE);
        ButtonType btnSimplificado = new ButtonType("Simplificado");
        ButtonType btnCancelar = new ButtonType("Cancelar");
        dialogoExe.setTitle("Fechamento do caixa");
        dialogoExe.setHeaderText("Deseja imprimir o resumo do caixa como?");
        dialogoExe.getButtonTypes().setAll((Object[])new ButtonType[]{btnCompleto, btnSimplificado, btnCancelar});
        List<ResumoRecebimento> resumo = ResumoRecebimento.convertListControleCaixaRes(controleCaixa.getResumoRecebimentos());
        dialogoExe.showAndWait().ifPresent(b -> {
            if (b == btnCompleto) {
                try {
                    new PrintFechamentoCaixaComp().printResumoCompleto(controleCaixa, resumo);
                }
                catch (ExceptionJasperReports | ExceptionPrint ex) {
                    Logger.getLogger(FechamentoCaixaController.class.getName()).log(Level.SEVERE, null, ex);
                    Alerts.showAlertError(ex.getMessage());
                }
            } else if (b == btnSimplificado) {
                try {
                    new PrintFechamentoCaixaRes().printResumoCompleto(controleCaixa);
                }
                catch (ExceptionJasperReports | ExceptionPrint ex) {
                    Logger.getLogger(FechamentoCaixaController.class.getName()).log(Level.SEVERE, null, ex);
                    Alerts.showAlertError(ex.getMessage());
                }
            } else {
                dialogoExe.close();
            }
        });
    }

    private void setConfiguracoes() {
        this.chFullScreen.setSelected(this.props.getIsFullScreen());
    }

    @Override
    protected void requestFocusOnOpen() {
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKey(KeyEvent evt) {
        switch (evt.getCode()) {
            case F12: {
                this.salvaConf(this.props);
                break;
            }
            case ESCAPE: {
                this.goBack();
                break;
            }
            case F1: {
                this.tabPaneOpcoes.getSelectionModel().select((Object)this.tabReimprimir);
                break;
            }
            case F2: {
                this.tabPaneOpcoes.getSelectionModel().select((Object)this.tabTEF);
                break;
            }
            case F3: {
                this.tabPaneOpcoes.getSelectionModel().select((Object)this.tabPeriodoEmissao);
                break;
            }
            case F4: {
                this.tabPaneOpcoes.getSelectionModel().select((Object)this.tabOutrasOpcoes);
                break;
            }
            case F5: {
                this.tabPaneOpcoes.getSelectionModel().select((Object)this.tabConfigGerais);
                break;
            }
            case F6: {
                if (this.tabPaneOpcoes.getSelectionModel().getSelectedItem() == this.tabReimprimir) {
                    this.reimprimirAberturaCaixa();
                    break;
                }
                if (this.tabPaneOpcoes.getSelectionModel().getSelectedItem() != this.tabPeriodoEmissao) break;
                this.cadastrarNovoPeriodoEmissaoNFe();
                break;
            }
            case F7: {
                if (this.tabPaneOpcoes.getSelectionModel().getSelectedItem() == this.tabReimprimir) {
                    this.reimprimirFechamentoCaixa();
                    break;
                }
                if (this.tabPaneOpcoes.getSelectionModel().getSelectedItem() != this.tabOutrasOpcoes) break;
                this.validEmissaoProdutos();
                break;
            }
            case F8: {
                this.reimprimirMovCaixa(EnumConstNFCeTipoMovimentoCaixa.SAIDA_SANGRIA);
                break;
            }
            case F9: {
                this.reimprimirMovCaixa(EnumConstNFCeTipoMovimentoCaixa.ENTRADA_SUPRIMENTO);
                break;
            }
            case F10: {
                if (this.tabReimprimir.isSelected()) {
                    this.atualizarStatus();
                    break;
                }
                if (!this.tabTEF.isSelected()) break;
                this.realizarTransacoesGerenciais();
                break;
            }
            case F11: {
                this.cadastrarNovoPeriodoEmissaoNFCe();
                break;
            }
            case ALT_GRAPH: {
                this.desabilitarConsultasTerminalPDV();
                break;
            }
        }
    }

    private void salvaConf(ConfPropertiesLoader props) {
        props.adicionaProperties("fullScreen", String.valueOf(this.chFullScreen.isSelected()));
        if (this.chFullScreen.isSelected()) {
            Main.get().getPrimaryStage().setFullScreen(true);
        } else {
            Main.get().getPrimaryStage().setFullScreen(false);
            Main.get().maximized();
            Main.get().getPrimaryStage().setResizable(true);
            if (StaticObjects.getOpcoes().getEmpresa().getEmpresaDados().getTipoEmpresa().getCodigo() == 6) {
                props.setHeigthMenuScreen(Main.get().getLastControllerPath().getHeight());
                props.setWidthMenuScreen(Main.get().getLastControllerPath().getWidth());
                props.setXMenuScreen(Main.get().getPrimaryStage().getX());
                props.setYMenuScreen(Main.get().getPrimaryStage().getY());
            }
        }
        if (this.dados != null) {
            PrintService selTermica;
            PrintService selLaser = (PrintService)this.cmbImpressoraLaser.getSelectionModel().getSelectedItem();
            if (selLaser != null) {
                this.dados.setNomeImpressoraLaser(selLaser.getName());
            }
            if ((selTermica = (PrintService)this.cmbImpressoraTermica.getSelectionModel().getSelectedItem()) != null) {
                this.dados.setNomeImpressoraTermica(selTermica.getName());
            }
            if (this.chLiberarVenda.isSelected()) {
                this.dados.setTerminalPreVenda((short)1);
            } else {
                this.dados.setTerminalPreVenda((short)0);
            }
            StaticObjects.refreshDadosConfiguracaoLocal(this.dados);
        }
        this.goBack();
    }

    private void realizarTransacoesGerenciais() {
        HashMap<String, Integer> h = new HashMap<String, Integer>();
        h.put("modalidade", 110);
        h.put("retorno", -9999);
        SplashTEFTransacaoGerencial s = new SplashTEFTransacaoGerencial(h);
        s.showAndWait();
        String via1 = (String)h.get("1viaTEF");
        String via2 = (String)h.get("2viaTEF");
        JCliSiTefI j = (JCliSiTefI)h.get("jCliSiTef");
        if (via1 != null && !via1.isEmpty() || via2 != null && !via2.isEmpty()) {
            SplashImpressaoComprovanteTransacaoGerencial imp = new SplashImpressaoComprovanteTransacaoGerencial(h);
            imp.showAndWait();
        }
        if (h.get("impresso") != null && ((Boolean)h.get("impresso")).booleanValue()) {
            int n = new UtilSitefTransacaoGerencial().finalizarTransacaoSiTef(1, j);
        }
    }

    private void cadastrarNovoPeriodoEmissaoNFCe() {
        ServiceTipoEmissaoNFe tp = Main.getBean(ServiceTipoEmissaoNFe.class);
        List<TipoEmissaoNFe> lista = tp.getTipoEmissaoValidoNFCe();
        DialogComboBox dialog = Alerts.showDialogComboBox("Informe o Tipo de Emiss\u00e3o NFC-e", lista);
        switch (dialog.getStatus()) {
            case 0: {
                TipoEmissaoNFe valor = (TipoEmissaoNFe)dialog.getSelectedItem();
                if (valor == null) break;
                StaticObjects.checaExcluiNFCeTemp();
                if (StaticObjects.getNfceAberta() != null) {
                    Alerts.showAlertInfo("Primeiro, finalize a NFCe que est\u00e1 em aberto no sistema e em seguida altere o per\u00edodo de emiss\u00e3o!");
                    return;
                }
                NFCePeriodoEmissao periodo = UtilPeriodoEmissao.criarPeriodoNFCe(StaticObjects.getNFCeCaixa(), valor);
                if (periodo == null) break;
                StaticObjects.setPeriodoEmissaoNFCe(periodo);
                Main.get().getFooterController().atualizaPeriodoEmissaoNFCe();
                break;
            }
        }
    }

    private void validEmissaoProdutos() {
        boolean gerarNFCeTest = false;
        boolean gerarNFeTest = false;
        UnidadeFatCliente unidadeFatSel = null;
        NaturezaOperacao natOpNFCe = null;
        NaturezaOperacao natOpNFe = null;
        if (this.chcGerarNFe.isSelected() || this.chcValidarModeloFiscalNFe.isSelected()) {
            unidadeFatSel = this.getUnidadeFatClienteTest();
        }
        if (this.chcGerarNFCe.isSelected() || this.chcValidarModeloFiscalNFCe.isSelected()) {
            natOpNFCe = this.getNaturezaOperacaoTest(EnumConstantsModeloDocFiscal.NFCE_65.getCodigo());
        }
        if (this.chcGerarNFe.isSelected() || this.chcValidarModeloFiscalNFe.isSelected()) {
            natOpNFe = this.getNaturezaOperacaoTest(EnumConstantsModeloDocFiscal.NFE_55.getCodigo());
        }
        Alerts.showAlertInfo("Este processo pode demorar dependendo do n\u00famero de produtos. Voc\u00ea ser\u00e1 avisado ao final, enquanto isso o sistema ficar\u00e1 travado.");
        File baseDir = new File(ToolFile.getUserDir() + "/output/");
        if (this.chcValidarModeloFiscalNFCe.isSelected() && natOpNFCe != null) {
            this.validarNFCeSemModeloFiscal(baseDir, natOpNFCe);
        }
        if (this.chcValidarModeloFiscalNFe.isSelected() && natOpNFe != null) {
            this.validarNFeSemModeloFiscal(baseDir, unidadeFatSel, natOpNFe);
        }
        if (this.chcGerarNFCe.isSelected() && natOpNFCe != null) {
            this.gerarNFCeNFeTests(natOpNFCe, unidadeFatSel);
        }
        if (this.chcGerarNFe.isSelected() && natOpNFe != null) {
            if (unidadeFatSel == null) {
                Alerts.showAlertError("Voc\u00ea deve informar um cliente para testes.");
                return;
            }
            this.gerarNFCeNFeTests(natOpNFe, unidadeFatSel);
        }
        Platform.runLater(() -> Alerts.showAlertInfo("Processo finalizado. Os arquivos foram gerados no local instala\u00e7\u00e3o do TouchComp NFCe, na pasta output. As Notas Fiscais est\u00e3o na Op\u00e7\u00e3o Inconsist\u00eancias, para envio."));
        Desktop desk = Desktop.getDesktop();
        try {
            desk.open(baseDir);
        }
        catch (IOException ex) {
            Logger.getLogger(OutrasOpcoesController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void validarNFCeSemModeloFiscal(File baseDir, NaturezaOperacao natOp) {
        try {
            new AuxValidaProdutosSemModelo().validaProdutosSemModeloNFCe(baseDir, StaticObjects.getOpcoes(), natOp);
        }
        catch (ExceptionIO ex) {
            Logger.getLogger(OutrasOpcoesController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError("Erro ao validar/checar produtos relativo ao modelo fiscal: " + ex.getMessage());
        }
    }

    private void validarNFeSemModeloFiscal(File baseDir, UnidadeFatCliente selected, NaturezaOperacao natOp) {
        try {
            new AuxValidaProdutosSemModelo().validaProdutosSemModeloNFe(baseDir, StaticObjects.getOpcoes(), selected, natOp);
        }
        catch (ExceptionIO ex) {
            Logger.getLogger(OutrasOpcoesController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError("Erro ao validar/checar produtos relativo ao modelo fiscal: " + ex.getMessage());
        }
    }

    private void gerarNFCeNFeTests(NaturezaOperacao nat, UnidadeFatCliente unidade) {
        try {
            ServiceTabelaPrecoBase serviceTabPreco = Main.getBean(ServiceTabelaPrecoBase.class);
            StringBuilder sb = new StringBuilder();
            NFCe nfce = null;
            TabelaPrecoBase tabela = StaticObjects.getOpcoes().getTabelaPrecoBase();
            if (tabela == null) {
                tabela = this.getTabelaPreco();
            }
            if (tabela == null) {
                Alerts.showAlertError("Tabela de Pre\u00e7o n\u00e3o encontrada para a empresa: " + String.valueOf(StaticObjects.getEmpresa()));
                return;
            }
            if (StaticObjects.getNFCeCaixa() == null) {
                Alerts.showAlertError("Nenhum caixa logado, para iniciar os testes nesta empresa: " + String.valueOf(StaticObjects.getEmpresa()));
                return;
            }
            int i = 0;
            LinkedList<TabelaPrecoBaseProduto> produtos = new LinkedList<TabelaPrecoBaseProduto>();
            produtos.addAll(tabela.getProdutos());
            if (tabela.getTabelaPrecoVinculada() != null) {
                produtos.addAll(tabela.getTabelaPrecoVinculada().getProdutos());
            }
            if (tabela == null) {
                return;
            }
            for (TabelaPrecoBaseProduto tabProd : produtos) {
                if (nfce == null) {
                    nfce = UtilNFCe.createNFCeModelo65(nat, unidade);
                }
                GradeCor gradeCor = null;
                if (tabProd.getProduto().getProdutoGrade() != null && tabProd.getProduto().getProdutoGrade().getGradesCores().size() > 0) {
                    gradeCor = tabProd.getProduto().getProdutoGrade().getGradesCores().get(0);
                }
                ModeloFiscal modeloFiscal = null;
                modeloFiscal = new AuxModeloFiscal().getModeloFiscalNFCe(tabProd.getProduto(), unidade, null, null, nfce.getNaturezaOperacao(), nfce.getEmpresa(), false);
                boolean createItem = true;
                if (gradeCor == null) {
                    sb.append("Produto sem grades " + String.valueOf(tabProd.getProduto()));
                    createItem = false;
                }
                if (modeloFiscal == null) {
                    sb.append("Produto sem modelo fiscal " + String.valueOf(tabProd.getProduto()));
                    createItem = false;
                }
                if (createItem) {
                    NFCeItem item = new NFCeItem();
                    UtilNFCe.getNewNFCeItem(item, nfce, gradeCor, modeloFiscal, 1.0, 0.0, tabProd.getValorVenda(), tabProd.getValorCusto(), 0.0, StaticObjects.getOpcoes().getCentroEstoque(), null, false);
                    nfce.getItens().add(item);
                }
                if (nfce.getItens().size() > 0 && nfce.getItens().size() % 600 == 0) {
                    UtilNFCeCalculos.calcularValores(nfce);
                    StaticObjects.refreshNFCe(nfce);
                    nfce = null;
                }
                System.out.println("Item " + ++i + "/" + produtos.size());
            }
            if (nfce != null && nfce.getItens().size() > 0) {
                UtilNFCeCalculos.calcularValores(nfce);
                StaticObjects.refreshNFCe(nfce);
                nfce = null;
            }
            if (sb.length() > 0) {
                Alerts.showAlertInfo(sb.toString());
            }
        }
        catch (ExceptionImpostoPisCofins ex) {
            Logger.getLogger(OutrasOpcoesController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
        catch (ExceptionImpostoIcms ex) {
            Logger.getLogger(OutrasOpcoesController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
        catch (ExceptionImpostoIPI ex) {
            Logger.getLogger(OutrasOpcoesController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
        catch (Exception ex) {
            Logger.getLogger(OutrasOpcoesController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
    }

    private TabelaPrecoBase getTabelaPreco() {
        List tabs = Main.getBean(ServiceTabelaPrecoBase.class).getAll();
        return Alerts.showQuestion("Selecione uma tabela de pre\u00e7os", tabs.toArray(), TabelaPrecoBase.class);
    }

    private UnidadeFatCliente getUnidadeFatClienteTest() {
        String cpfCnpj = Alerts.showAlertInput("Informe o CPF/CNPJ do cliente.");
        Cliente c = Main.getBean(ServiceCliente.class).getClient(ToolString.refina((String)cpfCnpj));
        if (c != null) {
            return Alerts.showQuestion("Selecione uma unidade de Faturamento", c.getUnidadeFatClientes().toArray(), UnidadeFatCliente.class);
        }
        return null;
    }

    private void cadastrarNovoPeriodoEmissaoNFe() {
        ServiceTipoEmissaoNFe tp = Main.getBean(ServiceTipoEmissaoNFe.class);
        List<TipoEmissaoNFe> lista = tp.getTipoEmissaoValidoNFe();
        DialogComboBox dialog = Alerts.showDialogComboBox("Informe o Tipo de Emiss\u00e3o NF-e", lista);
        switch (dialog.getStatus()) {
            case 0: {
                TipoEmissaoNFe valor = (TipoEmissaoNFe)dialog.getSelectedItem();
                if (valor == null) break;
                StaticObjects.checaExcluiNFCeTemp();
                if (StaticObjects.getNfceAberta() != null) {
                    Alerts.showAlertInfo("Primeiro, finalize a NFe que est\u00e1 em aberto no sistema e em seguida altere o per\u00edodo de emiss\u00e3o!");
                    return;
                }
                PeriodoEmissaoNFe periodo = UtilPeriodoEmissao.criarPeriodoNFe(StaticObjects.getNFCeCaixa(), valor);
                if (periodo == null) break;
                StaticObjects.setPeriodoEmissaoNFe(periodo);
                Main.get().getFooterController().atualizaPeriodoEmissaoNFe();
                break;
            }
        }
    }

    private PrintService[] impressorasRedesLocais() {
        return PrintServiceLookup.lookupPrintServices(null, null);
    }

    private void setComboBoxImpressoras() {
        this.cmbImpressoraLaser.setLabel(this.lblImpressoraLaser);
        this.cmbImpressoraTermica.setLabel(this.lblImpressoraTermica);
        this.dados = StaticObjects.getDadosConfiguracaoLocal();
        this.cmbImpressoraLaser.setItems(FXCollections.observableArrayList((Object[])this.impressorasRedesLocais()));
        if (this.dados.getNomeImpressoraLaser() != null && !this.dados.getNomeImpressoraLaser().isEmpty()) {
            this.cmbImpressoraLaser.getSelectionModel().select(this.getImpressoraByNome(this.dados.getNomeImpressoraLaser()));
        }
        this.cmbImpressoraTermica.setItems(FXCollections.observableArrayList((Object[])this.impressorasRedesLocais()));
        if (this.dados.getNomeImpressoraTermica() != null && !this.dados.getNomeImpressoraTermica().isEmpty()) {
            this.cmbImpressoraTermica.getSelectionModel().select(this.getImpressoraByNome(this.dados.getNomeImpressoraTermica()));
        }
        this.chLiberarVenda.setSelected(ToolMethods.isEquals((Object)this.dados.getTerminalPreVenda(), (Object)1));
    }

    private Object getImpressoraByNome(String nome) {
        PrintService[] aux = this.impressorasRedesLocais();
        for (int i = 0; i < aux.length; ++i) {
            PrintService pf = aux[i];
            if (!pf.getName().equalsIgnoreCase(nome)) continue;
            return pf;
        }
        return null;
    }

    private NaturezaOperacao getNaturezaOperacaoTest(String codModDoc) {
        ServiceNaturezaOperacao service = Main.getBean(ServiceNaturezaOperacao.class);
        List<NaturezaOperacao> list = service.getAllNuterezaOperacaoDisponivelNFCe(StaticObjects.getEmpresa().getIdentificador());
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return Alerts.showQuestion("Selecione uma Natureza de Opera\u00e7\u00e3o", list.toArray(), NaturezaOperacao.class);
    }

    private void desabilitarConsultasTerminalPDV() {
        NFCeOpcoes op = StaticObjects.getOpcoes();
        String senha = Alerts.showAlertInputMask("Informe a senha de seguran\u00e7a para desabilitar consultas ao ERP!");
        if (!ToolMethods.isEquals((Object)op.getSenhaSeguranca(), (Object)senha)) {
            Alerts.showAlertError("Senha para desabilitar consultas ao ERP est\u00e1 incorreta!");
            op.setBloquearSenhaSeguranca((short)1);
        } else {
            op.setBloquearSenhaSeguranca((short)0);
            Alerts.showAlertInfo("Consultas ao ERP est\u00e3o temporariamente desativadas! Tenha cuidado, e volte com as consultas assim que poss\u00edvel!");
        }
        ServiceNFCeOpcoes serviceNFCe = Main.getBean(ServiceNFCeOpcoes.class);
        op = serviceNFCe.save(op);
        StaticObjects.setOpcoes(op);
    }
}

