/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.opcoessincronizacao;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.components.TouchCheckBox;
import com.touchcomp.touchnfce.components.TouchPasswordField;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.model.ServidorSincronizacao;
import com.touchcomp.touchnfce.utils.MaskField;
import java.util.HashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;

public class NovoServidorController
extends BaseDialog {
    @FXML
    TouchTextField tfIpServidor;
    @FXML
    TouchTextField tfPortaServidor;
    @FXML
    TouchTextField tfIpServidorProxy;
    @FXML
    TouchTextField tfUsuario;
    @FXML
    TouchTextField tfPortaServidorProxy;
    @FXML
    TouchPasswordField pfSenhaProxy;
    @FXML
    Label llblIpServidor;
    @FXML
    Label llblPortaServidor;
    @FXML
    Label lblIpServidorProxy;
    @FXML
    Label lblUsuario;
    @FXML
    Label lblPortaServidorProxy;
    @FXML
    Label lblSenha;
    @FXML
    TouchCheckBox possuiProxy;
    @FXML
    TouchCheckBox possuiAutenticacao;
    @FXML
    Button btnConfirmar;
    @FXML
    Button btnCancelar;
    @FXML
    AnchorPane body;
    private ServidorSincronizacao servidor;

    @Override
    public void initializeController(ResourceBundle resources) {
        this.configureFields();
        this.btnConfirmar.setOnAction(event -> this.confirmar());
        this.btnCancelar.setOnAction(evt -> this.closeDialog());
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt != null) {
            switch (evt.getCode()) {
                case F1: {
                    this.confirmar();
                    break;
                }
                case ESCAPE: {
                    this.closeDialog();
                    break;
                }
            }
        }
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void requestFocusOnOpen() {
    }

    public ServidorSincronizacao getServidor() {
        return this.servidor;
    }

    private void configureFields() {
        this.tfPortaServidor.textProperty().addListener((observableValue, antigo, novo) -> {
            if (novo.length() <= 4) {
                this.tfPortaServidor.setText(MaskField.onlyDigitsIntValue(this.tfPortaServidor));
            } else {
                this.tfPortaServidor.setText((String)antigo);
            }
        });
        this.tfPortaServidorProxy.textProperty().addListener((observableValue, antigo, novo) -> {
            if (novo.length() <= 4) {
                this.tfPortaServidor.setText(MaskField.onlyDigitsIntValue(this.tfPortaServidor));
            } else {
                this.tfPortaServidor.setText((String)antigo);
            }
        });
        this.possuiProxy.setOnAction(event -> {
            if (this.possuiProxy.isSelected()) {
                this.habilitaFieldsProxy();
                this.desabilitaFieldsAutent();
            } else {
                this.desabilitaFieldsProxy();
            }
        });
        this.possuiAutenticacao.setOnAction(event -> {
            if (this.possuiAutenticacao.isSelected()) {
                this.habilitaFieldsAutent();
            } else {
                this.desabilitaFieldsAutent();
            }
        });
        this.tfIpServidor.setLabel(this.llblIpServidor);
        this.tfPortaServidor.setLabel(this.llblPortaServidor);
        this.tfIpServidorProxy.setLabel(this.lblIpServidorProxy);
        this.tfPortaServidorProxy.setLabel(this.lblPortaServidorProxy);
        this.tfUsuario.setLabel(this.lblUsuario);
        this.pfSenhaProxy.setLabel(this.lblSenha);
        this.tfIpServidorProxy.setDisable(true);
        this.tfPortaServidorProxy.setDisable(true);
        this.tfUsuario.setDisable(true);
        this.pfSenhaProxy.setDisable(true);
    }

    private void desabilitaFieldsProxy() {
        this.possuiAutenticacao.setSelected(false);
        this.possuiAutenticacao.setDisable(true);
        this.tfIpServidorProxy.setDisable(true);
        this.tfIpServidorProxy.setText("");
        this.tfPortaServidorProxy.setDisable(true);
        this.tfPortaServidorProxy.setText("");
        this.tfUsuario.setDisable(true);
        this.tfUsuario.setText("");
        this.pfSenhaProxy.setDisable(true);
        this.pfSenhaProxy.setText("");
    }

    private void habilitaFieldsProxy() {
        this.possuiAutenticacao.setDisable(false);
        this.tfIpServidorProxy.setDisable(false);
        this.tfPortaServidorProxy.setDisable(false);
        this.tfUsuario.setDisable(false);
        this.pfSenhaProxy.setDisable(false);
    }

    private void desabilitaFieldsAutent() {
        this.tfUsuario.setDisable(true);
        this.tfUsuario.setText("");
        this.pfSenhaProxy.setDisable(true);
        this.pfSenhaProxy.setText("");
    }

    private void habilitaFieldsAutent() {
        this.tfUsuario.setDisable(false);
        this.pfSenhaProxy.setDisable(false);
    }

    private void confirmar() {
        ServidorSincronizacao servidorSincronizacao = this.novoServidor();
        HashMap<String, ServidorSincronizacao> data = new HashMap<String, ServidorSincronizacao>();
        data.put("servidorSincronizacao", servidorSincronizacao);
        this.closeDialog();
    }

    private ServidorSincronizacao novoServidor() {
        if (this.isValidBefore()) {
            this.servidor = new ServidorSincronizacao();
            this.servidor.setIp(this.tfIpServidor.getText());
            this.servidor.setPorta(Integer.parseInt(this.tfPortaServidor.getText()));
            this.servidor.setPossuiProxy(this.possuiProxy.isSelected() ? EnumConstantsMentorSimNao.SIM.getValue() : EnumConstantsMentorSimNao.NAO.getValue());
            this.servidor.setPossuiAutenticacaoProxy(this.possuiAutenticacao.isSelected() ? EnumConstantsMentorSimNao.SIM.getValue() : EnumConstantsMentorSimNao.NAO.getValue());
            this.servidor.setPrincipal(EnumConstantsMentorSimNao.NAO.getValue());
            if (this.possuiProxy.isSelected()) {
                this.servidor.setServidorProxy(this.tfIpServidorProxy.getText());
                this.servidor.setPortaServidorProxy(Integer.parseInt(this.tfPortaServidorProxy.getText()));
                if (this.possuiAutenticacao.isSelected()) {
                    this.servidor.setUsuarioProxy(this.tfUsuario.getText());
                    this.servidor.setSenhaProxy(this.pfSenhaProxy.getText());
                }
            }
            return this.servidor;
        }
        return null;
    }

    private boolean isValidBefore() {
        if (this.tfIpServidor.getText() == null || this.tfIpServidor.getText().isEmpty()) {
            Alerts.showAlertInfo("Campo Servidor \u00e9 obrigat\u00f3rio. ");
            return false;
        }
        if (this.tfPortaServidor.getText() == null || this.tfPortaServidor.getText().isEmpty()) {
            Alerts.showAlertInfo("Campo Porta Servidor \u00e9 obrigat\u00f3rio.");
            return false;
        }
        try {
            Long.valueOf(this.tfPortaServidor.getText());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Alerts.showAlertInfo("Valor informado na Porta Servidor \u00e9 inv\u00e1lido.");
            return false;
        }
        if (this.possuiProxy.isSelected()) {
            if (this.tfIpServidorProxy.getText() == null || this.tfIpServidorProxy.getText().isEmpty()) {
                Alerts.showAlertInfo("Campo Servidor Proxy \u00e9 obrigat\u00f3rio. ");
                return false;
            }
            if (this.tfPortaServidorProxy.getText() == null || this.tfPortaServidorProxy.getText().isEmpty()) {
                Alerts.showAlertInfo("Campo Porta Servidor Proxy \u00e9 obrigat\u00f3rio.");
                return false;
            }
            try {
                Long.valueOf(this.tfPortaServidorProxy.getText());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Alerts.showAlertInfo("Valor informado na Porta Servidor Proxy \u00e9 inv\u00e1lido.");
                return false;
            }
            if (this.possuiAutenticacao.isSelected()) {
                if (this.tfUsuario.getText() == null || this.tfUsuario.getText().isEmpty()) {
                    Alerts.showAlertInfo("Campo usu\u00e1rio \u00e9 obrigat\u00f3rio. ");
                    return false;
                }
                if (this.pfSenhaProxy.getText() == null || this.pfSenhaProxy.getText().isEmpty()) {
                    Alerts.showAlertInfo("Campo senha \u00e9 obrigat\u00f3rio.");
                    return false;
                }
            }
        }
        return true;
    }
}

