/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.opcoessincronizacao;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.others.cpfcnpj.ValidadeCPFCNPJ;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.TouchCheckBox;
import com.touchcomp.touchnfce.components.TouchPasswordField;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.BaseController;
import com.touchcomp.touchnfce.controller.nfce.PesquisaNFCeController;
import com.touchcomp.touchnfce.controller.opcoessincronizacao.NovoServidorController;
import com.touchcomp.touchnfce.model.DadosSincronizacao;
import com.touchcomp.touchnfce.model.ServidorSincronizacao;
import com.touchcomp.touchnfce.service.impl.ServiceServidorSincronizacao;
import com.touchcomp.touchnfce.sinc.receive.SincOthers;
import com.touchcomp.touchnfce.utils.MaskField;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;

public class OpcoesSincronizacaoController
extends BaseController {
    @FXML
    private Label lblIpServidor;
    @FXML
    private Label lblPortaServidor;
    @FXML
    private Label lblCnpjEmp;
    @FXML
    private Label lblIpServidorProxy;
    @FXML
    private Label lblPortaServidorProxy;
    @FXML
    private Label lblUsuario;
    @FXML
    private Label lblSenha;
    @FXML
    private Label lblMac;
    @FXML
    private Label lblServidorTouch;
    @FXML
    private TouchTextField tfIpServidor;
    @FXML
    private TouchTextField tfPortaServidor;
    @FXML
    private TouchTextField tfCnpjEmp;
    @FXML
    private TouchTextField tfIpServidorProxy;
    @FXML
    private TouchTextField tfPortaServidorProxy;
    @FXML
    private TouchTextField tfUsuario;
    @FXML
    private TouchTextField tfServidorTouch;
    @FXML
    private TouchPasswordField pfSenhaProxy;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnAutoConfigurar;
    @FXML
    private Button btnCancelar;
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnRemover;
    @FXML
    private Button btnSubir;
    @FXML
    private Button btnDescer;
    @FXML
    private AnchorPane body;
    @FXML
    private TouchCheckBox possuiProxy;
    @FXML
    private TouchCheckBox possuiAutenticacao;
    @FXML
    private TabPane tabPaneConfiguracao;
    @FXML
    private Tab tabConfManual;
    @FXML
    private Tab tabAutoConf;
    @FXML
    private TableView<ServidorSincronizacao> tblServidoresReservas;
    @FXML
    private TableColumn<ServidorSincronizacao, String> columnIpServidor;
    @FXML
    private TableColumn<ServidorSincronizacao, String> columnPortaServidor;
    @FXML
    private TableColumn<ServidorSincronizacao, String> columnSequencia;
    private boolean modified = false;

    private void setupTable() {
        this.columnIpServidor.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ServidorSincronizacao, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ServidorSincronizacao, String> param) {
                return new SimpleObjectProperty((Object)((ServidorSincronizacao)param.getValue()).getIp());
            }
        });
        this.columnPortaServidor.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ServidorSincronizacao, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ServidorSincronizacao, String> param) {
                return new SimpleObjectProperty((Object)((ServidorSincronizacao)param.getValue()).getPorta().toString());
            }
        });
        this.columnSequencia.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ServidorSincronizacao, String>, ObservableValue<String>>(this){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ServidorSincronizacao, String> param) {
                return new SimpleObjectProperty((Object)((ServidorSincronizacao)param.getValue()).getSequencia().toString());
            }
        });
        this.tblServidoresReservas.getSortOrder().addAll((Object[])new TableColumn[]{this.columnSequencia});
        this.tblServidoresReservas.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
    }

    @Override
    protected void initializeController(ResourceBundle rb) {
        this.lblMac.setText(this.lblMac.getText() + OpcoesSincronizacaoController.getMacAddress());
        this.btnConfirmar.setOnAction(event -> this.salvarDadosProperties());
        this.btnCancelar.setOnAction(evt -> {
            this.ordenarSequencia(StaticObjects.getDadosSincronizacao());
            this.goBack();
        });
        this.btnSubir.setOnAction(evt -> this.up());
        this.btnDescer.setOnAction(evt -> this.down());
        this.btnRemover.setOnAction(evt -> this.delete());
        this.btnNovo.setOnAction(evt -> this.novoServidorReserva());
        this.currentToScreen();
        this.desabilitaFieldsProxy();
        this.modifiedFields();
        this.setLabelsTextField();
        this.setupTable();
    }

    private void novoServidorReserva() {
        this.modified = true;
        NovoServidorController controller = (NovoServidorController)Main.get().showDialog(Controllers.CADASTRO_SERVIDOR);
        if (controller.getServidor() != null) {
            controller.getServidor().setSequencia(this.tblServidoresReservas.getItems().size());
            this.tblServidoresReservas.getItems().add((Object)controller.getServidor());
            this.sortTable();
        }
    }

    private void setLabelsTextField() {
        this.tfCnpjEmp.setLabel(this.lblCnpjEmp);
        this.tfIpServidor.setLabel(this.lblIpServidor);
        this.tfIpServidorProxy.setLabel(this.lblIpServidorProxy);
        this.tfPortaServidor.setLabel(this.lblPortaServidor);
        this.tfPortaServidorProxy.setLabel(this.lblPortaServidorProxy);
        this.tfServidorTouch.setLabel(this.lblServidorTouch);
        this.tfUsuario.setLabel(this.lblUsuario);
        this.pfSenhaProxy.setLabel(this.lblSenha);
    }

    @Override
    public void goBack() {
        if (StaticObjects.getUltimaPagina().equals(Controllers.LOGIN)) {
            Main.get().mudaTela(Controllers.LOGIN);
        } else {
            super.goBack();
        }
    }

    @Override
    protected void requestFocusOnOpen() {
    }

    private void ordenarSequencia(DadosSincronizacao vo) {
        if (vo.getServidores() != null) {
            Integer sequencia = 0;
            for (ServidorSincronizacao s : vo.getServidores()) {
                if (ToolMethods.isAffirmative((Number)s.getPrincipal())) continue;
                s.setSequencia(sequencia);
                Integer n = sequencia;
                sequencia = sequencia + 1;
            }
        }
    }

    private void modifiedFields() {
        this.tfPortaServidor.textProperty().addListener((observableValue, antigo, novo) -> {
            if (novo.length() <= 4) {
                this.tfPortaServidor.setText(MaskField.onlyDigitsIntValue(this.tfPortaServidor));
            } else {
                this.tfPortaServidor.setText((String)antigo);
            }
            this.modified = true;
        });
        this.tfPortaServidorProxy.textProperty().addListener((observableValue, antigo, novo) -> {
            if (novo.length() <= 4) {
                this.tfPortaServidor.setText(MaskField.onlyDigitsIntValue(this.tfPortaServidor));
            } else {
                this.tfPortaServidor.setText((String)antigo);
            }
            this.modified = true;
        });
        this.tfIpServidor.textProperty().addListener((observableValue, antigo, novo) -> {
            this.modified = true;
        });
        this.tfIpServidorProxy.textProperty().addListener((observableValue, antigo, novo) -> {
            this.modified = true;
        });
        this.pfSenhaProxy.textProperty().addListener((observableValue, antigo, novo) -> {
            this.modified = true;
        });
        this.tfServidorTouch.textProperty().addListener((observableValue, antigo, novo) -> {
            this.modified = true;
        });
        this.possuiProxy.setOnAction(event -> {
            if (this.possuiProxy.isSelected()) {
                this.habilitaFieldsProxy();
                this.desabilitaFieldsAutent();
            } else {
                this.desabilitaFieldsProxy();
            }
            this.modified = true;
        });
        this.possuiAutenticacao.setOnAction(event -> {
            if (this.possuiAutenticacao.isSelected()) {
                this.habilitaFieldsAutent();
            } else {
                this.desabilitaFieldsAutent();
            }
            this.modified = true;
        });
    }

    private void currentToScreen() {
        DadosSincronizacao dadosSincronizacao = StaticObjects.getDadosSincronizacao();
        this.tfCnpjEmp.setText(dadosSincronizacao.getCnpjEmpresa());
        if (ToolMethods.isEquals((Object)dadosSincronizacao.getSincronizadoCompeletamente(), (Object)1)) {
            this.tfCnpjEmp.setEditable(false);
        }
        this.setServidorPrincipal(dadosSincronizacao);
    }

    private void setServidorPrincipal(DadosSincronizacao vo) {
        ArrayList<ServidorSincronizacao> reservas = new ArrayList<ServidorSincronizacao>();
        if (vo != null && vo.getServidores() != null) {
            for (ServidorSincronizacao s : vo.getServidores()) {
                if (ToolMethods.isAffirmative((Number)s.getPrincipal())) {
                    this.tfIpServidor.setText(s.getIp());
                    this.tfPortaServidor.setText(String.valueOf(s.getPorta()));
                    this.possuiProxy.setSelected(s.getPossuiProxy() != null && s.getPossuiProxy() == 1);
                    this.tfIpServidorProxy.setText(s.getServidorProxy());
                    this.tfPortaServidorProxy.setText(String.valueOf(s.getPortaServidorProxy()));
                    this.possuiAutenticacao.setSelected(s.getPossuiAutenticacaoProxy() != null && s.getPossuiAutenticacaoProxy() == 1);
                    this.tfUsuario.setText(s.getUsuarioProxy());
                    this.pfSenhaProxy.setText(s.getSenhaProxy());
                    continue;
                }
                reservas.add(s);
            }
            this.tblServidoresReservas.setItems(FXCollections.observableList(reservas));
            this.sortTable();
        }
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKey(KeyEvent evt) {
        switch (evt.getCode()) {
            case F12: {
                this.salvarDadosProperties();
                this.goBack();
                break;
            }
            case F2: {
                this.tabPaneConfiguracao.getSelectionModel().select((Object)this.tabConfManual);
                break;
            }
            case F3: {
                this.tabPaneConfiguracao.getSelectionModel().select((Object)this.tabAutoConf);
                break;
            }
            case F4: {
                this.tblServidoresReservas.requestFocus();
                this.tblServidoresReservas.getSelectionModel().selectFirst();
                break;
            }
            case F5: {
                this.novoServidorReserva();
                break;
            }
            case F6: {
                this.delete();
                break;
            }
            case F7: {
                this.up();
                break;
            }
            case F8: {
                this.down();
                break;
            }
            case ESCAPE: {
                this.goBack();
                break;
            }
        }
    }

    private void salvarDadosProperties() {
        if (this.modified) {
            try {
                String cnpj;
                String porta;
                if (!this.isvalidContinue()) {
                    return;
                }
                Optional<ButtonType> type = Alerts.showQuestion("Voc\u00ea modificou as configura\u00e7\u00f5es de sincroniza\u00e7\u00e3o. Continuar mesmo assim?");
                if (type.get() != ButtonType.OK) {
                    return;
                }
                String servidor = this.tfIpServidor.getText();
                Long idEmpresa = this.getIdEmpresa(servidor, porta = this.tfPortaServidor.getText(), cnpj = ToolString.onlyNumbers((String)this.tfCnpjEmp.getText()));
                if (idEmpresa == null || idEmpresa <= 0L) {
                    Alerts.showAlertInfo("N\u00e3o foi encontrado nenhuma empresa no servidor informado com este CNPJ.");
                    return;
                }
                DadosSincronizacao dadosSincronizacao = StaticObjects.getDadosSincronizacao();
                dadosSincronizacao.setServidor(this.tfIpServidor.getText());
                dadosSincronizacao.setAppConfigurado((short)1);
                dadosSincronizacao.setPortaServidor(Integer.valueOf(this.tfPortaServidor.getText()));
                dadosSincronizacao.setIdEmpresa(idEmpresa);
                dadosSincronizacao.setCnpjEmpresa(ToolString.onlyNumbers((String)this.tfCnpjEmp.getText()));
                dadosSincronizacao.setPossuiProxy(this.possuiProxy.isSelected() ? (short)1 : 0);
                dadosSincronizacao.setServidorProxy(this.tfIpServidorProxy.getText());
                if (this.tfPortaServidorProxy.getText() != null && this.tfPortaServidorProxy.getText().length() > 0) {
                    dadosSincronizacao.setPortaServidorProxy(Integer.valueOf(this.tfPortaServidorProxy.getText()));
                } else {
                    dadosSincronizacao.setPortaServidorProxy(8080);
                }
                dadosSincronizacao.setPossuiAutenticacaoProxy(this.possuiAutenticacao.isSelected() ? (short)1 : 0);
                dadosSincronizacao.setUsuarioProxy(this.tfUsuario.getText());
                dadosSincronizacao.setSenhaProxy(this.pfSenhaProxy.getText());
                this.getServidores(dadosSincronizacao);
                this.ordenarSequencia(dadosSincronizacao);
                StaticObjects.refreshDadosSincronizacao();
                type = Alerts.showQuestion("Aten\u00e7\u00e3o: ser\u00e1 preciso reiniciar a aplica\u00e7\u00e3o para nova sincroniza\u00e7\u00e3o. Deseja sair agora?");
                if (type.get() == ButtonType.OK) {
                    System.exit(0);
                }
            }
            catch (Exception ex) {
                Logger.getLogger(OpcoesSincronizacaoController.class.getName()).log(Level.SEVERE, null, ex);
                Alerts.showAlertError(ex.getMessage());
                return;
            }
        }
        Main.get().mudaTela(Controllers.MENU_PRINCIPAL);
    }

    @Override
    public void paramsData(Class<? extends BaseController> aClass, Map data) {
        ServidorSincronizacao servidorReserva;
        if (PesquisaNFCeController.class.equals(aClass) && (servidorReserva = (ServidorSincronizacao)data.get("servidor")) != null) {
            this.modified = true;
            Platform.runLater(() -> this.tblServidoresReservas.getItems().add((Object)servidorReserva));
        }
    }

    private ServidorSincronizacao getServidorPricipal(DadosSincronizacao vo) {
        if (vo.getServidores() != null) {
            for (ServidorSincronizacao s : vo.getServidores()) {
                if (!ToolMethods.isAffirmative((Number)s.getPrincipal())) continue;
                return s;
            }
        }
        return null;
    }

    private void getServidores(DadosSincronizacao vo) {
        ArrayList<ServidorSincronizacao> servidores = new ArrayList<ServidorSincronizacao>();
        ServidorSincronizacao servidorPrincipal = this.getServidorPricipal(vo);
        if (servidorPrincipal == null) {
            servidorPrincipal = new ServidorSincronizacao();
        }
        servidorPrincipal.setPrincipal(EnumConstantsMentorSimNao.SIM.getValue());
        servidorPrincipal.setIp(this.tfIpServidor.getText());
        servidorPrincipal.setPorta(Integer.parseInt(this.tfPortaServidor.getText()));
        servidorPrincipal.setPossuiProxy(this.possuiProxy.isSelected() ? EnumConstantsMentorSimNao.SIM.getValue() : EnumConstantsMentorSimNao.NAO.getValue());
        if (this.possuiProxy.isSelected()) {
            servidorPrincipal.setServidorProxy(this.tfIpServidorProxy.getText());
            servidorPrincipal.setPortaServidorProxy(Integer.parseInt(this.tfPortaServidorProxy.getText()));
            if (this.possuiAutenticacao.isSelected()) {
                servidorPrincipal.setUsuarioProxy(this.tfUsuario.getText());
                servidorPrincipal.setSenhaProxy(this.pfSenhaProxy.getText());
            }
        }
        servidores.add(servidorPrincipal);
        if (!this.tblServidoresReservas.getItems().isEmpty()) {
            for (ServidorSincronizacao s : this.tblServidoresReservas.getItems()) {
                s.setPrincipal(EnumConstantsMentorSimNao.NAO.getValue());
                s.setDadosSincronizacao(vo);
            }
            servidores.addAll((Collection<ServidorSincronizacao>)this.tblServidoresReservas.getItems());
        }
        vo.setServidores(servidores);
    }

    private void up() {
        this.modified = true;
        ServidorSincronizacao servidorUp = (ServidorSincronizacao)this.tblServidoresReservas.getSelectionModel().getSelectedItem();
        if (servidorUp != null && servidorUp.getSequencia() > 0 && this.tblServidoresReservas.getSelectionModel().getSelectedIndex() > 0) {
            Integer indexOrg = this.tblServidoresReservas.getSelectionModel().getSelectedIndex();
            Integer indexDest = indexOrg - 1;
            ServidorSincronizacao servidorDown = (ServidorSincronizacao)this.tblServidoresReservas.getItems().get(this.tblServidoresReservas.getSelectionModel().getSelectedIndex() - 1);
            servidorDown.setSequencia(servidorUp.getSequencia());
            this.tblServidoresReservas.getItems().set(indexDest.intValue(), (Object)servidorUp);
            servidorUp.setSequencia(servidorUp.getSequencia() - 1);
            this.tblServidoresReservas.getItems().set(indexOrg.intValue(), (Object)servidorDown);
            this.sortTable();
        }
    }

    private void down() {
        this.modified = true;
        ServidorSincronizacao servidorDown = (ServidorSincronizacao)this.tblServidoresReservas.getSelectionModel().getSelectedItem();
        if (servidorDown != null && this.tblServidoresReservas.getSelectionModel().getSelectedIndex() < this.tblServidoresReservas.getItems().size() - 1) {
            Integer indexOrg = this.tblServidoresReservas.getSelectionModel().getSelectedIndex();
            Integer indexDest = indexOrg + 1;
            ServidorSincronizacao servidorUp = (ServidorSincronizacao)this.tblServidoresReservas.getItems().get(this.tblServidoresReservas.getSelectionModel().getSelectedIndex() + 1);
            servidorUp.setSequencia(servidorDown.getSequencia());
            this.tblServidoresReservas.getItems().set(indexDest.intValue(), (Object)servidorDown);
            servidorDown.setSequencia(servidorDown.getSequencia() + 1);
            this.tblServidoresReservas.getItems().set(indexOrg.intValue(), (Object)servidorUp);
            this.sortTable();
        }
    }

    private void delete() {
        EnumConstantsMentorSimNao result;
        if (this.tblServidoresReservas.getSelectionModel().getSelectedItem() != null && StaticObjects.getDadosSincronizacao().getServidores() != null && (result = Alerts.showQuestionYesNo("", "Tem certeza que deseja excluir esse servidor?", "", Main.get().getPrimaryStage())) != null && ToolMethods.isAffirmative((Number)result.getValue())) {
            ServiceServidorSincronizacao service = Main.getBean(ServiceServidorSincronizacao.class);
            service.delete((ServidorSincronizacao)this.tblServidoresReservas.getSelectionModel().getSelectedItem());
            StaticObjects.getDadosSincronizacao().getServidores().remove(this.tblServidoresReservas.getSelectionModel().getSelectedItem());
            this.tblServidoresReservas.getItems().remove(this.tblServidoresReservas.getSelectionModel().getSelectedItem());
            for (int i = 0; i < this.tblServidoresReservas.getItems().size(); ++i) {
                ((ServidorSincronizacao)this.tblServidoresReservas.getItems().get(i)).setSequencia(i);
            }
            this.sortTable();
        }
    }

    private void sortTable() {
        Platform.runLater(() -> this.tblServidoresReservas.refresh());
    }

    private void desabilitaFieldsProxy() {
        this.possuiAutenticacao.setSelected(false);
        this.possuiAutenticacao.setDisable(true);
        this.tfIpServidorProxy.setDisable(true);
        this.tfIpServidorProxy.setText("");
        this.tfPortaServidorProxy.setDisable(true);
        this.tfPortaServidorProxy.setText("");
        this.tfUsuario.setDisable(true);
        this.tfUsuario.setText("");
        this.pfSenhaProxy.setDisable(true);
        this.pfSenhaProxy.setText("");
    }

    private void habilitaFieldsProxy() {
        this.possuiAutenticacao.setDisable(false);
        this.tfIpServidorProxy.setDisable(false);
        this.tfPortaServidorProxy.setDisable(false);
        this.tfUsuario.setDisable(false);
        this.pfSenhaProxy.setDisable(false);
    }

    private void desabilitaFieldsAutent() {
        this.tfUsuario.setDisable(true);
        this.tfUsuario.setText("");
        this.pfSenhaProxy.setDisable(true);
        this.pfSenhaProxy.setText("");
    }

    private void habilitaFieldsAutent() {
        this.tfUsuario.setDisable(false);
        this.pfSenhaProxy.setDisable(false);
    }

    public static String getMacAddress() {
        try {
            ArrayList<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface nif : all) {
                if (!nif.getName().equalsIgnoreCase("wlan0")) continue;
                byte[] macBytes = nif.getHardwareAddress();
                if (macBytes == null) {
                    return "";
                }
                StringBuilder res1 = new StringBuilder();
                for (byte b : macBytes) {
                    res1.append(String.format("%02X:", b));
                }
                if (res1.length() > 0) {
                    res1.deleteCharAt(res1.length() - 1);
                }
                return res1.toString();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private boolean isvalidContinue() {
        if (this.tfIpServidor.getText() == null || this.tfIpServidor.getText().isEmpty()) {
            Alerts.showAlertInfo("Campo Servidor \u00e9 obrigat\u00f3rio. ");
            return false;
        }
        if (this.tfPortaServidor.getText() == null || this.tfPortaServidor.getText().isEmpty()) {
            Alerts.showAlertInfo("Campo Porta Servidor \u00e9 obrigat\u00f3rio.");
            return false;
        }
        try {
            Long.valueOf(this.tfPortaServidor.getText());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Alerts.showAlertInfo("Valor informado na Porta Servidor \u00e9 inv\u00e1lido.");
            return false;
        }
        if (this.tfCnpjEmp.getText() == null || this.tfCnpjEmp.getText().isEmpty()) {
            Alerts.showAlertInfo("Campo CNPJ/CPF da empresa \u00e9 obrigat\u00f3rio.");
            return false;
        }
        if (!ValidadeCPFCNPJ.isValid((String)this.tfCnpjEmp.getText())) {
            Alerts.showAlertInfo("Campo CNPJ/CPF da empresa \u00e9 inv\u00e1lido.");
            return false;
        }
        return true;
    }

    private Long getIdEmpresa(String servidor, String porta, String cnpj) throws Exception {
        return SincOthers.getIDEmpresaByCnpj(servidor, porta, cnpj);
    }
}

