/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.pessoa;

import com.touchcomp.basementorclientwebservices.nfe.model.ret.consultacadastro.NFeConsultaCadastroRet;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorexceptions.exceptions.impl.zip.ExceptionZip;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.others.cpfcnpj.ValidadeCPFCNPJ;
import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.TouchComboBox;
import com.touchcomp.touchnfce.components.TouchDataField;
import com.touchcomp.touchnfce.components.TouchDoubleField;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.components.listener.FocusListener;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.model.Cidade;
import com.touchcomp.touchnfce.model.NFCePessoa;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import com.touchcomp.touchnfce.modeltemp.TempImplLogradouro;
import com.touchcomp.touchnfce.service.impl.ServiceCidade;
import com.touchcomp.touchnfce.service.impl.ServiceNFCePessoa;
import com.touchcomp.touchnfce.service.impl.ServiceUnidadeFatCliente;
import com.touchcomp.touchnfce.sinc.receive.SincFactory;
import com.touchcomp.touchnfce.sinc.send.SincEnvFactory;
import com.touchcomp.touchnfce.tasks.TaskResult;
import com.touchcomp.touchnfce.tasks.utils.UtilPesquisaCEP;
import com.touchcomp.touchnfce.utils.MaskField;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import com.touchcomp.touchnfce.utils.UtilNFCeSerial;
import com.touchcomp.touchnfce.utils.pedido.UtilPedido;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;

public class CadastroPessoaController
extends BaseDialog
implements TaskResult<NFeConsultaCadastroRet> {
    public static final String CURRENT_PESSOA = "current_pessoa";
    @FXML
    private Label lblNome;
    @FXML
    private Label lblNomeFantasia;
    @FXML
    private Label lblCpfCnpj;
    @FXML
    private Label lblLogradouro;
    @FXML
    private Label lblNumero;
    @FXML
    private Label lblCEP;
    @FXML
    private Label lblComplemento;
    @FXML
    private Label lblInscEstadual;
    @FXML
    private Label lblInscMunicipal;
    @FXML
    private Label lblCelular1;
    @FXML
    private Label lblCelular2;
    @FXML
    private Label lblPassaporte;
    @FXML
    private Label lblBairro;
    @FXML
    private Label lblCidade;
    @FXML
    private Label lblReferencia;
    @FXML
    private Label lblObservacao;
    @FXML
    private Label lblTelefone1;
    @FXML
    private Label lblTelefone2;
    @FXML
    private Label lblEmail;
    @FXML
    private Label lblVrServicoTransportador;
    @FXML
    private Label lblDataNascimento;
    @FXML
    private TouchTextField tfCpfCnpj;
    @FXML
    private TouchTextField tfNome;
    @FXML
    private TouchTextField tfNomeFantasia;
    @FXML
    private TouchTextField tfLogradouro;
    @FXML
    private TouchTextField tfNumero;
    @FXML
    private TouchTextField tfCEP;
    @FXML
    private TouchTextField tfComplemento;
    @FXML
    private TouchTextField tfInscEstadual;
    @FXML
    private TouchTextField tfInscMunicipal;
    @FXML
    private TouchTextField tfCelular1;
    @FXML
    private TouchTextField tfCelular2;
    @FXML
    private TouchTextField tfTelefone1;
    @FXML
    private TouchTextField tfTelefone2;
    @FXML
    private TouchTextField tfPassaporte;
    @FXML
    private TouchTextField tfBairro;
    @FXML
    private TouchTextField tfReferencia;
    @FXML
    private TouchTextField tfObservacao;
    @FXML
    private TouchTextField tfEmail;
    @FXML
    private TouchDoubleField tfVrServicoTransportador;
    @FXML
    private TouchDataField tfDataNascimento;
    @FXML
    private TouchComboBox<Cidade> cmbCidade;
    @FXML
    private TabPane tabPane;
    @FXML
    private Tab tabInfoBasicas;
    @FXML
    private Tab tabEndereco;
    @FXML
    private Tab tabMais;
    @FXML
    private AnchorPane body;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnLimpar;
    @FXML
    private Button btnSair;
    Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Buscando pessoa no banco de dados...", new ButtonType[0]);
    private NFCePessoa currentPessoa;
    private Cidade cidade;
    private Boolean lastControllerIsVenda;

    @Override
    public void initializeController(ResourceBundle rb) {
        this.lastControllerIsVenda = ToolMethods.isEquals((Object)StaticObjects.getUltimaPagina(), (Object)Controllers.VENDA);
        this.setPropertiesElements();
        this.loadCidades();
        this.initBtnActions();
        MaskField.cpfCnpjField(this.tfCpfCnpj);
        this.setLabelsTextFields();
    }

    private void setLabelsTextFields() {
        this.tfDataNascimento.setLabel(this.lblDataNascimento);
        this.tfBairro.setLabel(this.lblBairro);
        this.tfCEP.setLabel(this.lblCEP);
        this.tfComplemento.setLabel(this.lblComplemento);
        this.tfLogradouro.setLabel(this.lblLogradouro);
        this.tfNumero.setLabel(this.lblNumero);
        this.tfObservacao.setLabel(this.lblObservacao);
        this.tfReferencia.setLabel(this.lblReferencia);
        this.tfCelular1.setLabel(this.lblCelular1);
        this.tfCelular2.setLabel(this.lblCelular2);
        this.tfCpfCnpj.setLabel(this.lblCpfCnpj);
        this.tfEmail.setLabel(this.lblEmail);
        this.tfInscEstadual.setLabel(this.lblInscEstadual);
        this.tfInscMunicipal.setLabel(this.lblInscMunicipal);
        this.tfNome.setLabel(this.lblNome);
        this.tfNomeFantasia.setLabel(this.lblNomeFantasia);
        this.tfPassaporte.setLabel(this.lblPassaporte);
        this.tfTelefone1.setLabel(this.lblTelefone1);
        this.tfTelefone2.setLabel(this.lblTelefone2);
        this.tfVrServicoTransportador.setLabel(this.lblVrServicoTransportador);
    }

    private void initBtnActions() {
        this.btnConfirmar.setOnAction(event -> this.savePessoa());
        this.btnLimpar.setOnAction(event -> this.limpaCampos());
        this.btnSair.setOnAction(event -> this.closeDialog());
        this.tfCEP.addFocusListener(new FocusListener(){

            @Override
            public void onFocusGained() {
            }

            @Override
            public void onFocusLost() {
                if (CadastroPessoaController.this.tfCEP.getText() != null && !CadastroPessoaController.this.tfCEP.getText().isEmpty()) {
                    CadastroPessoaController.this.findEnderecoByCEP();
                }
            }
        });
        this.tfCpfCnpj.addFocusListener(new FocusListener(){

            @Override
            public void onFocusGained() {
            }

            @Override
            public void onFocusLost() {
                if (CadastroPessoaController.this.tfCpfCnpj.getText() != null && !CadastroPessoaController.this.tfCpfCnpj.getText().isEmpty() && CadastroPessoaController.this.getUnidadeFatCli(CadastroPessoaController.this.tfCpfCnpj.getText()) != null) {
                    Alerts.showAlertInfo("Ja existe um cliente cadastrado com este CPF/CNPJ");
                }
            }
        });
    }

    @Override
    public void requestFocusOnOpen() {
        this.tfCpfCnpj.requestFocus();
    }

    public void loadCidades() {
        try {
            ServiceCidade service = Main.getBean(ServiceCidade.class);
            List caixas = service.getAll();
            this.cmbCidade.getItems().addAll(caixas);
        }
        catch (Exception ex) {
            Logger.getLogger(CadastroPessoaController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError("Erro", ex.getMessage());
        }
    }

    private void setPropertiesElements() {
        this.tfCpfCnpj.textProperty().addListener((observableValue, antigo, novo) -> {
            if (novo.length() == 14) {
                this.tfCpfCnpj.setText(MaskField.cpfField(novo));
            }
            if (novo.length() == 18) {
                this.tfCpfCnpj.setText(MaskField.cnpjField(novo));
            }
        });
        this.btnLimpar.setOnAction(event -> this.limpaCampos());
        this.btnConfirmar.setOnAction(event -> this.savePessoa());
        this.btnSair.setOnAction(event -> this.closeDialog());
    }

    private void savePessoa() {
        if (this.currentPessoa == null) {
            this.currentPessoa = new NFCePessoa();
        }
        this.screenToCurrent();
        if (!this.isValidBefore()) {
            return;
        }
        this.saveAndBack();
    }

    private void saveAndBack() {
        this.sincronizaNFCePessoaAndCriaUnidadeFat();
        if (this.lastControllerIsVenda.booleanValue()) {
            Main.get().mudaTela(Controllers.VENDA);
        } else {
            Main.get().mudaTela(Controllers.PRE_VENDA);
        }
    }

    private boolean isValidBefore() {
        boolean ret = this.validObject(this.currentPessoa.getNome());
        if (!ret) {
            Alerts.showAlertInfo("Campo nome \u00e9 obrigat\u00f3rio.");
            return false;
        }
        ret = this.validObject(this.currentPessoa.getCep());
        if (!ret) {
            Alerts.showAlertInfo("Campo cep \u00e9 obrigat\u00f3rio.");
            return false;
        }
        ret = this.validObject(this.currentPessoa.getLogradouro());
        if (!ret) {
            Alerts.showAlertInfo("Campo logradouro \u00e9 obrigat\u00f3rio.");
            return false;
        }
        ret = this.validObject(this.currentPessoa.getBairro());
        if (!ret) {
            Alerts.showAlertInfo("Campo bairro \u00e9 obrigat\u00f3rio.");
            return false;
        }
        ret = this.validObject(this.currentPessoa.getNumero());
        if (!ret) {
            Alerts.showAlertInfo("Campo numero \u00e9 obrigat\u00f3rio.");
            return false;
        }
        ret = this.validObject(this.currentPessoa.getCidade());
        if (!ret) {
            Alerts.showAlertInfo("Campo cidade \u00e9 obrigat\u00f3rio.");
            return false;
        }
        ret = this.validObject(this.currentPessoa.getCpfCnpj());
        if (!ret) {
            Alerts.showAlertInfo("Campo Cnpj/Cpf \u00e9 obrigat\u00f3rio.");
            return false;
        }
        if (!ValidadeCPFCNPJ.isValid((String)this.currentPessoa.getCpfCnpj())) {
            Alerts.showAlertInfo("Campo Cnpj/Cpf inv\u00e1lido!");
            return false;
        }
        return true;
    }

    private boolean validObject(Object aux) {
        return aux != null && aux.toString().trim().length() > 0;
    }

    private void screenToCurrent() {
        this.currentPessoa.setNome(this.tfNome.getText());
        this.currentPessoa.setNomeFantasia(this.tfNomeFantasia.getText());
        this.currentPessoa.setCpfCnpj(this.clearTexto(this.tfCpfCnpj.getText()));
        this.currentPessoa.setCep(ToolString.refina((String)this.tfCEP.getText()));
        this.currentPessoa.setCidade((Cidade)this.cmbCidade.getSelectionModel().getSelectedItem());
        this.currentPessoa.setInscricaoEstadual(this.tfInscEstadual.getText());
        this.currentPessoa.setInscricaoMunicipal(this.tfInscMunicipal.getText());
        this.currentPessoa.setPassaporte(this.tfPassaporte.getText());
        this.currentPessoa.setCel1(this.tfCelular1.getText());
        this.currentPessoa.setCel2(this.tfCelular2.getText());
        this.currentPessoa.setFone1(this.tfTelefone1.getText());
        this.currentPessoa.setFone2(this.tfTelefone2.getText());
        this.currentPessoa.setEmail(this.tfEmail.getText());
        this.currentPessoa.setLogradouro(this.tfLogradouro.getText());
        this.currentPessoa.setNumero(this.tfNumero.getText());
        this.currentPessoa.setComplemento(this.tfComplemento.getText());
        this.currentPessoa.setCep(this.tfCEP.getText());
        this.currentPessoa.setBairro(this.tfBairro.getText());
        this.currentPessoa.setObservacao(this.tfObservacao.getText());
        this.currentPessoa.setReferencia(this.tfReferencia.getText());
        this.currentPessoa.setSerialForSinc(UtilNFCeSerial.getSerial(StaticObjects.getNFCeCaixa()));
        this.currentPessoa.setEmpresa(StaticObjects.getOpcoes().getEmpresa());
        Date dataNascimento = this.getDataNascimentoFormatada();
        this.currentPessoa.setDataNascimento(dataNascimento);
    }

    public void limpaCampos() {
        this.tfBairro.setText("");
        this.tfCEP.setText("");
        this.tfCelular1.setText("");
        this.tfCelular2.setText("");
        this.tfComplemento.setText("");
        this.tfCpfCnpj.setText("");
        this.tfInscEstadual.setText("");
        this.tfInscMunicipal.setText("");
        this.tfLogradouro.setText("");
        this.tfNome.setText("");
        this.tfNomeFantasia.setText("");
        this.tfNumero.setText("");
        this.tfObservacao.setText("");
        this.tfPassaporte.setText("");
        this.tfReferencia.setText("");
        this.tfTelefone1.setText("");
        this.tfTelefone2.setText("");
        this.currentPessoa = null;
    }

    @Override
    public void onFinish(NFeConsultaCadastroRet result) {
        if (result != null) {
            this.tfNomeFantasia.setText(((NFeConsultaCadastroRet.NFeConsultaCadastroSitCadRet)result.getSituacaoCadastral().get(0)).getNomeFantasia());
            this.tfInscEstadual.setText(result.getInscricaoEstadual());
            this.tfBairro.setText(((NFeConsultaCadastroRet.NFeConsultaCadastroSitCadRet)result.getSituacaoCadastral().get(0)).getEndereco().getBairro());
            this.tfLogradouro.setText(((NFeConsultaCadastroRet.NFeConsultaCadastroSitCadRet)result.getSituacaoCadastral().get(0)).getEndereco().getLogradouro());
            this.tfComplemento.setText(((NFeConsultaCadastroRet.NFeConsultaCadastroSitCadRet)result.getSituacaoCadastral().get(0)).getEndereco().getComplemento());
            this.tfCEP.setText(((NFeConsultaCadastroRet.NFeConsultaCadastroSitCadRet)result.getSituacaoCadastral().get(0)).getEndereco().getCep());
            this.tfNumero.setText(((NFeConsultaCadastroRet.NFeConsultaCadastroSitCadRet)result.getSituacaoCadastral().get(0)).getEndereco().getNumero());
            this.alert.close();
        } else {
            Alerts.showAlertError("Erro", "Nenhuma pessoa encontrada nas bases de dados com estas informa\u00e7\u00f5es");
        }
    }

    @Override
    public void onError(NFeConsultaCadastroRet result, Exception ex) {
        Alerts.showAlertError("Erro", "Ocorreu um erro ao consultar os dados:\n " + ex.getMessage());
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt != null) {
            switch (evt.getCode()) {
                case F1: {
                    this.tabPane.getSelectionModel().select((Object)this.tabInfoBasicas);
                    this.tfCpfCnpj.requestFocus();
                    break;
                }
                case F2: {
                    this.tabPane.getSelectionModel().select((Object)this.tabEndereco);
                    this.tfCEP.requestFocus();
                    break;
                }
                case F3: {
                    this.tabPane.getSelectionModel().select((Object)this.tabMais);
                    this.tfInscEstadual.requestFocus();
                    break;
                }
                case F12: {
                    this.savePessoa();
                    break;
                }
                case F5: {
                    this.limpaCampos();
                    break;
                }
                case ESCAPE: {
                    this.closeDialog();
                    break;
                }
                case ENTER: {
                    if (!this.tfCEP.isFocused() || this.tfCEP.getText() == null || this.tfCEP.getText().length() <= 0) break;
                    this.findEnderecoByCEP();
                    this.tfNumero.requestFocus();
                    break;
                }
            }
        }
    }

    private String clearTexto(String text) {
        if (text != null && !text.isEmpty()) {
            text = text.replace(".", "");
            text = text.replace("-", "");
            text = text.replace("/", "");
        }
        return text;
    }

    private void sincronizaNFCePessoaAndCriaUnidadeFat() {
        try {
            UnidadeFatCliente unid = this.getUnidadeFatCli(this.currentPessoa.getCpfCnpj());
            if (unid == null) {
                ServiceNFCePessoa serviceNFCePessoa = Main.getBean(ServiceNFCePessoa.class);
                this.currentPessoa = serviceNFCePessoa.save(this.currentPessoa);
                SincEnvFactory.getInstance().startSincUnidadeFatCliente(this.currentPessoa);
                SincFactory.getInstance().startSincCliente();
                ServiceUnidadeFatCliente service = Main.getBean(ServiceUnidadeFatCliente.class);
                List<UnidadeFatCliente> listUnidade = service.getUnidadeFatClienteByCpfCnpj(this.currentPessoa.getCpfCnpj());
                if (listUnidade == null || listUnidade.isEmpty()) {
                    Alerts.showAlertError("Erro ao pesquisar o novo Cliente cadastrado. Nenhuma unidade de faturamento encontrada.");
                    return;
                }
                unid = listUnidade.get(0);
            }
            if (this.lastControllerIsVenda.booleanValue()) {
                this.criarNFCe(unid);
            } else {
                this.criarPedido(unid);
            }
        }
        catch (ExceptionDecodeHexString64 | ExceptionIO | ExceptionReflection | ExceptionWebService | ExceptionZip ex) {
            ex.printStackTrace();
            Logger.getLogger(CadastroPessoaController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError("Erro ao Cadastrar/Pesquisar Pessoa." + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Logger.getLogger(CadastroPessoaController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError("Erro ao Cadastrar/Pesquisar Pessoa." + ex.getMessage());
        }
    }

    private void findEnderecoByCEP() {
        try {
            String cep = this.tfCEP.getText();
            cep = ToolString.completaZeros((String)ToolString.refina((String)cep), (int)8, (boolean)false);
            TempImplLogradouro temp = UtilPesquisaCEP.pesquisaEnderecoCep(cep);
            if (temp != null) {
                this.tfLogradouro.setText(temp.getLogradouro());
                this.tfBairro.setText(temp.getBairro());
                this.tfComplemento.setText(temp.getComplemento());
                this.cmbCidade.getSelectionModel().select((Object)temp.getCidade());
            }
        }
        catch (Exception ex) {
            Alerts.showAlertInfo("Erro ao carreggar endere\u00e7o de forma automatica. " + String.valueOf(ex.getCause()));
        }
    }

    private UnidadeFatCliente getUnidadeFatCli(String cpf) {
        ServiceUnidadeFatCliente service = Main.getBean(ServiceUnidadeFatCliente.class);
        List<UnidadeFatCliente> listUnidade = service.getUnidadeFatClienteByCpfCnpj(this.clearTexto(cpf));
        if (listUnidade != null && !listUnidade.isEmpty()) {
            return listUnidade.get(0);
        }
        return null;
    }

    private void criarPedido(UnidadeFatCliente un) {
        if (StaticObjects.getPedidoAberto() == null) {
            StaticObjects.setPedidoAberto(UtilPedido.getNewPedido(un));
        }
        StaticObjects.getPedidoAberto().setUnidadeFatCliente(un);
        StaticObjects.refreshPedido(StaticObjects.getPedidoAberto());
    }

    private void criarNFCe(UnidadeFatCliente un) {
        if (StaticObjects.getNfceAberta() == null) {
            StaticObjects.setNfceAberta(UtilNFCe.createNFCeModelo55(this.currentPessoa));
        }
        StaticObjects.getNfceAberta().setNfcePessoa(this.currentPessoa);
        UtilNFCe.setUnidadeFatCliente(un, StaticObjects.getNfceAberta());
        StaticObjects.refreshNFCe();
        this.closeDialog();
    }

    private Date getDataNascimentoFormatada() {
        if (ToolMethods.isStrWithData((String)this.tfDataNascimento.getText())) {
            try {
                return ToolDate.strToDate((String)this.tfDataNascimento.getText());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

