/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.pessoa.autorizadasdesautorizadas;

import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.TouchComboBox;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.pessoa.autorizadasdesautorizadas.components.TouchTextPessoasDesautorizadas;
import com.touchcomp.touchnfce.model.ClienteFichaFinanceiraAutorizados;
import com.touchcomp.touchnfce.model.Pessoa;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import com.touchcomp.touchnfce.service.impl.ServicePessoa;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;

public class PessoasVinculadasAutDesautController
extends BaseDialog {
    @FXML
    private Label lblPessoasAut;
    @FXML
    private Label lblPessoasDesaut;
    @FXML
    private Label lblCliente;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnVoltar;
    @FXML
    private AnchorPane body;
    @FXML
    private TouchComboBox<Pessoa> cmbPessoasAut;
    @FXML
    private TableView<Pessoa> tablePessoasDesaut;
    @FXML
    private TableColumn<Pessoa, String> nomePessoaDesaut;
    public static final String CLIENTE = "cliente";
    public static final String IS_ORDER = "is_order";
    UnidadeFatCliente cliente = null;
    Boolean isOrder = false;
    private Pessoa pessoaAutorizada;

    @Override
    public void initializeController(ResourceBundle resources) {
        this.tablePessoasDesaut.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.btnVoltar.setOnAction(evt -> this.cancelar());
        this.btnConfirmar.setOnAction(evt -> this.confirmar());
    }

    void cancelar() {
        Pessoa selected = this.cmbPessoasAut.getSelectedItem();
        if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getObrigarPessoaAutorizadaNFCe(), (Object)1) && selected == null) {
            Alerts.showAlertError("Primeiro, informe a Pessoa Autorizada!", this.getStage());
            this.setPessoaAutorizada(null);
            return;
        }
        this.closeDialog();
    }

    void confirmar() {
        Pessoa selected = this.cmbPessoasAut.getSelectedItem();
        if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getObrigarPessoaAutorizadaNFCe(), (Object)1) && selected == null) {
            Alerts.showAlertError("Primeiro, informe a Pessoa Autorizada!", this.getStage());
            return;
        }
        if (selected == null) {
            this.setPessoaAutorizada(null);
            this.closeDialog();
            return;
        }
        ServicePessoa service = Main.getBean(ServicePessoa.class);
        Pessoa aut = (Pessoa)service.get(selected.getIdentificador());
        if (!this.isOrder.booleanValue()) {
            this.setPessoaAutorizada(aut);
            this.closeDialog();
        } else {
            this.setPessoaAutorizada(aut);
            this.closeDialog();
        }
    }

    void iniciaParametros() {
        this.cliente = (UnidadeFatCliente)this.getParams().get(CLIENTE);
        this.isOrder = (Boolean)this.getParams().get(IS_ORDER);
        if (this.cliente != null && this.cliente.getPessoa() != null) {
            this.lblCliente.setText("Cliente: " + this.cliente.getPessoa().getNome());
        }
        this.cmbPessoasAut.setLabel(this.lblPessoasAut);
        this.configureTable();
        this.setDataTable();
    }

    @Override
    public void posInitialize() {
        this.iniciaParametros();
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt != null) {
            switch (evt.getCode()) {
                case F1: {
                    this.cmbPessoasAut.requestFocus();
                    break;
                }
                case F2: {
                    this.tablePessoasDesaut.requestFocus();
                    this.tablePessoasDesaut.getSelectionModel().selectFirst();
                    break;
                }
                case ESCAPE: {
                    this.cancelar();
                    break;
                }
                case F12: {
                    this.confirmar();
                    break;
                }
            }
        }
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void requestFocusOnOpen() {
        this.cmbPessoasAut.requestFocus();
    }

    void configureTable() {
        this.nomePessoaDesaut.setCellValueFactory(cellData -> new SimpleStringProperty(((Pessoa)cellData.getValue()).getNome()));
        this.nomePessoaDesaut.setCellFactory((Callback)new Callback<TableColumn<Pessoa, String>, TableCell<Pessoa, String>>(){

            public TableCell<Pessoa, String> call(TableColumn<Pessoa, String> param) {
                TableCell<Pessoa, String> cell = new TableCell<Pessoa, String>(){
                    private TouchTextPessoasDesautorizadas text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.text = !this.isEmpty() && item != null ? new TouchTextPessoasDesautorizadas(item.toString(), PessoasVinculadasAutDesautController.this.nomePessoaDesaut.getWidth()) : new TouchTextPessoasDesautorizadas("", PessoasVinculadasAutDesautController.this.nomePessoaDesaut.getWidth());
                        this.setGraphic((Node)this.text);
                    }
                };
                return cell;
            }
        });
    }

    void setDataTable() {
        ArrayList<Pessoa> pessoasAut = new ArrayList<Pessoa>();
        ArrayList<Pessoa> pessoasDesaut = new ArrayList<Pessoa>();
        pessoasAut.add(this.cliente.getCliente().getPessoa());
        for (ClienteFichaFinanceiraAutorizados pa : this.cliente.getCliente().getFichaFinanceira().getPessoasAutorizadas()) {
            if (ToolMethods.isAffirmative((Number)pa.getAtivo())) {
                pessoasAut.add(pa.getPessoa());
                continue;
            }
            pessoasDesaut.add(pa.getPessoa());
        }
        this.cmbPessoasAut.setObjects(pessoasAut);
        this.cmbPessoasAut.select(this.cliente.getCliente().getPessoa());
        this.tablePessoasDesaut.setItems(FXCollections.observableArrayList(pessoasDesaut));
        if (!this.isOrder.booleanValue()) {
            if (StaticObjects.getNfceAberta() != null && StaticObjects.getNfceAberta().getPessoaAutorizada() != null) {
                this.cmbPessoasAut.select(StaticObjects.getNfceAberta().getPessoaAutorizada());
                this.setPessoaAutorizada(StaticObjects.getNfceAberta().getPessoaAutorizada());
            }
        } else if (StaticObjects.getPedidoAberto() != null && StaticObjects.getPedidoAberto().getPessoaAutorizada() != null) {
            this.cmbPessoasAut.select(StaticObjects.getPedidoAberto().getPessoaAutorizada());
            this.setPessoaAutorizada(StaticObjects.getPedidoAberto().getPessoaAutorizada());
        }
    }

    public Pessoa getPessoaAutorizada() {
        return this.pessoaAutorizada;
    }

    public void setPessoaAutorizada(Pessoa pessoaAutorizada) {
        this.pessoaAutorizada = pessoaAutorizada;
    }
}

