/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.prevenda;

import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.BaseController;
import com.touchcomp.touchnfce.model.Pedido;
import com.touchcomp.touchnfce.model.SituacaoPedidos;
import com.touchcomp.touchnfce.service.impl.ServiceSituacaoPedidos;
import com.touchcomp.touchnfce.utils.MaskField;
import com.touchcomp.touchnfce.utils.pedido.UtilPedido;
import com.touchcomp.touchvomodel.vo.findpedidoprevenda.DTOFindPedidoPreVenda;
import com.touchcomp.touchvomodel.vo.pedido.nfce.DTOPedidoV9;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.Text;
import javafx.util.Callback;

public class PesquisaPreVendaController
extends BaseController {
    @FXML
    private Label lblBusca;
    @FXML
    private Label lblFocusCampoBusca;
    @FXML
    private Label lblTabela;
    @FXML
    private TouchTextField tfCampoBusca;
    @FXML
    private TableView<DTOFindPedidoPreVenda> tablePedidos;
    @FXML
    private TableColumn<DTOFindPedidoPreVenda, String> columnCliente;
    @FXML
    private TableColumn<DTOFindPedidoPreVenda, String> columnDataEmissao;
    @FXML
    private TableColumn<DTOFindPedidoPreVenda, String> columnNumero;
    @FXML
    private TableColumn<DTOFindPedidoPreVenda, String> columnValor;
    @FXML
    private TableColumn<DTOFindPedidoPreVenda, String> columnCodCliente;
    @FXML
    private TableColumn<DTOFindPedidoPreVenda, String> columnSitPedido;
    @FXML
    private Button btnVoltar;
    @FXML
    private Button btnSelecionarPedido;
    @FXML
    private Button btnImprimirPedido;
    @FXML
    private Button btnImprimirPedidoTermica;
    @FXML
    private AnchorPane body;

    @Override
    protected void initializeController(ResourceBundle rb) {
        this.tablePedidos.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.btnVoltar.setOnAction(event -> Main.get().mudaTela(Controllers.PRE_VENDA));
        this.btnSelecionarPedido.setOnAction(event -> this.selecionaPedido());
        this.btnImprimirPedido.setOnAction(event -> this.imprimirPedido());
        this.btnImprimirPedidoTermica.setOnAction(event -> this.imprimirPedidoTermica());
        this.setDataAtualPesquisa();
        this.tfCampoBusca.textProperty().addListener((observable, oldValue, newValue) -> {});
        this.configureTable();
        this.tfCampoBusca.setLabel(this.lblBusca);
        this.tfCampoBusca.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ENTER) {
                    PesquisaPreVendaController.this.filterElementsTable();
                }
            }
        });
    }

    @Override
    protected void requestFocusOnOpen() {
        this.tfCampoBusca.requestFocus();
    }

    private void selecionaPedido() {
        DTOFindPedidoPreVenda selected = (DTOFindPedidoPreVenda)this.tablePedidos.getSelectionModel().getSelectedItem();
        if (selected != null) {
            DTOPedidoV9 dtoPedido = UtilPedido.sicronizaPedidoPreVenda(selected.getIdentificador());
            if (dtoPedido == null) {
                Alerts.showAlertError("Nenhum pedido foi encontrado no ERP com o serialForSync: " + selected.getIdentificador());
                return;
            }
            Pedido pedido = UtilPedido.getClonePedidoSincronizado(dtoPedido);
            StaticObjects.refreshPedido(pedido);
            StaticObjects.setPedidoAberto(pedido);
            Main.get().mudaTela(Controllers.PRE_VENDA);
        } else {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Selecione um Pedido para continuar!", "");
        }
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void eventKey(KeyEvent evt) {
        switch (evt.getCode()) {
            case DOWN: {
                if (!this.tfCampoBusca.isFocused()) break;
                this.tablePedidos.requestFocus();
                break;
            }
            case F1: {
                this.selecionaPedido();
                break;
            }
            case F2: {
                this.tablePedidos.getSelectionModel().select(null);
                this.tfCampoBusca.requestFocus();
                break;
            }
            case F3: {
                this.tablePedidos.requestFocus();
                this.tablePedidos.getSelectionModel().selectFirst();
                break;
            }
            case F4: {
                this.imprimirPedido();
                break;
            }
            case F5: {
                this.imprimirPedidoTermica();
                break;
            }
            case ESCAPE: {
                Main.get().mudaTela(Controllers.PRE_VENDA);
                break;
            }
            case ENTER: {
                break;
            }
        }
    }

    private void setPedidoTable(List<DTOFindPedidoPreVenda> result) {
        this.columnDataEmissao.setCellValueFactory(cellData -> new SimpleStringProperty(ToolDate.dateToStr((Date)((DTOFindPedidoPreVenda)cellData.getValue()).getDataEmissao(), (String)"dd/MM/yyyy")));
        this.columnNumero.setCellValueFactory(cellData -> new SimpleStringProperty(String.valueOf(((DTOFindPedidoPreVenda)cellData.getValue()).getIdentificador())));
        this.columnCodCliente.setCellValueFactory(cellData -> new SimpleStringProperty(String.valueOf(this.getCodClienteConsumidor((DTOFindPedidoPreVenda)cellData.getValue()))));
        this.columnCliente.setCellValueFactory(cellData -> new SimpleStringProperty(String.valueOf(this.getNomeClienteConsumidor((DTOFindPedidoPreVenda)cellData.getValue()))));
        this.columnCliente.setCellFactory((Callback)new Callback<TableColumn<DTOFindPedidoPreVenda, String>, TableCell<DTOFindPedidoPreVenda, String>>(){

            public TableCell<DTOFindPedidoPreVenda, String> call(TableColumn<DTOFindPedidoPreVenda, String> param) {
                TableCell<DTOFindPedidoPreVenda, String> cell = new TableCell<DTOFindPedidoPreVenda, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.text = !this.isEmpty() && item != null ? new Text(item.toString()) : new Text("");
                        this.text.setWrappingWidth(PesquisaPreVendaController.this.columnCliente.getWidth());
                        this.setGraphic((Node)this.text);
                    }
                };
                return cell;
            }
        });
        this.columnSitPedido.setCellValueFactory(cellData -> new SimpleStringProperty(String.valueOf(this.getSituacaoPedido(((DTOFindPedidoPreVenda)cellData.getValue()).getSituacaoPedidoIdentificador()))));
        this.columnSitPedido.setCellFactory((Callback)new Callback<TableColumn<DTOFindPedidoPreVenda, String>, TableCell<DTOFindPedidoPreVenda, String>>(){

            public TableCell<DTOFindPedidoPreVenda, String> call(TableColumn<DTOFindPedidoPreVenda, String> param) {
                TableCell<DTOFindPedidoPreVenda, String> cell = new TableCell<DTOFindPedidoPreVenda, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty() && item != null) {
                            this.text = new Text(item.toString());
                            this.text.setWrappingWidth(PesquisaPreVendaController.this.columnSitPedido.getWidth());
                            this.setGraphic((Node)this.text);
                        }
                    }
                };
                return cell;
            }
        });
        this.columnValor.setCellValueFactory(cellData -> new SimpleStringProperty(MaskField.monetaryField(((DTOFindPedidoPreVenda)cellData.getValue()).getValorTotal())));
        this.tablePedidos.setItems(FXCollections.observableArrayList(result));
    }

    private void filterElementsTable() {
        this.tablePedidos.getItems().clear();
        String aux = this.tfCampoBusca.getText();
        if (aux != null && !ToolString.stringIsANumber((String)aux).booleanValue() && aux.length() < 3) {
            return;
        }
        List<DTOFindPedidoPreVenda> result = UtilPedido.findPedidosSemNotas(aux);
        this.setPedidoTable(result);
    }

    private void configureTable() {
        this.columnCliente.setMinWidth(350.0);
        this.columnSitPedido.setMinWidth(270.0);
        this.columnDataEmissao.setMinWidth(120.0);
        this.columnNumero.setMinWidth(200.0);
        this.columnValor.setMinWidth(80.0);
        this.columnValor.setStyle("-fx-alignment: BOTTOM_RIGHT;");
    }

    private void setDataAtualPesquisa() {
        Integer day = ToolDate.dayFromDate((Date)new Date());
        Integer month = ToolDate.monthFromDate((Date)new Date());
        Integer year = ToolDate.yearFromDate((Object)new Date());
        StringBuilder sb = new StringBuilder();
        if (day < 10) {
            sb.append("0");
        }
        sb.append(day.toString());
        sb.append("/");
        if (month < 10) {
            sb.append("0");
        }
        sb.append(month.toString());
        sb.append("/");
        sb.append(year.toString());
        this.tfCampoBusca.setText(sb.toString());
        this.filterElementsTable();
    }

    private String getCodClienteConsumidor(DTOFindPedidoPreVenda value) {
        Object str = "";
        if (value.getUnidadeFatCliente() != null) {
            str = (String)str + (value.getUnidadeFatCliente().getCliente().getCodigoCliente() == null ? "" : value.getUnidadeFatCliente().getCliente().getCodigoCliente());
        } else if (value.getNfceConsumidor() != null) {
            str = (String)str + (value.getNfceConsumidor().getCpfCnpj() == null || value.getNfceConsumidor().getCpfCnpj().isEmpty() ? value.getNfceConsumidor().getPassaporte() : value.getNfceConsumidor().getCpfCnpj());
        }
        return str;
    }

    private String getNomeClienteConsumidor(DTOFindPedidoPreVenda value) {
        Object str = "";
        if (value == null) {
            return str;
        }
        if (value.getUnidadeFatCliente() != null) {
            str = (String)str + (value.getUnidadeFatCliente().getCliente().getPessoa().getNome() == null ? "" : value.getUnidadeFatCliente().getCliente().getPessoa().getNome());
        } else if (value.getNfceConsumidor() != null) {
            str = (String)str + (value.getNfceConsumidor().getNome() == null ? "" : value.getNfceConsumidor().getNome());
        }
        return str;
    }

    private void imprimirPedido() {
        DTOFindPedidoPreVenda selected = (DTOFindPedidoPreVenda)this.tablePedidos.getSelectionModel().getSelectedItem();
        if (selected != null) {
            DTOPedidoV9 dtoPedido = UtilPedido.sicronizaPedidoPreVenda(selected.getIdentificador());
            if (dtoPedido == null) {
                Alerts.showAlertError("Nenhum pedido foi encontrado no ERP com o serialForSinc: " + selected.getIdentificador());
                return;
            }
            Pedido pedido = UtilPedido.getClonePedidoSincronizado(dtoPedido);
            UtilPedido.showOpcaoImpressaoPreVenda(pedido);
        } else {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Selecione um Pedido para continuar!", "");
        }
    }

    private String getSituacaoPedido(Long situacaoPedidoIdentificador) {
        ServiceSituacaoPedidos service = Main.getBean(ServiceSituacaoPedidos.class);
        SituacaoPedidos sit = (SituacaoPedidos)service.get(situacaoPedidoIdentificador);
        if (sit == null) {
            return "";
        }
        return sit.getDescricao();
    }

    private void imprimirPedidoTermica() {
        DTOFindPedidoPreVenda selected = (DTOFindPedidoPreVenda)this.tablePedidos.getSelectionModel().getSelectedItem();
        if (selected != null) {
            DTOPedidoV9 dtoPedido = UtilPedido.sicronizaPedidoPreVenda(selected.getIdentificador());
            if (dtoPedido == null) {
                Alerts.showAlertError("Nenhum pedido foi encontrado no ERP com o serialForSinc: " + selected.getIdentificador());
                return;
            }
            Pedido pedido = UtilPedido.getClonePedidoSincronizado(dtoPedido);
            UtilPedido.showOpcaoImpressaoPreVendaTermica(pedido);
        } else {
            Alerts.showAlertInfo("Informa\u00e7\u00e3o", "Selecione um Pedido para continuar!", "");
        }
    }
}

