/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.controller.produto.medicamento;

import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.BaseDialog;
import com.touchcomp.touchnfce.components.TouchDataField;
import com.touchcomp.touchnfce.components.TouchTextField;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.model.ItemPedido;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.Produto;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;

public class InformacoesProdutoMedicamentoController
extends BaseDialog {
    public static final String PRODUTO = "produto";
    public static final String ITEM_NFCE = "itemNFCe";
    public static final String ITEM_PEDIDO = "itemPedido";
    @FXML
    private Label lblLote;
    @FXML
    private Label lblDataFabricacao;
    @FXML
    private Label lblDataValidade;
    @FXML
    private Label lblProduto;
    @FXML
    private TouchTextField tfLote;
    @FXML
    private TouchDataField tfDataFabricacao;
    @FXML
    private TouchDataField tfDataValidade;
    @FXML
    private AnchorPane body;
    @FXML
    private Button btnConfirmar;
    @FXML
    private Button btnCancelar;
    Produto produto = null;

    @Override
    public void initializeController(ResourceBundle resources) {
        this.tfLote.setLabel(this.lblLote);
        this.tfDataFabricacao.setLabel(this.lblDataFabricacao);
        this.tfDataValidade.setLabel(this.lblDataValidade);
        this.tfDataFabricacao.setNextNodeFocus((Node)this.tfDataValidade);
        this.tfDataValidade.setNextNodeFocus((Node)this.btnConfirmar);
        this.btnConfirmar.setOnAction(evt -> this.confirmar());
        this.btnCancelar.setOnAction(evt -> this.cancelar());
    }

    void iniciaCampoProduto() {
        this.produto = (Produto)this.getParams().get(PRODUTO);
        if (this.produto != null && this.produto.getNome() != null) {
            this.lblProduto.setText(this.produto.getNome());
        }
    }

    void confirmar() {
        if (this.validarDadosInformados()) {
            NFCeItem item = (NFCeItem)this.getParams().get(ITEM_NFCE);
            if (item != null) {
                item.setNrLoteFabricacao(this.tfLote.getText());
                item.setDataFabricacao(ToolDate.strToDate((String)this.tfDataFabricacao.getText()));
                item.setDataValidade(ToolDate.strToDate((String)this.tfDataValidade.getText()));
                this.closeDialog();
            } else {
                ItemPedido itemPedido = (ItemPedido)this.getParams().get(ITEM_PEDIDO);
                if (itemPedido != null) {
                    itemPedido.setNrLoteFabricacao(this.tfLote.getText());
                    itemPedido.setDataFabricacao(ToolDate.strToDate((String)this.tfDataFabricacao.getText()));
                    itemPedido.setDataValidade(ToolDate.strToDate((String)this.tfDataValidade.getText()));
                    this.closeDialog();
                }
            }
        }
    }

    void cancelar() {
        this.closeDialog();
    }

    @Override
    public void eventKey(KeyEvent evt) {
        if (evt != null) {
            switch (evt.getCode()) {
                case ESCAPE: {
                    this.cancelar();
                    break;
                }
                case ENTER: {
                    this.confirmar();
                    break;
                }
            }
        }
    }

    @Override
    public void eventAltControl(KeyEvent evt) {
    }

    @Override
    public void requestFocusOnOpen() {
        this.tfLote.requestFocus();
    }

    @Override
    public void posInitialize() {
        this.iniciaCampoProduto();
    }

    private boolean validarDadosInformados() {
        String nrLote = this.tfLote.getText();
        if (!ToolMethods.isStrWithData((String)nrLote)) {
            Alerts.showAlertError("Informe o Lote de Fabrica\u00e7\u00e3o!", this.getStage());
            return false;
        }
        String dataFab = this.tfDataFabricacao.getText();
        if (!ToolMethods.isStrWithData((String)dataFab)) {
            Alerts.showAlertError("Informe a data de fabrica\u00e7\u00e3o do lote!", this.getStage());
            return false;
        }
        try {
            ToolDate.strToDate((String)dataFab);
        }
        catch (Exception e) {
            Alerts.showAlertError("Campo data de fabrica\u00e7\u00e3o est\u00e1 preenchido incorretamente!", this.getStage());
            return false;
        }
        String dataVal = this.tfDataValidade.getText();
        if (!ToolMethods.isStrWithData((String)dataVal)) {
            Alerts.showAlertError("Informe a data de validade do lote!", this.getStage());
            return false;
        }
        try {
            ToolDate.strToDate((String)dataVal);
        }
        catch (Exception e) {
            Alerts.showAlertError("Campo data de validade est\u00e1 preenchido incorretamente!", this.getStage());
            return false;
        }
        return true;
    }
}

